/*
 * Decompiled with CFR 0.152.
 */
package com.sas.tools.installs.it;

import com.sas.tools.installs.it.DeploymentPackage;
import java.util.HashMap;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.Logger;

public class DeploymentParameters {
    protected static Logger log = (Logger)LogManager.getLogger("com.sas.tools.installs.it.Controller");
    private final Map<String, String> lastProductSku = new HashMap<String, String>();
    private final Map<String, DeploymentPackage> packages = new HashMap<String, DeploymentPackage>();

    public void addPackage(String altSku, DeploymentPackage pkg) {
        pkg.getProductCode();
        this.packages.put(altSku, pkg);
        String oldAltSku = this.lastProductSku.put(pkg.getProductCode(), altSku);
        if (oldAltSku != null) {
            log.info("Replacing last sku " + oldAltSku + " with current sku " + altSku);
        }
    }

    public DeploymentPackage getSkuPackage(String altSku) {
        return this.packages.get(altSku);
    }

    public DeploymentPackage getProductPackage(String productCode) {
        String altSku = this.lastProductSku.get(productCode);
        if (altSku != null) {
            return this.packages.get(altSku);
        }
        return null;
    }
}

