/*
 * Decompiled with CFR 0.152.
 */
package com.sas.publicobjects.storedprocessreport;

import com.sas.publicobjects.storedprocessreport.RB;
import com.sas.publicobjects.storedprocessreport.StoredProcessReportOutputInterface;
import com.sas.report.repository.CacheItemInterface;
import com.sas.report.repository.RepositoryException;
import com.sas.report.repository.RepositoryIOException;
import com.sas.report.repository.RepositoryLockedException;
import com.sas.services.ServiceException;
import com.sas.services.TransportException;
import com.sas.services.information.Filter;
import com.sas.services.information.FilterInterface;
import com.sas.services.information.ServerInterface;
import com.sas.services.information.metadata.IdentityInterface;
import com.sas.services.publish.ResultPackageInterface;
import com.sas.services.publish.archive.ArchiveTransport;
import com.sas.services.session.SessionContextInterface;
import com.sas.services.user.UserContextInterface;
import com.sas.text.Message;
import java.io.InputStream;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

class StoredProcessReportOutput
extends UnicastRemoteObject
implements StoredProcessReportOutputInterface {
    private final CacheItemInterface _ci;
    private final String _name;
    private ResultPackageInterface _package;
    private long _generation;
    private Date _creationDate;
    long _creationDateLong;
    private Date _expirationDate;
    private String _creator;
    private IdentityInterface _identity;
    private final UserContextInterface _userContext;
    private int _conditionCode;
    private final List<StoredProcessReportOutputInterface> _list;
    private final Date _storedProcessLastModified;
    private final Date _storedProcessReportLastModified;
    private boolean _valid;
    private String _error;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    StoredProcessReportOutput(UserContextInterface userContext, CacheItemInterface ci, List<StoredProcessReportOutputInterface> list, Date storedProcessLastModified, Date storedProcessReportLastModified) throws RemoteException {
        block47: {
            this._valid = true;
            try {
                this._userContext = userContext;
                this._ci = ci;
                this._name = ci.getName();
                this._list = list;
                this._storedProcessLastModified = storedProcessLastModified;
                this._storedProcessReportLastModified = storedProcessReportLastModified;
                String genStr = null;
                String creationDateStr = null;
                String expirationDateStr = null;
                String personKey = null;
                String sasCCStr = null;
                HashMap attrMap = new HashMap();
                try {
                    Iterator it = this._ci.getAttributes();
                    while (it.hasNext()) {
                        Map.Entry me = (Map.Entry)it.next();
                        attrMap.put((String)me.getKey(), me.getValue());
                    }
                }
                catch (RepositoryException e) {
                    this._error = Message.format((String)RB.getStringResource("SPRO.cantGetAttrs.ex.fmt.txt"), (Object)e.getMessage());
                    this._valid = false;
                    if (!this._valid) {
                        this._creationDateLong = 0L;
                    }
                    return;
                }
                catch (SecurityException e) {
                    this._error = Message.format((String)RB.getStringResource("SPRO.cantGetAttrs.ex.fmt.txt"), (Object)e.getMessage());
                    this._valid = false;
                    if (!this._valid) {
                        this._creationDateLong = 0L;
                    }
                    return;
                }
                try {
                    genStr = (String)attrMap.get("{http://www.sas.com/xml/namespace/services.sp.report-1.1}Generation");
                    creationDateStr = (String)attrMap.get("{http://www.sas.com/xml/namespace/services.sp.report-1.1}CreationTime");
                    expirationDateStr = (String)attrMap.get("{http://www.sas.com/xml/namespace/services.sp.report-1.1}ExpirationTime");
                    sasCCStr = (String)attrMap.get("{http://www.sas.com/xml/namespace/services.sp.report-1.1}ConditionCode");
                    personKey = (String)attrMap.get("{http://www.sas.com/xml/namespace/services.sp.report-1.1}IdentityTypeAndName");
                }
                catch (Exception e) {
                    this._error = Message.format((String)RB.getStringResource("SPRO.cantGetAttrs.ex.fmt.txt"), (Object)e.getMessage());
                    this._valid = false;
                    if (!this._valid) {
                        this._creationDateLong = 0L;
                    }
                    return;
                }
                if (genStr == null) {
                    this._error = Message.format((String)RB.getStringResource("SPRO.noAttr.ex.fmt.txt"), (Object)"{http://www.sas.com/xml/namespace/services.sp.report-1.1}Generation");
                    this._valid = false;
                    return;
                }
                try {
                    this._generation = Long.decode(genStr);
                }
                catch (Exception e) {
                    this._error = Message.format((String)RB.getStringResource("SPRO.invldGen.ex.fmt.txt"), (Object)genStr);
                    this._valid = false;
                    if (!this._valid) {
                        this._creationDateLong = 0L;
                    }
                    return;
                }
                if (creationDateStr == null) {
                    this._error = Message.format((String)RB.getStringResource("SPRO.noAttr.ex.fmt.txt"), (Object)"{http://www.sas.com/xml/namespace/services.sp.report-1.1}CreationTime");
                    this._valid = false;
                    return;
                }
                try {
                    this._creationDateLong = Long.parseLong(creationDateStr);
                    this._creationDate = new Date(this._creationDateLong);
                }
                catch (Exception e) {
                    this._error = Message.format((String)RB.getStringResource("SPRO.invldCrDate.ex.fmt.txt"), (Object)creationDateStr);
                    this._valid = false;
                    if (!this._valid) {
                        this._creationDateLong = 0L;
                    }
                    return;
                }
                try {
                    if (expirationDateStr == null || expirationDateStr.length() == 0) {
                        this._expirationDate = null;
                    } else {
                        long expirationDateLong = Long.parseLong(expirationDateStr);
                        this._expirationDate = new Date(expirationDateLong);
                    }
                }
                catch (Exception e) {
                    this._error = Message.format((String)RB.getStringResource("SPRO.invldExpDate.ex.fmt.txt"), (Object)expirationDateStr);
                    this._valid = false;
                    if (!this._valid) {
                        this._creationDateLong = 0L;
                    }
                    return;
                }
                if (sasCCStr == null) {
                    this._error = Message.format((String)RB.getStringResource("SPRO.noAttr.ex.fmt.txt"), (Object)"{http://www.sas.com/xml/namespace/services.sp.report-1.1}ConditionCode");
                    this._valid = false;
                    return;
                }
                try {
                    this._conditionCode = Integer.parseInt(sasCCStr);
                }
                catch (Exception e) {
                    this._error = Message.format((String)RB.getStringResource("SPRO.invldCC.ex.fmt.txt"), (Object)sasCCStr);
                    this._valid = false;
                    if (!this._valid) {
                        this._creationDateLong = 0L;
                    }
                    return;
                }
                this._creator = personKey;
                if (personKey == null) break block47;
                try {
                    ServerInterface si = this._userContext.getAuthServer();
                    String search = null;
                    String metadataType = null;
                    if (personKey.startsWith("User:")) {
                        search = personKey.substring("User:".length());
                        metadataType = "Person";
                    } else if (personKey.startsWith("UserGroup:")) {
                        search = personKey.substring("UserGroup:".length());
                        metadataType = "IdentityGroup";
                    }
                    if (metadataType != null) {
                        Filter filter = new Filter("Name", 0, search);
                        filter.setType(metadataType);
                        List results = si.search((FilterInterface)filter);
                        if (results.size() > 0) {
                            this._identity = (IdentityInterface)results.get(0);
                        }
                    }
                    break block47;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                break block47;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                if (!this._valid) {
                    this._creationDateLong = 0L;
                }
            }
        }
    }

    @Override
    public void delete() throws ServiceException, RemoteException {
        this.disposePackage();
        try {
            this._ci.delete();
        }
        catch (RepositoryLockedException e) {
            throw new ServiceException((Throwable)e);
        }
        catch (RepositoryException e) {
            throw new ServiceException((Throwable)e);
        }
        catch (SecurityException e) {
            throw new ServiceException((Throwable)e);
        }
        this._list.remove(this);
    }

    @Override
    public void disposePackage() throws ServiceException, RemoteException {
        if (this._package != null) {
            try {
                this._package.delete();
                this._package = null;
            }
            catch (TransportException e) {
                throw new ServiceException((Throwable)e);
            }
        }
    }

    @Override
    public Date getCreationDate() {
        return this._creationDate;
    }

    @Override
    public String getCreator() {
        return this._creator;
    }

    @Override
    public IdentityInterface getCreatorIdentity() {
        return this._identity;
    }

    @Override
    public int getSASConditionCode() {
        return this._conditionCode;
    }

    @Override
    public Date getExpirationDate() {
        return this._expirationDate;
    }

    @Override
    public long getGeneration() {
        return this._generation;
    }

    @Override
    public ResultPackageInterface getPackage() throws ServiceException, RemoteException {
        if (this._package == null) {
            InputStream is;
            try {
                is = this._ci.getInputStream();
            }
            catch (RepositoryIOException e) {
                throw new ServiceException((Throwable)e);
            }
            catch (SecurityException e) {
                throw new ServiceException((Throwable)e);
            }
            SessionContextInterface sc = this._userContext != null ? this._userContext.getSessionContext() : null;
            ArchiveTransport transport = new ArchiveTransport(is, sc);
            this._package = transport.getResultPackage();
        }
        return this._package;
    }

    @Override
    public boolean isExpired() {
        if (this._storedProcessLastModified.after(this._creationDate)) {
            return true;
        }
        if (this._storedProcessReportLastModified.after(this._creationDate)) {
            return true;
        }
        if (this._expirationDate == null) {
            return false;
        }
        Date today = new Date();
        return !today.before(this._expirationDate);
    }

    @Override
    public boolean isValid() throws ServiceException, RemoteException {
        return this._valid;
    }

    @Override
    public String getError() throws ServiceException, RemoteException {
        return this._error;
    }

    @Override
    public String getName() throws ServiceException, RemoteException {
        return this._name;
    }
}

