/*
 * Decompiled with CFR 0.152.
 */
package com.sas.publicobjects.storedprocessreport;

import com.sas.publicobjects.storedprocessreport.RB;
import com.sas.report.repository.CacheInterface;
import com.sas.report.repository.CacheItemInterface;
import com.sas.report.repository.CacheSetInterface;
import com.sas.report.repository.EntryInterface;
import com.sas.report.repository.Repository;
import com.sas.report.repository.RepositoryDuplicateNameException;
import com.sas.report.repository.RepositoryException;
import com.sas.report.repository.RepositoryFactory;
import com.sas.report.repository.RepositoryIOException;
import com.sas.report.repository.RepositoryIllegalNameException;
import com.sas.report.repository.RepositoryLockedException;
import com.sas.services.ServiceException;
import com.sas.services.information.RepositoryInterface;
import com.sas.services.information.metadata.MetadataInterface;
import com.sas.services.information.metadata.PathUrl;
import com.sas.services.user.UserContextInterface;
import com.sas.text.Message;
import java.io.IOException;
import java.io.OutputStream;
import java.rmi.RemoteException;
import java.util.List;
import java.util.ResourceBundle;

public class RRSupport {
    Repository _reportRepository;
    CacheInterface _cacheInterface;
    private final MetadataInterface _mi;
    private PathUrl _pathUrl;

    public RRSupport(MetadataInterface mi) {
        this._mi = mi;
    }

    private CacheInterface getCache(EntryInterface entry, String cacheName, PathUrl pathUrl) throws RepositoryException, ServiceException {
        CacheSetInterface cs = entry.getCacheSetInterface();
        CacheInterface c = cs.get(cacheName);
        if (c != null) {
            return c;
        }
        throw new ServiceException(Message.format((ResourceBundle)RB.getResources(), (String)"RRS.cacheShouldExist.ex.fmt.txt", (Object)"SPRCache", (Object)pathUrl.getAbsolutePath()));
    }

    void clearCacheInterface(boolean closeRR) {
        if (closeRR) {
            if (this._reportRepository != null) {
                this._reportRepository.close();
            }
            this._reportRepository = null;
            this._pathUrl = null;
        }
        this._cacheInterface = null;
    }

    public CacheItemInterface createHighWaterMark(PathUrl pathUrl) throws ServiceException, RemoteException {
        this.setCacheInterface(pathUrl);
        return RRSupport.createHighWaterMark(this._cacheInterface);
    }

    static CacheItemInterface createHighWaterMark(CacheInterface cacheInterface) throws ServiceException {
        try {
            List cacheItems = cacheInterface.list(null);
            for (CacheItemInterface ci : cacheItems) {
                ci.delete();
            }
            CacheItemInterface highWaterCacheItem = cacheInterface.create("__HighWaterMark__");
            OutputStream os = highWaterCacheItem.getOutputStream();
            String text = "__HighWaterMark__";
            byte[] buffer = text.getBytes();
            int len = buffer.length;
            try {
                os.write(buffer, 0, len);
            }
            catch (IOException e) {
                throw new ServiceException((Throwable)e, RB.getStringResource("RRS.cantCreatHWM.ex.txt"));
            }
            finally {
                try {
                    os.close();
                }
                catch (IOException e) {
                    throw new ServiceException((Throwable)e, RB.getStringResource("RRS.cantCreatHWM.ex.txt"));
                }
            }
            try {
                highWaterCacheItem.setAttribute("{http://www.sas.com/xml/namespace/services.sp.report-1.1}HighestGeneration", (Object)Long.toString(0L));
            }
            catch (RepositoryLockedException e) {
                throw new ServiceException((Throwable)e);
            }
            catch (RepositoryException e) {
                throw new ServiceException((Throwable)e);
            }
            catch (SecurityException e) {
                throw new ServiceException((Throwable)e);
            }
            return highWaterCacheItem;
        }
        catch (RepositoryIllegalNameException e) {
            throw new ServiceException((Throwable)e, RB.getStringResource("RRS.cantCreatHWM.ex.txt"));
        }
        catch (RepositoryDuplicateNameException e) {
            throw new ServiceException((Throwable)e, RB.getStringResource("RRS.cantCreatHWM.ex.txt"));
        }
        catch (RepositoryException e) {
            throw new ServiceException((Throwable)e, RB.getStringResource("RRS.cantCreatHWM.ex.txt"));
        }
    }

    void setCacheInterface(PathUrl pathUrl) throws RemoteException, ServiceException {
        this.checkPathUrlAndClearFieldsIfNeeded(pathUrl);
        if (this._cacheInterface == null) {
            try {
                Repository myRepository = this.getRepositoryAdapter(pathUrl);
                EntryInterface entry = myRepository.getEntry(pathUrl);
                if (entry == null) {
                    throw new ServiceException(Message.format((ResourceBundle)RB.getResources(), (String)"RRS.entryShouldExist.ex.fmt.txt", (Object)pathUrl.getAbsolutePath()));
                }
                this._cacheInterface = this.getCache(entry, "SPRCache", pathUrl);
            }
            catch (RepositoryException e) {
                throw new ServiceException((Throwable)e);
            }
        }
    }

    Repository getRepositoryAdapter(PathUrl pathUrl) throws RemoteException, ServiceException {
        this.checkPathUrlAndClearFieldsIfNeeded(pathUrl);
        if (this._reportRepository != null) {
            return this._reportRepository;
        }
        RepositoryInterface ri = this._mi.getRepository();
        if (ri == null) {
            throw new ServiceException(RB.getStringResource("RRS.noRepos.msg.txt"));
        }
        UserContextInterface userContext = ri.getUserContext();
        if (userContext == null) {
            throw new ServiceException(RB.getStringResource("COM.noUserCtxt.ex.txt"));
        }
        try {
            RepositoryFactory repositoryFactory = new RepositoryFactory(userContext.getSessionContext());
            this._reportRepository = repositoryFactory.getReportRepository(pathUrl);
            if (this._reportRepository == null) {
                throw new ServiceException(Message.format((ResourceBundle)RB.getResources(), (String)"RRS.noRR.ex.fmt.txt", (Object)pathUrl.getAbsolutePath()));
            }
            this._pathUrl = pathUrl;
            return this._reportRepository;
        }
        catch (RepositoryIOException e) {
            throw new ServiceException((Throwable)e);
        }
        catch (RepositoryException e) {
            throw new ServiceException((Throwable)e);
        }
    }

    private void checkPathUrlAndClearFieldsIfNeeded(PathUrl pathUrl) throws ServiceException {
        if (pathUrl == null || pathUrl.getServer().length() == 0) {
            throw new ServiceException(RB.getStringResource("RRS.noPath.txt"));
        }
        if (this._pathUrl == null) {
            return;
        }
        if (this._pathUrl.equals((Object)pathUrl)) {
            return;
        }
        this.clearCacheInterface(true);
    }
}

