/*
 * Decompiled with CFR 0.152.
 */
package com.sas.publicobjects.storedprocessreport;

import com.sas.publicobjects.storedprocessreport.ExpirationPolicyInterface;
import com.sas.publicobjects.storedprocessreport.RB;
import com.sas.scheduler.model.DailyRecurrence;
import com.sas.scheduler.model.IRecurrenceInfo;
import com.sas.scheduler.model.InvalidRecurrenceException;
import com.sas.scheduler.model.MonthlyRecurrence;
import com.sas.scheduler.model.WeeklyRecurrence;
import com.sas.services.ServiceException;
import java.rmi.RemoteException;
import java.util.Calendar;
import java.util.Date;
import java.util.EnumSet;
import java.util.List;
import java.util.TimeZone;

public class ExpirationPolicy
implements ExpirationPolicyInterface {
    private static final long serialVersionUID = 773556415861621506L;
    private ExpirationPolicyInterface.Period _period = ExpirationPolicyInterface.Period.NONE;
    private int _hourOfDay;
    private int _minuteOfDay;
    private int _dayOfMonth;
    private TimeZone _timeZone = TimeZone.getDefault();
    private EnumSet<ExpirationPolicyInterface.DayOfWeek> _daysOfWeek;
    private ExpirationPolicyInterface.RecurringDay _recurringDay;
    private ExpirationPolicyInterface.RecurringOccurrence _recurringOccurrence;

    @Override
    public Date getExpirationDate() throws ServiceException {
        return this.getExpirationDate(null);
    }

    @Override
    public Date getExpirationDate(Date startDate) throws ServiceException {
        if (this._period == null) {
            return null;
        }
        if (startDate == null) {
            startDate = new Date();
        }
        Calendar start = this._timeZone == null ? Calendar.getInstance() : Calendar.getInstance(this._timeZone);
        start.setTime(startDate);
        Calendar end = (Calendar)start.clone();
        end.add(2, 6);
        switch (this._period) {
            case NONE: {
                return null;
            }
            case DAILY: {
                DailyRecurrence dr = new DailyRecurrence();
                return this.getNextRecurrence((IRecurrenceInfo)dr, start, end);
            }
            case WEEKLY: {
                EnumSet<ExpirationPolicyInterface.DayOfWeek> daysOfTheWeek = this.getDaysOfWeek();
                WeeklyRecurrence wr = new WeeklyRecurrence();
                int dayMask = 0;
                if (daysOfTheWeek.contains((Object)ExpirationPolicyInterface.DayOfWeek.SUNDAY)) {
                    dayMask |= 0x40;
                }
                if (daysOfTheWeek.contains((Object)ExpirationPolicyInterface.DayOfWeek.MONDAY)) {
                    dayMask |= 1;
                }
                if (daysOfTheWeek.contains((Object)ExpirationPolicyInterface.DayOfWeek.TUESDAY)) {
                    dayMask |= 2;
                }
                if (daysOfTheWeek.contains((Object)ExpirationPolicyInterface.DayOfWeek.WEDNESDAY)) {
                    dayMask |= 4;
                }
                if (daysOfTheWeek.contains((Object)ExpirationPolicyInterface.DayOfWeek.THURSDAY)) {
                    dayMask |= 8;
                }
                if (daysOfTheWeek.contains((Object)ExpirationPolicyInterface.DayOfWeek.FRIDAY)) {
                    dayMask |= 0x10;
                }
                if (daysOfTheWeek.contains((Object)ExpirationPolicyInterface.DayOfWeek.SATURDAY)) {
                    dayMask |= 0x20;
                }
                wr.setDaysToRun(dayMask);
                return this.getNextRecurrence((IRecurrenceInfo)wr, start, end);
            }
            case MONTHLY: {
                MonthlyRecurrence mr = new MonthlyRecurrence();
                int dom = this.getDayOfMonth();
                if (dom == 0) {
                    mr.setRecurringDay(128, 6);
                } else {
                    mr.setDayOfMonth(dom);
                }
                mr.setStartDate(start);
                mr.setEndDate(end);
                return this.getNextRecurrence((IRecurrenceInfo)mr, start, end);
            }
        }
        return null;
    }

    private Date getNextRecurrence(IRecurrenceInfo ir, Calendar start, Calendar end) throws ServiceException {
        try {
            List dates = ir.getNextDates(start, end, 3);
            for (Object date : dates) {
                Calendar test = (Calendar)date;
                test.set(11, this.getHourOfDay());
                test.set(12, this.getMinuteOfDay());
                test.set(13, 0);
                if (!test.after(start)) continue;
                return test.getTime();
            }
        }
        catch (InvalidRecurrenceException e) {
            throw new ServiceException(e.getMessage());
        }
        return null;
    }

    @Override
    public int getDayOfMonth() throws ServiceException {
        if (this._period != ExpirationPolicyInterface.Period.MONTHLY) {
            throw new IllegalStateException(RB.getStringResource("EP.CantInvk.ex.txt"));
        }
        return this._dayOfMonth;
    }

    @Override
    public EnumSet<ExpirationPolicyInterface.DayOfWeek> getDaysOfWeek() throws ServiceException {
        if (this._period != ExpirationPolicyInterface.Period.WEEKLY) {
            throw new IllegalStateException(RB.getStringResource("EP.CantInvk.ex.txt"));
        }
        return this._daysOfWeek;
    }

    @Override
    public ExpirationPolicyInterface.Period getPeriod() throws ServiceException {
        return this._period;
    }

    @Override
    public int getHourOfDay() throws ServiceException {
        return this._hourOfDay;
    }

    @Override
    public int getMinuteOfDay() throws ServiceException {
        return this._minuteOfDay;
    }

    @Override
    public void setHourOfDay(int hour) throws ServiceException {
        if (hour < 0 || hour > 23) {
            throw new IllegalArgumentException(RB.getStringResource("EP.InvHr.ex.txt"));
        }
        this._hourOfDay = hour;
    }

    @Override
    public void setMinuteOfDay(int minute) throws ServiceException {
        if (minute < 0 || minute > 59) {
            throw new IllegalArgumentException(RB.getStringResource("EP.InvMin.ex.txt"));
        }
        this._minuteOfDay = minute;
    }

    @Override
    public void setDayOfMonth(int dayOfMonth) {
        if (this._period != ExpirationPolicyInterface.Period.MONTHLY) {
            throw new IllegalStateException(RB.getStringResource("EP.CantInvk.ex.txt"));
        }
        if (dayOfMonth < 1 || dayOfMonth > 31) {
            throw new IllegalArgumentException(RB.getStringResource("EP.InvDOM.ex.txt"));
        }
        this._dayOfMonth = dayOfMonth;
        this._recurringDay = null;
        this._recurringOccurrence = null;
    }

    @Override
    public void setDaysOfWeek(EnumSet<ExpirationPolicyInterface.DayOfWeek> daysOfWeek) throws ServiceException {
        if (this._period != ExpirationPolicyInterface.Period.WEEKLY) {
            throw new IllegalStateException(RB.getStringResource("EP.CantInvk.ex.txt"));
        }
        this._daysOfWeek = daysOfWeek;
    }

    @Override
    public void setPeriod(ExpirationPolicyInterface.Period period) throws ServiceException {
        this._period = period;
    }

    @Override
    public TimeZone getTimeZone() throws ServiceException {
        return this._timeZone;
    }

    @Override
    public void setTimeZone(TimeZone timeZone) throws ServiceException {
        this._timeZone = timeZone;
    }

    @Override
    public void setRecurring(ExpirationPolicyInterface.RecurringDay day, ExpirationPolicyInterface.RecurringOccurrence occurrence) {
        if (this._period != ExpirationPolicyInterface.Period.MONTHLY) {
            throw new IllegalStateException(RB.getStringResource("EP.CantInvk.ex.txt"));
        }
        this._dayOfMonth = 0;
        if (day == null || occurrence == null) {
            throw new IllegalArgumentException(RB.getStringResource("COM.missingArg.txt"));
        }
        this._recurringDay = day;
        this._recurringOccurrence = occurrence;
    }

    @Override
    public ExpirationPolicyInterface.RecurringDay getRecurringDay() {
        if (this._period != ExpirationPolicyInterface.Period.MONTHLY) {
            throw new IllegalStateException(RB.getStringResource("EP.CantInvk.ex.txt"));
        }
        return this._recurringDay;
    }

    @Override
    public ExpirationPolicyInterface.RecurringOccurrence getRecurringOccurrence() {
        if (this._period != ExpirationPolicyInterface.Period.MONTHLY) {
            throw new IllegalStateException(RB.getStringResource("EP.CantInvk.ex.txt"));
        }
        return this._recurringOccurrence;
    }
}

