/*
 * Decompiled with CFR 0.152.
 */
package com.sas.publicobjects.reportdocument;

import com.sas.publicobjects.reportdocument.ReportDocumentEntry;
import com.sas.report.repository.ContentInterface;
import com.sas.report.repository.EntryInterface;
import com.sas.report.repository.OMRID;
import com.sas.report.repository.ReportEntryCreatorInterface;
import com.sas.report.repository.RepositoryException;
import com.sas.services.ServiceException;
import com.sas.services.information.OMIRepositoryInterface;
import com.sas.services.information.metadata.MetadataInterface;
import com.sas.util.UsageVersion;
import java.rmi.RemoteException;

public class ReportDocumentEntryCreator
implements ReportEntryCreatorInterface {
    private String _publicType;
    private UsageVersion _currentVersion;

    public ReportDocumentEntryCreator(String publicType, UsageVersion currentVersion) {
        this._publicType = publicType;
        this._currentVersion = currentVersion;
    }

    public EntryInterface createEntry(MetadataInterface entryObject, OMRID omrRepositoryId, ContentInterface content) throws RepositoryException, RemoteException {
        return new ReportDocumentEntry(entryObject, omrRepositoryId, content);
    }

    public EntryInterface createEntry(String entryName, String publicType, OMRID omrRepositoryId, ContentInterface content, OMIRepositoryInterface omiRepository) throws RepositoryException, RemoteException {
        if (!this._publicType.equalsIgnoreCase(publicType)) {
            throw new RepositoryException("Unable to create " + publicType + " object in " + this._publicType + " EntryCreator.");
        }
        try {
            MetadataInterface mi = omrRepositoryId.createSmartObject(entryName, omiRepository, this._publicType, this._publicType, this._currentVersion.encode());
            return this.createEntry(mi, omrRepositoryId, content);
        }
        catch (ServiceException e) {
            throw new RepositoryException((Throwable)e, e.getMessage());
        }
    }
}

