/*
 * Decompiled with CFR 0.152.
 */
package com.sas.olapadmin.utilities;

import com.sas.olapadmin.designer.model.ModelUtilities;
import com.sas.swing.visuals.util.Util;
import com.sas.util.Strings;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WorkspaceFile;
import java.text.DecimalFormat;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JLabel;

public class Utilities {
    private static WAdminResource bundle = new WAdminResource(Utilities.class);
    public static final int APPEND_OPTION = 0;
    public static final int REPLACE_OPTION = 1;
    public static final int CANCEL_OPTION = 2;
    public static String BATCH_SECURITY_PATHS = "CubeStudio.BatchSecurity.Path.";
    private static WorkspaceFile fileAppDefaults;
    public static int MAX_PATHS;
    private static Vector batchSecurityPaths;

    public static boolean isConnectedToMetadataServer(boolean showPrompt) {
        int iRC;
        return !Workspace.getWorkspace().isServerStatusCheckEnabled() || (iRC = Workspace.getWorkspace().checkMetadataServerStatus(showPrompt)) != Workspace.SERVERSTATUS_ERROR && iRC != Workspace.SERVERSTATUS_PAUSED;
    }

    public static boolean isBlank(String value) {
        return value == null || Strings.trimmedLength((String)value) == 0;
    }

    public static void setButtonTextAndMnemonic(AbstractButton field, String item) {
        String text = Util.getLabelWithoutMnemonic((String)item);
        field.setText(text);
        int index = Util.getDisplayedMnemonicIndex((String)item);
        if (index > -1) {
            int mnemonic = Util.getDisplayedMnemonic((String)item);
            field.setMnemonic(mnemonic);
            field.setDisplayedMnemonicIndex(index);
        }
    }

    public static void setLabelTextAndMnemonic(JLabel field, String item) throws IllegalArgumentException {
        String text = Util.getLabelWithoutMnemonic((String)item);
        field.setText(text);
        int index = Util.getDisplayedMnemonicIndex((String)item);
        if (index > -1) {
            int mnemonic = Util.getDisplayedMnemonic((String)item);
            field.setDisplayedMnemonic(mnemonic);
            field.setDisplayedMnemonicIndex(index);
        }
    }

    public static String trim(String input) {
        if (!Utilities.isBlank(input)) {
            input = input.trim();
            String tempInput = Strings.removeWhitespace((String)input);
            int index = input.indexOf(tempInput.charAt(0));
            input = input.substring(index, input.length());
        }
        return input;
    }

    public static void displayNonCriticalMessage(String message) {
        JButton[] buttons = new JButton[]{new JButton()};
        Utilities.setButtonTextAndMnemonic(buttons[0], bundle.getString("Common.Close.action.label"));
        MessageUtil.displayMessage((String)message, (String)Utilities.getMessageWindowTitle(), (int)-1, (JButton[])buttons);
    }

    public static String getMessageWindowTitle() {
        return bundle.getString("Common.Message.window.title");
    }

    public static String formatTime(double time, boolean alwaysShowHours) {
        DecimalFormat millisecFormat = new DecimalFormat("000");
        DecimalFormat twoDigitFormat = new DecimalFormat("00");
        String formattedTime = null;
        Double timeValue = new Double(time);
        if (timeValue != null) {
            int timeInt = timeValue.intValue();
            int hoursInt = timeInt / 3600;
            int minutesInt = (timeInt - hoursInt * 3600) / 60;
            int secondsInt = timeInt - hoursInt * 3600 - minutesInt * 60;
            Double msDouble = new Double((time - (double)timeInt) * 1000.0);
            String displayHours = twoDigitFormat.format(hoursInt);
            String displayMinutes = twoDigitFormat.format(minutesInt);
            String displaySeconds = twoDigitFormat.format(secondsInt);
            String displayMilliseconds = millisecFormat.format(msDouble.intValue());
            formattedTime = hoursInt == 0 & !alwaysShowHours ? bundle.formatString("FormatTime.MMSSMS.fmt.txt", (Object)displayMinutes, (Object)displaySeconds, (Object)displayMilliseconds) : bundle.formatString("FormatTime.HHMMSSMS.fmt.txt", (Object)displayHours, (Object)displayMinutes, (Object)displaySeconds, (Object)displayMilliseconds);
        }
        return formattedTime;
    }

    public static int displayFileExistsMessage(String saveToFile) {
        int option = Utilities.displayAppendReplaceDialog(bundle.formatString("ExportCode.Error.filename.exists.txt", (Object)saveToFile), bundle.getString("ExportCode.window.title"));
        return option;
    }

    public static int displayAppendReplaceDialog(String sMessage, String sTitle) {
        JButton[] appendReplaceButtons = new JButton[3];
        JButton append = new JButton();
        Utilities.setButtonTextAndMnemonic(append, bundle.getString("DisplayMessage.Append.action.label"));
        JButton replace = new JButton();
        Utilities.setButtonTextAndMnemonic(replace, bundle.getString("DisplayMessage.Replace.action.label"));
        JButton cancel = new JButton();
        Utilities.setButtonTextAndMnemonic(cancel, bundle.getString("DisplayMessage.Cancel.action.label"));
        appendReplaceButtons[0] = append;
        appendReplaceButtons[1] = replace;
        appendReplaceButtons[2] = cancel;
        int option = MessageUtil.displayMessage((String)sMessage, (String)sTitle, (int)3, (JButton[])appendReplaceButtons);
        return option;
    }

    private static Vector getPaths(String key) {
        Vector<String> pathsFromOlapdefTxt = new Vector<String>();
        for (int i = 0; i < MAX_PATHS; ++i) {
            String path = fileAppDefaults.getPropertyString(key + i);
            if (ModelUtilities.isBlank((String)path)) continue;
            pathsFromOlapdefTxt.add(path);
        }
        return pathsFromOlapdefTxt;
    }

    public static void setBatchSecurityPaths(Vector newPaths) {
        Utilities.setPaths(BATCH_SECURITY_PATHS, newPaths);
    }

    private static void setPaths(String key, Vector newPaths) {
        if (newPaths.size() == MAX_PATHS + 1) {
            newPaths.remove(newPaths.size() - 1);
        }
        int size = newPaths.size();
        for (int i = 0; i < size; ++i) {
            String path = (String)newPaths.get(i);
            fileAppDefaults.setPropertyString(key + i, path);
        }
    }

    public static Vector getBatchSecurityPaths() {
        if (batchSecurityPaths == null) {
            batchSecurityPaths = Utilities.getPaths(BATCH_SECURITY_PATHS);
        }
        return batchSecurityPaths;
    }

    static {
        MAX_PATHS = 5;
        fileAppDefaults = Workspace.getWorkspace().getAppDefaultsFile();
    }
}

