/*
 * Decompiled with CFR 0.152.
 */
package com.sas.olapadmin.utilities;

import com.sas.metadata.remote.Cube;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.OLAPSchema;
import com.sas.olapadmin.designer.model.ModelUtilities;
import com.sas.olapadmin.designer.model.OLAPCube;
import com.sas.olapadmin.designer.model.OLAPDimension;
import com.sas.olapadmin.designer.model.OLAPHierarchy;
import com.sas.olapadmin.designer.model.OlapServer;
import com.sas.olapadmin.utilities.ExceptionHandler;
import com.sas.olapadmin.utilities.MemberTreeCellRenderer;
import com.sas.olapadmin.utilities.MemberTreeNode;
import com.sas.storage.olap.Filter;
import com.sas.storage.olap.MemberInterface;
import com.sas.storage.olap.MetadataEntityInterface;
import com.sas.storage.olap.OLAPException;
import com.sas.storage.olap.sasmdx.Metadata;
import com.sas.workspace.OpRequestUI;
import com.sas.workspace.WAPanel;
import com.sas.workspace.Workspace;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Enumeration;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.TreePath;

public class MemberTreePanel
extends WAPanel
implements TreeExpansionListener,
TreeWillExpandListener {
    private static final long serialVersionUID = 1L;
    protected JTree tree;
    protected Cube cube;
    protected com.sas.metadata.remote.Dimension dimension;
    protected OlapServer server;
    protected boolean showLeafNodes;
    protected boolean showMeasures;
    protected boolean showHierarchy;
    protected boolean toggleClick;
    private JScrollPane treePane;
    private OLAPCube olapCube;
    private OLAPDimension olapDimension;
    private String uniqueName;
    private OLAPHierarchy olapHierarchy;

    public MemberTreePanel(Cube inCube, OlapServer inServer) {
        this(inCube, inServer, true, true, true, null, true);
    }

    public MemberTreePanel(Cube inCube, OlapServer inServer, boolean leaf) {
        this(inCube, inServer, leaf, true, true, null, true);
    }

    public MemberTreePanel(Cube inCube, OlapServer inServer, boolean leaf, boolean measures) {
        this(inCube, inServer, leaf, measures, true, null, true);
    }

    public MemberTreePanel(Cube inCube, OlapServer inServer, boolean leaf, boolean measures, boolean hiers) {
        this(inCube, inServer, leaf, measures, hiers, null, true);
    }

    public MemberTreePanel(Cube inCube, OlapServer inServer, boolean leaf, boolean measures, boolean hiers, com.sas.metadata.remote.Dimension dim) {
        this(inCube, inServer, leaf, measures, hiers, dim, true);
    }

    public MemberTreePanel(Cube inCube, OlapServer inServer, boolean leaf, boolean measures, boolean hiers, com.sas.metadata.remote.Dimension dim, boolean inToggleClick) {
        this.cube = inCube;
        this.server = inServer;
        this.showLeafNodes = leaf;
        this.showMeasures = measures;
        this.showHierarchy = hiers;
        this.dimension = dim;
        this.toggleClick = inToggleClick;
        this.layoutWidgets();
    }

    public MemberTreePanel(OLAPCube inCube, OlapServer inServer, boolean leaf, boolean measures, boolean hiers, OLAPDimension dimension2, boolean click) {
        this(inCube, inServer, leaf, measures, hiers, dimension2, click, null);
    }

    public MemberTreePanel(OLAPCube inCube, OlapServer inServer, boolean leaf, boolean measures, boolean hiers, OLAPDimension dimension2, boolean click, OLAPHierarchy hier) {
        this.olapCube = inCube;
        this.server = inServer;
        this.showLeafNodes = leaf;
        this.showMeasures = measures;
        this.showHierarchy = hiers;
        this.olapDimension = dimension2;
        this.olapHierarchy = hier;
        this.toggleClick = click;
        this.layoutWidgets();
    }

    public JTree getTreeComponent() {
        return this.tree;
    }

    protected void showProgressIndicator(String sTitle, String sMessage, Runnable run) {
        OpRequestUI request = new OpRequestUI((Component)((Object)this), sTitle, sMessage);
        JLabel lblSize = new JLabel("XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX");
        request.setMessagePreferredSize(lblSize.getPreferredSize());
        request.setDelayBeforeProgressCancelDialog(250);
        request.execute(run);
        request = null;
    }

    protected void layoutWidgets() {
        this.setLayout(new GridBagLayout());
        this.tree = new JTree();
        this.tree.setShowsRootHandles(true);
        this.tree.getSelectionModel().setSelectionMode(1);
        this.tree.addTreeExpansionListener(this);
        this.tree.addTreeWillExpandListener(this);
        this.treePane = new JScrollPane(this.tree);
        this.treePane.setPreferredSize(new Dimension(100, 200));
        this.add(this.treePane, new GridBagConstraints(0, 1, 3, 1, 1.0, 1.0, 18, 1, new Insets(5, 0, 0, 0), 0, 0));
    }

    public void moveDataToStore() throws MdException, RemoteException {
    }

    public void moveDataToView() throws MdException, RemoteException {
        MemberTreeNode root = null;
        if (this.cube != null) {
            root = new MemberTreeNode(this.cube, this.server, this.showLeafNodes, this.showMeasures, this.showHierarchy, this.dimension);
        } else if (this.olapCube != null || this.olapDimension != null) {
            root = new MemberTreeNode(this.olapCube, this.server, this.showLeafNodes, this.showMeasures, this.showHierarchy, this.olapDimension, this.olapHierarchy);
        }
        ((DefaultTreeModel)this.tree.getModel()).setRoot(root);
        this.tree.setCellRenderer(new MemberTreeCellRenderer());
        if (this.toggleClick) {
            this.tree.setToggleClickCount(1);
        }
        this.tree.addFocusListener(new BrowseTreeFocusAdapter());
        if (!ModelUtilities.isBlank((String)this.uniqueName)) {
            this.findSelectedMember();
        }
    }

    public void populateStore() throws MdException, RemoteException {
        this.setStorePopulated(true);
    }

    public boolean validateData() {
        return true;
    }

    public void setEnabled(boolean bEnabled) {
        super.setEnabled(bEnabled);
        this.enableComponents(bEnabled);
    }

    public void setSelectedMember(String uniqueName) {
        this.uniqueName = uniqueName;
    }

    private void findSelectedMember() {
        if (ModelUtilities.isBlank((String)this.uniqueName)) {
            return;
        }
        try {
            if (this.server.isConnected()) {
                DefaultMutableTreeNode selectedNode = null;
                Filter filter = new Filter();
                Metadata metadataSet = null;
                if (this.olapCube != null) {
                    metadataSet = this.server.getCubeMetadataSet();
                    filter.setCubeName(this.olapCube.getName());
                    OLAPSchema schema = this.olapCube.getAssociatedOLAPSchema();
                    String schemaName = "";
                    if (schema != null) {
                        schemaName = schema.getName();
                    }
                    filter.setSchemaName(schemaName);
                } else if (this.olapDimension != null) {
                    metadataSet = this.server.getSharedDimensionMetadataSet();
                    filter.setIncludeSharedDimensions(true);
                }
                filter.setUniqueMemberName(this.uniqueName);
                MemberInterface[] members = metadataSet.getMembers(filter, 0, 1);
                if (members != null && members.length > 0) {
                    MemberInterface member = members[0];
                    selectedNode = (MemberTreeNode)this.tree.getModel().getRoot();
                    if (this.olapCube != null) {
                        String dimName = member.getDimension().getUniqueName();
                        selectedNode = this.findNode(dimName, (MemberTreeNode)selectedNode);
                    }
                    if (selectedNode != null) {
                        ArrayList<MemberInterface> membersToCheck = new ArrayList<MemberInterface>();
                        membersToCheck.add(member);
                        for (MemberInterface parent = member.getParentMember(); parent != null; parent = parent.getParentMember()) {
                            membersToCheck.add(parent);
                        }
                        for (int i = membersToCheck.size() - 1; i >= 0 && selectedNode != null; --i) {
                            MemberInterface mbr = (MemberInterface)membersToCheck.get(i);
                            String name = mbr.getUniqueName();
                            selectedNode = this.findNode(name, (MemberTreeNode)selectedNode);
                        }
                    }
                }
                if (selectedNode != null) {
                    Object[] nodes = selectedNode.getPath();
                    this.tree.setSelectionPath(new TreePath(nodes));
                }
            }
        }
        catch (com.sas.olapadmin.designer.model.OLAPException e) {
            ExceptionHandler.handleException((Exception)((Object)e));
        }
        catch (RemoteException e) {
            Workspace.handleRemoteException((RemoteException)e);
        }
        catch (OLAPException e) {
            ExceptionHandler.handleException(e);
        }
    }

    private MemberTreeNode findNode(String name, MemberTreeNode startingNode) throws OLAPException {
        MemberTreeNode node = null;
        Enumeration e = startingNode.children();
        while (e.hasMoreElements() && node == null) {
            MemberTreeNode childNode = (MemberTreeNode)e.nextElement();
            MetadataEntityInterface obj = (MetadataEntityInterface)childNode.getUserObject();
            if (!obj.getUniqueName().equals(name)) continue;
            node = childNode;
        }
        return node;
    }

    private void enableComponents(boolean bEnabled) {
        this.tree.setEnabled(bEnabled);
    }

    @Override
    public void treeCollapsed(TreeExpansionEvent event) {
        this.setCursor(Cursor.getPredefinedCursor(0));
    }

    @Override
    public void treeExpanded(TreeExpansionEvent event) {
        this.setCursor(Cursor.getPredefinedCursor(0));
    }

    @Override
    public void treeWillCollapse(TreeExpansionEvent event) throws ExpandVetoException {
        this.setCursor(Cursor.getPredefinedCursor(3));
    }

    @Override
    public void treeWillExpand(TreeExpansionEvent event) throws ExpandVetoException {
        this.setCursor(Cursor.getPredefinedCursor(3));
    }

    public class BrowseTreeFocusAdapter
    implements FocusListener {
        @Override
        public void focusGained(FocusEvent e) {
            if (MemberTreePanel.this.tree.getMaxSelectionRow() < 0) {
                MemberTreePanel.this.tree.setSelectionRow(0);
            }
        }

        @Override
        public void focusLost(FocusEvent e) {
        }
    }
}

