/*
 * Decompiled with CFR 0.152.
 */
package com.sas.olapadmin.utilities;

import com.sas.expressions.visuals.DefaultFunctionTree;
import com.sas.expressions.visuals.DefaultOperationList;
import com.sas.expressions.visuals.ExpressionBuilderPanel;
import com.sas.expressions.visuals.ExpressionTextPane;
import com.sas.expressions.visuals.Operation;
import com.sas.expressions.visuals.OperationListInterface;
import com.sas.metadata.remote.Cube;
import com.sas.metadata.remote.MdException;
import com.sas.olapadmin.designer.model.ModelUtilities;
import com.sas.olapadmin.designer.model.OLAPCube;
import com.sas.olapadmin.designer.model.OLAPDimension;
import com.sas.olapadmin.designer.model.OLAPException;
import com.sas.olapadmin.designer.model.OlapServer;
import com.sas.olapadmin.utilities.ExceptionHandler;
import com.sas.olapadmin.utilities.ExpressionTreeModel;
import com.sas.olapadmin.utilities.MemberTreeNode;
import com.sas.olapadmin.utilities.Utilities;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WAStandardDialog;
import com.sas.workspace.WAdminResource;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.rmi.RemoteException;
import java.util.ArrayList;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class MDXExpressionBuilder
extends WAPanel
implements ActionListener,
DocumentListener {
    private static final long serialVersionUID = 1L;
    private static WAdminResource bundle = new WAdminResource(MDXExpressionBuilder.class);
    private ExpressionBuilderPanel expressionBuilderPanel;
    private ExpressionTreeModel sourceTree;
    private boolean verifiedOK;
    private Cube cube;
    private OLAPCube olapCube;
    private com.sas.metadata.remote.Dimension dimension;
    private OLAPDimension olapDimension;
    private OlapServer olapServer;
    private String beginning;
    private String expression;
    private String ending;
    private boolean showIdentities = false;

    public MDXExpressionBuilder(Cube inCube, OlapServer inServer, com.sas.metadata.remote.Dimension inDim, String inStart, String inExpression, String inEnd, boolean showId) {
        this.cube = inCube;
        this.olapServer = inServer;
        this.dimension = inDim;
        this.beginning = inStart;
        this.expression = inExpression;
        this.ending = inEnd;
        this.showIdentities = showId;
        this.layoutWidgets();
    }

    public MDXExpressionBuilder(OLAPCube inCube, OlapServer inServer, OLAPDimension inDim, String inStart, String inExpression, String inEnd, boolean showId) {
        this.olapCube = inCube;
        this.olapServer = inServer;
        this.olapDimension = inDim;
        this.beginning = inStart;
        this.expression = inExpression;
        this.ending = inEnd;
        this.showIdentities = showId;
        this.layoutWidgets();
    }

    private void connectToServer() {
        if (!this.olapServer.isConnected() && Utilities.isConnectedToMetadataServer(true)) {
            try {
                this.olapServer.connect();
                MemberTreeNode node = this.sourceTree.getMemberTreeRoot();
                node.initializeRoot();
            }
            catch (OLAPException e) {
                ExceptionHandler.handleException((Exception)((Object)e));
            }
        }
    }

    protected void layoutWidgets() {
        this.setLayout(new GridBagLayout());
        this.expressionBuilderPanel = new ExpressionBuilderPanel();
        this.expressionBuilderPanel.setOpaque(false);
        this.expressionBuilderPanel.setExpressionLabelVisible(true);
        this.expressionBuilderPanel.setValidationButtonVisible(true);
        this.expressionBuilderPanel.setSingleButtonInsertInToolBar(false);
        this.expressionBuilderPanel.setSingleButtonInsertMode(true);
        this.expressionBuilderPanel.setSourceDescriptionEnabled(true);
        this.setHelpProduct(this.expressionBuilderPanel.getDefaultHelpProduct());
        this.setHelpTopic(this.expressionBuilderPanel.getDefaultHelpMapID());
        DefaultOperationList operations = new DefaultOperationList("MDX");
        ArrayList<Operation> ops = new ArrayList<Operation>(operations.getOperations());
        String commaName = bundle.getString("MDXExpressionBuilder.Comma.txt");
        ops.add(new Operation(commaName, commaName, ",", bundle.getString("MDXExpressionBuilder.Comma.tip"), ",", new ArrayList()));
        operations = new DefaultOperationList(ops);
        this.expressionBuilderPanel.setOperationList((OperationListInterface)operations);
        DefaultFunctionTree mdxFunctions = new DefaultFunctionTree(1);
        this.expressionBuilderPanel.setFunctionListTreeModel((TreeModel)mdxFunctions);
        this.sourceTree = this.olapCube != null ? new ExpressionTreeModel(this.olapCube, this.olapServer, this.olapDimension, true, this.showIdentities, (JPanel)((Object)this)) : new ExpressionTreeModel(this.cube, this.olapServer, this.dimension, true, this.showIdentities, (JPanel)((Object)this));
        this.expressionBuilderPanel.setDataSourceTreeModel((TreeModel)this.sourceTree);
        if (this.olapServer != null && !this.olapServer.isConnected()) {
            JTree tree = this.sourceTree.getTree();
            tree.addTreeWillExpandListener(new cTreeWillExpandListener());
        }
        this.expressionBuilderPanel.setPreferredSize(new Dimension(500, 400));
        this.expressionBuilderPanel.addValidateActionListener((ActionListener)this);
        this.expressionBuilderPanel.setExpressionText(this.expression);
        this.add((Component)this.expressionBuilderPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    public void moveDataToStore() throws MdException, RemoteException {
    }

    public void moveDataToView() throws MdException, RemoteException {
        ExpressionTextPane textPane = this.expressionBuilderPanel.getExpressionTextPane();
        textPane.getDocument().addDocumentListener(this);
    }

    public void populateStore() throws MdException, RemoteException {
        this.setStorePopulated(true);
    }

    public boolean validateData() {
        String text;
        if (this.cube == null && this.olapCube == null) {
            int answer = MessageUtil.displayMessage((String)bundle.getString("MDXExpressionBuilder.SharedDimensionYesNo.txt"), (int)1, (int)0);
            if (answer == 0) {
                return true;
            }
            if (answer == 1) {
                return false;
            }
        }
        if (!ModelUtilities.isBlank((String)(text = this.expressionBuilderPanel.getExpressionText())) && !this.verifiedOK) {
            String temp = text;
            int newpos = 0;
            int numClause = 0;
            int numValid = 0;
            while (newpos >= 0 && temp.length() > 0) {
                newpos = temp.indexOf("<!--CONDITION-->", 0);
                String clause = temp;
                ++numClause;
                if (newpos > 0 && newpos < temp.length()) {
                    clause = temp.substring(0, newpos);
                    temp = temp.substring(newpos + 16);
                }
                String mdxText = "";
                if (!ModelUtilities.isBlank((String)this.beginning)) {
                    mdxText = this.beginning;
                }
                mdxText = mdxText + clause;
                if (!ModelUtilities.isBlank((String)this.ending)) {
                    mdxText = mdxText + this.ending;
                }
                this.connectToServer();
                if (!this.olapServer.isConnected()) continue;
                try {
                    this.olapServer.verifyMdx(mdxText);
                    ++numValid;
                }
                catch (OLAPException e) {
                    ExceptionHandler.handleException((Exception)((Object)e));
                }
            }
            if (numClause == numValid) {
                this.verifiedOK = true;
                MessageUtil.displayMessage((String)bundle.getString("MDXExpression.ValidatedOK.txt"), (int)1);
            } else {
                this.verifiedOK = false;
            }
        } else {
            this.verifiedOK = true;
        }
        return this.verifiedOK;
    }

    public String getExpressionText() {
        return this.expressionBuilderPanel.getExpressionText();
    }

    public ExpressionBuilderPanel getExpressionBuilderPanel() {
        return this.expressionBuilderPanel;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        WAStandardDialog parent = (WAStandardDialog)this.getTopLevelAncestor();
        parent.setCursor(Cursor.getPredefinedCursor(3));
        this.verifiedOK = this.validateData();
        parent.setCursor(Cursor.getPredefinedCursor(0));
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.verifiedOK = false;
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.verifiedOK = false;
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.verifiedOK = false;
    }

    public class cTreeWillExpandListener
    implements TreeWillExpandListener {
        @Override
        public void treeWillExpand(TreeExpansionEvent event) throws ExpandVetoException {
            TreeNode selectedNode;
            TreePath selectedPath;
            if (!MDXExpressionBuilder.this.olapServer.isConnected() && (selectedPath = event.getPath()) != null && (selectedNode = (TreeNode)selectedPath.getLastPathComponent()) instanceof MemberTreeNode) {
                MDXExpressionBuilder.this.connectToServer();
            }
        }

        @Override
        public void treeWillCollapse(TreeExpansionEvent event) throws ExpandVetoException {
        }
    }
}

