/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.cache.impl;

import com.sas.services.cache.CacheStatistics;
import java.io.Serializable;

public class BaseCacheStatistics
implements CacheStatistics,
Serializable {
    private static final long serialVersionUID = 1L;
    private int hits;
    private int misses;
    private int count;
    private int highwater;
    private int accuracy;

    public BaseCacheStatistics() {
        this.hits = 0;
        this.misses = 0;
        this.count = 0;
        this.highwater = 0;
        this.accuracy = 1;
    }

    public BaseCacheStatistics(int hits, int misses, int count, int accuracy) {
        this.hits = hits;
        this.misses = misses;
        this.count = count;
        this.highwater = 0;
        this.accuracy = accuracy;
    }

    @Override
    public void clearStatistics() {
        this.hits = 0;
        this.misses = 0;
        this.count = 0;
        this.highwater = 0;
        this.accuracy = 2;
    }

    @Override
    public final int getCacheHits() {
        return this.hits;
    }

    public void incrementHits() {
        ++this.hits;
    }

    @Override
    public final int getCacheMisses() {
        return this.misses;
    }

    public void incrementMisses() {
        ++this.misses;
    }

    @Override
    public final int getObjectCount() {
        return this.count;
    }

    public void setObjectCount(int count) {
        if (count >= 0) {
            this.count = count;
        }
        if (count > this.highwater) {
            this.highwater = count;
        }
    }

    public void incrementObjectCount() {
        ++this.count;
        if (this.count > this.highwater) {
            this.highwater = this.count;
        }
    }

    public void decrementObjectCount() {
        if (this.count > 0) {
            --this.count;
        }
    }

    @Override
    public final int getStatisticsAccuracy() {
        return this.accuracy;
    }

    public String toString() {
        return "Hits: " + this.hits + "  Misses: " + this.misses + " count: " + this.count + "  highwater: " + this.highwater;
    }
}

