/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.cache.impl;

import com.sas.services.cache.Cache;
import com.sas.services.cache.CacheException;
import com.sas.services.cache.CacheFactory;
import com.sas.services.cache.impl.RB;
import java.io.FileInputStream;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class BaseCacheFactory
implements CacheFactory {
    private static final String CACHEPROPERTY = "com.sas.services.cacheconfig";
    private static final String RESOURCENAME = "cacheconfig.config";
    private static final String CACHECLASS_KEY = "CacheClass";
    private static Properties defaultProperties = null;
    public static final String CLASSLOADER_KEY = "ClassLoader";
    public static final String CACHELOADER_CLASS = "CacheLoaderClass";

    @Override
    public Cache createCache(Map env) throws CacheException {
        try {
            ClassLoader cl = null;
            Object o = env.get(CLASSLOADER_KEY);
            if (o != null && o instanceof ClassLoader) {
                cl = (ClassLoader)o;
            }
            if (cl == null) {
                cl = CacheFactory.class.getClassLoader();
            }
            Class<?> cacheClass = null;
            Object classObject = env.get(CACHECLASS_KEY);
            if (classObject == null) {
                throw new CacheException(RB.getStringResource("BaseCacheFactory.noclassmenv.msg.txt"));
            }
            if (classObject instanceof String) {
                String specClass = (String)classObject;
                cacheClass = cl.loadClass(specClass);
            }
            if (classObject instanceof Class) {
                cacheClass = (Class<?>)classObject;
            }
            Class[] ctorArgs = new Class[]{Map.class};
            Object[] ctorParms = new Object[]{env};
            Constructor<?> ctor = null;
            ctor = cacheClass.getConstructor(ctorArgs);
            Cache rc = (Cache)ctor.newInstance(ctorParms);
            return rc;
        }
        catch (ClassNotFoundException cnfe) {
            throw new CacheException(cnfe.getMessage(), cnfe);
        }
        catch (NoSuchMethodException nsme) {
            throw new CacheException(nsme.getMessage(), nsme);
        }
        catch (IllegalAccessException iae) {
            throw new CacheException(iae.getMessage(), iae);
        }
        catch (InvocationTargetException ite) {
            Throwable t = ite.getCause();
            t.printStackTrace(System.err);
            throw new CacheException(t.getMessage(), t);
        }
        catch (InstantiationException ie) {
            throw new CacheException(ie.getMessage(), ie);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Cache getCache(String namespace, String cacheNode, ClassLoader loader) throws CacheException {
        try {
            String filepath = System.getProperty(CACHEPROPERTY);
            InputStream inputStream = null;
            if (filepath == null) {
                if (defaultProperties == null) {
                    defaultProperties = new Properties();
                    inputStream = BaseCacheFactory.class.getResourceAsStream(RESOURCENAME);
                    try {
                        defaultProperties.load(inputStream);
                    }
                    finally {
                        inputStream.close();
                    }
                    defaultProperties.setProperty("NodeName", cacheNode);
                }
                return BaseCacheFactory.getCache(defaultProperties, namespace, cacheNode, loader);
            }
            inputStream = new FileInputStream(filepath);
            return BaseCacheFactory.getCache(inputStream, namespace, cacheNode, loader);
        }
        catch (Exception ex) {
            throw new CacheException(ex.getMessage(), ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Cache getCache(InputStream inputStream, String namespace, String cacheNode, ClassLoader loader) throws CacheException {
        Properties prop = new Properties();
        try {
            try {
                prop.load(inputStream);
            }
            finally {
                inputStream.close();
            }
            prop.setProperty("NodeName", cacheNode);
            return BaseCacheFactory.getCache(prop, namespace, cacheNode, loader);
        }
        catch (Exception ex) {
            throw new CacheException(ex.getMessage(), ex);
        }
    }

    private static Cache getCache(Properties prop, String namespace, String cacheNode, ClassLoader loader) throws CacheException {
        Properties newProp = BaseCacheFactory.makeSpecialProp(prop, namespace);
        String specClass = newProp.getProperty(CACHECLASS_KEY);
        if (specClass == null) {
            throw new RuntimeException(RB.getStringResource("BaseCacheFactory.noclassprop.msg.txt"));
        }
        ClassLoader cl = loader != null ? loader : CacheFactory.class.getClassLoader();
        HashMap<Object, Object> env = new HashMap<Object, Object>(newProp);
        env.put(CLASSLOADER_KEY, cl);
        BaseCacheFactory bcf = new BaseCacheFactory();
        return bcf.createCache(env);
    }

    private static Properties makeSpecialProp(Properties oldProp, String prefix) {
        Properties newProp = new Properties();
        ArrayList<Object> keyList = new ArrayList<Object>(oldProp.keySet());
        Collections.sort(keyList);
        for (String string : keyList) {
            int prefixEnd = string.lastIndexOf(46);
            String nextPrefix = null;
            nextPrefix = prefixEnd > 0 ? string.substring(0, prefixEnd) : "";
            if (!prefix.startsWith(nextPrefix)) continue;
            String plainKey = string.substring(prefixEnd + 1);
            String value = oldProp.getProperty(string);
            newProp.put(plainKey, value);
        }
        return newProp;
    }
}

