/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.events.alerts;

import com.sas.framework.commons.holders.ClientApplicationNameHolder;
import com.sas.svcs.events.alerts.AlertEventMessage;
import com.sas.svcs.events.alerts.Alertable;
import com.sas.svcs.events.client.adapters.AbstractEventDelegate;
import com.sas.svcs.events.client.senders.EventSenderInterface;

public class AlertableEventDelegate
extends AbstractEventDelegate {
    private EventSenderInterface eventSender;

    public void setEventSender(EventSenderInterface esi) {
        this.eventSender = esi;
    }

    public void handleEvent(Alertable alert) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("AlertableEventDelegate received the object: " + alert);
        }
        if (!this.valid(alert)) {
            return;
        }
        AlertEventMessage message = new AlertEventMessage();
        message.setAlertConditions(alert.getAlertableConditions());
        message.setDirective(alert.getTargetDirective());
        message.setEventName(alert.getEventName());
        message.setHttpParameters(alert.getHttpParameters());
        message.setSoftwareComponent(ClientApplicationNameHolder.getName());
        message.setNotificationType(alert.getNotificationType());
        message.setNotificationTemplate(alert.getNotificationTemplate());
        message.setNotificationHoldInterval(alert.getNotificationHoldInterval());
        message.setNotificationVariables(alert.getNotificationVariables());
        this.eventSender.send((Object)message);
    }

    private boolean valid(Alertable alert) {
        if (null == alert) {
            return false;
        }
        String name = alert.getEventName();
        if (null == name || "".equals(name)) {
            return false;
        }
        return null != alert.getAlertableConditions() && !alert.getAlertableConditions().isEmpty();
    }
}

