/*
 * Decompiled with CFR 0.152.
 */
package com.sas.security;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.security.AccessController;
import java.security.Permission;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Properties;

public final class PermissionFactory {
    private Properties permissionsMap = new Properties();
    private static PermissionFactory instance = new PermissionFactory();

    public static PermissionFactory getInstance() {
        return instance;
    }

    private PermissionFactory() {
        FileInputStream inputStream = null;
        try {
            inputStream = (FileInputStream)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws FileNotFoundException {
                    String configFileNamePath = System.getProperty("com.sas.security.permissionfactory.config.file");
                    if (configFileNamePath == null) {
                        return null;
                    }
                    return new FileInputStream(configFileNamePath);
                }
            });
            if (inputStream != null) {
                this.permissionsMap.load(inputStream);
            }
        }
        catch (PrivilegedActionException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {}
            }
        }
    }

    public Permission getPermission(Permission inputPerm) {
        String inputClassName = inputPerm.getClass().getName();
        try {
            String outClassName = this.permissionsMap.getProperty(inputClassName);
            if (outClassName == null) {
                return inputPerm;
            }
            Class<?> outClass = Class.forName(outClassName);
            try {
                Constructor<?> outClassConstructor = outClass.getConstructor(inputPerm.getClass());
                return (Permission)outClassConstructor.newInstance(inputPerm);
            }
            catch (NoSuchMethodException outClassConstructor) {
                try {
                    Object[] argsArray = new Object[]{inputPerm.getName(), inputPerm.getActions()};
                    int i = 2;
                    if (i >= 0) {
                        Class[] argTypes = new Class[i];
                        Object[] args = new Object[i];
                        for (int j = 0; j < i; ++j) {
                            argTypes[j] = String.class;
                            args[j] = argsArray[j];
                        }
                        Constructor<?> outClassConstructor2 = outClass.getConstructor(argTypes);
                        return (Permission)outClassConstructor2.newInstance(args);
                    }
                }
                catch (NoSuchMethodException noSuchMethodException) {}
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return inputPerm;
        }
        return inputPerm;
    }
}

