/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.backup.common.impl;

import com.sas.svcs.backup.common.definitions.BackupErrorConstants;
import com.sas.svcs.backup.common.definitions.BackupErrorDetails;
import com.sas.svcs.backup.common.definitions.BackupErrorEntry;
import com.sas.svcs.backup.common.definitions.BackupErrorLogger;
import com.sas.svcs.backup.common.definitions.BackupException;
import com.sas.svcs.backup.common.impl.BackupErrorXmlFormatter;
import java.util.LinkedList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component(value="BackupErrorXmlLogger")
public class BackupErrorXmlLogger
implements BackupErrorLogger {
    @Autowired
    @Qualifier(value="BackupErrorXmlFormatter")
    private BackupErrorXmlFormatter errorFormatter;
    private static final Logger logger = LogManager.getLogger(BackupErrorXmlLogger.class);
    public static final String LOG_FOR = " for ";
    public static final String LOG_COMMA = ", ";
    public static final String LOG_COLON = ": ";
    public static final String LOG_OR = " or ";
    private static final String ERROR_SUMMARY = "";
    private static final String ERROR_MESSAGE = "Exception occured";

    @Override
    public String generateErrorEntryMessage(BackupException pBackupException) throws BackupException {
        BackupErrorEntry errorEntry = null;
        String lErrorXMLMsg = null;
        StringBuffer lErrorMsg = null;
        if (pBackupException != null) {
            try {
                errorEntry = this.getErrorEntry(pBackupException);
                lErrorXMLMsg = this.errorFormatter.createFormattedErrorEntry(errorEntry);
                lErrorXMLMsg = lErrorXMLMsg.replaceAll("\r\n", ERROR_SUMMARY);
                lErrorXMLMsg = lErrorXMLMsg.replaceAll("\n", ERROR_SUMMARY);
                lErrorMsg = new StringBuffer("\tError Start|||  ");
                lErrorMsg.append(lErrorXMLMsg);
                lErrorMsg.append("\t\t|||  Error End");
            }
            catch (BackupException e) {
                throw e;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                logger.error((Object)exception);
                throw new BackupException(exception, BackupErrorConstants.ErrorCodes.ERROR_CODE_ERROR_XML_GENERATION_FAILED.getErrorCode());
            }
        }
        return lErrorXMLMsg;
    }

    @Override
    public String generateCompleteErrorMessage(BackupErrorDetails backupError) throws BackupException {
        String lErrorXMLMsg = null;
        try {
            lErrorXMLMsg = this.errorFormatter.createFormattedErrorMessage(backupError);
            lErrorXMLMsg = lErrorXMLMsg.replaceAll("\r\n", ERROR_SUMMARY);
            lErrorXMLMsg = lErrorXMLMsg.replaceAll("\n", ERROR_SUMMARY);
        }
        catch (BackupException e) {
            throw e;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            logger.error((Object)exception);
            throw new BackupException(exception, BackupErrorConstants.ErrorCodes.ERROR_CODE_ERROR_XML_GENERATION_FAILED.getErrorCode());
        }
        backupError.setFormattedErrorMessage(lErrorXMLMsg);
        return lErrorXMLMsg;
    }

    @Override
    public BackupErrorEntry getErrorEntry(BackupException backupException) throws BackupException {
        BackupErrorEntry errorEntry = null;
        int lErrorCode = 0;
        StringBuffer strBuffer = null;
        if (backupException != null) {
            try {
                String errorCategory;
                String remedyCause;
                String logFileLoc;
                String logName;
                lErrorCode = Integer.parseInt(backupException.getErrorInfo("errorCode"));
                errorEntry = this.errorFormatter.getErrorEntry(lErrorCode);
                if (null == errorEntry) {
                    errorEntry = new BackupErrorEntry();
                    errorEntry.setErrorCode(lErrorCode);
                    errorEntry.setErrorSummary(ERROR_SUMMARY);
                    errorEntry.setErrorMessage(ERROR_MESSAGE);
                    errorEntry.setErrorMessageForMail(ERROR_MESSAGE);
                }
                errorEntry.setDateTimeOfError(backupException.getErrorInfo("dateTimeOfError"));
                errorEntry.setStackTrace(backupException.getErrorInfo("stackTrace"));
                errorEntry.setOriginalMessage(backupException.getErrorInfo("originalMessage"));
                String operationType = backupException.getErrorInfo("operationType");
                if (operationType != null) {
                    errorEntry.setOperationType(operationType);
                }
                if ((logName = backupException.getErrorInfo("logName")) != null) {
                    errorEntry.setLogName(logName);
                }
                if ((logFileLoc = backupException.getErrorInfo("logFileLocation")) != null) {
                    errorEntry.setLogFileLocation(logFileLoc);
                }
                String errorOriginatingTier = backupException.getErrorInfo("errorOriginatingTier");
                if (logFileLoc != null) {
                    errorEntry.setErrorOriginatingTier(errorOriginatingTier);
                }
                strBuffer = new StringBuffer(errorEntry.getErrorMessage());
                errorEntry.setErrorMessage(strBuffer.toString());
                String possibleCause = backupException.getErrorInfo("possibleCause");
                if (possibleCause != null) {
                    strBuffer = new StringBuffer();
                    if (strBuffer.length() > 0) {
                        strBuffer.append(LOG_OR);
                    }
                    strBuffer.append(possibleCause);
                    errorEntry.setPossibleCause(strBuffer.toString());
                }
                if ((remedyCause = backupException.getErrorInfo("remedyMessage")) != null) {
                    strBuffer = new StringBuffer();
                    if (strBuffer.length() > 0) {
                        strBuffer.append(LOG_OR);
                    }
                    strBuffer.append(remedyCause);
                    errorEntry.setRemedyMessage(strBuffer.toString());
                }
                if ((errorCategory = backupException.getErrorInfo("errorCategory")) != null) {
                    errorEntry.setErrorCategory(errorCategory);
                }
            }
            catch (BackupException e) {
                throw new BackupException("Errors encountered and error message generation failed.", backupException, BackupErrorConstants.ErrorCodes.ERROR_CODE_ERROR_XML_GENERATION_FAILED.getErrorCode());
            }
            catch (Exception exception) {
                exception.printStackTrace();
                logger.error((Object)exception);
                throw new BackupException("Errors encountered and error message generation failed.", backupException, BackupErrorConstants.ErrorCodes.ERROR_CODE_ERROR_XML_GENERATION_FAILED.getErrorCode());
            }
        }
        return errorEntry;
    }

    @Override
    public List<BackupErrorEntry> getErrorEntries(List<BackupException> exceptions) throws BackupException {
        LinkedList<BackupErrorEntry> errorEntries = new LinkedList<BackupErrorEntry>();
        try {
            for (BackupException be : exceptions) {
                BackupErrorEntry errorEntry = this.getErrorEntry(be);
                errorEntries.add(errorEntry);
            }
        }
        catch (BackupException e) {
            throw e;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            logger.error((Object)exception);
            throw new BackupException(exception, BackupErrorConstants.ErrorCodes.ERROR_CODE_ERROR_XML_GENERATION_FAILED.getErrorCode());
        }
        return errorEntries;
    }
}

