/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.backup.common.impl;

import com.sas.svcs.backup.common.definitions.BackupErrorConstants;
import com.sas.svcs.backup.common.definitions.BackupErrorDetails;
import com.sas.svcs.backup.common.definitions.BackupErrorEntry;
import com.sas.svcs.backup.common.definitions.BackupException;
import com.sas.svcs.backup.common.impl.RB;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Locale;
import java.util.MissingResourceException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Component;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Component(value="BackupErrorXmlFormatter")
public class BackupErrorXmlFormatter {
    private static final Logger logger = LogManager.getLogger(BackupErrorXmlFormatter.class);

    public String createFormattedErrorMessage(BackupErrorDetails backupError) throws BackupException {
        logger.debug("Entering");
        String errorMessage = null;
        String lStrTemp = null;
        int lErrorCode = BackupErrorConstants.ErrorCodes.ERROR_CODE_UNKNOWN.getErrorCode();
        String lErrorMsg = null;
        ByteArrayOutputStream lStrRespMsg = null;
        XMLOutputFactory lOutputFactory = null;
        XMLStreamWriter lStreamWriter = null;
        try {
            if (null == backupError) {
                lErrorCode = BackupErrorConstants.ErrorCodes.ERROR_CODE_UNKNOWN.getErrorCode();
                lErrorMsg = "Error object is null";
                logger.error("Backup Exception: " + lErrorCode + lErrorMsg);
                throw new BackupException(lErrorMsg, lErrorCode);
            }
            logger.debug("Process for creating XML error message started");
            lOutputFactory = XMLOutputFactory.newInstance();
            lStrRespMsg = new ByteArrayOutputStream();
            lStreamWriter = lOutputFactory.createXMLStreamWriter(lStrRespMsg);
            lStreamWriter.writeStartElement("BackupErrors");
            lStreamWriter.writeStartElement("BackupError");
            for (BackupErrorEntry errorEntry : backupError.getBackupErrorEntries()) {
                this.appendBackupEntry(errorEntry, lStreamWriter);
            }
            lStreamWriter.writeStartElement("errorNotificationInformation");
            lStrTemp = Boolean.toString(backupError.isNotified());
            lStreamWriter.writeStartElement("isUserNotified");
            if (null != lStrTemp && !lStrTemp.isEmpty()) {
                lStreamWriter.writeCharacters(lStrTemp);
            } else {
                lStreamWriter.writeCharacters("Not Available");
            }
            lStreamWriter.writeEndElement();
            lStreamWriter.writeStartElement("mailDetails");
            lStrTemp = backupError.getMailSubject();
            lStreamWriter.writeStartElement("mailSubject");
            if (null != lStrTemp && !lStrTemp.isEmpty()) {
                lStreamWriter.writeCharacters(lStrTemp);
            } else {
                lStreamWriter.writeCharacters("Not Available");
            }
            lStreamWriter.writeEndElement();
            lStrTemp = backupError.getMailToAddress();
            lStreamWriter.writeStartElement("mailToAddress");
            if (null != lStrTemp && !lStrTemp.isEmpty()) {
                lStreamWriter.writeCharacters(lStrTemp);
            } else {
                lStreamWriter.writeCharacters("Not Available");
            }
            lStreamWriter.writeEndElement();
            lStrTemp = backupError.getMailCCAddress();
            lStreamWriter.writeStartElement("mailCCAddress");
            if (null != lStrTemp && !lStrTemp.isEmpty()) {
                lStreamWriter.writeCharacters(lStrTemp);
            } else {
                lStreamWriter.writeCharacters("Not Available");
            }
            lStreamWriter.writeEndElement();
            lStreamWriter.writeEndElement();
            lStreamWriter.writeEndElement();
            lStreamWriter.writeEndElement();
            lStreamWriter.writeEndElement();
            lStreamWriter.writeEndDocument();
            logger.debug("Process for creating XML error message completed successfully");
        }
        catch (XMLStreamException e) {
            logger.error("Process for creating XML error message aborted due to errors");
            throw new BackupException(e, BackupErrorConstants.ErrorCodes.ERROR_CODE_ERROR_XML_GENERATION_FAILED.getErrorCode());
        }
        finally {
            try {
                if (lStreamWriter != null) {
                    lStreamWriter.flush();
                    lStreamWriter.close();
                }
                if (null != lStrRespMsg) {
                    errorMessage = lStrRespMsg.toString();
                    lStrRespMsg.close();
                }
            }
            catch (Exception exception) {}
        }
        logger.debug("Exiting");
        return errorMessage;
    }

    private void appendBackupEntry(BackupErrorEntry errorEntry, XMLStreamWriter streamWriter) throws XMLStreamException {
        if (errorEntry != null) {
            logger.debug("Creating XML error entry  for error code: " + errorEntry.getErrorCode());
            streamWriter.writeStartElement("BackupErrorEntry");
            String temp = null;
            streamWriter.writeStartElement("errorHeader");
            streamWriter.writeStartElement("errorCode");
            temp = Integer.toString(errorEntry.getErrorCode());
            if (null != temp && !temp.isEmpty()) {
                streamWriter.writeCharacters(temp);
            } else {
                streamWriter.writeCharacters("Not Available");
            }
            streamWriter.writeEndElement();
            streamWriter.writeStartElement("errorImpact");
            temp = errorEntry.getErrorImpact();
            if (null != temp && !temp.isEmpty()) {
                streamWriter.writeCharacters(temp);
            } else {
                streamWriter.writeCharacters("Not Available");
            }
            streamWriter.writeEndElement();
            streamWriter.writeStartElement("errorClassification");
            temp = errorEntry.getErrorClassification();
            if (null != temp && !temp.isEmpty()) {
                streamWriter.writeCharacters(temp);
            } else {
                streamWriter.writeCharacters("Not Available");
            }
            streamWriter.writeEndElement();
            streamWriter.writeStartElement("errorName");
            temp = errorEntry.getErrorName();
            if (null != temp && !temp.isEmpty()) {
                streamWriter.writeCharacters(temp);
            } else {
                streamWriter.writeCharacters("Not Available");
            }
            streamWriter.writeEndElement();
            streamWriter.writeStartElement("errorCategory");
            temp = errorEntry.getErrorCategory();
            if (null != temp && !temp.isEmpty()) {
                streamWriter.writeCharacters(temp);
            } else {
                streamWriter.writeCharacters("Not Available");
            }
            streamWriter.writeEndElement();
            streamWriter.writeStartElement("errorSummary");
            temp = errorEntry.getErrorSummary();
            if (null != temp && !temp.isEmpty()) {
                streamWriter.writeCharacters(temp);
            } else {
                streamWriter.writeCharacters("Not Available");
            }
            streamWriter.writeEndElement();
            streamWriter.writeStartElement("dateTimeOfError");
            temp = errorEntry.getDateTimeOfError();
            if (null != temp && !temp.isEmpty()) {
                streamWriter.writeCharacters(temp);
            } else {
                streamWriter.writeCharacters("Not Available");
            }
            streamWriter.writeEndElement();
            temp = errorEntry.getLogName();
            streamWriter.writeStartElement("logName");
            if (null != temp && !temp.isEmpty()) {
                streamWriter.writeCharacters(temp);
            } else {
                streamWriter.writeCharacters("Not Available");
            }
            streamWriter.writeEndElement();
            temp = errorEntry.getLogFileLocation();
            streamWriter.writeStartElement("logFileLocation");
            if (null != temp && !temp.isEmpty()) {
                streamWriter.writeCharacters(temp);
            } else {
                streamWriter.writeCharacters("Not Available");
            }
            streamWriter.writeEndElement();
            temp = errorEntry.getOperationType();
            streamWriter.writeStartElement("operationType");
            if (null != temp && !temp.isEmpty()) {
                streamWriter.writeCharacters(temp);
            } else {
                streamWriter.writeCharacters("Not Available");
            }
            streamWriter.writeEndElement();
            temp = errorEntry.getErrorOriginatingTier();
            streamWriter.writeStartElement("errorOriginatingTier");
            if (null != temp && !temp.isEmpty()) {
                streamWriter.writeCharacters(temp);
            } else {
                streamWriter.writeCharacters("Not Available");
            }
            streamWriter.writeEndElement();
            streamWriter.writeEndElement();
            streamWriter.writeStartElement("errorBody");
            streamWriter.writeStartElement("errorMessage");
            temp = errorEntry.getErrorMessage();
            if (null != temp && !temp.isEmpty()) {
                streamWriter.writeCharacters(temp);
            } else {
                streamWriter.writeCharacters("Not Available");
            }
            streamWriter.writeEndElement();
            temp = errorEntry.getStackTrace();
            streamWriter.writeStartElement("stackTrace");
            if (temp != null) {
                streamWriter.writeCData(temp);
            }
            streamWriter.writeEndElement();
            temp = errorEntry.getPossibleCause();
            streamWriter.writeStartElement("possibleCause");
            if (null != temp && !temp.isEmpty()) {
                streamWriter.writeCharacters(temp);
            } else {
                streamWriter.writeCharacters("Not Available");
            }
            streamWriter.writeEndElement();
            temp = errorEntry.getOriginalMessage();
            streamWriter.writeStartElement("originalMessage");
            if (null != temp) {
                streamWriter.writeCData(temp);
            } else {
                streamWriter.writeCharacters("Not Available");
            }
            streamWriter.writeEndElement();
            temp = errorEntry.getRemedyMessage();
            streamWriter.writeStartElement("remedyMessage");
            if (null != temp) {
                streamWriter.writeCharacters(temp);
            } else {
                streamWriter.writeCharacters("Not Available");
            }
            streamWriter.writeEndElement();
            streamWriter.writeEndElement();
            streamWriter.writeEndElement();
            logger.debug("Completed XML entry creation for error code: " + errorEntry.getErrorCode());
        }
    }

    public String createFormattedErrorEntry(BackupErrorEntry errorEntry) throws BackupException {
        logger.debug("Creating formatted error entry");
        String errorMessage = null;
        ByteArrayOutputStream strEntry = null;
        XMLOutputFactory outputFactory = null;
        XMLStreamWriter streamWriter = null;
        try {
            outputFactory = XMLOutputFactory.newInstance();
            strEntry = new ByteArrayOutputStream();
            streamWriter = outputFactory.createXMLStreamWriter(strEntry);
            this.appendBackupEntry(errorEntry, streamWriter);
        }
        catch (XMLStreamException e) {
            logger.error("Process for creating XML error message aborted due to errors");
            throw new BackupException(e, BackupErrorConstants.ErrorCodes.ERROR_CODE_ERROR_XML_GENERATION_FAILED.getErrorCode());
        }
        finally {
            try {
                if (null != strEntry) {
                    if (streamWriter != null) {
                        streamWriter.flush();
                        streamWriter.close();
                    }
                    errorMessage = strEntry.toString();
                }
                if (streamWriter != null) {
                    streamWriter.flush();
                    streamWriter.close();
                }
            }
            catch (Exception exception) {}
        }
        logger.debug("Finished with Creating formatted error entry.");
        return errorMessage;
    }

    public BackupErrorEntry getErrorEntry(int errorCode) throws BackupException {
        BackupErrorEntry errorEntry = null;
        InputStream stream = null;
        try {
            String strErrorCode = Integer.toString(errorCode);
            stream = BackupErrorXmlFormatter.class.getResourceAsStream("/com/sas/svcs/backup/common/definitions/BackupErrors.xml");
            DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
            Document doc = docBuilder.parse(stream);
            if (doc != null) {
                doc.getDocumentElement().normalize();
                Node rootNode = doc.getFirstChild();
                Element docEle = doc.getDocumentElement();
                NodeList nList = docEle.getElementsByTagName("BackupError");
                if (nList != null && nList.getLength() > 0) {
                    for (int temp = 0; temp < nList.getLength(); ++temp) {
                        Node nNode = nList.item(temp);
                        Node tempAttrNode = nNode.getAttributes().getNamedItem("errorCode");
                        if (tempAttrNode == null || !tempAttrNode.getNodeValue().equals(strErrorCode)) continue;
                        errorEntry = new BackupErrorEntry();
                        errorEntry.setErrorCode(errorCode);
                        NamedNodeMap attribs = nNode.getAttributes();
                        errorEntry.setErrorImpact(this.getAttribValue(attribs, "errorImpact"));
                        errorEntry.setErrorCategory(this.getAttribValue(attribs, "errorCategory"));
                        errorEntry.setErrorClassification(this.getAttribValue(attribs, "errorClassification"));
                        errorEntry.setErrorSummary(this.getAttribValue(attribs, "errorSummary"));
                        errorEntry.setAlertRequired(Boolean.valueOf(this.getAttribValue(attribs, "alertRequired")));
                        errorEntry.setErrorMessage(this.getAttribValue(attribs, "errorMessage"));
                        logger.debug("Setting value from ResourceBundle for ErrorMessageForMail without passing locale");
                        errorEntry.setErrorMessageForMail(this.getAttribValueInDefaultLocale(attribs, "errorMessage"));
                        errorEntry.setOriginalMessage(this.getAttribValue(attribs, "originalMessage"));
                        errorEntry.setErrorName(this.getAttribValue(attribs, "errorName"));
                    }
                }
            }
        }
        catch (Exception e) {
            logger.error("Process for creating backup error entry details using BackupErrors.xml aborted due to errors.");
            throw new BackupException("Process for creating backup error entry details using BackupErrors.xml aborted due to errors.", e, BackupErrorConstants.ErrorCodes.ERROR_CODE_ERROR_ENTRY_GENERATION_FAILED.getErrorCode());
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException iOException) {}
            }
        }
        return errorEntry;
    }

    private String getAttribValueInDefaultLocale(NamedNodeMap attribs, String attribName) {
        String value;
        logger.debug("Fetch value from ResourceBundle for " + attribName + " without passing locale");
        Node attribNode = attribs.getNamedItem(attribName);
        String attribVauleFromRB = null;
        if (attribNode != null && (value = attribNode.getNodeValue()) != null && value.endsWith(".txt")) {
            try {
                attribVauleFromRB = RB.getStringResource(value);
            }
            catch (MissingResourceException e) {
                attribVauleFromRB = value;
            }
        }
        return attribVauleFromRB;
    }

    private String getAttribValue(NamedNodeMap attribs, String attribName) {
        if (attribs != null) {
            for (int i = 0; i < attribs.getLength(); ++i) {
                Node attrib = attribs.item(i);
                if (!attrib.getNodeName().equals(attribName)) continue;
                String value = attrib.getNodeValue();
                if (value != null && value.endsWith(".txt")) {
                    try {
                        return this.getPropertyValueFromRB(value);
                    }
                    catch (MissingResourceException e) {
                        logger.error(e.getMessage(), (Throwable)e);
                    }
                }
                return value;
            }
        }
        return null;
    }

    public String getPropertyValueFromRB(String propertyName) {
        String propertyValue = null;
        Locale locale = LocaleContextHolder.getLocale();
        logger.debug("Client locale: " + locale);
        if (propertyName != null) {
            if (locale != null) {
                try {
                    propertyValue = RB.getStringResource(propertyName, locale);
                }
                catch (Exception e) {
                    propertyValue = RB.getStringResource(propertyName);
                }
            } else {
                propertyValue = RB.getStringResource(propertyName);
            }
        }
        return propertyValue == null ? propertyValue : propertyValue.trim();
    }
}

