/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.backup.common.definitions;

import com.sas.svcs.backup.common.definitions.BackupErrorConstants;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.exception.ExceptionUtils;

public class BackupException
extends RuntimeException {
    private static final long serialVersionUID = 12121212L;
    public static final String LOG_COMMA = ", ";
    private int errorCode = BackupErrorConstants.ErrorCodes.ERROR_CODE_UNKNOWN.getErrorCode();
    private Map<String, String> errorInfo = new HashMap<String, String>();
    private int errorInfoSize;
    private boolean logInNewSession;

    public static BackupExceptionBuilder getBuilder(int statusCode) {
        return new BackupExceptionBuilder(statusCode);
    }

    public BackupException(Throwable cause, int statusCode) {
        super(cause);
        StackTraceElement[] trace;
        StringBuffer stackTraceString = new StringBuffer();
        if (cause.getMessage() != null) {
            stackTraceString.append(cause.getMessage());
        }
        if ((trace = cause.getStackTrace()).length > 0) {
            stackTraceString.append(trace[0].toString());
            if (trace.length > 1) {
                stackTraceString.append(" ").append(trace[1].toString()).append("...");
            }
        }
        if (cause instanceof BackupException) {
            int errorCode = ((BackupException)cause).getErrorCode();
            stackTraceString.append(" Nested BackupException : Error code - ").append(errorCode);
            String nestedTrace = ((BackupException)cause).getErrorInfo("stackTrace");
            if (nestedTrace != null) {
                stackTraceString.append(" Stack Trace - ").append(nestedTrace);
            }
        }
        this.errorCode = statusCode;
        this.errorInfo.put("errorCode", Integer.toString(statusCode));
        this.errorInfo.put("stackTrace", stackTraceString.toString());
        this.setExceptionTime();
    }

    public BackupException(String message, Throwable cause, int statusCode) {
        super(message, cause);
        StackTraceElement[] trace;
        StringBuffer stackTraceString = new StringBuffer();
        if (cause.getMessage() != null) {
            stackTraceString.append(cause.getMessage());
        }
        if ((trace = cause.getStackTrace()).length > 0) {
            stackTraceString.append(trace[0].toString());
            if (trace.length > 1) {
                stackTraceString.append(" ").append(trace[1].toString()).append("...");
            }
        }
        if (cause instanceof BackupException) {
            int errorCode = ((BackupException)cause).getErrorCode();
            stackTraceString.append(" Nested BackupException : Error code - ").append(errorCode);
            String nestedTrace = ((BackupException)cause).getErrorInfo("stackTrace");
            if (nestedTrace != null) {
                stackTraceString.append(" Stack Trace - ").append(nestedTrace);
            }
        }
        StringBuffer sb = new StringBuffer(message).append(LOG_COMMA).append(stackTraceString);
        this.errorInfo.put("errorCode", Integer.toString(statusCode));
        this.errorInfo.put("stackTrace", sb.toString());
        ExceptionUtils.getStackTrace((Throwable)cause);
        this.setExceptionTime();
    }

    public BackupException(String message, int statusCode) {
        super(message);
        this.errorCode = statusCode;
        this.errorInfo.put("stackTrace", message);
        this.errorInfo.put("errorCode", Integer.toString(statusCode));
        this.setExceptionTime();
    }

    public BackupException(int statusCode) {
        this.errorCode = statusCode;
        this.errorInfo.put("errorCode", Integer.toString(statusCode));
        this.setExceptionTime();
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    @Override
    public String toString() {
        StringBuffer errorMessage = new StringBuffer();
        try {
            errorMessage.append("Error Code: ").append(this.errorCode);
            String trace = this.errorInfo.get("stackTrace");
            if (trace != null) {
                errorMessage.append(", Stack Trace: ").append(trace);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return errorMessage.toString();
    }

    public String getErrorInfo(String errorKey) {
        if (this.errorInfo.containsKey(errorKey)) {
            return this.errorInfo.get(errorKey);
        }
        return null;
    }

    public void setErrorInfo(String errorKey, String errorValue) {
        this.errorInfo.put(errorKey, errorValue);
    }

    private void readObject(ObjectInputStream aInputStream) throws ClassNotFoundException, IOException {
        aInputStream.defaultReadObject();
        this.validateState();
    }

    private void validateState() {
        if (this.errorInfo != null && this.errorInfoSize != this.errorInfo.size()) {
            throw new IllegalStateException("Validation failed for deserialzed object.");
        }
    }

    private void writeObject(ObjectOutputStream aOutputStream) throws IOException {
        this.errorInfoSize = this.errorInfo.size();
        aOutputStream.defaultWriteObject();
    }

    private void setExceptionTime() {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd'T'HH_mm_ss");
        Date currentDate = new Date();
        String dateTime = formatter.format(currentDate);
        if (dateTime != null) {
            this.setErrorInfo("dateTimeOfError", dateTime);
        } else {
            this.setErrorInfo("dateTimeOfError", "Not Available");
        }
    }

    public boolean isLogInNewSession() {
        return this.logInNewSession;
    }

    public void setLogInNewSession(boolean logInNewSession) {
        this.logInNewSession = logInNewSession;
    }

    public static class BackupExceptionBuilder {
        private int statusCode;
        private String message;
        private Throwable cause;
        private Map<String, String> info;
        private boolean logInNewSession;

        public BackupExceptionBuilder(int statusCode) {
            this.statusCode = statusCode;
            this.info = new HashMap<String, String>();
        }

        public BackupExceptionBuilder setCause(Throwable cause) {
            this.cause = cause;
            return this;
        }

        public BackupExceptionBuilder setMessage(String message) {
            this.message = message;
            return this;
        }

        public BackupExceptionBuilder addInfo(String key, String value) {
            this.info.put(key, value);
            return this;
        }

        public BackupExceptionBuilder setLogInNewSession(boolean logInNewSession) {
            this.logInNewSession = logInNewSession;
            return this;
        }

        public BackupException build() {
            BackupException be = null;
            be = this.message != null ? (this.cause != null ? new BackupException(this.message, this.cause, this.statusCode) : new BackupException(this.message, this.statusCode)) : new BackupException(this.statusCode);
            if (!this.info.isEmpty()) {
                for (Map.Entry<String, String> entry : this.info.entrySet()) {
                    be.setErrorInfo(entry.getKey(), entry.getValue());
                }
            }
            be.setLogInNewSession(this.logInNewSession);
            return be;
        }
    }
}

