/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.backup.common.definitions;

public final class BackupErrorConstants {
    public static final String ERROR_STACKTRACE = "stackTrace";
    public static final String ERROR_CODE = "errorCode";
    public static final String ERROR_CODE_ZERO = "0";
    public static final String WINDOWS_CARRIAGE_RETURN = "\r\n";
    public static final String UNIX_CARRIAGE_RETURN = "\n";
    public static final String ERROR_KEY_CREATEDATETIME = "Create Time Stamp";
    public static final String ERROR_DATE_FORMAT = "yyyy-MM-dd hh:mm:ss";
    public static final String ERROR_LOG_START = "\tError Start|||  ";
    public static final String ERROR_LOG_END = "\t\t|||  Error End";
    public static final String STACKTRACE_IDENTIFIER = "Backup Exception: ";
    public static final String ERROR_DETAILS_ERROR_CODE = "";
    public static final String ERROR_DETAILS_ERROR_IMPACT = "";
    public static final String ERROR_DETAILS_ERROR_CLASSIFICATION = "";
    public static final String ERROR_DETAILS_ERROR_TYPE = "";
    public static final String ERROR_DETAILS_ERROR_CATEGORY = "";
    public static final String ERROR_DETAILS_ERROR_SUMMARY = "";
    public static final String ERROR_DETAILS_ERROR_MESSAGE = "";
    public static final String ERROR_DETAILS_POSSIBLE_CAUSE = "";

    public static enum ErrorCodes {
        OK(0),
        ERROR_CODE_UNKNOWN(999),
        ERROR_CODE_ERROR_XML_GENERATION_FAILED(901),
        ERROR_CODE_ERROR_ENTRY_GENERATION_FAILED(902),
        ERROR_CODE_GET_HISTORY_ERROR(603),
        ERROR_CODE_UPDATE_HISTORY_ERROR(604),
        ERROR_CODE_GET_CONFIG_ERROR(605),
        ERROR_CODE_SET_CONFIG_ERROR(606),
        ERROR_CODE_DB_DISCOVERY_FAILED(651),
        ERROR_CODE_CONTENT_SERVER_DISCOVERY_FAILED(652),
        ERROR_CODE_METADATA_SERVER_DISCOVERY_FAILED(653),
        ERROR_CODE_CONFIGDIR_DISCOVERY_FAILED(654),
        ERROR_CODE_CUSTOMDIR_DISCOVERY_FAILED(685),
        ERROR_CODE_GENERAL_AUTO_DISCOVERY_FAILURE(655),
        ERROR_CODE_DB_BACKUP_FAILED(656),
        ERROR_CODE_CONTENT_SERVER_BACKUP_FAILED(657),
        ERROR_CODE_METADATA_SERVER_BACKUP_FAILED(658),
        ERROR_CODE_CONFIGDIR_BACKUP_FAILED(659),
        ERROR_CODE_CUSTOMDIR_BACKUP_FAILED(686),
        ERROR_CODE_GENERAL_BACKUP_FAILURE(660),
        ERROR_CODE_DB_RECOVERY_FAILED(661),
        ERROR_CODE_CONTENT_SERVER_RECOVERY_FAILED(662),
        ERROR_CODE_METADATA_SERVER_RECOVERY_FAILED(663),
        ERROR_CODE_CONFIGDIR_RECOVERY_FAILED(664),
        ERROR_CODE_CUSTOMDIR_RECOVERY_FAILED(687),
        ERROR_CODE_GENERAL_RECOVERY_FAILURE(665),
        ERROR_CODE_DEPLOYMENT_AGENT_COMMUNICATION_FAILURE(671),
        ERROR_CODE_BACKUP_SERVER_CONFIGURATION_FAILURE(672),
        ERROR_CODE_BACKUP_ALREADY_RUNNING(673),
        ERROR_CODE_RECOVERY_ALREADY_RUNNING(674),
        ERROR_CODE_OPERATION_TIMEOUT(675),
        ERROR_CODE_METADATA_RETRIVAL_FAILED(676),
        ERROR_CODE_ARCHIVE_FAILED(677),
        WARN_CODE_HOSTS_EXCLUDED(678),
        ERROR_CODE_BACKUP_SERVER_RECONFIGURATION_FAILURE(679),
        ERROR_CODE_GENERAL_IO_FAILURE(681),
        ERROR_CODE_GET_CONTENT_DETAILS_FAILED(682),
        ERROR_CODE_EMAIL_NOTIFICATION_FAILED(683),
        ERROR_CODE_GET_BACKUPSERVER_FILE_FAILED(684),
        ERROR_CODE_SESSION_START_FAILED(688),
        ERROR_CODE_SESSION_END_FAILED(689),
        ERROR_CODE_PURGE_FAILED(690),
        COMMAND_INTERNAL_WARN_POSTRECOVER(691),
        COMMAND_INTERNAL_WARN_LOCALCONTENT_POSTRECOVERY(692),
        COMMAND_INTERNAL_WARN_EXTERNAL_DATABASE(693);

        private int errorCode;

        private ErrorCodes(int errorCode) {
            this.setErrorCode(errorCode);
        }

        public int getErrorCode() {
            return this.errorCode;
        }

        public void setErrorCode(int intCode) {
            this.errorCode = intCode;
        }
    }
}

