/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.batch.rest;

import com.sas.svcs.batch.rest.EnvironmentContextHolder;
import com.sas.svcs.batch.rest.RB;
import com.sas.svcs.batch.rest.model.EnvironmentContext;
import com.sas.svcs.batch.rest.model.Service;
import com.sas.text.Message;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.BasicResponseHandler;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.message.BasicNameValuePair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TicketMaster {
    private static String logonEndpoint = "SASLogon/v1/tickets";
    private static final Logger logger = LogManager.getLogger(TicketMaster.class);

    private String getLogOnURI() {
        EnvironmentContext context = EnvironmentContextHolder.get();
        return context.getBaseURI() + "/" + logonEndpoint;
    }

    public String getTicketGrantingTicket(HttpHost proxy) throws Exception {
        ArrayList<NameValuePair> nameValuePairs = new ArrayList<NameValuePair>(2);
        EnvironmentContext context = EnvironmentContextHolder.get();
        nameValuePairs.add((NameValuePair)new BasicNameValuePair("username", context.getUser()));
        nameValuePairs.add((NameValuePair)new BasicNameValuePair("password", context.getPassword()));
        HttpPost post = new HttpPost(this.getLogOnURI());
        HttpResponse response = this.execute(nameValuePairs, post, proxy);
        Header[] header = response.getHeaders("location");
        String location = null;
        if (header.length > 0) {
            location = header[0].getValue();
            logger.debug("Location header value is " + location);
        }
        post.abort();
        return location;
    }

    private HttpResponse execute(List<NameValuePair> formParams, HttpPost request, HttpHost proxy) throws Exception {
        request.addHeader("content-type", "application/x-www-form-urlencoded");
        DefaultHttpClient client = new DefaultHttpClient();
        if (proxy != null) {
            client.getParams().setParameter("http.route.default-proxy", (Object)proxy);
            logger.info(RB.getStringResource("ServiceExecutor.proxy.mode.txt"));
        }
        request.setEntity((HttpEntity)new UrlEncodedFormEntity(formParams));
        return client.execute((HttpUriRequest)request);
    }

    public String getServiceTicket(Service service, HttpHost proxy) throws Exception {
        String tgt = this.getTicketGrantingTicket(proxy);
        logger.debug("tgt value is " + tgt);
        if (tgt != null) {
            ArrayList<NameValuePair> nameValuePairs = new ArrayList<NameValuePair>(2);
            nameValuePairs.add((NameValuePair)new BasicNameValuePair("service", service.getURL()));
            logger.info(Message.format((String)RB.getStringResource("TicketMaster.logonurl.fmt"), (Object)service.getURL()));
            String validatedtgt = this.reformulateURL(tgt);
            logger.debug("Sending request to uri " + validatedtgt);
            HttpPost post = new HttpPost(validatedtgt);
            HttpResponse response = this.execute(nameValuePairs, post, proxy);
            return new BasicResponseHandler().handleResponse(response);
        }
        return null;
    }

    private String reformulateURL(String tgt) throws MalformedURLException {
        URL url = new URL(tgt);
        String formulatedtgt = null;
        EnvironmentContext context = EnvironmentContextHolder.get();
        logger.debug("Host present in tgt is " + url.getHost());
        logger.debug("port present in tgt is " + url.getPort());
        logger.debug("Protocol present in tgt is " + url.getProtocol());
        logger.debug("Host present in tgt is " + context.getHost());
        logger.debug("port present in tgt is " + context.getPort());
        logger.debug("Protocol present in tgt is " + context.getProtocol());
        if (url.getHost().equalsIgnoreCase(context.getHost()) && url.getPort() == Integer.parseInt(context.getPort()) && url.getProtocol().equalsIgnoreCase(context.getProtocol())) {
            logger.debug("Host match so url is not reformulated");
            formulatedtgt = tgt;
        } else {
            logger.debug("Host , port , protocol does not match so url is reformulated");
            String ticket = tgt.substring(tgt.indexOf(logonEndpoint) + logonEndpoint.length(), tgt.length());
            logger.debug("Ticket extracted from url is " + ticket);
            formulatedtgt = ticket != "" & ticket.length() > 1 ? this.getLogOnURI() + ticket : tgt;
            logger.debug("Formulated uri is " + formulatedtgt);
        }
        return formulatedtgt;
    }
}

