/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.batch.rest;

import com.sas.svcs.batch.rest.RB;
import com.sas.svcs.batch.rest.ResponseDecorator;
import com.sas.svcs.batch.rest.model.BasicResponse;
import com.sas.svcs.batch.rest.model.Service;
import com.sas.text.Message;
import java.io.File;
import java.io.IOException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.appender.FileAppender;
import org.apache.logging.log4j.core.config.Configuration;

public class BasicDecorator
implements ResponseDecorator {
    private static final Logger logger = LogManager.getLogger(BasicDecorator.class);

    @Override
    public void decorate(BasicResponse response, Service service) throws Exception {
        System.out.println(Message.format((String)RB.getStringResource("BasicDecorator.utility.failed.fmt"), (Object)response.getStatusCode(), (Object)this.getLogFileLocation()));
        logger.error(response.getHeaders());
        logger.error(response.getRawResponse());
    }

    private String getLogFileLocation() {
        String logFileName = "backuprestbatch.log";
        File file = null;
        LoggerContext lc = (LoggerContext)LogManager.getContext((boolean)false);
        Configuration config = lc.getConfiguration();
        Appender app = config.getAppender("R");
        if (app instanceof FileAppender && ((FileAppender)app).getFileName() != null && ((FileAppender)app).getFileName().length() > 0) {
            file = new File(((FileAppender)app).getFileName());
        }
        if (file != null) {
            try {
                logFileName = file.getCanonicalPath();
            }
            catch (IOException e1) {
                logger.error(Message.format((String)RB.getStringResource("BatchDriver.incorrect.filepath.fmt"), (Object)file.getName()));
            }
        }
        return logFileName;
    }
}

