/*
 * Decompiled with CFR 0.152.
 */
package com.sas.midtier.components.lifecycle.impl;

import com.sas.midtier.components.container.ContainerCompositionException;
import com.sas.midtier.components.container.ContainerManager;
import com.sas.midtier.components.container.LifecycleException;
import com.sas.midtier.components.container.impl.ContainerManagerLocator;
import com.sas.midtier.components.container.impl.DefaultContainerManager;
import com.sas.midtier.components.container.impl.ServletAwareComposer;
import com.sas.midtier.components.lifecycle.ContainerDestroyer;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import org.picocontainer.PicoContainer;

public class PicoInitializerServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;

    public void destroy() {
        block2: {
            ServletContext context = this.getServletContext();
            ContainerManagerLocator locator = new ContainerManagerLocator(context);
            ContainerManager manager = locator.locate();
            ContainerDestroyer cd = new ContainerDestroyer(manager);
            try {
                cd.destroy();
            }
            catch (LifecycleException e) {
                Throwable uc = e.getUltimateCause();
                if (uc == null) break block2;
                uc.printStackTrace();
            }
        }
    }

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        ServletContext context = config.getServletContext();
        ContainerManagerLocator locator = new ContainerManagerLocator(context);
        DefaultContainerManager containerManager = new DefaultContainerManager(context, new ServletAwareComposer());
        InputStream stream = context.getResourceAsStream("/WEB-INF/containers.xml");
        if (stream == null) {
            context.log("Container configuration file \"containers.xml\" not found");
            return;
        }
        try {
            ArrayList compNames = new ArrayList();
            containerManager.initializeContainers(stream, compNames);
            this.guaranteeComponentLoad(containerManager.getContainer(), compNames, context);
        }
        catch (ContainerCompositionException e) {
            Throwable rootCause = e.getUltimateCause();
            context.log(rootCause.getLocalizedMessage(), rootCause);
            return;
        }
        catch (LifecycleException e) {
            Throwable rootCause = e.getUltimateCause();
            context.log(rootCause.getLocalizedMessage(), rootCause);
            return;
        }
        locator.store(containerManager);
    }

    private void guaranteeComponentLoad(PicoContainer container, List compNames, ServletContext context) {
        for (String name : compNames) {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            if (name.startsWith("java.") || name.startsWith("javax.")) {
                System.out.println("Component type: " + name);
            }
            try {
                container.getComponentInstanceOfType(classLoader.loadClass(name));
            }
            catch (Throwable t) {
                context.log(t.getMessage(), t);
            }
        }
    }
}

