/*
 * Decompiled with CFR 0.152.
 */
package com.sas.midtier.components.container.util.impl;

import com.sas.midtier.components.container.ContainerManager;
import com.sas.midtier.components.container.impl.ContainerManagerLocator;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import org.picocontainer.PicoContainer;

public class ComponentsUtil {
    private ComponentsUtil() {
    }

    public static Object locateComponent(Class componentClass, HttpServletRequest request) {
        return ComponentsUtil.locateComponent(componentClass, request.getSession(true).getServletContext());
    }

    public static PicoContainer getComponentContainer(HttpServletRequest request) {
        ServletContext context = request.getSession().getServletContext();
        return ComponentsUtil.getComponentContainer(context);
    }

    public static PicoContainer getComponentContainer(ServletContext context) {
        PicoContainer container = null;
        ContainerManagerLocator locator = new ContainerManagerLocator(context);
        ContainerManager containerManager = locator.locate();
        if (containerManager != null) {
            container = containerManager.getContainer();
        }
        return container;
    }

    public static Object locateComponent(Class componentClass, ServletContext context) {
        return ComponentsUtil.locateComponent(componentClass, (Object)context);
    }

    public static Object locateComponent(Class componentClass, Object context) {
        Object retval = null;
        ContainerManagerLocator locator = new ContainerManagerLocator(context);
        ContainerManager containerManager = locator.locate();
        if (containerManager != null) {
            PicoContainer container = containerManager.getContainer();
            retval = container.getComponentInstanceOfType(componentClass);
        }
        return retval;
    }

    public static Object locateComponent(Class componentClass, HttpServletRequest request, int waitForNumSeconds) {
        return ComponentsUtil.locateComponent(componentClass, request.getSession(true).getServletContext(), waitForNumSeconds);
    }

    public static Object locateComponent(Class componentClass, ServletContext context, int waitSecondsForNotNull) {
        Object retval = null;
        retval = ComponentsUtil.locateComponent(componentClass, context);
        int count = 0;
        while (retval == null && count <= waitSecondsForNotNull) {
            ++count;
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            retval = ComponentsUtil.locateComponent(componentClass, context);
        }
        return retval;
    }
}

