/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.tools.hostporttool;

import com.sas.metadata.logical.batch.BatchDriver2;
import com.sas.metadata.logical.batch.BatchDriverOptions;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.COMConnection;
import com.sas.metadata.remote.DeployedComponent;
import com.sas.metadata.remote.Directory;
import com.sas.metadata.remote.Document;
import com.sas.metadata.remote.File;
import com.sas.metadata.remote.Machine;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.MdStore;
import com.sas.metadata.remote.Property;
import com.sas.metadata.remote.PropertySet;
import com.sas.metadata.remote.SASClientConnection;
import com.sas.metadata.remote.ServiceComponent;
import com.sas.metadata.remote.SoftwareComponent;
import com.sas.metadata.remote.TCPIPConnection;
import com.sas.metadata.remote.TextStore;
import com.sas.metadata.remote.Tree;
import com.sas.metadata.tools.hostporttool.HostPortArgument;
import com.sas.metadata.tools.hostporttool.RB;
import com.sas.services.util.UncaughtRuntimeExceptionHandler;
import com.sas.text.Message;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.rmi.RemoteException;
import java.util.List;
import java.util.ResourceBundle;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.MissingOptionException;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.ParseException;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class HostPortTool2
extends BatchDriver2 {
    public static final String OPTION_APP_PROTOCOL = "applicationProtocol";
    public static final String OPTION_COMM_PROTOCOL = "communicationProtocol";
    public static final String OPTION_NOEXECUTE = "noexecute";
    private String _applicationProtocol = null;
    private String _communicationProtocol = null;
    private boolean _noExecute = false;
    private int _inspectedCount = 0;
    private int _matchCount = 0;
    private int _updateCount = 0;
    private HostPortArgument[] _arguments = null;
    private static Pattern _uncPattern = Pattern.compile("\\\\\\\\([^\\\\]+)(.*)");
    private static Pattern _uriPattern = Pattern.compile("(http:|https:|ftp:|ldap:|omi:)?//([^/:]+)(:(\\d+))?(.*)", 2);

    public HostPortTool2() {
        this._logTimestamps = false;
    }

    public void setApplicationProtocol(String applicationProtocol) {
        this._applicationProtocol = applicationProtocol;
    }

    public void setCommunicationProtocol(String communicationProtocol) {
        this._communicationProtocol = communicationProtocol;
    }

    public void setHostsAndPorts(String[] hostsAndPorts) throws IllegalArgumentException {
        if (hostsAndPorts == null) {
            this._arguments = null;
            return;
        }
        HostPortArgument[] arguments = new HostPortArgument[hostsAndPorts.length];
        for (int i = 0; i < hostsAndPorts.length; ++i) {
            arguments[i] = new HostPortArgument(hostsAndPorts[i]);
        }
        this._arguments = arguments;
    }

    public void setHostsAndPorts(HostPortArgument[] hostsAndPorts) {
        this._arguments = hostsAndPorts;
    }

    public void setNoExecute(boolean noexecute) {
        this._noExecute = noexecute;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int execute() throws Exception {
        try {
            this.setInitializeLogicalTypes(false);
            this.initialize();
            this.logStart();
            this.logConnectionInfo();
            if (this._arguments != null && this._arguments.length > 0) {
                StringBuffer listArgs = new StringBuffer();
                StringBuffer updateArgs = new StringBuffer();
                for (int i = 0; i < this._arguments.length; ++i) {
                    if (this._arguments[i].isUpdateArgument()) {
                        if (updateArgs.length() > 0) {
                            updateArgs.append(' ');
                        }
                        updateArgs.append(this._arguments[i].toString());
                        continue;
                    }
                    if (listArgs.length() > 0) {
                        listArgs.append(' ');
                    }
                    listArgs.append(this._arguments[i].toString());
                }
                if (listArgs.length() > 0) {
                    this._logger.info(Message.format((ResourceBundle)RB.getResources(), (String)"HostPortTool.List.fmt.log", (Object)listArgs));
                }
                if (updateArgs.length() > 0) {
                    this._logger.info(Message.format((ResourceBundle)RB.getResources(), (String)"HostPortTool.Update.fmt.log", (Object)updateArgs));
                }
            } else {
                this._logger.info(RB.getStringResource("HostPortTool.ListAll.log"));
                this._arguments = new HostPortArgument[]{new HostPortArgument(".")};
            }
            this.processMachines();
            this.processTCPIPConnections();
            this.processSASClientConnections();
            this.processCOMConnections();
            this.processDocuments();
            this.processFiles();
            this.processDirectories();
            this.processInformationServiceDefinitions();
            this.processUserServiceDefinitions();
            this.processLoggingServiceDefinitions();
            this.processJpsSoftwareComponent();
            if (this._updateCount == 0) {
                this._logger.info(Message.format((ResourceBundle)RB.getResources(), (String)"HostPortTool.TotalFound.fmt.log", (Object)new Integer(this._inspectedCount), (Object)new Integer(this._matchCount)));
            } else if (this._noExecute) {
                this._logger.info(Message.format((ResourceBundle)RB.getResources(), (String)"HostPortTool.TotalNoExecuteUpdated.fmt.log", (Object)new Integer(this._inspectedCount), (Object)new Integer(this._updateCount)));
            } else {
                this._logger.info(Message.format((ResourceBundle)RB.getResources(), (String)"HostPortTool.TotalUpdated.fmt.log", (Object)new Integer(this._inspectedCount), (Object)new Integer(this._updateCount)));
            }
        }
        catch (Exception e) {
            this.logException(e);
        }
        finally {
            this.terminate();
        }
        return this._rc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processMachines() throws MdException, RemoteException {
        int matched = 0;
        int updated = 0;
        String objectType = "Machine";
        MdObjectStore store = this._factory.createObjectStore();
        try {
            int flags = 8192;
            List objects = this._factory.getOMIUtil().getMetadataObjectsSubset((MdStore)store, "", "Machine", flags, "");
            block3: for (Machine object : objects) {
                String host = object.getName();
                for (int i = 0; i < this._arguments.length; ++i) {
                    HostPortArgument arg = this._arguments[i];
                    if (!arg.isHostOnly() || !arg.isMatch(host)) continue;
                    ++matched;
                    if (arg.isUpdateArgument()) {
                        String newHost = arg.getNewHost();
                        object.setName(newHost);
                        this._logger.info(Message.format((ResourceBundle)RB.getResources(), (String)"HostPortTool.HostUpdate.fmt.log", (Object)object.getCMetadataType(), (Object)object.getId(), (Object)host, (Object)newHost));
                        ++updated;
                        continue block3;
                    }
                    this._logger.info(Message.format((ResourceBundle)RB.getResources(), (String)"HostPortTool.HostMatch.fmt.log", (Object)object.getCMetadataType(), (Object)object.getId(), (Object)host));
                    continue block3;
                }
            }
            if (updated > 0) {
                if (!this._noExecute) {
                    store.updatedMetadataAll();
                }
                this._logger.info(Message.format((ResourceBundle)RB.getResources(), (String)"HostPortTool.ObjectsUpdated.fmt.log", (Object)new Integer(matched), (Object)"Machine", (Object)new Integer(updated)));
            } else {
                this._logger.info(Message.format((ResourceBundle)RB.getResources(), (String)"HostPortTool.ObjectsFound.fmt.log", (Object)new Integer(matched), (Object)"Machine"));
            }
            this._inspectedCount += objects.size();
            this._matchCount += matched;
            this._updateCount += updated;
        }
        finally {
            store.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processTCPIPConnections() throws MdException, RemoteException {
        int matched = 0;
        int updated = 0;
        String objectType = "TCPIPConnection";
        MdObjectStore store = this._factory.createObjectStore();
        try {
            int flags = 8456;
            List connections = this._factory.getOMIUtil().getMetadataObjectsSubset((MdStore)store, "", "TCPIPConnection", flags, "");
            block3: for (TCPIPConnection connection : connections) {
                String host;
                if (this._applicationProtocol != null && !this._applicationProtocol.equalsIgnoreCase(connection.getApplicationProtocol()) || this._communicationProtocol != null && !this._communicationProtocol.equalsIgnoreCase(connection.getCommunicationProtocol())) continue;
                String displayHost = host = connection.getHostName();
                if (host.length() == 0) {
                    displayHost = "<blank>";
                }
                int port = connection.getPort();
                for (int i = 0; i < this._arguments.length; ++i) {
                    HostPortArgument arg = this._arguments[i];
                    if (!arg.isMatch(host, port)) continue;
                    ++matched;
                    DeployedComponent dc = connection.getSource();
                    if (arg.isUpdateArgument()) {
                        String newHost = arg.getNewHost();
                        int newPort = arg.getNewPortNumber();
                        if (newHost != null) {
                            connection.setHostName(newHost);
                        } else {
                            newHost = displayHost;
                        }
                        if (newPort > 0) {
                            connection.setPort(newPort);
                        } else {
                            newPort = port;
                        }
                        this._logger.info(Message.format((ResourceBundle)RB.getResources(), (String)"HostPortTool.ConnectionUpdate.fmt.log", (Object)(connection.getCMetadataType() + " " + connection.getId()), (Object)(dc.getCMetadataType() + " " + dc.getName()), (Object)displayHost, (Object)new Integer(port), (Object)newHost, (Object)new Integer(newPort)));
                        ++updated;
                        continue block3;
                    }
                    this._logger.info(Message.format((ResourceBundle)RB.getResources(), (String)"HostPortTool.ConnectionMatch.fmt.log", (Object)(connection.getCMetadataType() + " " + connection.getId()), (Object)(dc.getCMetadataType() + " " + dc.getName()), (Object)displayHost, (Object)new Integer(port)));
                    continue block3;
                }
            }
            if (updated > 0) {
                if (!this._noExecute) {
                    store.updatedMetadataAll();
                }
                this._logger.info(Message.format((ResourceBundle)RB.getResources(), (String)"HostPortTool.ObjectsUpdated.fmt.log", (Object)new Integer(matched), (Object)"TCPIPConnection", (Object)new Integer(updated)));
            } else {
                this._logger.info(Message.format((ResourceBundle)RB.getResources(), (String)"HostPortTool.ObjectsFound.fmt.log", (Object)new Integer(matched), (Object)"TCPIPConnection"));
            }
            this._inspectedCount += connections.size();
            this._matchCount += matched;
            this._updateCount += updated;
        }
        finally {
            store.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processSASClientConnections() throws MdException, RemoteException {
        int inspected = 0;
        int matched = 0;
        int updated = 0;
        String objectType = "SASClientConnection";
        MdObjectStore store = this._factory.createObjectStore();
        try {
            int flags = 8456;
            List connections = this._factory.getOMIUtil().getMetadataObjectsSubset((MdStore)store, "", "SASClientConnection", flags, "");
            for (SASClientConnection connection : connections) {
                String shortHost;
                String host;
                ++inspected;
                if (this._applicationProtocol != null && !this._applicationProtocol.equalsIgnoreCase(connection.getApplicationProtocol()) || this._communicationProtocol != null && !this._communicationProtocol.equalsIgnoreCase(connection.getCommunicationProtocol())) continue;
                String displayHost = host = connection.getRemoteAddress();
                if (host.length() == 0) {
                    displayHost = "<blank>";
                }
                int port = connection.getPort();
                for (int i = 0; i < this._arguments.length; ++i) {
                    HostPortArgument arg = this._arguments[i];
                    if (!arg.isMatch(host, port)) continue;
                    ++matched;
                    DeployedComponent dc = connection.getSource();
                    if (arg.isUpdateArgument()) {
                        String newHost = arg.getNewHost();
                        int newPort = arg.getNewPortNumber();
                        if (newHost != null) {
                            connection.setRemoteAddress(newHost);
                        } else {
                            newHost = displayHost;
                        }
                        if (newPort > 0) {
                            connection.setPort(newPort);
                        } else {
                            newPort = port;
                        }
                        this._logger.info(Message.format((ResourceBundle)RB.getResources(), (String)"HostPortTool.ConnectionUpdate.fmt.log", (Object)(connection.getCMetadataType() + " " + connection.getId()), (Object)(dc.getCMetadataType() + " " + dc.getName()), (Object)displayHost, (Object)new Integer(port), (Object)newHost, (Object)new Integer(newPort)));
                        ++updated;
                        break;
                    }
                    this._logger.info(Message.format((ResourceBundle)RB.getResources(), (String)"HostPortTool.ConnectionMatch.fmt.log", (Object)(connection.getCMetadataType() + " " + connection.getId()), (Object)(dc.getCMetadataType() + " " + dc.getName()), (Object)displayHost, (Object)new Integer(port)));
                    break;
                }
                if ((shortHost = connection.getServerShortName()) != null && shortHost.length() > 0) {
                    for (int i = 0; i < this._arguments.length; ++i) {
                        HostPortArgument arg = this._arguments[i];
                        if (!arg.isMatch(shortHost, port)) continue;
                        ++matched;
                        DeployedComponent dc = connection.getSource();
                        if (arg.isUpdateArgument()) {
                            String newHost = arg.getNewHost();
                            if (newHost != null) {
                                if (newHost.indexOf(46) > 0) {
                                    newHost = newHost.substring(0, newHost.indexOf(46));
                                }
                                connection.setServerShortName(newHost);
                                this._logger.info(Message.format((ResourceBundle)RB.getResources(), (String)"HostPortTool.ShortConnectionUpdate.fmt.log", (Object)(connection.getCMetadataType() + " " + connection.getId()), (Object)(dc.getCMetadataType() + " " + dc.getName()), (Object)shortHost, (Object)newHost));
                                ++updated;
                                break;
                            }
                            this._logger.info(Message.format((ResourceBundle)RB.getResources(), (String)"HostPortTool.ShortConnectionMatch.fmt.log", (Object)(connection.getCMetadataType() + " " + connection.getId()), (Object)(dc.getCMetadataType() + " " + dc.getName()), (Object)shortHost));
                            break;
                        }
                        this._logger.info(Message.format((ResourceBundle)RB.getResources(), (String)"HostPortTool.ShortConnectionMatch.fmt.log", (Object)(connection.getCMetadataType() + " " + connection.getId()), (Object)(dc.getCMetadataType() + " " + dc.getName()), (Object)shortHost));
                        break;
                    }
                }
                if (!"SHARE".equals(connection.getApplicationProtocol())) continue;
                MatchStats stats = this.processSASClientConnectionProperties(connection, port);
                inspected += stats.inspected;
                matched += stats.matched;
                updated += stats.updated;
            }
            if (updated > 0) {
                if (!this._noExecute) {
                    store.updatedMetadataAll();
                }
                this._logger.info(Message.format((ResourceBundle)RB.getResources(), (String)"HostPortTool.ObjectsUpdated.fmt.log", (Object)matched, (Object)"SASClientConnection", (Object)updated));
            } else {
                this._logger.info(Message.format((ResourceBundle)RB.getResources(), (String)"HostPortTool.ObjectsFound.fmt.log", (Object)matched, (Object)"SASClientConnection"));
            }
            this._inspectedCount += inspected;
            this._matchCount += matched;
            this._updateCount += updated;
        }
        finally {
            store.dispose();
        }
    }

    private MatchStats processSASClientConnectionProperties(SASClientConnection connection, int port) throws RemoteException, MdException {
        MatchStats stats = new MatchStats();
        String objectType = "SASClientConnection HOSTNAME Property";
        AssociationList properties = connection.getProperties();
        block0: for (Property property : properties) {
            if (!"HOSTNAME".equals(property.getPropertyName())) continue;
            ++stats.inspected;
            String hostName = property.getDefaultValue();
            if (hostName.length() > 2 && (hostName.startsWith("\"") && hostName.endsWith("\"") || hostName.startsWith("'") && hostName.endsWith("'"))) {
                hostName = hostName.substring(1, hostName.length() - 1);
            }
            for (int i = 0; i < this._arguments.length; ++i) {
                HostPortArgument arg = this._arguments[i];
                if (!arg.isMatch(hostName, port)) continue;
                ++stats.matched;
                DeployedComponent dc = connection.getSource();
                if (arg.isUpdateArgument()) {
                    String newHost = arg.getNewHost();
                    if (newHost != null) {
                        property.setDefaultValue("\"" + newHost + "\"");
                        ++stats.updated;
                        this._logger.info(Message.format((ResourceBundle)RB.getResources(), (String)"HostPortTool.ShortConnectionUpdate.fmt.log", (Object)(connection.getApplicationProtocol() + " " + "SASClientConnection HOSTNAME Property" + " " + connection.getId()), (Object)(dc.getCMetadataType() + " " + dc.getName()), (Object)hostName, (Object)newHost));
                        continue block0;
                    }
                    this._logger.info(Message.format((ResourceBundle)RB.getResources(), (String)"HostPortTool.ShortConnectionMatch.fmt.log", (Object)(connection.getApplicationProtocol() + " " + "SASClientConnection HOSTNAME Property" + " " + property.getId()), (Object)(dc.getCMetadataType() + " " + dc.getName()), (Object)hostName));
                    continue block0;
                }
                this._logger.info(Message.format((ResourceBundle)RB.getResources(), (String)"HostPortTool.ShortConnectionMatch.fmt.log", (Object)(connection.getApplicationProtocol() + " " + "SASClientConnection HOSTNAME Property" + " " + property.getId()), (Object)(dc.getCMetadataType() + " " + dc.getName()), (Object)hostName));
                continue block0;
            }
        }
        return stats;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processCOMConnections() throws MdException, RemoteException {
        int matched = 0;
        int updated = 0;
        String objectType = "COMConnection";
        MdObjectStore store = this._factory.createObjectStore();
        try {
            int flags = 8456;
            List objects = this._factory.getOMIUtil().getMetadataObjectsSubset((MdStore)store, "", "COMConnection", flags, "");
            block3: for (COMConnection object : objects) {
                String host;
                String displayHost = host = object.getHostName();
                if (host.length() == 0) {
                    displayHost = "<blank>";
                }
                for (int i = 0; i < this._arguments.length; ++i) {
                    HostPortArgument arg = this._arguments[i];
                    if (!arg.isHostOnly() || !arg.isMatch(host)) continue;
                    ++matched;
                    DeployedComponent dc = object.getSource();
                    if (arg.isUpdateArgument()) {
                        String newHost = arg.getNewHost();
                        if (!this._noExecute) {
                            object.setHostName(newHost);
                        }
                        this._logger.info(Message.format((ResourceBundle)RB.getResources(), (String)"HostPortTool.HostUpdate.fmt.log", (Object)(object.getCMetadataType() + " " + object.getId()), (Object)("(" + dc.getCMetadataType() + " " + dc.getName() + ")"), (Object)displayHost, (Object)newHost));
                        ++updated;
                        continue block3;
                    }
                    this._logger.info(Message.format((ResourceBundle)RB.getResources(), (String)"HostPortTool.HostMatch.fmt.log", (Object)(object.getCMetadataType() + " " + object.getId()), (Object)("(" + dc.getCMetadataType() + " " + dc.getName() + ")"), (Object)displayHost));
                    continue block3;
                }
            }
            if (updated > 0) {
                if (!this._noExecute) {
                    store.updatedMetadataAll();
                }
                this._logger.info(Message.format((ResourceBundle)RB.getResources(), (String)"HostPortTool.ObjectsUpdated.fmt.log", (Object)new Integer(matched), (Object)"COMConnection", (Object)new Integer(updated)));
            } else {
                this._logger.info(Message.format((ResourceBundle)RB.getResources(), (String)"HostPortTool.ObjectsFound.fmt.log", (Object)new Integer(matched), (Object)"COMConnection"));
            }
            this._inspectedCount += objects.size();
            this._matchCount += matched;
            this._updateCount += updated;
        }
        finally {
            store.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processDocuments() throws MdException, RemoteException {
        int matched = 0;
        int updated = 0;
        String objectType = "Document";
        MdObjectStore store = this._factory.createObjectStore();
        try {
            int flags = 8456;
            List objects = this._factory.getOMIUtil().getMetadataObjectsSubset((MdStore)store, "", "Document", flags, "");
            for (Document object : objects) {
                String uri = object.getURI();
                FixState fixState = this.fixURI(uri);
                if (!fixState.matched) continue;
                ++matched;
                if (fixState.updated) {
                    ++updated;
                    object.setURI(fixState.updatedPath);
                    this._logger.info(Message.format((ResourceBundle)RB.getResources(), (String)"HostPortTool.PathUpdate.fmt.log", (Object)object.getCMetadataType(), (Object)object.getId(), (Object)uri, (Object)fixState.updatedPath));
                    continue;
                }
                this._logger.info(Message.format((ResourceBundle)RB.getResources(), (String)"HostPortTool.PathMatch.fmt.log", (Object)object.getCMetadataType(), (Object)object.getId(), (Object)uri));
            }
            if (updated > 0) {
                if (!this._noExecute) {
                    store.updatedMetadataAll();
                }
                this._logger.info(Message.format((ResourceBundle)RB.getResources(), (String)"HostPortTool.ObjectsUpdated.fmt.log", (Object)new Integer(matched), (Object)"Document", (Object)new Integer(updated)));
            } else {
                this._logger.info(Message.format((ResourceBundle)RB.getResources(), (String)"HostPortTool.ObjectsFound.fmt.log", (Object)new Integer(matched), (Object)"Document"));
            }
            this._inspectedCount += objects.size();
            this._matchCount += matched;
            this._updateCount += updated;
        }
        finally {
            store.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processFiles() throws MdException, RemoteException {
        int matched = 0;
        int updated = 0;
        String objectType = "File";
        MdObjectStore store = this._factory.createObjectStore();
        try {
            int flags = 8600;
            List objects = this._factory.getOMIUtil().getMetadataObjectsSubset((MdStore)store, "", "File", flags, "<XMLSelect search=\"*[@IsARelativeName='0']\"/>");
            for (File object : objects) {
                String path = object.getFileName();
                FixState fixState = this.fixUNCPath(path);
                if (!fixState.matched) continue;
                ++matched;
                if (fixState.updated) {
                    ++updated;
                    object.setFileName(fixState.updatedPath);
                    this._logger.info(Message.format((ResourceBundle)RB.getResources(), (String)"HostPortTool.PathUpdate.fmt.log", (Object)object.getCMetadataType(), (Object)object.getId(), (Object)path, (Object)fixState.updatedPath));
                    continue;
                }
                this._logger.info(Message.format((ResourceBundle)RB.getResources(), (String)"HostPortTool.PathMatch.fmt.log", (Object)object.getCMetadataType(), (Object)object.getId(), (Object)path));
            }
            if (updated > 0) {
                if (!this._noExecute) {
                    store.updatedMetadataAll();
                }
                this._logger.info(Message.format((ResourceBundle)RB.getResources(), (String)"HostPortTool.ObjectsUpdated.fmt.log", (Object)new Integer(matched), (Object)"File", (Object)new Integer(updated)));
            } else {
                this._logger.info(Message.format((ResourceBundle)RB.getResources(), (String)"HostPortTool.ObjectsFound.fmt.log", (Object)new Integer(matched), (Object)"File"));
            }
            this._inspectedCount += objects.size();
            this._matchCount += matched;
            this._updateCount += updated;
        }
        finally {
            store.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processDirectories() throws MdException, RemoteException {
        int matched = 0;
        int updated = 0;
        String objectType = "Directory";
        MdObjectStore store = this._factory.createObjectStore();
        try {
            int flags = 8600;
            List objects = this._factory.getOMIUtil().getMetadataObjectsSubset((MdStore)store, "", "Directory", flags, "<XMLSelect search=\"*[@IsRelative='0']\"/>");
            for (Directory object : objects) {
                String path = object.getDirectoryName();
                FixState fixState = this.fixUNCPath(path);
                if (!fixState.matched) continue;
                ++matched;
                if (fixState.updated) {
                    ++updated;
                    object.setDirectoryName(fixState.updatedPath);
                    this._logger.info(Message.format((ResourceBundle)RB.getResources(), (String)"HostPortTool.PathUpdate.fmt.log", (Object)object.getCMetadataType(), (Object)object.getId(), (Object)path, (Object)fixState.updatedPath));
                    continue;
                }
                this._logger.info(Message.format((ResourceBundle)RB.getResources(), (String)"HostPortTool.PathMatch.fmt.log", (Object)object.getCMetadataType(), (Object)object.getId(), (Object)path));
            }
            if (updated > 0) {
                if (!this._noExecute) {
                    store.updatedMetadataAll();
                }
                this._logger.info(Message.format((ResourceBundle)RB.getResources(), (String)"HostPortTool.ObjectsUpdated.fmt.log", (Object)new Integer(matched), (Object)"Directory", (Object)new Integer(updated)));
            } else {
                this._logger.info(Message.format((ResourceBundle)RB.getResources(), (String)"HostPortTool.ObjectsFound.fmt.log", (Object)new Integer(matched), (Object)"Directory"));
            }
            this._inspectedCount += objects.size();
            this._matchCount += matched;
            this._updateCount += updated;
        }
        finally {
            store.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processInformationServiceDefinitions() throws MdException, RemoteException {
        int matched = 0;
        int updated = 0;
        MdObjectStore store = this._factory.createObjectStore();
        try {
            int flags = 8584;
            List objects = this._factory.getOMIUtil().getMetadataObjectsSubset((MdStore)store, "", "TextStore", flags, "<XMLSelect search=\"*[@Name='Initialization Data'][AssociatedProperty/Property[@PropertyName='INIT_DATA']/AssociatedObject/ServiceComponent[@FactoryClassName='com.sas.services.information.InformationServiceFactory']]\"/>");
            for (TextStore object : objects) {
                String serviceDeploymentName;
                try {
                    Property serviceProperty = (Property)object.getAssociatedProperty();
                    ServiceComponent serviceDefinition = (ServiceComponent)serviceProperty.getAssociatedObject();
                    Tree serviceGroup = (Tree)serviceDefinition.getTrees().elementAt(0);
                    SoftwareComponent serviceDeployment = (SoftwareComponent)serviceGroup.getSoftwareComponents().elementAt(0);
                    serviceDeploymentName = serviceDeployment.getName() + " - Information Service";
                }
                catch (Exception e) {
                    serviceDeploymentName = "Information Service";
                }
                try {
                    String newPort;
                    String newHost;
                    String reposName;
                    HostPortArgument arg;
                    int j;
                    String port;
                    String host;
                    Element def;
                    int i;
                    boolean configurationMatched = false;
                    boolean configurationUpdated = false;
                    org.w3c.dom.Document configDocument = this.parseXML(object.getStoredText());
                    NodeList defs = configDocument.getElementsByTagName("ReposDef");
                    block8: for (i = 0; i < defs.getLength(); ++i) {
                        def = (Element)defs.item(i);
                        host = def.getAttribute("host");
                        port = def.getAttribute("port");
                        for (j = 0; j < this._arguments.length; ++j) {
                            arg = this._arguments[j];
                            if (!arg.isMatch(host, port)) continue;
                            configurationMatched = true;
                            reposName = def.getAttribute("name");
                            if (arg.isUpdateArgument()) {
                                newHost = arg.getNewHost();
                                newPort = arg.getNewPort();
                                if (newHost != null) {
                                    def.setAttribute("host", newHost);
                                } else {
                                    newHost = host;
                                }
                                if (arg.getNewPortNumber() > 0) {
                                    def.setAttribute("port", newPort);
                                } else {
                                    newPort = port;
                                }
                                this._logger.info(Message.format((ResourceBundle)RB.getResources(), (String)"HostPortTool.ConnectionUpdate.fmt.log", (Object)(object.getCMetadataType() + " " + object.getId()), (Object)(serviceDeploymentName + " - Repository " + reposName), (Object)host, (Object)new Integer(port), (Object)newHost, (Object)new Integer(newPort)));
                                configurationUpdated = true;
                                continue block8;
                            }
                            this._logger.info(Message.format((ResourceBundle)RB.getResources(), (String)"HostPortTool.ConnectionMatch.fmt.log", (Object)(object.getCMetadataType() + " " + object.getId()), (Object)(serviceDeploymentName + " - Repository " + reposName), (Object)host, (Object)new Integer(port)));
                            continue block8;
                        }
                    }
                    defs = configDocument.getElementsByTagName("ServerDef");
                    block10: for (i = 0; i < defs.getLength(); ++i) {
                        def = (Element)defs.item(i);
                        host = def.getAttribute("host");
                        port = def.getAttribute("port");
                        for (j = 0; j < this._arguments.length; ++j) {
                            arg = this._arguments[j];
                            if (!arg.isMatch(host, port)) continue;
                            configurationMatched = true;
                            reposName = def.getAttribute("name");
                            if (arg.isUpdateArgument()) {
                                newHost = arg.getNewHost();
                                newPort = arg.getNewPort();
                                if (newHost != null) {
                                    def.setAttribute("host", newHost);
                                } else {
                                    newHost = host;
                                }
                                if (arg.getNewPortNumber() > 0) {
                                    def.setAttribute("port", newPort);
                                } else {
                                    newPort = port;
                                }
                                this._logger.info(Message.format((ResourceBundle)RB.getResources(), (String)"HostPortTool.ConnectionUpdate.fmt.log", (Object)(object.getCMetadataType() + " " + object.getId()), (Object)(serviceDeploymentName + " - Server " + reposName), (Object)host, (Object)new Integer(port), (Object)newHost, (Object)new Integer(newPort)));
                                configurationUpdated = true;
                                continue block10;
                            }
                            this._logger.info(Message.format((ResourceBundle)RB.getResources(), (String)"HostPortTool.ConnectionMatch.fmt.log", (Object)(object.getCMetadataType() + " " + object.getId()), (Object)(serviceDeploymentName + " - Server " + reposName), (Object)host, (Object)new Integer(port)));
                            continue block10;
                        }
                    }
                    if (configurationMatched) {
                        ++matched;
                    }
                    if (!configurationUpdated) continue;
                    ++updated;
                    object.setStoredText(this.writeXML(configDocument));
                }
                catch (Exception e) {
                    this._rc = 8;
                    this._logger.error(Message.format((ResourceBundle)RB.getResources(), (String)"HostPortTool.ServiceDefinitionError.fmt.log", (Object)object.getCMetadataType(), (Object)object.getId(), (Object)e.getLocalizedMessage()));
                }
            }
            if (updated > 0) {
                if (!this._noExecute) {
                    store.updatedMetadataAll();
                }
                this._logger.info(Message.format((ResourceBundle)RB.getResources(), (String)"HostPortTool.ObjectsUpdated.fmt.log", (Object)new Integer(matched), (Object)"Information Service TextStore", (Object)new Integer(updated)));
            } else {
                this._logger.info(Message.format((ResourceBundle)RB.getResources(), (String)"HostPortTool.ObjectsFound.fmt.log", (Object)new Integer(matched), (Object)"Information Service TextStore"));
            }
            this._inspectedCount += objects.size();
            this._matchCount += matched;
            this._updateCount += updated;
        }
        finally {
            store.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processUserServiceDefinitions() throws MdException, RemoteException {
        int matched = 0;
        int updated = 0;
        MdObjectStore store = this._factory.createObjectStore();
        try {
            int flags = 8584;
            List objects = this._factory.getOMIUtil().getMetadataObjectsSubset((MdStore)store, "", "TextStore", flags, "<XMLSelect search=\"*[@Name='Initialization Data'][AssociatedProperty/Property[@PropertyName='INIT_DATA']/AssociatedObject/ServiceComponent[@FactoryClassName='com.sas.services.user.UserServiceFactory']]\"/>");
            for (TextStore object : objects) {
                String serviceDeploymentName;
                try {
                    Property serviceProperty = (Property)object.getAssociatedProperty();
                    ServiceComponent serviceDefinition = (ServiceComponent)serviceProperty.getAssociatedObject();
                    Tree serviceGroup = (Tree)serviceDefinition.getTrees().elementAt(0);
                    SoftwareComponent serviceDeployment = (SoftwareComponent)serviceGroup.getSoftwareComponents().elementAt(0);
                    serviceDeploymentName = serviceDeployment.getName() + " - User Service";
                }
                catch (Exception e) {
                    serviceDeploymentName = "User Service";
                }
                try {
                    boolean configurationMatched = false;
                    boolean configurationUpdated = false;
                    org.w3c.dom.Document configDocument = this.parseXML(object.getStoredText());
                    NodeList profiles = configDocument.getElementsByTagName("Profile");
                    for (int i = 0; i < profiles.getLength(); ++i) {
                        Element profile = (Element)profiles.item(i);
                        String uri = profile.getAttribute("url");
                        String app = profile.getAttribute("Application");
                        FixState fixState = this.fixURI(uri);
                        if (!fixState.matched) continue;
                        configurationMatched = true;
                        if (fixState.updated) {
                            profile.setAttribute("url", fixState.updatedPath);
                            this._logger.info(Message.format((ResourceBundle)RB.getResources(), (String)"HostPortTool.PathUpdate.fmt.log", (Object)(object.getCMetadataType() + " " + object.getId()), (Object)("(" + serviceDeploymentName + " - Application " + app + ")"), (Object)uri, (Object)fixState.updatedPath));
                            configurationUpdated = true;
                            continue;
                        }
                        this._logger.info(Message.format((ResourceBundle)RB.getResources(), (String)"HostPortTool.PathMatch.fmt.log", (Object)(object.getCMetadataType() + " " + object.getId()), (Object)("(" + serviceDeploymentName + " - Application " + app + ")"), (Object)uri));
                    }
                    if (configurationMatched) {
                        ++matched;
                    }
                    if (!configurationUpdated) continue;
                    ++updated;
                    object.setStoredText(this.writeXML(configDocument));
                }
                catch (Exception e) {
                    this._rc = 8;
                    this._logger.error(Message.format((ResourceBundle)RB.getResources(), (String)"HostPortTool.ServiceDefinitionError.fmt.log", (Object)object.getCMetadataType(), (Object)object.getId(), (Object)e.getLocalizedMessage()));
                }
            }
            if (updated > 0) {
                if (!this._noExecute) {
                    store.updatedMetadataAll();
                }
                this._logger.info(Message.format((ResourceBundle)RB.getResources(), (String)"HostPortTool.ObjectsUpdated.fmt.log", (Object)new Integer(matched), (Object)"User Service TextStore", (Object)new Integer(updated)));
            } else {
                this._logger.info(Message.format((ResourceBundle)RB.getResources(), (String)"HostPortTool.ObjectsFound.fmt.log", (Object)new Integer(matched), (Object)"User Service TextStore"));
            }
            this._inspectedCount += objects.size();
            this._matchCount += matched;
            this._updateCount += updated;
        }
        finally {
            store.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processLoggingServiceDefinitions() throws MdException, RemoteException {
        int matched = 0;
        int updated = 0;
        MdObjectStore store = this._factory.createObjectStore();
        try {
            int flags = 8584;
            List objects = this._factory.getOMIUtil().getMetadataObjectsSubset((MdStore)store, "", "TextStore", flags, "<XMLSelect search=\"*[@Name='Initialization Data'][AssociatedProperty/Property[@PropertyName='INIT_DATA']/AssociatedObject/ServiceComponent[@FactoryClassName='com.sas.services.logging.LoggingServiceFactory']]\"/>");
            for (TextStore object : objects) {
                String serviceDeploymentName;
                try {
                    Property serviceProperty = (Property)object.getAssociatedProperty();
                    ServiceComponent serviceDefinition = (ServiceComponent)serviceProperty.getAssociatedObject();
                    Tree serviceGroup = (Tree)serviceDefinition.getTrees().elementAt(0);
                    SoftwareComponent serviceDeployment = (SoftwareComponent)serviceGroup.getSoftwareComponents().elementAt(0);
                    serviceDeploymentName = serviceDeployment.getName() + " - Logging Service";
                }
                catch (Exception e) {
                    serviceDeploymentName = "Logging Service";
                }
                try {
                    boolean configurationMatched = false;
                    boolean configurationUpdated = false;
                    org.w3c.dom.Document configDocument = this.parseXML(object.getStoredText());
                    NodeList outputs = configDocument.getElementsByTagName("Output");
                    block8: for (int i = 0; i < outputs.getLength(); ++i) {
                        int j;
                        Element output = (Element)outputs.item(i);
                        if (!output.getAttribute("type").equals("Socket")) continue;
                        NodeList params = output.getElementsByTagName("param");
                        Element hostParam = null;
                        Element portParam = null;
                        String host = null;
                        String port = null;
                        for (j = 0; j < params.getLength(); ++j) {
                            Element param = (Element)params.item(j);
                            if (param.getAttribute("name").equalsIgnoreCase("host")) {
                                hostParam = param;
                                host = param.getAttribute("value");
                                continue;
                            }
                            if (!param.getAttribute("name").equalsIgnoreCase("port")) continue;
                            portParam = param;
                            port = param.getAttribute("value");
                        }
                        if (host == null && port == null) continue;
                        for (j = 0; j < this._arguments.length; ++j) {
                            HostPortArgument arg = this._arguments[j];
                            if (!arg.isMatch(host, port)) continue;
                            configurationMatched = true;
                            String outputId = output.getAttribute("id");
                            if (arg.isUpdateArgument()) {
                                String newHost = arg.getNewHost();
                                String newPort = arg.getNewPort();
                                if (newHost != null && hostParam != null) {
                                    hostParam.setAttribute("value", newHost);
                                } else {
                                    newHost = host;
                                }
                                if (arg.getNewPortNumber() > 0 && portParam != null) {
                                    portParam.setAttribute("value", newPort);
                                } else {
                                    newPort = port;
                                }
                                this._logger.info(Message.format((ResourceBundle)RB.getResources(), (String)"HostPortTool.ConnectionUpdate.fmt.log", (Object)(object.getCMetadataType() + " " + object.getId()), (Object)(serviceDeploymentName + " - Output " + outputId), (Object)host, (Object)new Integer(port), (Object)newHost, (Object)new Integer(newPort)));
                                configurationUpdated = true;
                                continue block8;
                            }
                            this._logger.info(Message.format((ResourceBundle)RB.getResources(), (String)"HostPortTool.ConnectionMatch.fmt.log", (Object)(object.getCMetadataType() + " " + object.getId()), (Object)(serviceDeploymentName + " - Output " + outputId), (Object)host, (Object)new Integer(port)));
                            continue block8;
                        }
                    }
                    if (configurationMatched) {
                        ++matched;
                    }
                    if (!configurationUpdated) continue;
                    ++updated;
                    object.setStoredText(this.writeXML(configDocument));
                }
                catch (Exception e) {
                    this._rc = 8;
                    this._logger.error(Message.format((ResourceBundle)RB.getResources(), (String)"HostPortTool.ServiceDefinitionError.fmt.log", (Object)object.getCMetadataType(), (Object)object.getId(), (Object)e.getLocalizedMessage()));
                }
            }
            if (updated > 0) {
                if (!this._noExecute) {
                    store.updatedMetadataAll();
                }
                this._logger.info(Message.format((ResourceBundle)RB.getResources(), (String)"HostPortTool.ObjectsUpdated.fmt.log", (Object)new Integer(matched), (Object)"Logging Service TextStore", (Object)new Integer(updated)));
            } else {
                this._logger.info(Message.format((ResourceBundle)RB.getResources(), (String)"HostPortTool.ObjectsFound.fmt.log", (Object)new Integer(matched), (Object)"Logging Service TextStore"));
            }
            this._inspectedCount += objects.size();
            this._matchCount += matched;
            this._updateCount += updated;
        }
        finally {
            store.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processJpsSoftwareComponent() throws MdException, RemoteException {
        int matched = 0;
        int updated = 0;
        MdObjectStore store = this._factory.createObjectStore();
        try {
            int flags = 8584;
            List objects = this._factory.getOMIUtil().getMetadataObjectsSubset((MdStore)store, "", "PropertySet", flags, "<XMLSelect search=\"*[@PropertySetName='Environment.Properties'][OwningOBject/SoftwareComponent[@ClassIdentifier='jps']]\"/>");
            block7: for (PropertySet object : objects) {
                String softwareComponentName;
                try {
                    SoftwareComponent softwareComponent = (SoftwareComponent)object.getOwningObject();
                    softwareComponentName = softwareComponent.getName();
                }
                catch (Exception e) {
                    softwareComponentName = "jps SoftwareComponent";
                }
                try {
                    String newPort;
                    String newHost;
                    HostPortArgument arg;
                    int i;
                    Property omr_host = null;
                    Property omr_port = null;
                    String host = "";
                    String port = "";
                    Property mcHostProp = null;
                    Property mcPortProp = null;
                    String mcHost = "";
                    String mcPort = "";
                    AssociationList properties = object.getSetProperties();
                    for (i = 1; i < properties.size(); ++i) {
                        Property property = (Property)properties.elementAt(i);
                        String name = property.getPropertyName();
                        if (name.equals("omr_host")) {
                            omr_host = property;
                            host = omr_host.getDefaultValue();
                            continue;
                        }
                        if (name.equals("omr_port")) {
                            omr_port = property;
                            port = omr_port.getDefaultValue();
                            continue;
                        }
                        if (name.equals("multicast.address")) {
                            mcHostProp = property;
                            mcHost = property.getDefaultValue();
                            continue;
                        }
                        if (!name.equals("multicast.port")) continue;
                        mcPortProp = property;
                        mcPort = property.getDefaultValue();
                    }
                    for (i = 0; i < this._arguments.length; ++i) {
                        arg = this._arguments[i];
                        if (!arg.isMatch(host, port)) continue;
                        ++matched;
                        if (arg.isUpdateArgument()) {
                            ++updated;
                            newHost = arg.getNewHost();
                            newPort = arg.getNewPort();
                            if (newHost != null && omr_host != null) {
                                omr_host.setDefaultValue(newHost);
                            } else {
                                newHost = host;
                            }
                            if (arg.getNewPortNumber() > 0 && omr_port != null) {
                                omr_port.setDefaultValue(newPort);
                            } else {
                                newPort = port;
                            }
                            if (host.length() == 0) {
                                host = "<blank>";
                            }
                            if (newHost.length() == 0) {
                                newHost = "<blank>";
                            }
                            this._logger.info(Message.format((ResourceBundle)RB.getResources(), (String)"HostPortTool.ConnectionUpdate.fmt.log", (Object)(object.getCMetadataType() + " " + object.getId()), (Object)("SoftwareComponent " + softwareComponentName + " - omr_host, omr_port"), (Object)host, (Object)new Integer(port), (Object)newHost, (Object)new Integer(newPort)));
                            break;
                        }
                        if (host.length() == 0) {
                            host = "<blank>";
                        }
                        this._logger.info(Message.format((ResourceBundle)RB.getResources(), (String)"HostPortTool.ConnectionMatch.fmt.log", (Object)(object.getCMetadataType() + " " + object.getId()), (Object)("SoftwareComponent " + softwareComponentName + " - omr_host, omr_port"), (Object)host, (Object)new Integer(port)));
                        break;
                    }
                    for (i = 0; i < this._arguments.length; ++i) {
                        arg = this._arguments[i];
                        if (!arg.isMatch(mcHost, mcPort)) continue;
                        ++matched;
                        if (arg.isUpdateArgument()) {
                            ++updated;
                            newHost = arg.getNewHost();
                            newPort = arg.getNewPort();
                            if (newHost != null && mcHostProp != null) {
                                mcHostProp.setDefaultValue(newHost);
                            } else {
                                newHost = mcHost;
                            }
                            if (arg.getNewPortNumber() > 0 && mcPortProp != null) {
                                mcPortProp.setDefaultValue(newPort);
                            } else {
                                newPort = port;
                            }
                            if (mcHost.length() == 0) {
                                mcHost = "<blank>";
                            }
                            if (newHost.length() == 0) {
                                newHost = "<blank>";
                            }
                            this._logger.info(Message.format((ResourceBundle)RB.getResources(), (String)"HostPortTool.ConnectionUpdate.fmt.log", (Object)(object.getCMetadataType() + " " + object.getId()), (Object)("SoftwareComponent " + softwareComponentName + " - multicast.address, multicast.port"), (Object)mcHost, (Object)new Integer(mcPort), (Object)newHost, (Object)new Integer(newPort)));
                            continue block7;
                        }
                        if (mcHost.length() == 0) {
                            mcHost = "<blank>";
                        }
                        this._logger.info(Message.format((ResourceBundle)RB.getResources(), (String)"HostPortTool.ConnectionMatch.fmt.log", (Object)(object.getCMetadataType() + " " + object.getId()), (Object)("SoftwareComponent " + softwareComponentName + " - multicast.address, multicast.port"), (Object)mcHost, (Object)new Integer(mcPort)));
                        continue block7;
                    }
                }
                catch (Exception e) {
                    this._rc = 8;
                    this._logger.error(Message.format((ResourceBundle)RB.getResources(), (String)"HostPortTool.ServiceDefinitionError.fmt.log", (Object)object.getCMetadataType(), (Object)object.getId(), (Object)e.getLocalizedMessage()));
                }
            }
            if (updated > 0) {
                if (!this._noExecute) {
                    store.updatedMetadataAll();
                }
                this._logger.info(Message.format((ResourceBundle)RB.getResources(), (String)"HostPortTool.ObjectsUpdated.fmt.log", (Object)new Integer(matched), (Object)"Foundation Service SoftwareComponent", (Object)new Integer(updated)));
            } else {
                this._logger.info(Message.format((ResourceBundle)RB.getResources(), (String)"HostPortTool.ObjectsFound.fmt.log", (Object)new Integer(matched), (Object)"Foundation Service SoftwareComponent"));
            }
            this._inspectedCount += objects.size();
            this._matchCount += matched;
            this._updateCount += updated;
        }
        finally {
            store.dispose();
        }
    }

    private FixState fixUNCPath(String path) {
        FixState state = new FixState();
        Matcher m = _uncPattern.matcher(path);
        if (m.matches()) {
            String host = m.group(1);
            for (int i = 0; i < this._arguments.length; ++i) {
                HostPortArgument arg = this._arguments[i];
                if (!arg.isMatch(host)) continue;
                state.matched = true;
                if (!arg.isUpdateArgument()) break;
                state.updated = true;
                String newPath = "\\\\" + arg.getNewHost();
                if (m.group(2) != null) {
                    newPath = newPath + m.group(2);
                }
                state.updatedPath = newPath;
                break;
            }
        }
        return state;
    }

    private FixState fixURI(String uri) {
        FixState state = new FixState();
        Matcher m = _uriPattern.matcher(uri);
        if (m.matches()) {
            String protocol = m.group(1);
            String host = m.group(2);
            String port = m.group(4);
            String matchPort = port;
            if (matchPort == null && protocol != null) {
                if (protocol.equalsIgnoreCase("http:")) {
                    matchPort = "80";
                } else if (protocol.equalsIgnoreCase("https:")) {
                    matchPort = "443";
                } else if (protocol.equalsIgnoreCase("ftp:")) {
                    matchPort = "21";
                } else if (protocol.equalsIgnoreCase("ldap:")) {
                    matchPort = "389";
                }
            }
            for (int i = 0; i < this._arguments.length; ++i) {
                String newHost;
                HostPortArgument arg = this._arguments[i];
                if (!arg.isMatch(host, matchPort)) continue;
                state.matched = true;
                if (!arg.isUpdateArgument()) break;
                state.updated = true;
                String newUri = "";
                if (protocol != null) {
                    newUri = newUri + protocol;
                }
                if ((newHost = arg.getNewHost()) == null) {
                    newHost = host;
                }
                newUri = newUri + "//" + newHost;
                int newPortNumber = arg.getNewPortNumber();
                if (newPortNumber != 0) {
                    if (protocol == null) {
                        newUri = newUri + ":" + arg.getNewPort();
                    } else if (protocol.equalsIgnoreCase("http:")) {
                        if (newPortNumber != 80) {
                            newUri = newUri + ":" + arg.getNewPort();
                        }
                    } else if (protocol.equalsIgnoreCase("https:")) {
                        if (newPortNumber != 443) {
                            newUri = newUri + ":" + arg.getNewPort();
                        }
                    } else if (protocol.equalsIgnoreCase("ftp:")) {
                        if (newPortNumber != 21) {
                            newUri = newUri + ":" + arg.getNewPort();
                        }
                    } else if (protocol.equalsIgnoreCase("ldap:")) {
                        if (newPortNumber != 389) {
                            newUri = newUri + ":" + arg.getNewPort();
                        }
                    } else {
                        newUri = newUri + ":" + arg.getNewPort();
                    }
                } else if (port != null) {
                    newUri = newUri + ":" + port;
                }
                if (m.group(5) != null) {
                    newUri = newUri + m.group(5);
                }
                state.updatedPath = newUri;
                break;
            }
        }
        return state;
    }

    private org.w3c.dom.Document parseXML(String xml) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = dbf.newDocumentBuilder();
        StringReader reader = new StringReader(xml);
        InputSource is = new InputSource(reader);
        return docBuilder.parse(is);
    }

    private String writeXML(org.w3c.dom.Document document) throws TransformerException {
        StringWriter writer = new StringWriter();
        DOMSource source = new DOMSource(document);
        StreamResult result = new StreamResult(writer);
        TransformerFactory factory = TransformerFactory.newInstance();
        Transformer transformer = factory.newTransformer();
        transformer.setOutputProperty("method", "xml");
        transformer.setOutputProperty("encoding", "UTF-8");
        transformer.setOutputProperty("indent", "no");
        transformer.transform(source, result);
        return writer.toString();
    }

    @Override
    protected void parse(String[] args) throws ParseException, MissingOptionException {
        this._options = new Options();
        super.parse(args);
        if (this._help) {
            return;
        }
        if (this._commandLine.hasOption(OPTION_APP_PROTOCOL)) {
            this.setApplicationProtocol(this._commandLine.getOptionValue(OPTION_APP_PROTOCOL));
        }
        if (this._commandLine.hasOption(OPTION_COMM_PROTOCOL)) {
            this.setCommunicationProtocol(this._commandLine.getOptionValue(OPTION_COMM_PROTOCOL));
        }
        this.setNoExecute(this._commandLine.hasOption(OPTION_NOEXECUTE));
        this.setHostsAndPorts(this._commandLine.getArgs());
    }

    public static void main(String[] args) {
        Thread.setDefaultUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)new UncaughtRuntimeExceptionHandler(true, 8));
        HostPortTool2 changer = new HostPortTool2();
        try {
            changer.parse(args);
            if (changer._help) {
                HelpFormatter help = new HelpFormatter();
                help.printHelp(80, HostPortTool2.getUsage(help), RB.getStringResource("HostPortTool.Options.txt"), (org.apache.commons.cli.Options)changer._options, null);
                return;
            }
            changer.execute();
        }
        catch (Exception e) {
            changer.logException(e);
        }
        changer.logCompletion();
        System.exit(changer.getReturnCode());
    }

    private static String getUsage(HelpFormatter help) {
        String NEW_LINE = help.getNewLine();
        StringBuffer usage = new StringBuffer();
        usage.append(RB.getStringResource("HostPortTool.HelpUsage.txt"));
        usage.append(NEW_LINE).append(NEW_LINE);
        usage.append(RB.getStringResource("HostPortTool.HelpUsage2.txt"));
        return usage.toString();
    }

    protected class Options
    extends BatchDriverOptions {
        private static final long serialVersionUID = 1L;

        public Options() {
            Option option = new Option(HostPortTool2.OPTION_APP_PROTOCOL, true, RB.getStringResource("HostPortTool.ApplicationProtocol.Desc.txt"));
            option.setArgName(RB.getStringResource("HostPortTool.ApplicationProtocol.ArgName.txt"));
            this.addOption(option);
            option = new Option(HostPortTool2.OPTION_COMM_PROTOCOL, true, RB.getStringResource("HostPortTool.CommunicationProtocol.Desc.txt"));
            option.setArgName(RB.getStringResource("HostPortTool.CommunicationProtocol.ArgName.txt"));
            this.addOption(option);
            option = new Option(HostPortTool2.OPTION_NOEXECUTE, RB.getStringResource("HostPortTool.Noexecute.Desc.txt"));
            this.addOption(option);
        }
    }

    private class FixState {
        boolean matched = false;
        boolean updated = false;
        String updatedPath = null;

        private FixState() {
        }
    }

    private class MatchStats {
        int inspected = 0;
        int matched = 0;
        int updated = 0;

        private MatchStats() {
        }
    }
}

