/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.tools.hostporttool;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class HostPortArgument {
    String _matchHost = null;
    String _matchPort = null;
    String _newHost = null;
    String _newPort = null;
    static final Pattern MATCH_PATTERN = Pattern.compile("([^:=]+)?(:\\d+)?(=([^:=]+)?(:\\d+)?)?");

    public HostPortArgument(String hostPortArgument) {
        Matcher matcher = MATCH_PATTERN.matcher(hostPortArgument);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("Invalid host/port argument: " + hostPortArgument);
        }
        this._matchHost = matcher.group(1);
        this._matchPort = matcher.group(2);
        if (this._matchPort != null) {
            this._matchPort = this._matchPort.substring(1);
        }
        this._newHost = matcher.group(4);
        this._newPort = matcher.group(5);
        if (this._newPort != null) {
            this._newPort = this._newPort.substring(1);
        }
        this.checkFields();
    }

    public HostPortArgument(String matchHost, String matchPort, String newHost, String newPort) {
        this._matchHost = matchHost;
        this._matchPort = matchPort;
        this._newHost = newHost;
        this._newPort = newPort;
        this.checkFields();
    }

    private void checkFields() {
        if (this._matchHost == null && this._newHost != null) {
            throw new IllegalArgumentException("Matching host must be specified if new host is specified.");
        }
        if (this._matchPort == null && this._newPort != null) {
            throw new IllegalArgumentException("Matching port must be specified if new port is specified.");
        }
        if (this._matchHost == null && this._matchPort == null) {
            throw new IllegalArgumentException("Matching host or matching port must be specified.");
        }
    }

    public boolean isHostOnly() {
        return this._matchPort == null;
    }

    public boolean isMatch(String host) {
        if (this._matchPort != null) {
            return false;
        }
        if (this._matchHost == null) {
            return host == null;
        }
        return this._matchHost.equalsIgnoreCase(host) || this._matchHost.equals(".");
    }

    public boolean isMatch(String host, String port) {
        if (this._matchHost == null || this._matchHost.equalsIgnoreCase(host) || this._matchHost.equals(".")) {
            if (this._matchPort == null) {
                return true;
            }
            return this._matchPort.equalsIgnoreCase(port);
        }
        return false;
    }

    public boolean isMatch(String host, int port) {
        if (this._matchHost == null || this._matchHost.equalsIgnoreCase(host) || this._matchHost.equals(".")) {
            if (this._matchPort == null) {
                return true;
            }
            try {
                return port == Integer.parseInt(this._matchPort);
            }
            catch (NumberFormatException e) {
                return false;
            }
        }
        return false;
    }

    public boolean isUpdateArgument() {
        return this._newHost != null && !this._newHost.equals(this._matchHost) || this._newPort != null && !this._newPort.equals(this._matchPort);
    }

    public String getNewHost() {
        return this._newHost;
    }

    public String getNewPort() {
        return this._newPort;
    }

    public int getNewPortNumber() {
        if (this._newPort == null) {
            return 0;
        }
        try {
            return Integer.parseInt(this._newPort);
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        if (this._matchHost != null) {
            builder.append(this._matchHost);
        }
        if (this._matchPort != null) {
            builder.append(":");
            builder.append(this._matchPort);
        }
        if (this._newHost != null || this._newPort != null) {
            builder.append("=");
            if (this._newHost != null) {
                builder.append(this._newHost);
            }
            if (this._newPort != null) {
                builder.append(":");
                builder.append(this._newPort);
            }
        }
        return builder.toString();
    }
}

