/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.tools.appmeta;

import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.Property;
import com.sas.metadata.remote.ServiceComponent;
import com.sas.metadata.remote.Tree;
import com.sas.metadata.tools.appmeta.AppMetaException;
import com.sas.metadata.tools.appmeta.Directive2;
import com.sas.metadata.tools.appmeta.Directives2;
import java.lang.reflect.UndeclaredThrowableException;
import java.rmi.RemoteException;
import org.w3c.dom.Element;

final class URLDirective2
extends Directive2 {
    String _appName = null;
    private String _uri = null;

    private URLDirective2(Directives2 directives) {
        super(directives);
        this._directives = directives;
    }

    static URLDirective2 create(Directives2 directives) {
        URLDirective2 directive = new URLDirective2(directives);
        return directive;
    }

    String getUri() {
        return this._uri;
    }

    void loadFromXML(Element xml) throws AppMetaException {
        this._name = xml.getAttribute("Name");
        super.getCommonAttributes(xml);
        this._appName = xml.getAttribute("AppName");
        this._uri = xml.getAttribute("Uri");
        if (!("Delete".equals(this._action) || this._uri != null && this._uri.length() != 0)) {
            throw new AppMetaException("Uri must be specified for URLDirective elements.");
        }
    }

    @Override
    void loadFromMetadata(ServiceComponent directive, Element parent) throws MdException {
        this._jomaObject = directive;
        this.getCommonObjectAttributes();
        if (this._directivePropertySet != null) {
            try {
                for (Object item : this._directivePropertySet.getSetProperties()) {
                    Property property = (Property)item;
                    if (property.getName().equals("app-name")) {
                        this._appName = property.getDefaultValue();
                        continue;
                    }
                    if (!property.getName().equals("uri")) continue;
                    this._uri = property.getDefaultValue();
                }
            }
            catch (RemoteException e) {
                throw new UndeclaredThrowableException(e);
            }
        }
        Element dir = parent.getOwnerDocument().createElement("URLDirective");
        parent.appendChild(dir);
        this.setCommonObjectAttributes(dir);
        if (this._appName != null) {
            dir.setAttribute("AppName", this._appName);
        }
        if (this._uri != null) {
            dir.setAttribute("Uri", this._uri);
        }
        this.loadKeywordsFromMetadata(dir);
    }

    @Override
    void mergeToMetadata() throws MdException {
        if (super.mergeToMetadataBase()) {
            return;
        }
        try {
            Property property;
            Tree directivesObject = this._directives.getJomaObject();
            MdObjectStore store = (MdObjectStore)directivesObject.getObjectStore();
            String reposId = directivesObject.getId().substring(0, 8);
            this._typeProperty.setDefaultValue("URL");
            if (this._appName.length() > 0) {
                property = (Property)store.getFactory().createComplexMetadataObject(store, "app-name", "Property", reposId);
                property.setPropertyName("app-name");
                property.setSQLType(12);
                property.setDefaultValue(this._appName);
                property.setAssociatedPropertySet(this._directivePropertySet);
            }
            property = (Property)store.getFactory().createComplexMetadataObject(store, "uri", "Property", reposId);
            property.setPropertyName("uri");
            property.setSQLType(12);
            property.setDefaultValue(this._uri);
            property.setAssociatedPropertySet(this._directivePropertySet);
        }
        catch (RemoteException e) {
            throw new UndeclaredThrowableException(e);
        }
    }
}

