/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.tools.appmeta;

import com.sas.metadata.remote.MdException;
import com.sas.metadata.tools.appmeta.AppMetaException;
import com.sas.metadata.tools.appmeta.ApplicationMetadataUtility2;
import com.sas.metadata.tools.appmeta.RB;
import com.sas.metadata.tools.appmeta.TypeDefinition2;
import com.sas.services.ServiceException;
import com.sas.services.information.OMIServer;
import com.sas.services.information.metadata.FolderInterface;
import com.sas.storage.editableproperties.LocalizableProperties;
import com.sas.storage.editableproperties.PropertyList;
import com.sas.storage.editableproperties.PropertyMap;
import com.sas.storage.editableproperties.UnexpectedLocalizationException;
import com.sas.text.Message;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TypeGroup2
implements LocalizableProperties {
    private ApplicationMetadataUtility2 _context = null;
    private String _desc = null;
    private FolderInterface _folder = null;
    private String _name = null;
    private List<TypeGroup2> _subGroups = null;
    private List<TypeDefinition2> _typeDefs = null;
    private TypeGroup2 _parent = null;

    private TypeGroup2(ApplicationMetadataUtility2 context, TypeGroup2 parent) {
        this._context = context;
        this._parent = parent;
        this._subGroups = new ArrayList<TypeGroup2>();
        this._typeDefs = new ArrayList<TypeDefinition2>();
    }

    static TypeGroup2 create(Element xml, TypeGroup2 parent) {
        TypeGroup2 typeGroup = new TypeGroup2(parent.getContext(), parent);
        typeGroup.loadFromXML(xml);
        parent.add(typeGroup);
        return typeGroup;
    }

    static TypeGroup2 createRootTypeGroup(ApplicationMetadataUtility2 context) {
        TypeGroup2 typeGroup = new TypeGroup2(context, null);
        return typeGroup;
    }

    void loadFromXML(Element xml) {
        this._desc = xml.getAttribute("Desc");
        this._name = xml.getAttribute("Name");
        NodeList nodes = xml.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            if (node.getNodeType() != 1) continue;
            Element element = (Element)node;
            String tagName = element.getTagName();
            if (tagName.equals("TypeGroup")) {
                TypeGroup2.create(element, this);
                continue;
            }
            if (!tagName.equals("TypeDefinition2")) continue;
            TypeDefinition2.create(element, this);
        }
    }

    void add(TypeGroup2 group) {
        this._subGroups.add(group);
    }

    void add(TypeDefinition2 typeDef) {
        this._typeDefs.add(typeDef);
    }

    ApplicationMetadataUtility2 getContext() {
        return this._context;
    }

    String getName() {
        return this._name;
    }

    String getPath() {
        if (this._parent == null) {
            return "/System/Types";
        }
        return this._parent.getPath() + "/" + this._name;
    }

    FolderInterface getFolder() {
        return this._folder;
    }

    List<TypeGroup2> getGroups() {
        ArrayList<TypeGroup2> list = new ArrayList<TypeGroup2>();
        for (TypeGroup2 group : this._subGroups) {
            list.add(group);
            list.addAll(group.getGroups());
        }
        return list;
    }

    List<TypeDefinition2> getDefinitions() {
        ArrayList<TypeDefinition2> list = new ArrayList<TypeDefinition2>();
        for (TypeGroup2 group : this._subGroups) {
            list.addAll(group.getDefinitions());
        }
        for (TypeDefinition2 typeDef : this._typeDefs) {
            list.add(typeDef);
        }
        return list;
    }

    void mergeToMetadata(OMIServer server) throws RemoteException, MdException, AppMetaException {
        try {
            if (this._parent == null) {
                this._folder = this._context.makeFolder(server, this.getPath());
            } else {
                this._folder = this._parent.getFolder().getSubfolder(this._name);
                if (this._folder == null) {
                    this._folder = this._parent.getFolder().makeSubfolder(this._name);
                    this._context.getLogger().info(Message.format((ResourceBundle)RB.getResources(), (String)"ApplicationMetadataUtility2.FolderCreated.fmt.log", (Object)this.getPath()));
                }
            }
        }
        catch (ServiceException e) {
            throw new AppMetaException(Message.format((ResourceBundle)RB.getResources(), (String)"TypeGroup.FolderCreateError.fmt.log", (Object)this.getPath()), e);
        }
        if (this._desc != null && this._desc.length() > 0 && !this._desc.equals(this._folder.getDescription())) {
            this._folder.setDescription(this._desc);
        }
        for (TypeGroup2 group : this._subGroups) {
            group.mergeToMetadata(server);
        }
        for (TypeDefinition2 typeDef : this._typeDefs) {
            typeDef.mergeToMetadata(server);
        }
    }

    public PropertyList getLocalizableProperties() throws UnexpectedLocalizationException {
        PropertyList list = new PropertyList();
        list.addProperty("Name", this._name);
        list.addProperty("Desc", this._desc);
        return list;
    }

    public void setLocalizableProperties(PropertyMap map) throws UnexpectedLocalizationException {
        if (map.containsProperty("Name")) {
            this._name = map.getProperty("Name");
        }
        if (map.containsProperty("Desc")) {
            this._desc = map.getProperty("Desc");
        }
    }
}

