/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.tools.appmeta;

import com.sas.meta.SASOMI.ISecurityAdmin;
import com.sas.metadata.remote.ApplicationAction;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.IdentityGroup;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdOMIUtil;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.MdStore;
import com.sas.metadata.remote.SoftwareComponent;
import com.sas.metadata.remote.Tree;
import com.sas.metadata.tools.appmeta.Application2;
import com.sas.metadata.tools.appmeta.ApplicationMetadataUtility2;
import com.sas.metadata.tools.appmeta.Capability2;
import com.sas.metadata.tools.appmeta.GroupOrRole2;
import com.sas.metadata.tools.appmeta.RB;
import com.sas.services.ServiceException;
import com.sas.text.Message;
import java.lang.reflect.UndeclaredThrowableException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

final class Role2
extends GroupOrRole2 {
    private List<RoleReference> _contributingRoles = new ArrayList<RoleReference>();
    private List<CapabilityReference> _capabilities = new ArrayList<CapabilityReference>();
    private Element _roleElement = null;
    private Element _capabilitiesElement = null;

    private Role2(ApplicationMetadataUtility2 context) {
        super(context, "Role");
    }

    static Role2 create(Element xml, ApplicationMetadataUtility2 context) {
        Role2 role = new Role2(context);
        role.loadFromXML(xml);
        return role;
    }

    static Role2 createAssociatedRole(ApplicationMetadataUtility2 context, IdentityGroup roleObject) throws MdException {
        String roleName;
        try {
            roleName = roleObject.getName();
        }
        catch (RemoteException e) {
            throw new UndeclaredThrowableException(e);
        }
        Role2 role = context.getRoles().get(roleName);
        if (role != null) {
            return role;
        }
        role = new Role2(context);
        role.loadFromMetadata(roleObject);
        context.getRoles().put(roleName, role);
        return role;
    }

    private void loadFromMetadata(IdentityGroup roleObject) throws MdException {
        try {
            this._name = roleObject.getName();
            this._displayName = roleObject.getDisplayName();
            this._desc = roleObject.getDesc();
        }
        catch (RemoteException e) {
            throw new UndeclaredThrowableException(e);
        }
        this._roleElement = this._context._sourceDocument.createElement("Role");
        this._roleElement.setAttribute("Name", this._name);
        this._roleElement.setAttribute("Desc", this._desc);
        if (this._displayName != null && this._displayName.length() > 0 && !this._displayName.equals(this._name)) {
            this._roleElement.setAttribute("DisplayName", this._displayName);
        }
        this._context._sourceDocument.getLastChild().appendChild(this._roleElement);
        Element members = this._context._sourceDocument.createElement("Members");
        this._roleElement.appendChild(members);
        this.loadMembersFromMetadata(roleObject, members);
        Element contributingRoles = this._context._sourceDocument.createElement("ContributingRoles");
        this._roleElement.appendChild(contributingRoles);
        try {
            for (Object item : roleObject.getIdentityGroups()) {
                IdentityGroup group = (IdentityGroup)item;
                if (!group.getPublicType().equals("Role")) continue;
                this._contributingRoles.add(new RoleReference(group.getName()));
                Element role = this._context._sourceDocument.createElement("Role");
                role.setAttribute("Name", group.getName());
                contributingRoles.appendChild(role);
            }
        }
        catch (RemoteException e) {
            throw new UndeclaredThrowableException(e);
        }
        this._context.getLogger().info(Message.format((ResourceBundle)RB.getResources(), (String)"Role.RoleFound.fmt.log", (Object)this._name));
    }

    void addCapability(String id) {
        this._capabilities.add(new CapabilityReference("", id));
        if (this._roleElement != null) {
            if (this._capabilitiesElement == null) {
                this._capabilitiesElement = this._context._sourceDocument.createElement("Capabilities");
                this._roleElement.appendChild(this._capabilitiesElement);
            }
            Element capability = this._capabilitiesElement.getOwnerDocument().createElement("Capability");
            capability.setAttribute("CapabilityId", id);
            this._capabilitiesElement.appendChild(capability);
        }
    }

    private void loadFromXML(Element xml) {
        this.getCommonAttributes(xml);
        NodeList nodes = xml.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            if (node.getNodeType() != 1) continue;
            Element element = (Element)node;
            String tagName = element.getTagName();
            if (tagName.equals("Capabilities")) {
                this.processCapabilities(element);
                continue;
            }
            if (tagName.equals("ContributingRoles")) {
                this.processContributingRoles(element);
                continue;
            }
            if (!tagName.equals("Members")) continue;
            this.processMembers(element);
        }
    }

    private void processCapabilities(Element capabilities) {
        NodeList nodes = capabilities.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Element element;
            String tagName;
            Node node = nodes.item(i);
            if (node.getNodeType() != 1 || !(tagName = (element = (Element)node).getTagName()).equals("Capability")) continue;
            this._capabilities.add(new CapabilityReference(element.getAttribute("Application2"), element.getAttribute("CapabilityId")));
        }
    }

    private void processContributingRoles(Element contributingRoles) {
        NodeList nodes = contributingRoles.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Element element;
            String tagName;
            Node node = nodes.item(i);
            if (node.getNodeType() != 1 || !(tagName = (element = (Element)node).getTagName()).equals("Role")) continue;
            this._contributingRoles.add(new RoleReference(element.getAttribute("Name")));
        }
    }

    @Override
    void addExternalReferences() throws MdException {
        IdentityGroup identity = (IdentityGroup)this._jomaObject;
        try {
            MdOMIUtil omiUtil = identity.getObjectStore().getFactory().getOMIUtil();
            super.addExternalReferences();
            ArrayList<RoleReference> contributingRolesCopy = new ArrayList<RoleReference>(this._contributingRoles);
            AssociationList contributingRoles = identity.getIdentityGroups();
            if (!identity.isNewObject()) {
                block2: for (Object item : contributingRoles) {
                    IdentityGroup role = (IdentityGroup)item;
                    for (RoleReference roleRef : contributingRolesCopy) {
                        if (!role.getName().equalsIgnoreCase(roleRef._name) || !role.getPublicType().equalsIgnoreCase("Role")) continue;
                        contributingRolesCopy.remove(roleRef);
                        continue block2;
                    }
                }
            }
            for (RoleReference roleRef : contributingRolesCopy) {
                List identities = omiUtil.getMetadataObjectsSubset(identity.getObjectStore(), omiUtil.getFoundationReposID(), "IdentityGroup", 8584, "<XMLSelect search=\"*[@Name='" + roleRef._name + "']\"/>");
                if (identities.size() == 1) {
                    IdentityGroup role = (IdentityGroup)identities.get(0);
                    if (role.getPublicType().equals("Role")) {
                        contributingRoles.add(identities.get(0));
                        continue;
                    }
                    this._context.getLogger().error(Message.format((ResourceBundle)RB.getResources(), (String)"Role.NotARole.fmt.log", (Object)roleRef._name, (Object)this._name));
                    this._context.declareError();
                    continue;
                }
                if (identities.size() != 0) continue;
                Role2 desiredRole = this._context.getRoles().get(roleRef._name);
                if (desiredRole != null) {
                    if (desiredRole._jomaObject != null) {
                        contributingRoles.add((Object)desiredRole.getJomaObject());
                        continue;
                    }
                    this._context.getLogger().error(Message.format((ResourceBundle)RB.getResources(), (String)"Role.RefNotCreated.fmt.log", (Object)roleRef._name, (Object)this._name));
                    this._context.declareError();
                    continue;
                }
                this._context.getLogger().warn(Message.format((ResourceBundle)RB.getResources(), (String)"Role.RoleNotFound.fmt.log", (Object)roleRef._name, (Object)this._name));
                this._context.declareWarning();
            }
        }
        catch (RemoteException e) {
            throw new UndeclaredThrowableException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void grantCapabilities(ISecurityAdmin iSecAdmin, Application2 application) throws ServiceException, MdException {
        if (this._jomaObject == null) {
            return;
        }
        HashMap<String, Map<String, String>> otherApps = new HashMap<String, Map<String, String>>();
        String[][] authorizations = new String[][]{{"Role", this._name, "G", "Execute", ""}};
        int grantCount = 0;
        int grantAttemptCount = 0;
        for (CapabilityReference capabilityRef : this._capabilities) {
            ++grantAttemptCount;
            String capabilityFQID = null;
            String referencedApplication = capabilityRef.getApplicationName();
            String capabilityId = capabilityRef.getId();
            if (referencedApplication.length() == 0 || application != null && referencedApplication.equalsIgnoreCase(application.getName())) {
                Capability2 capability = application.getCapability(capabilityId);
                if (capability != null) {
                    try {
                        capabilityFQID = capability.getJomaObject().getId();
                    }
                    catch (RemoteException e) {
                        throw new UndeclaredThrowableException(e);
                    }
                } else {
                    this._context.getLogger().error(Message.format((ResourceBundle)RB.getResources(), (String)"Role.GrantFailed.fmt.log", (Object)capabilityId, (Object)this._name));
                    this._context.getLogger().error("  " + RB.getStringResource("Role.CapabilityNotFound.log"));
                    this._context.declareError();
                    continue;
                }
            }
            Map<String, String> referencedAppCapabilities = (Map<String, String>)otherApps.get(referencedApplication);
            if (referencedAppCapabilities == null) {
                referencedAppCapabilities = this.loadOtherApplicationCapabilities(referencedApplication);
                if (referencedAppCapabilities == null) {
                    this._context.getLogger().error(Message.format((ResourceBundle)RB.getResources(), (String)"Role.GrantFailed.fmt.log", (Object)capabilityId, (Object)this._name));
                    this._context.getLogger().error("  " + Message.format((ResourceBundle)RB.getResources(), (String)"Role.ApplicationNotFound.fmt.log", (Object)referencedApplication));
                    this._context.declareError();
                    continue;
                }
                otherApps.put(referencedApplication, referencedAppCapabilities);
            }
            if ((capabilityFQID = (String)referencedAppCapabilities.get(capabilityId)) == null) {
                this._context.getLogger().error(Message.format((ResourceBundle)RB.getResources(), (String)"Role.GrantFailed.fmt.log", (Object)capabilityId, (Object)this._name));
                this._context.getLogger().error("  " + Message.format((ResourceBundle)RB.getResources(), (String)"Role.CapabilityNotFoundForApp.fmt.log", (Object)referencedApplication));
                this._context.declareError();
                continue;
            }
            if (this._context.isDebug()) {
                this._context.getLogger().debug("Granting capability " + capabilityId + " to role " + this._name);
            }
            if (this._context.isNoExecute()) {
                ++grantCount;
                continue;
            }
            try {
                iSecAdmin.SetAuthorizationsOnObj("", "omsobj:ApplicationAction/" + capabilityFQID, 0, authorizations);
                ++grantCount;
            }
            catch (Exception e) {
                this._context.getLogger().error(Message.format((ResourceBundle)RB.getResources(), (String)"Role.GrantFailed.fmt.log", (Object)capabilityId, (Object)this._name));
                this._context.getLogger().error("  " + e.getLocalizedMessage());
                this._context.declareError();
            }
        }
        if (grantAttemptCount <= 0) return;
        if (grantCount != grantAttemptCount) {
            this._context.getLogger().error(Message.format((ResourceBundle)RB.getResources(), (String)"Role.GrantFailedSummary.fmt.log", (Object)new Integer(grantCount), (Object)new Integer(grantAttemptCount), (Object)this._name));
            this._context.declareError();
            return;
        }
        if (this._context.isNoExecute()) {
            this._context.getLogger().info(Message.format((ResourceBundle)RB.getResources(), (String)"Role.GrantWouldSucceed.fmt.log", (Object)new Integer(grantCount), (Object)this._name));
            return;
        }
        this._context.getLogger().info(Message.format((ResourceBundle)RB.getResources(), (String)"Role.GrantSucceeded.fmt.log", (Object)new Integer(grantCount), (Object)this._name));
    }

    Map<String, String> loadOtherApplicationCapabilities(String applicationName) throws MdException, ServiceException {
        MdObjectStore store = this._context.getOMIServer().getObjectStore();
        try {
            MdOMIUtil omiUtil = store.getFactory().getOMIUtil();
            List objects = omiUtil.getMetadataObjectsSubset((MdStore)store, omiUtil.getFoundationReposID(), "SoftwareComponent", 8584, "<XMLSelect search=\"SoftwareComponent[@Name='" + applicationName + "' and @PublicType='Application2']\"/>");
            if (objects.size() == 0) {
                return null;
            }
            SoftwareComponent sc = (SoftwareComponent)objects.get(0);
            HashMap<String, String> capabilities = new HashMap<String, String>();
            AssociationList trees = sc.getSoftwareTrees();
            for (Tree tree : trees) {
                if (!tree.getName().equals("ApplicationActions")) continue;
                this.loadCapabilitiesFromCategory(tree, capabilities);
                break;
            }
            return capabilities;
        }
        catch (RemoteException e) {
            throw new UndeclaredThrowableException(e);
        }
    }

    void loadCapabilitiesFromCategory(Tree category, Map<String, String> capabilities) throws RemoteException, MdException {
        AssociationList subcategories = category.getSubTrees();
        for (Tree subcategory : subcategories) {
            this.loadCapabilitiesFromCategory(subcategory, capabilities);
        }
        for (Object item : category.getMembers()) {
            if (!(item instanceof ApplicationAction)) continue;
            ApplicationAction action = (ApplicationAction)item;
            capabilities.put(action.getActionIdentifier(), action.getId());
        }
    }

    private class RoleReference {
        String _name = null;

        RoleReference(String name) {
            this._name = name;
        }
    }

    private class CapabilityReference {
        String applicationName = null;
        String capabilityId = null;

        CapabilityReference(String application, String id) {
            this.applicationName = application;
            this.capabilityId = id;
        }

        String getId() {
            return this.capabilityId;
        }

        String getApplicationName() {
            return this.applicationName;
        }
    }
}

