/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.tools.appmeta;

import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.Keyword;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.Root;
import com.sas.metadata.tools.appmeta.ApplicationMetadataUtility2;
import com.sas.metadata.tools.appmeta.Keyword2;
import com.sas.storage.editableproperties.PropertyList;
import com.sas.storage.editableproperties.PropertyMap;
import java.lang.reflect.UndeclaredThrowableException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

abstract class MetadataBase2 {
    String _name = null;
    String _desc = null;
    List<Keyword2> _keywords = null;
    ApplicationMetadataUtility2 _context = null;
    Root _jomaObject = null;

    MetadataBase2(ApplicationMetadataUtility2 context) {
        this._context = context;
    }

    String getName() {
        return this._name;
    }

    String getDesc() {
        return this._desc;
    }

    ApplicationMetadataUtility2 getContext() {
        return this._context;
    }

    Root getJomaObject() {
        return this._jomaObject;
    }

    protected void loadKeywordsFromXML(Element xml) {
        if (this._keywords == null) {
            this._keywords = new ArrayList<Keyword2>();
        }
        NodeList nodes = xml.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Element element;
            String tagName;
            Node node = nodes.item(i);
            if (node.getNodeType() != 1 || !(tagName = (element = (Element)node).getTagName()).equals("Keyword2")) continue;
            Keyword2 keyword = Keyword2.create(this, element);
            this._keywords.add(keyword);
        }
    }

    protected void mergeKeywordMetadata() throws MdException {
        if (this._keywords == null) {
            return;
        }
        for (Keyword2 keyword : this._keywords) {
            keyword.mergeToMetadata();
        }
    }

    protected void loadKeywordsFromMetadata(Element element) throws MdException {
        try {
            AssociationList jomaKeywords = this._jomaObject.getKeywords();
            for (Keyword jomaKeyword : jomaKeywords) {
                Element keyword = element.getOwnerDocument().createElement("Keyword2");
                element.appendChild(keyword);
                keyword.setAttribute("Name", jomaKeyword.getName());
                if (jomaKeyword.getDesc().length() <= 0) continue;
                keyword.setAttribute("Desc", jomaKeyword.getDesc());
            }
        }
        catch (RemoteException e) {
            throw new UndeclaredThrowableException(e);
        }
    }

    protected void addLocalizableKeywordProperties(PropertyList list) {
        if (this._keywords == null) {
            return;
        }
        for (Keyword2 keyword : this._keywords) {
            list.addProperty(keyword.getName(), keyword.getLocalizableProperties());
        }
    }

    protected void setLocalizableKeywordProperties(PropertyMap map) {
        if (this._keywords == null) {
            return;
        }
        for (Keyword2 keyword : this._keywords) {
            String propertyName = keyword.getName();
            if (!map.containsNestedProperty(propertyName)) continue;
            keyword.setLocalizableProperties(map.getNestedProperties(propertyName));
        }
    }
}

