/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.tools.appmeta;

import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.Property;
import com.sas.metadata.remote.ServiceComponent;
import com.sas.metadata.remote.SoftwareComponent;
import com.sas.metadata.remote.Tree;
import com.sas.metadata.tools.appmeta.AppMetaException;
import com.sas.metadata.tools.appmeta.Application2;
import com.sas.metadata.tools.appmeta.Directive2;
import com.sas.metadata.tools.appmeta.RefDirective2;
import com.sas.metadata.tools.appmeta.URLDirective2;
import com.sas.storage.editableproperties.LocalizableProperties;
import com.sas.storage.editableproperties.PropertyList;
import com.sas.storage.editableproperties.PropertyMap;
import com.sas.storage.editableproperties.UnexpectedLocalizationException;
import java.lang.reflect.UndeclaredThrowableException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

final class Directives2
implements LocalizableProperties {
    private Application2 _application = null;
    private List<Directive2> _directives = new ArrayList<Directive2>();
    private Tree _jomaObject = null;

    private Directives2() {
    }

    static Directives2 create(Application2 application) {
        Directives2 directives = new Directives2();
        directives._application = application;
        return directives;
    }

    Application2 getApplication() {
        return this._application;
    }

    Tree getJomaObject() {
        return this._jomaObject;
    }

    void loadFromXML(Element xml) throws AppMetaException {
        NodeList nodes = xml.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Directive2 directive;
            Node node = nodes.item(i);
            if (node.getNodeType() != 1) continue;
            Element element = (Element)node;
            String tagName = element.getTagName();
            if (tagName.equals("URLDirective2")) {
                directive = URLDirective2.create(this);
                ((URLDirective2)directive).loadFromXML(element);
                this._directives.add(directive);
                continue;
            }
            if (!tagName.equals("RefDirective2")) continue;
            directive = RefDirective2.create(this);
            ((RefDirective2)directive).loadFromXML(element);
            this._directives.add(directive);
        }
    }

    void loadFromMetadata(Tree tree, Element parent) throws MdException {
        this._jomaObject = tree;
        Element dirs = parent.getOwnerDocument().createElement("Directives");
        parent.appendChild(dirs);
        try {
            block2: for (Object item : tree.getMembers()) {
                ServiceComponent sc;
                if (!(item instanceof ServiceComponent) || !(sc = (ServiceComponent)item).getClassIdentifier().equals("com.sas.framework.directives.client.Directive2")) continue;
                for (Object rawprop : sc.getProperties()) {
                    Directive2 directive;
                    Property property = (Property)rawprop;
                    if (!property.getName().equals("Type")) continue;
                    if (property.getDefaultValue().equalsIgnoreCase("URL")) {
                        directive = URLDirective2.create(this);
                    } else {
                        if (!property.getDefaultValue().equalsIgnoreCase("REF")) continue block2;
                        directive = RefDirective2.create(this);
                    }
                    ((Directive2)directive).loadFromMetadata(sc, dirs);
                    this._directives.add(directive);
                    continue block2;
                }
            }
        }
        catch (RemoteException e) {
            throw new UndeclaredThrowableException(e);
        }
    }

    void mergeToMetadata() throws MdException {
        try {
            AssociationList trees = ((SoftwareComponent)this._application.getJomaObject()).getSoftwareTrees();
            for (Object item : trees) {
                Tree tree = (Tree)item;
                if (!tree.getName().equals("Directives")) continue;
                this._jomaObject = tree;
                break;
            }
            if (this._jomaObject == null) {
                MdObjectStore store = (MdObjectStore)this._application.getJomaObject().getObjectStore();
                this._jomaObject = (Tree)store.getFactory().createComplexMetadataObject(store, "Directives", "Tree", this._application.getJomaObject().getId().substring(0, 8));
                this._jomaObject.setDesc("Directive2 definitions for " + this._application.getName());
                this._jomaObject.getSoftwareComponents().add((Object)this._application.getJomaObject());
            }
            if (this._jomaObject.isNewObject()) {
                this._jomaObject.setTreeType("Directives");
            }
        }
        catch (RemoteException e) {
            throw new UndeclaredThrowableException(e);
        }
        for (Directive2 directive : this._directives) {
            directive.mergeToMetadata();
        }
    }

    public PropertyList getLocalizableProperties() throws UnexpectedLocalizationException {
        PropertyList list = new PropertyList();
        for (Directive2 directive : this._directives) {
            list.addProperty(directive.getName(), directive.getLocalizableProperties());
        }
        return list;
    }

    public void setLocalizableProperties(PropertyMap map) throws UnexpectedLocalizationException {
        for (Directive2 directive : this._directives) {
            String propertyName = directive.getName();
            if (!map.containsNestedProperty(propertyName)) continue;
            directive.setLocalizableProperties(map.getNestedProperties(propertyName));
        }
    }
}

