/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.tools.appmeta;

import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.Property;
import com.sas.metadata.remote.PropertySet;
import com.sas.metadata.tools.appmeta.AppMetaException;
import com.sas.metadata.tools.appmeta.Configuration2;
import com.sas.metadata.tools.appmeta.MetadataBase2;
import com.sas.storage.editableproperties.LocalizableProperties;
import com.sas.storage.editableproperties.PropertyList;
import com.sas.storage.editableproperties.PropertyMap;
import com.sas.storage.editableproperties.UnexpectedLocalizationException;
import java.lang.reflect.UndeclaredThrowableException;
import java.rmi.RemoteException;
import org.w3c.dom.Element;

final class ConfigurationProperty2
extends MetadataBase2
implements LocalizableProperties {
    private String _propertyName = null;
    private String _value = null;
    private int _isRequired = 0;
    private int _isUpdateable = 0;
    private int _isVisible = 0;
    private Configuration2 _parent = null;
    private String _action = null;

    private ConfigurationProperty2(Configuration2 parent) {
        super(parent.getContext());
        this._parent = parent;
    }

    static ConfigurationProperty2 create(Configuration2 parent) {
        ConfigurationProperty2 property = new ConfigurationProperty2(parent);
        return property;
    }

    void loadFromXML(Element xml) throws AppMetaException {
        String temp;
        this._name = xml.getAttribute("Name");
        this._propertyName = xml.getAttribute("PropertyName");
        if (this._propertyName == null || this._propertyName.length() == 0) {
            this._propertyName = this._name;
        }
        this._action = xml.getAttribute("_Action");
        this._desc = xml.getAttribute("Desc");
        this._value = xml.getAttribute("Value");
        if (xml.hasAttribute("IsRequired") && (temp = xml.getAttribute("IsRequired")).length() > 0) {
            this._isRequired = Integer.parseInt(temp);
        }
        if (xml.hasAttribute("IsUpdateable") && (temp = xml.getAttribute("IsUpdateable")).length() > 0) {
            this._isUpdateable = Integer.parseInt(temp);
        }
        if (xml.hasAttribute("IsVisible") && (temp = xml.getAttribute("IsVisible")).length() > 0) {
            this._isVisible = Integer.parseInt(temp);
        }
        if ("Delete".equals(this._action)) {
            if (!(this._name != null && this._name.length() != 0 || this._propertyName != null && this._propertyName.length() != 0)) {
                throw new AppMetaException("PropertyName or Name must be specified for Property elements to be deleted.");
            }
        } else if (this._name == null || this._name.length() == 0) {
            throw new AppMetaException("Name must be specified for Property elements.");
        }
    }

    void loadFromMetadata(Property property, Element parent) {
        try {
            this._jomaObject = property;
            this.getObjectAttributes();
            this._isRequired = property.getIsRequired();
            this._isUpdateable = property.getIsUpdateable();
            this._isVisible = property.getIsVisible();
        }
        catch (RemoteException e) {
            throw new UndeclaredThrowableException(e);
        }
        Element cap = parent.getOwnerDocument().createElement("Property");
        parent.appendChild(cap);
        cap.setAttribute("Name", this._name);
        cap.setAttribute("Desc", this._desc);
        if (!this._propertyName.equals(this._name)) {
            cap.setAttribute("PropertyName", this._propertyName);
        }
        cap.setAttribute("Value", this._value);
        if (this._isRequired > 0) {
            cap.setAttribute("IsRequired", Integer.toString(this._isRequired));
        }
        if (this._isUpdateable > 0) {
            cap.setAttribute("IsUpdateable", Integer.toString(this._isUpdateable));
        }
        if (this._isVisible > 0) {
            cap.setAttribute("IsVisible", Integer.toString(this._isVisible));
        }
    }

    private void getObjectAttributes() {
        Property prop = (Property)this._jomaObject;
        try {
            this._name = prop.getName();
            this._desc = prop.getDesc();
            this._propertyName = prop.getPropertyName();
            this._value = prop.getDefaultValue();
        }
        catch (RemoteException e) {
            throw new UndeclaredThrowableException(e);
        }
    }

    void mergeToMetadata() throws MdException {
        try {
            PropertySet parentObject = (PropertySet)this._parent.getJomaObject();
            for (Object item : parentObject.getSetProperties()) {
                Property property = (Property)item;
                if (!property.getPropertyName().equals(this._propertyName)) continue;
                this._jomaObject = property;
                break;
            }
            if ("Delete".equals(this._action)) {
                if (this._jomaObject != null) {
                    this._jomaObject.delete();
                }
                return;
            }
            Property property = (Property)this._jomaObject;
            if (property == null) {
                MdObjectStore store = (MdObjectStore)parentObject.getObjectStore();
                String reposId = parentObject.getId().substring(0, 8);
                property = (Property)store.getFactory().createComplexMetadataObject(store, this._name, "Property", reposId);
                property.setAssociatedPropertySet(parentObject);
                this._jomaObject = property;
            } else {
                if ("Create".equals(this._action)) {
                    return;
                }
                property.setName(this._name);
            }
            property.setDesc(this._desc);
            property.setPropertyName(this._propertyName);
            property.setDefaultValue(this._value);
            property.setSQLType(12);
            property.setIsRequired(this._isRequired);
            property.setIsUpdateable(this._isUpdateable);
            property.setIsVisible(this._isVisible);
        }
        catch (RemoteException e) {
            throw new UndeclaredThrowableException(e);
        }
    }

    public PropertyList getLocalizableProperties() throws UnexpectedLocalizationException {
        PropertyList list = new PropertyList();
        list.addProperty("Desc", this._desc);
        return list;
    }

    public void setLocalizableProperties(PropertyMap map) throws UnexpectedLocalizationException {
        if (map.containsProperty("Desc")) {
            this._desc = map.getProperty("Desc");
        }
    }
}

