/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.tools.appmeta;

import com.sas.meta.SASOMI.ISecurityAdmin;
import com.sas.metadata.logical.batch.BatchDriver2;
import com.sas.metadata.logical.batch.BatchDriverOptions;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdOMRConnection;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.tools.appmeta.AppMetaException;
import com.sas.metadata.tools.appmeta.Application2;
import com.sas.metadata.tools.appmeta.RB;
import com.sas.metadata.tools.appmeta.Role2;
import com.sas.metadata.tools.appmeta.TypeDefinition2;
import com.sas.metadata.tools.appmeta.TypeGroup2;
import com.sas.metadata.tools.appmeta.UserGroup2;
import com.sas.services.ServiceException;
import com.sas.services.information.OMIChildServer;
import com.sas.services.information.OMIServer;
import com.sas.services.information.metadata.FolderInterface;
import com.sas.services.information.metadata.PathUrl;
import com.sas.services.information.metadata.RootFolderInterface;
import com.sas.services.util.UncaughtRuntimeExceptionHandler;
import com.sas.storage.editableproperties.LocalizationUtil2;
import com.sas.storage.editableproperties.PropertyList;
import com.sas.storage.editableproperties.SectionedPropertyList;
import com.sas.storage.editableproperties.SectionedPropertyMap;
import com.sas.text.Message;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.URL;
import java.rmi.RemoteException;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.MissingOptionException;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.ParseException;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public final class ApplicationMetadataUtility2
extends BatchDriver2 {
    public static final int ERROR_APP_ALREADY_EXISTS = 9;
    public static final int ERROR_APP_NOT_FOUND = 10;
    public static final String OPTION_APPLICATIONID = "applicationId";
    public static final String OPTION_APPLICATIONNAME = "applicationName";
    public static final String OPTION_FOLDER = "folder";
    public static final String OPTION_LOCALIZE = "localize";
    public static final String OPTION_LOCPROP = "locprop";
    public static final String OPTION_NOEXECUTE = "noexecute";
    public static final String OPTION_EXTRACT = "extract";
    public static final String XML_NAMESPACE_PREFIX = "http://www.sas.com/xml/schema/namespace/ApplicationMetadata";
    public static final String CURRENT_XML_NAMESPACE = "http://www.sas.com/xml/schema/namespace/ApplicationMetadata-9.4";
    static final String ACTION_CREATE = "Create";
    static final String ACTION_DELETE = "Delete";
    static final String ACTION_UPDATE = "Update";
    private boolean _locprop = false;
    private boolean _localize = false;
    private boolean _noExecute = false;
    private boolean _extract = false;
    private String _applicationId = null;
    private String _applicationName = null;
    private String _folder = null;
    private String _sourceXML = null;
    private InputStream _sourceXMLStream = null;
    private OutputStream _extractXMLStream = null;
    protected Document _sourceDocument = null;
    private Application2 _application = null;
    private Map<String, UserGroup2> _groups = null;
    private Map<String, Role2> _roles = null;
    private TypeGroup2 _rootTypeGroup = null;
    private Level _logLevel = Level.INFO;

    public ApplicationMetadataUtility2() {
        this._logTimestamps = false;
    }

    public void setApplicationId(String id) {
        this._applicationId = id;
    }

    public String getApplicationId() {
        return this._applicationId;
    }

    public void setApplicationName(String name) {
        this._applicationName = name;
    }

    public String getApplicationName() {
        return this._applicationName;
    }

    public void setFolder(String folder) {
        this._folder = folder;
    }

    public String getFolder() {
        return this._folder;
    }

    public boolean isDebug() {
        return this._debug;
    }

    public void setLocalize(boolean localize) {
        this._localize = localize;
    }

    public boolean isLocalize() {
        return this._localize;
    }

    public void setLocprop(boolean locprop) {
        this._locprop = locprop;
    }

    public boolean isLocprop() {
        return this._locprop;
    }

    public void setNoExecute(boolean noexecute) {
        this._noExecute = noexecute;
    }

    public boolean isNoExecute() {
        return this._noExecute;
    }

    public void setExtract(boolean extract) {
        this._extract = extract;
    }

    public boolean isExtract() {
        return this._extract;
    }

    public void setSourceXML(String sourceXML) {
        this._sourceXML = sourceXML;
        this._sourceXMLStream = null;
    }

    public String getSourceXML() {
        return this._sourceXML;
    }

    public void setSourceXMLStream(InputStream sourceXML) {
        this._sourceXML = null;
        this._sourceXMLStream = sourceXML;
    }

    public void setExtractXMLStream(OutputStream stream) {
        this._sourceXML = null;
        this._extractXMLStream = stream;
    }

    OMIServer getOMIServer() throws ServiceException {
        try {
            return (OMIServer)this._session.getUserContext().getAuthServer();
        }
        catch (RemoteException e) {
            throw new UndeclaredThrowableException(e);
        }
    }

    void declareWarning() {
        if (this._rc < 4) {
            this._rc = 4;
        }
    }

    void declareError() {
        if (this._rc < 8) {
            this._rc = 8;
        }
    }

    void declareError(int returnCode) {
        if (this._rc < 8) {
            this._rc = returnCode;
        }
    }

    public int execute() throws Exception {
        this._application = null;
        this._rootTypeGroup = null;
        this._groups = new LinkedHashMap<String, UserGroup2>();
        this._roles = new LinkedHashMap<String, Role2>();
        try {
            this.setInitializeLogicalTypes(false);
            if (this._locprop && !this._extract) {
                this.initializeNoConnection();
                this.logStart();
            } else {
                this.initialize();
                this.logStart();
                this.logConnectionInfo();
            }
            if (this._extract) {
                this.loadFromMetadata();
                this.generateXML();
                if (this._locprop) {
                    this.generateLocProps();
                }
            } else {
                this.loadSourceXML();
                if (this._locprop) {
                    this.generateLocProps();
                } else {
                    if (this._localize) {
                        this.localize();
                    }
                    this.mergeMetadata();
                }
            }
        }
        catch (Exception e) {
            this.logException(e);
        }
        finally {
            this.terminate();
        }
        return this._rc;
    }

    Map<String, Role2> getRoles() {
        return this._roles;
    }

    Map<String, UserGroup2> getGroups() {
        return this._groups;
    }

    @Override
    public List<BatchDriver2.DefaultLoggingContext> getDefaultLoggingContexts() {
        ArrayList<BatchDriver2.DefaultLoggingContext> loggingContexts = new ArrayList();
        loggingContexts = super.getDefaultLoggingContexts();
        if (this._logContextName != null) {
            loggingContexts.add(new BatchDriver2.DefaultLoggingContext(this._logContextName, this._debug ? Level.DEBUG : this.getLogLevel()));
        }
        return loggingContexts;
    }

    public void setLogLevel(Level level) {
        this._logLevel = level;
    }

    public Level getLogLevel() {
        return this._logLevel;
    }

    private void loadSourceXML() throws AppMetaException {
        try {
            if (this._sourceXML != null) {
                this._sourceXMLStream = new FileInputStream(this._sourceXML);
            }
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(true);
            DocumentBuilder docBuilder = dbf.newDocumentBuilder();
            this._sourceDocument = docBuilder.parse(this._sourceXMLStream);
            Element root = this._sourceDocument.getDocumentElement();
            this.validateSourceDocument(root);
            NodeList nodes = root.getChildNodes();
            for (int i = 0; i < nodes.getLength(); ++i) {
                Node node = nodes.item(i);
                if (node.getNodeType() != 1) continue;
                Element element = (Element)node;
                String tagName = element.getTagName();
                if (tagName.equals("Application2")) {
                    this._application = Application2.create(this);
                    this._application.loadFromXML(element);
                    continue;
                }
                if (tagName.equals("Role2")) {
                    Role2 role = Role2.create(element, this);
                    this._roles.put(role.getName(), role);
                    continue;
                }
                if (tagName.equals("UserGroup2")) {
                    UserGroup2 group = UserGroup2.create(element, this);
                    this._groups.put(group.getName(), group);
                    continue;
                }
                if (tagName.equals("TypeGroup2")) {
                    if (this._rootTypeGroup == null) {
                        this._rootTypeGroup = TypeGroup2.createRootTypeGroup(this);
                    }
                    TypeGroup2.create(element, this._rootTypeGroup);
                    continue;
                }
                if (!tagName.equals("TypeDefinition2")) continue;
                if (this._rootTypeGroup == null) {
                    this._rootTypeGroup = TypeGroup2.createRootTypeGroup(this);
                }
                TypeDefinition2.create(element, this._rootTypeGroup);
            }
            if (this._sourceXML != null) {
                this._logger.info(Message.format((ResourceBundle)RB.getResources(), (String)"ApplicationMetadataUtility.LoadedXML.fmt.log", (Object)this._sourceXML));
            } else {
                this._logger.info(RB.getStringResource("ApplicationMetadataUtility.LoadedXMLStream.log"));
            }
            if (this._application != null) {
                String productName = this._application.getProductName();
                if (productName.length() == 0) {
                    productName = this._application.getName();
                }
                this._logger.info(Message.format((ResourceBundle)RB.getResources(), (String)"ApplicationMetadataUtility.Product.fmt.log", (Object)productName));
            }
        }
        catch (ParserConfigurationException e) {
            throw new AppMetaException(RB.getStringResource("ApplicationMetadataUtility.ParseSourceError.txt"), e);
        }
        catch (IOException e) {
            throw new AppMetaException(RB.getStringResource("ApplicationMetadataUtility.SourceXMLError.txt"), e);
        }
        catch (SAXException e) {
            throw new AppMetaException(RB.getStringResource("ApplicationMetadataUtility.ParseSourceError.txt"), e);
        }
        finally {
            if (this._sourceXMLStream != null) {
                try {
                    this._sourceXMLStream.close();
                    this._sourceXMLStream = null;
                }
                catch (IOException iOException) {}
            }
        }
    }

    private void validateSourceDocument(Element root) throws AppMetaException, IOException, SAXException {
        if (System.getProperty("java.vendor", "").startsWith("IBM")) {
            return;
        }
        String xmlns = root.getNamespaceURI();
        String schemaName = null;
        if (xmlns == null || xmlns.length() == 0) {
            schemaName = "appmeta.xsd";
        } else if (xmlns.startsWith(XML_NAMESPACE_PREFIX)) {
            schemaName = "ApplicationMetadata" + xmlns.substring(XML_NAMESPACE_PREFIX.length()) + ".xsd";
        } else {
            throw new AppMetaException(Message.format((ResourceBundle)RB.getResources(), (String)"ApplicationMetadataUtility.InvalidXMLNamespace.fmt.log", (Object)xmlns));
        }
        URL schemaUrl = ApplicationMetadataUtility2.class.getResource(schemaName);
        if (schemaUrl == null) {
            throw new AppMetaException(Message.format((ResourceBundle)RB.getResources(), (String)"ApplicationMetadataUtility.UnsupportedXMLNamespace.fmt.log", (Object)xmlns));
        }
        Schema xmlSchema = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema").newSchema(schemaUrl);
        Validator validator = xmlSchema.newValidator();
        try {
            validator.validate(new DOMSource(this._sourceDocument));
        }
        catch (SAXException e) {
            if (xmlns == null || xmlns.length() == 0) {
                this._logger.info(RB.getStringResource("ApplicationMetadataUtility.MissingXMLSchema.log"));
            }
            throw new AppMetaException(RB.getStringResource("ApplicationMetadataUtility.ParseSourceError.txt"), e);
        }
    }

    private void generateLocProps() throws IOException {
        int extOffset;
        SectionedPropertyList resources = new SectionedPropertyList();
        PropertyList header = new PropertyList();
        header.addComment("Generated by ApplicationMetadataUtility");
        header.addProperty("Created", DateFormat.getDateTimeInstance().format(new Date()));
        resources.addSection("", header);
        if (this._application != null) {
            resources.addSection("Application2", this._application.getLocalizableProperties());
        }
        for (String name : this._roles.keySet()) {
            resources.addSection("Role2: " + name, this._roles.get(name).getLocalizableProperties());
        }
        for (String name : this._groups.keySet()) {
            resources.addSection("UserGroup2: " + name, this._groups.get(name).getLocalizableProperties());
        }
        if (this._rootTypeGroup != null) {
            String sectionName;
            for (TypeGroup2 group : this._rootTypeGroup.getGroups()) {
                sectionName = "TypeGroup2: " + group.getPath();
                resources.addSection(sectionName, group.getLocalizableProperties());
            }
            for (TypeDefinition2 typeDef : this._rootTypeGroup.getDefinitions()) {
                sectionName = "Type: " + typeDef.getTypeName();
                resources.addSection(sectionName, typeDef.getLocalizableProperties());
            }
        }
        String locpropFileName = (extOffset = this._sourceXML.lastIndexOf(46)) <= 0 ? this._sourceXML + ".locprop" : this._sourceXML.substring(0, extOffset) + ".locprop";
        FileWriter locpropFileWriter = new FileWriter(locpropFileName);
        resources.save((Writer)locpropFileWriter);
        ((Writer)locpropFileWriter).close();
        this._logger.info(Message.format((ResourceBundle)RB.getResources(), (String)"ApplicationMetadataUtility.GeneratedLocprop.fmt.log", (Object)locpropFileName));
    }

    private void localize() throws IOException {
        int extOffset = this._sourceXML.lastIndexOf(46);
        String baseFileName = extOffset <= 0 ? this._sourceXML : this._sourceXML.substring(0, extOffset);
        File baseFile = new File(baseFileName);
        Map allProperties = LocalizationUtil2.getMultiLocaleProperties((Logger)this._logger, (File)baseFile);
        Locale defaultLocale = LocalizationUtil2.getDefaultLocale(allProperties.keySet());
        if (defaultLocale != null) {
            this._logger.info(Message.format((ResourceBundle)RB.getResources(), (String)"ApplicationMetadataUtility.DefaultLocale.fmt.log", (Object)defaultLocale.toString()));
        } else {
            this._logger.info(Message.format((ResourceBundle)RB.getResources(), (String)"ApplicationMetadataUtility.NoDefaultLocale.fmt.log", (Object)Locale.getDefault().toString()));
        }
        SectionedPropertyMap defaultLocaleProperties = (SectionedPropertyMap)allProperties.get(defaultLocale);
        if (this._application != null) {
            this._application.beginLocalization();
            if (defaultLocaleProperties != null) {
                if (defaultLocaleProperties.containsSection("Application2")) {
                    this._application.setLocalizableProperties(defaultLocaleProperties.getSection("Application2"));
                } else {
                    this._logger.warn(RB.getStringResource("ApplicationMetadataUtility.MissingApplicationLocProp.log"));
                }
            }
            for (Locale locale : allProperties.keySet()) {
                SectionedPropertyMap localeProperties;
                if (locale == defaultLocale || !(localeProperties = (SectionedPropertyMap)allProperties.get(locale)).containsSection("Application2")) continue;
                this._application.setLocalizableProperties(locale, localeProperties.getSection("Application2"));
            }
            this._application.endLocalization();
        }
        if (defaultLocaleProperties != null) {
            String sectionName;
            for (String name : this._roles.keySet()) {
                sectionName = "Role2: " + name;
                if (defaultLocaleProperties.containsSection(sectionName)) {
                    this._roles.get(name).setLocalizableProperties(defaultLocaleProperties.getSection(sectionName));
                    continue;
                }
                this._logger.warn(Message.format((ResourceBundle)RB.getResources(), (String)"ApplicationMetadataUtility.MissingRoleLocProp.fmt.log", (Object)name));
            }
            for (String name : this._groups.keySet()) {
                sectionName = "UserGroup2: " + name;
                if (defaultLocaleProperties.containsSection(sectionName)) {
                    this._groups.get(name).setLocalizableProperties(defaultLocaleProperties.getSection(sectionName));
                    continue;
                }
                this._logger.warn(Message.format((ResourceBundle)RB.getResources(), (String)"ApplicationMetadataUtility.MissingUserGroupLocProp.fmt.log", (Object)name));
            }
            if (this._rootTypeGroup != null) {
                for (TypeGroup2 group : this._rootTypeGroup.getGroups()) {
                    sectionName = "TypeGroup2: " + group.getPath();
                    if (defaultLocaleProperties.containsSection(sectionName)) {
                        group.setLocalizableProperties(defaultLocaleProperties.getSection(sectionName));
                        continue;
                    }
                    this._logger.warn(Message.format((ResourceBundle)RB.getResources(), (String)"ApplicationMetadataUtility.MissingLocProp.fmt.log", (Object)sectionName));
                }
                for (TypeDefinition2 typeDef : this._rootTypeGroup.getDefinitions()) {
                    sectionName = "Type: " + typeDef.getTypeName();
                    if (defaultLocaleProperties.containsSection(sectionName)) {
                        typeDef.setLocalizableProperties(defaultLocaleProperties.getSection(sectionName));
                        continue;
                    }
                    this._logger.warn(Message.format((ResourceBundle)RB.getResources(), (String)"ApplicationMetadataUtility.MissingLocProp.fmt.log", (Object)sectionName));
                }
            }
        }
    }

    private void mergeMetadata() throws Exception {
        OMIChildServer childServer = (OMIChildServer)this._server.newChild(true);
        MdObjectStore store = childServer.getObjectStore();
        if (this._application != null) {
            if (this._applicationId == null) {
                this._application.createNewApplication((OMIServer)childServer);
            } else {
                this._application.updateExistingApplication((OMIServer)childServer);
            }
        } else if (this._applicationId != null || this._applicationName != null) {
            this._application = Application2.create(this);
            this._application.loadFromMetadata((OMIServer)childServer);
        }
        for (String name : this._groups.keySet()) {
            UserGroup2 group = this._groups.get(name);
            group.mergeToMetadata(store);
            group.addExternalReferences();
        }
        for (String name : this._roles.keySet()) {
            Role2 role = this._roles.get(name);
            role.mergeToMetadata(store);
            role.addExternalReferences();
        }
        if (this._rootTypeGroup != null) {
            this._rootTypeGroup.mergeToMetadata((OMIServer)childServer);
        }
        boolean newCapabilities = this._application != null && this._application.getCapabilityCategories() != null && this._application.getCapabilityCategories().getJomaObject().isNewObject();
        int changed = store.getChangedObjects().size();
        int deleted = store.getDeletedObjects().size();
        if (!this._noExecute) {
            if (changed > 0 || deleted > 0) {
                childServer.flush();
                this._logger.info(Message.format((ResourceBundle)RB.getResources(), (String)"ApplicationMetadataUtility.Updated.fmt.log", (Object)changed));
                if (deleted > 0) {
                    this._logger.info(Message.format((ResourceBundle)RB.getResources(), (String)"ApplicationMetadataUtility.Deleted.fmt.log", (Object)deleted));
                }
            } else {
                this._logger.info(RB.getStringResource("ApplicationMetadataUtility.NoUpdates.log"));
            }
            if (newCapabilities) {
                MdOMRConnection connection = this._factory.getConnection();
                ISecurityAdmin iSecAdmin = connection.MakeISecurityAdminConnection(connection.getCMRHandle());
                this._application.getCapabilityCategories().denyPublicExecute(iSecAdmin);
            }
        } else {
            this._logger.info(Message.format((ResourceBundle)RB.getResources(), (String)"ApplicationMetadataUtility.WouldBeUpdated.fmt.log", (Object)changed, (Object)deleted));
        }
        this.grantCapabilitiesToRoles();
        if (this._application != null && this._applicationId == null) {
            this._applicationId = this._application.getJomaObject().getId();
            this._logger.info("Application2 SoftwareComponent: " + this._applicationId);
        }
        childServer.close();
    }

    private void grantCapabilitiesToRoles() throws MdException, ServiceException {
        ISecurityAdmin iSecAdmin;
        try {
            MdOMRConnection connection = this._factory.getConnection();
            iSecAdmin = connection.MakeISecurityAdminConnection(connection.getCMRHandle());
        }
        catch (RemoteException e) {
            throw new UndeclaredThrowableException(e);
        }
        for (String name : this._roles.keySet()) {
            this._roles.get(name).grantCapabilities(iSecAdmin, this._application);
        }
    }

    void loadFromMetadata() throws AppMetaException, MissingOptionException, MdException, ServiceException, IllegalStateException {
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = dbf.newDocumentBuilder();
            this._sourceDocument = docBuilder.newDocument();
            Element root = this._sourceDocument.createElement("ApplicationMetadata");
            root.setAttribute("xmlns", CURRENT_XML_NAMESPACE);
            this._sourceDocument.appendChild(root);
            this._application = Application2.create(this);
            this._application.loadFromMetadata(this.getOMIServer());
            this._logger.info(Message.format((ResourceBundle)RB.getResources(), (String)"ApplicationMetadataUtility.Product.fmt.log", (Object)this._application.getProductName()));
        }
        catch (ParserConfigurationException e) {
            throw new AppMetaException(RB.getStringResource("ApplicationMetadataUtility.ParseSourceError.txt"), e);
        }
    }

    void generateXML() throws AppMetaException {
        OutputStream stream = null;
        try {
            stream = this._extractXMLStream != null ? this._extractXMLStream : new FileOutputStream(this._sourceXML);
            TransformerFactory factory = TransformerFactory.newInstance();
            Transformer transformer = factory.newTransformer();
            transformer.setOutputProperty("method", "xml");
            transformer.setOutputProperty("omit-xml-declaration", "yes");
            transformer.setOutputProperty("standalone", "no");
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
            DOMSource source = new DOMSource(this._sourceDocument);
            StreamResult result = new StreamResult(stream);
            transformer.transform(source, result);
            if (this._sourceXML != null) {
                this._logger.info(Message.format((ResourceBundle)RB.getResources(), (String)"ApplicationMetadataUtility.CreatedXML.fmt.log", (Object)this._sourceXML));
            } else {
                this._logger.info(RB.getStringResource("ApplicationMetadataUtility.CreatedXMLStream.log"));
            }
        }
        catch (IOException e) {
            throw new AppMetaException(RB.getStringResource("ApplicationMetadataUtility.SourceXMLError.txt"), e);
        }
        catch (TransformerException e) {
            throw new AppMetaException(RB.getStringResource("ApplicationMetadataUtility.SourceXMLError.txt"), e);
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    String getEmbeddedXML(Node node) throws TransformerFactoryConfigurationError, TransformerException {
        Node nodeCopy = node.cloneNode(true);
        this.stripWhitespaceAndNamespace(nodeCopy);
        Transformer transformer = TransformerFactory.newInstance().newTransformer();
        transformer.setOutputProperty("omit-xml-declaration", "yes");
        DOMSource source = new DOMSource(nodeCopy);
        StringWriter writer = new StringWriter();
        StreamResult result = new StreamResult(writer);
        transformer.transform(source, result);
        return writer.toString();
    }

    void stripWhitespaceAndNamespace(Node node) {
        NodeList list;
        Pattern whitespaceOnly = Pattern.compile("\\s*");
        if (node.getNodeType() == 1) {
            node.getOwnerDocument().renameNode(node, "", node.getLocalName());
        }
        if ((list = node.getChildNodes()).getLength() <= 1) {
            return;
        }
        for (int i = 0; i < list.getLength(); ++i) {
            Node child = list.item(i);
            if (child.getNodeType() == 3) {
                Matcher m = whitespaceOnly.matcher(child.getTextContent());
                if (!m.matches()) continue;
                node.removeChild(child);
                --i;
                continue;
            }
            if (child.getNodeType() != 1) continue;
            this.stripWhitespaceAndNamespace(child);
        }
    }

    FolderInterface makeFolder(OMIServer server, String folderPath) throws ServiceException {
        FolderInterface folder;
        try {
            RootFolderInterface rootFolder = server.getRootFolder();
            PathUrl folderUrl = new PathUrl(rootFolder.getPathUrl(), folderPath);
            folderUrl.setType("Folder");
            folder = (FolderInterface)server.getObjectByPath(folderUrl);
            if (folder != null) {
                return folder;
            }
            Pattern pattern = Pattern.compile("^(/(.*?/)*)([^/]+)/?$");
            Matcher matcher = pattern.matcher(folderPath);
            if (!matcher.matches()) {
                throw new IllegalArgumentException(Message.format((ResourceBundle)RB.getResources(), (String)"ApplicationMetadataUtility.InvalidFolderPath.fmt.log", (Object)folderPath));
            }
            String parentFolderPath = matcher.group(1);
            String folderName = matcher.group(3);
            PathUrl parentFolderUrl = new PathUrl(rootFolder.getPathUrl(), parentFolderPath);
            FolderInterface parentFolder = (FolderInterface)server.getObjectByPath(parentFolderUrl);
            if (parentFolder == null) {
                parentFolder = this.makeFolder(server, parentFolderPath);
            }
            if ((folder = parentFolder.makeSubfolder(folderName)) != null) {
                this._logger.info(Message.format((ResourceBundle)RB.getResources(), (String)"ApplicationMetadataUtility.FolderCreated.fmt.log", (Object)folderPath));
            }
        }
        catch (RemoteException e) {
            throw new UndeclaredThrowableException(e);
        }
        return folder;
    }

    String[] getNonblankArgs() {
        int nargs = 0;
        String[] args = this._commandLine.getArgs();
        for (int i = 0; i < args.length; ++i) {
            if (args[i] == null || args[i].length() <= 0) continue;
            ++nargs;
        }
        String[] newArgs = new String[nargs];
        nargs = 0;
        for (int i = 0; i < args.length; ++i) {
            if (args[i] == null || args[i].length() <= 0) continue;
            newArgs[nargs++] = args[i];
        }
        return newArgs;
    }

    @Override
    protected void parse(String[] args) throws ParseException, MissingOptionException {
        String[] files;
        this._options = new Options();
        super.parse(args);
        if (this._help) {
            return;
        }
        if (this._commandLine.hasOption(OPTION_APPLICATIONID)) {
            this.setApplicationId(this._commandLine.getOptionValue(OPTION_APPLICATIONID));
            if (!Pattern.matches("\\p{Alnum}{8}\\.\\p{Alnum}{8}", this._applicationId)) {
                throw new ParseException(Message.format((ResourceBundle)RB.getResources(), (String)"ApplicationMetadataUtility.InvalidApplicationId.fmt.txt", (Object)this._applicationId));
            }
        }
        if (this._commandLine.hasOption(OPTION_APPLICATIONNAME)) {
            this.setApplicationName(this._commandLine.getOptionValue(OPTION_APPLICATIONNAME));
        }
        if (this._commandLine.hasOption(OPTION_FOLDER)) {
            this.setFolder(this._commandLine.getOptionValue(OPTION_FOLDER));
        }
        this.setLocalize(this._commandLine.hasOption(OPTION_LOCALIZE));
        this.setLocprop(this._commandLine.hasOption(OPTION_LOCPROP));
        this.setNoExecute(this._commandLine.hasOption(OPTION_NOEXECUTE));
        this.setExtract(this._commandLine.hasOption(OPTION_EXTRACT));
        if (this._locprop) {
            if (this._localize) {
                throw new ParseException(Message.format((ResourceBundle)RB.getResources(), (String)"ApplicationMetadataUtility.InvalidOptionCombo.fmt.txt", (Object)OPTION_LOCPROP, (Object)OPTION_LOCALIZE));
            }
            if (this._applicationId != null) {
                throw new ParseException(Message.format((ResourceBundle)RB.getResources(), (String)"ApplicationMetadataUtility.InvalidOptionCombo.fmt.txt", (Object)OPTION_LOCPROP, (Object)OPTION_APPLICATIONID));
            }
        }
        if (this._extract) {
            if (this._localize) {
                throw new ParseException(Message.format((ResourceBundle)RB.getResources(), (String)"ApplicationMetadataUtility.InvalidOptionCombo.fmt.txt", (Object)OPTION_EXTRACT, (Object)OPTION_LOCALIZE));
            }
            if (this._noExecute) {
                throw new ParseException(Message.format((ResourceBundle)RB.getResources(), (String)"ApplicationMetadataUtility.InvalidOptionCombo.fmt.txt", (Object)OPTION_EXTRACT, (Object)OPTION_NOEXECUTE));
            }
        }
        if ((files = this.getNonblankArgs()) == null || files.length == 0) {
            throw new ParseException(RB.getStringResource("ApplicationMetadataUtility.NoSourceFile.txt"));
        }
        if (files.length > 1) {
            throw new ParseException(RB.getStringResource("ApplicationMetadataUtility.TooManySourceFiles.txt"));
        }
        this.setSourceXML(files[0]);
    }

    public static void main(String[] args) {
        ApplicationMetadataUtility2 util = new ApplicationMetadataUtility2();
        Thread.setDefaultUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)new UncaughtRuntimeExceptionHandler(true, 8));
        try {
            util.parse(args);
            if (util._help) {
                HelpFormatter help = new HelpFormatter();
                help.printHelp(80, ApplicationMetadataUtility2.getUsage(help), RB.getStringResource("ApplicationMetadataUtility.Options.txt"), (org.apache.commons.cli.Options)util._options, null);
                return;
            }
            util.execute();
        }
        catch (Exception e) {
            util.logException(e);
        }
        util.logCompletion();
        System.exit(util.getReturnCode());
    }

    private static String getUsage(HelpFormatter help) {
        return RB.getStringResource("ApplicationMetadataUtility.HelpUsage.txt");
    }

    public void resetForTest() {
        this._rc = 0;
        this._locprop = false;
        this._localize = false;
        this._noExecute = false;
        this._extract = false;
        this._applicationId = null;
        this._applicationName = null;
        this._sourceXML = null;
        this._sourceXMLStream = null;
        this._extractXMLStream = null;
        this._sourceDocument = null;
        this._application = null;
        this._groups = null;
        this._roles = null;
        this._rootTypeGroup = null;
    }

    protected class Options
    extends BatchDriverOptions {
        private static final long serialVersionUID = 1L;

        public Options() {
            Option option = new Option(ApplicationMetadataUtility2.OPTION_APPLICATIONID, true, RB.getStringResource("ApplicationMetadataUtility.ApplicationId.Desc.txt"));
            option.setArgName(RB.getStringResource("ApplicationMetadataUtility.ApplicationId.ArgName.txt"));
            this.addOption(option);
            option = new Option(ApplicationMetadataUtility2.OPTION_APPLICATIONNAME, true, RB.getStringResource("ApplicationMetadataUtility.ApplicationName.Desc.txt"));
            option.setArgName(RB.getStringResource("ApplicationMetadataUtility.ApplicationName.ArgName.txt"));
            this.addOption(option);
            option = new Option(ApplicationMetadataUtility2.OPTION_FOLDER, true, RB.getStringResource("ApplicationMetadataUtility.Folder.Desc.txt"));
            option.setArgName(RB.getStringResource("ApplicationMetadataUtility.Folder.ArgName.txt"));
            this.addOption(option);
            option = new Option(ApplicationMetadataUtility2.OPTION_LOCALIZE, RB.getStringResource("ApplicationMetadataUtility.Localize.Desc.txt"));
            this.addOption(option);
            option = new Option(ApplicationMetadataUtility2.OPTION_LOCPROP, RB.getStringResource("ApplicationMetadataUtility.Locprop.Desc.txt"));
            this.addOption(option);
            option = new Option(ApplicationMetadataUtility2.OPTION_NOEXECUTE, RB.getStringResource("ApplicationMetadataUtility.Noexecute.Desc.txt"));
            this.addOption(option);
            option = new Option(ApplicationMetadataUtility2.OPTION_EXTRACT, RB.getStringResource("ApplicationMetadataUtility.Extract.Desc.txt"));
            this.addOption(option);
        }
    }
}

