/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.logical.visuals.search;

import com.sas.metadata.logical.visuals.search.RB;
import com.sas.services.information.search.ResultDetails;
import com.sas.services.information.search.SortOrder;
import com.sas.swing.visuals.ComboBox;
import com.sas.util.ValueItem;
import com.sas.workspace.WAPanel;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;

public class ResultsConfigurationComponent
extends WAPanel {
    private static final long serialVersionUID = 1L;
    protected JPanel _resultPanel;
    protected JLabel _resultLimitLabel;
    protected ComboBox _resultLimitOptions;
    protected DefaultComboBoxModel limitModel;
    protected ResultDetails.ResultLimit _resultLimit = ResultDetails.ResultLimit.UNLIMITED;
    protected JLabel _sortOrderLabel;
    protected ComboBox _sortOrder;
    protected DefaultComboBoxModel sortModel;
    protected SortOrder[] _order = SortOrder.getDefaultOrder();

    public ResultsConfigurationComponent() {
        this.initialize();
        this.layoutWidgets();
    }

    public ResultsConfigurationComponent(ResultDetails.ResultLimit resultLimit, SortOrder[] order) {
        this._resultLimit = resultLimit;
        this._order = order;
        this.initialize();
        this.layoutWidgets();
    }

    protected void initialize() {
        TitledBorder resultsBorder = BorderFactory.createTitledBorder(RB.getStringResource("ResultsConfigurationComponent.ResultsBorder.txt"));
        this.setBorder(resultsBorder);
        this._resultLimitLabel = new JLabel(RB.getStringResource("ResultsConfigurationComponent.LimitLabel.txt"));
        this._resultLimitOptions = new ComboBox();
        this.limitModel = new DefaultComboBoxModel<ResultDetails.ResultLimit>(ResultDetails.ResultLimit.values());
        this._resultLimitOptions.setModel((ComboBoxModel)this.limitModel);
        this._resultLimitOptions.setToolTipText(RB.getStringResource("ResultsConfigurationComponent.ResultLimit.Tooltip.txt"));
        this._resultLimitLabel.setLabelFor((Component)this._resultLimitOptions);
        this.setLimitIndexValue(this._resultLimit);
        this._sortOrderLabel = new JLabel(RB.getStringResource("ResultsConfigurationComponent.SortLabel.txt"));
        this._sortOrder = new ComboBox();
        this.sortModel = new DefaultComboBoxModel();
        this.createSortOptions();
        this._sortOrder.setModel((ComboBoxModel)this.sortModel);
        this._sortOrder.setToolTipText(RB.getStringResource("ResultsConfigurationComponent.SortOptions.Tooltip.txt"));
        this._sortOrderLabel.setLabelFor((Component)this._sortOrder);
        this.setOrderIndexValue(this._order);
    }

    protected void layoutWidgets() {
        super.layoutWidgets();
        this.setLayout(new GridBagLayout());
        this.add(this._resultLimitLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 5, 0, 0), 0, 0));
        this.add((Component)this._resultLimitOptions, new GridBagConstraints(1, 0, -1, 1, 1.0, 0.0, 18, 1, new Insets(5, 5, 0, 5), 0, 0));
        this.add(this._sortOrderLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(10, 5, 10, 0), 0, 0));
        this.add((Component)this._sortOrder, new GridBagConstraints(1, 1, -1, 1, 1.0, 1.0, 18, 1, new Insets(10, 5, 10, 5), 0, 0));
    }

    private void setLimitIndexValue(ResultDetails.ResultLimit limit) {
        this._resultLimitOptions.setSelectedIndex(this.limitModel.getIndexOf(limit));
    }

    private void createSortOptions() {
        ValueItem nameSort = new ValueItem((Object)SortOrder.SORT_BY_NAME, (Object)new SortOrder[]{SortOrder.NAME, SortOrder.TYPE});
        this.sortModel.addElement(nameSort);
        ValueItem typeSort = new ValueItem((Object)SortOrder.SORT_BY_TYPE, (Object)new SortOrder[]{SortOrder.TYPE, SortOrder.NAME});
        this.sortModel.addElement(typeSort);
        ValueItem descSort = new ValueItem((Object)SortOrder.SORT_BY_DESC, (Object)new SortOrder[]{SortOrder.DESCRIPTION, SortOrder.NAME, SortOrder.TYPE});
        this.sortModel.addElement(descSort);
        ValueItem crDateSort = new ValueItem((Object)SortOrder.SORT_BY_CREATEDATE, (Object)new SortOrder[]{SortOrder.CREATED_DATE, SortOrder.NAME, SortOrder.TYPE});
        this.sortModel.addElement(crDateSort);
        ValueItem mdDateSort = new ValueItem((Object)SortOrder.SORT_BY_MODIFIEDDATE, (Object)new SortOrder[]{SortOrder.MODIFIED_DATE, SortOrder.NAME, SortOrder.TYPE});
        this.sortModel.addElement(mdDateSort);
    }

    private void setOrderIndexValue(SortOrder[] order) {
        if (order == null) {
            return;
        }
        switch (order[0]) {
            case NAME: {
                this._sortOrder.setSelectedIndex(0);
                break;
            }
            case TYPE: {
                this._sortOrder.setSelectedIndex(1);
                break;
            }
            case DESCRIPTION: {
                this._sortOrder.setSelectedIndex(2);
                break;
            }
            case CREATED_DATE: {
                this._sortOrder.setSelectedIndex(3);
                break;
            }
            case MODIFIED_DATE: {
                this._sortOrder.setSelectedIndex(4);
            }
        }
    }

    public void resetValues() {
        this.setLimitIndexValue(this._resultLimit);
        this.setOrderIndexValue(this._order);
    }

    public SortOrder[] getSortOrder() {
        Object obj = this._sortOrder.getSelectedItem();
        ValueItem item = (ValueItem)obj;
        return (SortOrder[])item.getValue();
    }

    public ResultDetails.ResultLimit getResultLimit() {
        Object limitObj = this._resultLimitOptions.getSelectedItem();
        return (ResultDetails.ResultLimit)limitObj;
    }

    public void setPreviousValues(ResultDetails.ResultLimit resultLimit, SortOrder[] order) {
        if (resultLimit != null) {
            this.setLimitIndexValue(resultLimit);
        } else {
            this.setLimitIndexValue(this._resultLimit);
        }
        if (order != null) {
            this.setOrderIndexValue(order);
        } else {
            this.setOrderIndexValue(this._order);
        }
    }
}

