/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.logical.visuals.search;

import com.sas.metadata.logical.Factory;
import com.sas.metadata.logical.visuals.search.AbstractFilterComponent;
import com.sas.metadata.logical.visuals.search.RB;
import com.sas.services.ServiceException;
import com.sas.services.information.MetadataServerInterface;
import com.sas.services.information.ServerInterface;
import com.sas.services.information.publicobject.ResponsibilitiesModel;
import com.sas.services.information.search.ResponsibilitiesFilter;
import com.sas.services.information.search.Search;
import com.sas.services.information.search.SearchFilter;
import com.sas.swing.visuals.ComboBox;
import com.sas.swing.visuals.util.Util;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.rmi.RemoteException;
import java.util.List;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JLabel;

public class ResponsibilitiesFilterComponent
extends AbstractFilterComponent {
    private static final long serialVersionUID = 1L;
    protected JLabel _rpPartyNameLabel;
    protected ComboBox _rpNames;
    protected DefaultComboBoxModel _rpNameModel;
    protected JLabel _rpPartyRoleLabel;
    protected ComboBox _rpRoles;
    protected DefaultComboBoxModel _rpRoleModel;
    protected String _rpName = null;
    protected String _rpRole = null;
    protected ResponsibilitiesFilter _rFilter = null;

    @Override
    protected void initialize() {
        super.initialize();
        this._rpNames = new ComboBox();
        this._rpPartyNameLabel = Util.createLabelForComponent((Component)this._rpNames, (String)RB.getStringResource("ResponsibilitiesFilterComponent.NameLabel.txt"));
        this._rpNameModel = new DefaultComboBoxModel();
        this._rpRoles = new ComboBox();
        this._rpPartyRoleLabel = Util.createLabelForComponent((Component)this._rpRoles, (String)RB.getStringResource("ResponsibilitiesFilterComponent.RoleLabel.txt"));
        this._rpRoleModel = new DefaultComboBoxModel();
    }

    @Override
    protected void layoutWidgets() {
        super.layoutWidgets();
        this.setLayout(new GridBagLayout());
        this.add((Component)this._rpPartyNameLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 5, 0, 0), 0, 0));
        this.add((Component)this._rpNames, new GridBagConstraints(1, 0, -1, 1, 1.0, 1.0, 18, 1, new Insets(5, 5, 0, 5), 0, 0));
        this.add((Component)this._rpPartyRoleLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(10, 5, 10, 0), 0, 0));
        this.add((Component)this._rpRoles, new GridBagConstraints(1, 1, -1, 1, 1.0, 1.0, 18, 1, new Insets(10, 5, 10, 5), 0, 0));
    }

    @Override
    public String getLabel() {
        return RB.getStringResource("ResponsibilitiesFilterComponent.Label.txt");
    }

    @Override
    public SearchFilter createFilter() throws ServiceException, RemoteException {
        String name = ResponsibilitiesModel.getRoleForLabel((String)((String)this._rpNames.getSelectedItem()));
        String role = ResponsibilitiesModel.getRoleForLabel((String)((String)this._rpRoles.getSelectedItem()));
        if (name != null && name.length() > 0) {
            this._rFilter = new ResponsibilitiesFilter(name, role);
            return this._rFilter;
        }
        if (role != null && role.length() > 0) {
            throw new ServiceException(RB.getStringResource("ResponsibilitiesFilterComponent.NoUserName.txt"));
        }
        this._rpRoles.setSelectedIndex(-1);
        this._rpNames.setSelectedIndex(-1);
        this._rFilter = null;
        return null;
    }

    @Override
    public void loadInitialData() throws ServiceException, RemoteException {
        this.populateUserNamesandRoles();
        this._rpNames.setModel((ComboBoxModel)this._rpNameModel);
        this._rpPartyNameLabel.setLabelFor((Component)this._rpNames);
        if (this._rpName != null) {
            this._rpNames.setSelectedIndex(this.getSelectedIndex(this._rpNameModel, this._rpName));
        } else {
            this._rpNames.setSelectedIndex(-1);
        }
        this._rpRoles.setModel((ComboBoxModel)this._rpRoleModel);
        this._rpPartyRoleLabel.setLabelFor((Component)this._rpRoles);
        if (this._rpRole != null) {
            this._rpRoles.setSelectedIndex(this.getSelectedIndex(this._rpRoleModel, this._rpRole));
        } else {
            this._rpRoles.setSelectedIndex(-1);
        }
    }

    private void populateUserNamesandRoles() throws ServiceException, RemoteException {
        MetadataServerInterface server = Factory.getInstance().getMetadataServerInterface();
        if (server == null) {
            return;
        }
        if (this._rpNameModel.getSize() != 0) {
            this._rpNameModel.removeAllElements();
        }
        this._rpNameModel.addElement("");
        List names = ResponsibilitiesModel.getUserNames((ServerInterface)server);
        for (String name : names) {
            this._rpNameModel.addElement(name);
        }
        if (this._rpRoleModel.getSize() != 0) {
            this._rpRoleModel.removeAllElements();
        }
        this._rpRoleModel.addElement("");
        String[] roles = ResponsibilitiesModel.getRoleLabels();
        for (int index = 0; index < roles.length; ++index) {
            this._rpRoleModel.addElement(roles[index]);
        }
    }

    @Override
    public void refreshData() throws ServiceException, RemoteException {
        this.populateUserNamesandRoles();
        if (this._rFilter != null) {
            this.setPreviousValues((SearchFilter)this._rFilter);
        }
    }

    @Override
    public void resetValues() {
        this._rpRoles.setSelectedIndex(-1);
        this._rpNames.setSelectedIndex(-1);
        this._rFilter = null;
    }

    @Override
    public void setPreviousValues(SearchFilter filter) throws ServiceException, RemoteException {
        if (filter instanceof ResponsibilitiesFilter) {
            String userName = ResponsibilitiesModel.getLabelForRole((String)((ResponsibilitiesFilter)filter).getReponsiblePartyName());
            String role = ResponsibilitiesModel.getLabelForRole((String)((ResponsibilitiesFilter)filter).getReponsiblePartyRole());
            int nameIndex = -1;
            if (userName == null || userName.length() == 0) {
                this._rpNames.setSelectedIndex(nameIndex);
            } else {
                nameIndex = this._rpNameModel.getIndexOf(userName);
                this._rpNames.setSelectedIndex(nameIndex);
            }
            if (role == null || role.length() == 0) {
                this._rpRoles.setSelectedIndex(-1);
            } else if (nameIndex == -1) {
                this._rpRoles.setSelectedIndex(-1);
            } else {
                int index = this._rpRoleModel.getIndexOf(role);
                this._rpRoles.setSelectedIndex(index);
            }
            if (this._rFilter == null && userName != null) {
                this._rFilter = new ResponsibilitiesFilter(userName, role);
            }
        } else {
            this.resetValues();
        }
    }

    private int getSelectedIndex(DefaultComboBoxModel dataModel, String item) {
        String sObject = item;
        int c = dataModel.getSize();
        for (int i = 0; i < c; ++i) {
            Object obj = dataModel.getElementAt(i);
            if (obj == null || !obj.equals(sObject)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public void setPreviousValues(Search search) throws ServiceException, RemoteException {
        List filters = search.getFilters();
        if (filters == null) {
            return;
        }
        for (SearchFilter filter : filters) {
            if (!(filter instanceof ResponsibilitiesFilter)) continue;
            this.setPreviousValues(filter);
            break;
        }
    }

    @Override
    public void setEditable(boolean bEditable) {
        if (this._rpRoles != null) {
            this._rpRoles.setEnabled(bEditable);
        }
        if (this._rpNames != null) {
            this._rpNames.setEnabled(bEditable);
        }
    }
}

