/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.logical.visuals.search;

import com.sas.metadata.logical.UtilPlatformServices;
import com.sas.metadata.logical.visuals.search.AbstractFilterComponent;
import com.sas.metadata.logical.visuals.search.RB;
import com.sas.metadata.remote.Root;
import com.sas.services.ServiceException;
import com.sas.services.information.ServerInterface;
import com.sas.services.information.metadata.FolderInterface;
import com.sas.services.information.metadata.PathUrl;
import com.sas.services.information.search.Search;
import com.sas.services.information.search.SearchFilter;
import com.sas.swing.visuals.UnderlineIcon;
import com.sas.swing.visuals.util.Util;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WATextField;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsAbstractAction;
import com.sas.workspace.metadata.WsMetadataUtil;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.rmi.RemoteException;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.UIManager;

public class FolderScopeComponent
extends AbstractFilterComponent {
    private static final long serialVersionUID = 1L;
    protected JLabel _folderLabel;
    protected WATextField _folderTextField;
    protected JButton _folderButton;
    protected JButton _clearTextButton;
    protected JCheckBox _recursiveFolderSearchCheckBox;
    protected PathUrl _selectedPathUrl = null;
    protected boolean m_bEditable = true;
    private ServerInterface _server;

    @Override
    protected void initialize() {
        super.initialize();
        Font labelFont = UIManager.getFont("Label.font");
        this._folderLabel = new JLabel();
        Util.configureMnemonicForLabel((JLabel)this._folderLabel, (String)RB.getStringResource("FolderScopeComponent.FolderFieldLabel.txt"));
        this._folderTextField = new WATextField();
        this._folderTextField.setToolTipText(RB.getStringResource("FolderScopeComponent.FolderField.tooltip.txt"));
        this._folderLabel.setLabelFor((Component)this._folderTextField);
        this._folderTextField.setEditable(false);
        this._folderTextField.setBehavior(2);
        this._folderTextField.setFont(labelFont);
        this._recursiveFolderSearchCheckBox = new JCheckBox();
        this._recursiveFolderSearchCheckBox.setSelected(true);
        this._recursiveFolderSearchCheckBox.setEnabled(false);
        Util.configureMnemonicForButton((AbstractButton)this._recursiveFolderSearchCheckBox, (String)RB.getStringResource("FolderScopeComponent.RecursiveSearch.txt"));
        this._recursiveFolderSearchCheckBox.setToolTipText(RB.getStringResource("FolderScopeComponent.RecursiveSearch.Tooltip.txt"));
        this._folderButton = new JButton();
        Util.configureMnemonicForButton((AbstractButton)this._folderButton, (String)RB.getStringResource("FolderScopeComponent.FolderBrowse.txt"));
        this._folderButton.setToolTipText(RB.getStringResource("FolderScopeComponent.FolderBrowse.tooltip.txt"));
        this._folderButton.setBorderPainted(true);
        this._folderButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    Root folderTree;
                    if (FolderScopeComponent.this._server == null) {
                        FolderScopeComponent.this._server = (ServerInterface)Workspace.getWorkspace().getConnectionManager().getMetadataServer();
                    }
                    String startPath = FolderScopeComponent.this._server.getRootFolder().getPathUrl().getDisplayPath();
                    if (FolderScopeComponent.this._selectedPathUrl != null) {
                        startPath = FolderScopeComponent.this._selectedPathUrl.getDisplayPath();
                    }
                    if ((folderTree = WsMetadataUtil.promptForFolder((String)startPath, (boolean)true)) != null) {
                        FolderInterface selectedFolder = (FolderInterface)UtilPlatformServices.getSmartObject(folderTree);
                        FolderScopeComponent.this._selectedPathUrl = selectedFolder.getPathUrl();
                        FolderScopeComponent.this._folderTextField.setText(FolderScopeComponent.this._selectedPathUrl.getDisplayPath());
                        FolderScopeComponent.this._recursiveFolderSearchCheckBox.setEnabled(true);
                        FolderScopeComponent.this.firePropertyChange("scopeToFolder", 0, 1);
                    }
                }
                catch (Exception ex) {
                    MessageUtil.displayMessage((String)ex.getLocalizedMessage(), (int)0);
                }
            }
        });
        this._clearTextButton = this.createClearButton(new ClearTextAction());
    }

    @Override
    protected void layoutWidgets() {
        super.layoutWidgets();
        this.setLayout(new GridBagLayout());
        this.add((Component)this._folderLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 1, new Insets(0, 5, 0, 0), 0, 0));
        this.add((Component)this._clearTextButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 12, 0, new Insets(0, 0, 0, 10), 0, 0));
        this.add((Component)this._folderTextField, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 18, 2, new Insets(5, 5, 0, 0), 0, 0));
        this.add((Component)this._folderButton, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(3, 5, 0, 5), 0, 0));
        this.add((Component)this._recursiveFolderSearchCheckBox, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 18, 1, new Insets(5, 5, 5, 5), 0, 0));
    }

    public JButton createClearButton(WsAbstractAction action) {
        JButton clearButton = new JButton();
        Util.configureMnemonicForButton((AbstractButton)clearButton, (String)RB.getStringResource("Common.Clear.txt"));
        clearButton.setRolloverIcon((Icon)new UnderlineIcon(true));
        clearButton.setIcon((Icon)new UnderlineIcon(false));
        clearButton.setMargin(new Insets(0, 0, 0, 0));
        clearButton.setBorderPainted(false);
        clearButton.setContentAreaFilled(false);
        clearButton.setVerticalAlignment(1);
        clearButton.setForeground(SystemColor.blue);
        clearButton.setToolTipText(RB.getStringResource("FolderScopeComponent.Clear.Tooltip.txt"));
        clearButton.setFocusable(true);
        clearButton.addActionListener((ActionListener)action);
        return clearButton;
    }

    @Override
    public void resetValues() {
        this._selectedPathUrl = null;
        this._folderTextField.setText("");
        this._recursiveFolderSearchCheckBox.setSelected(true);
        this._recursiveFolderSearchCheckBox.setEnabled(false);
        this.firePropertyChange("scopeToFolder", 1, 0);
    }

    public PathUrl getSelectedPathUrl() {
        return this._selectedPathUrl;
    }

    public boolean getRecursiveFlag() {
        return this._recursiveFolderSearchCheckBox.isSelected();
    }

    @Override
    public SearchFilter createFilter() throws ServiceException, RemoteException {
        return null;
    }

    @Override
    public String getLabel() {
        return RB.getStringResource("FolderScopeComponent.FolderBorder.txt");
    }

    @Override
    public void loadInitialData() throws ServiceException, RemoteException {
    }

    @Override
    public void addToSearch(Search search) throws RemoteException, ServiceException {
        PathUrl url = this._selectedPathUrl != null ? this._selectedPathUrl : null;
        search.setFolderScope(url, this.getRecursiveFlag());
    }

    @Override
    public void setPreviousValues(SearchFilter filter) throws ServiceException, RemoteException {
        throw new UnsupportedOperationException();
    }

    public void setPreviousValues(PathUrl folderPathUrl, boolean recurse) throws ServiceException, RemoteException {
        FolderInterface folder = null;
        if (folderPathUrl != null) {
            if (this._server == null) {
                this._server = Workspace.getWorkspace().getConnectionManager().getMetadataServer();
            }
            folder = (FolderInterface)this._server.getObjectByPath(folderPathUrl);
        }
        if (folder != null) {
            this._selectedPathUrl = folderPathUrl;
            this._folderTextField.setText(this._selectedPathUrl.getDisplayPath());
            this._recursiveFolderSearchCheckBox.setSelected(recurse);
            if (this.m_bEditable) {
                this._recursiveFolderSearchCheckBox.setEnabled(true);
            }
            this.firePropertyChange("scopeToFolder", 0, 1);
        } else {
            this.resetValues();
        }
    }

    @Override
    public void setPreviousValues(Search search) throws ServiceException, RemoteException {
        PathUrl url = search.getFolderScope();
        this.setPreviousValues(url, search.isFolderSearchRecursive());
    }

    @Override
    public void setEditable(boolean bEditable) {
        this.m_bEditable = bEditable;
        if (!bEditable && this._recursiveFolderSearchCheckBox != null) {
            this._recursiveFolderSearchCheckBox.setEnabled(bEditable);
        }
        if (this._folderLabel != null) {
            this._folderLabel.setEnabled(bEditable);
        }
        if (this._folderButton != null) {
            this._folderButton.setEnabled(bEditable);
        }
        if (this._clearTextButton != null) {
            this._clearTextButton.setEnabled(bEditable);
        }
    }

    class ClearTextAction
    extends WsAbstractAction {
        private static final long serialVersionUID = 1L;

        ClearTextAction() {
        }

        public void actionPerformed(ActionEvent e) {
            FolderScopeComponent.this._selectedPathUrl = null;
            FolderScopeComponent.this.resetValues();
        }
    }
}

