/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.logical.visuals.search;

import com.sas.metadata.logical.DateParser;
import com.sas.metadata.logical.visuals.search.AbstractFilterComponent;
import com.sas.metadata.logical.visuals.search.RB;
import com.sas.services.ServiceException;
import com.sas.services.information.search.DateFilter;
import com.sas.services.information.search.Search;
import com.sas.services.information.search.SearchFilter;
import com.sas.swing.visuals.DatePicker;
import com.sas.swing.visuals.DateRangeEditor;
import com.sas.swing.visuals.util.LayoutConstants;
import com.sas.swing.visuals.util.Util;
import com.sas.util.DatePeriod;
import com.sas.util.DateTypes;
import com.sas.util.ValueItem;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import javax.swing.AbstractButton;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class DateFilterComponent
extends AbstractFilterComponent
implements ActionListener {
    private static final long serialVersionUID = 1L;
    protected JRadioButton _createdButton;
    protected JRadioButton _modifiedButton;
    protected DateRangeEditor _dateEditor;
    private boolean _searching = false;
    private boolean _enabled = true;

    public DateFilterComponent() {
    }

    public DateFilterComponent(boolean searching) {
        this();
        this._searching = searching;
    }

    @Override
    protected void initialize() {
        super.initialize();
        this._createdButton = new JRadioButton();
        this._modifiedButton = new JRadioButton();
        this._modifiedButton.setSelected(true);
        Util.configureMnemonicForButton((AbstractButton)this._createdButton, (String)RB.getStringResource("DateFilterComponent.CreatedDate.txt"));
        this._createdButton.setToolTipText(RB.getStringResource("DateFilterComponent.CreatedButton.tooltip.txt"));
        Util.configureMnemonicForButton((AbstractButton)this._modifiedButton, (String)RB.getStringResource("DateFilterComponent.ModifiedDate.txt"));
        this._modifiedButton.setToolTipText(RB.getStringResource("DateFilterComponent.ModifiedButton.tooltip.txt"));
        ButtonGroup group = new ButtonGroup();
        group.add(this._createdButton);
        group.add(this._modifiedButton);
        this._dateEditor = new DateRangeEditor(DateTypes.DATE, true, RB.getStringResource("DateFilterComponent.BeginRange.txt"), RB.getStringResource("DateFilterComponent.EndRange.txt"), false, Locale.getDefault());
        this._dateEditor.setNullAllowed(true);
        Component[] comp = this._dateEditor.getComponents();
        for (int i = 0; i < comp.length; ++i) {
            Component c = comp[i];
            if (!(c instanceof JComboBox)) continue;
            JComboBox rangeCombo = (JComboBox)c;
            rangeCombo.addActionListener(this);
            break;
        }
    }

    @Override
    protected void layoutWidgets() {
        super.layoutWidgets();
        this.setLayout(new GridBagLayout());
        JPanel dateButtonPanel = new JPanel();
        dateButtonPanel.setLayout(new BoxLayout(dateButtonPanel, 0));
        dateButtonPanel.add(this._createdButton);
        dateButtonPanel.add(this._modifiedButton);
        this.setLayout(new GridBagLayout());
        this.add((Component)dateButtonPanel, new GridBagConstraints(0, 0, -1, 1, 1.0, 1.0, 18, 1, LayoutConstants.EMPTY_INSETS, 0, 0));
        this.add((Component)this._dateEditor, new GridBagConstraints(0, 1, -1, 1, 1.0, 1.0, 18, 1, new Insets(5, 5, 5, 5), 0, 0));
    }

    @Override
    public String getLabel() {
        return RB.getStringResource("DateFilterComponent.Label.txt");
    }

    @Override
    public void loadInitialData() throws ServiceException, RemoteException {
        DateParser parser = DateParser.getInstance();
        ArrayList<ValueItem> rangeOptions = new ArrayList<ValueItem>(parser.getRangeOptions());
        if (this._searching) {
            ValueItem blankDate = new ValueItem();
            rangeOptions.add(0, blankDate);
        }
        this._dateEditor.setRangeTypeOptions(rangeOptions);
        DatePicker minEditor = (DatePicker)this._dateEditor.getMinEditor();
        minEditor.setRelativeOptions(parser.getRelativeFromDateOptions());
        DatePicker maxEditor = (DatePicker)this._dateEditor.getMaxEditor();
        maxEditor.setRelativeOptions(parser.getRelativeToDateOptions());
        minEditor.setEnabled(this.isEnabled());
        maxEditor.setEnabled(this.isEnabled());
    }

    @Override
    public void setPreviousValues(SearchFilter filter) throws ServiceException, RemoteException {
        if (filter instanceof DateFilter) {
            DateFilter dateFilter = (DateFilter)filter;
            if (dateFilter.getType() == DateFilter.DateType.CREATED_DATE) {
                this._createdButton.setSelected(true);
            }
            DatePeriod beginDate = dateFilter.getBeginDatePeriod();
            DatePeriod endDate = dateFilter.getEndDatePeriod();
            Date[] value = new Date[2];
            if (beginDate != null) {
                value[0] = beginDate;
            }
            if (endDate != null) {
                value[1] = endDate;
            }
            this._dateEditor.setValue(null);
            this._dateEditor.setValue((Object)value);
        } else {
            this.resetValues();
        }
    }

    @Override
    public void resetValues() {
        this._modifiedButton.setSelected(true);
        this._dateEditor.setValue(null);
    }

    @Override
    public SearchFilter createFilter() throws ServiceException, RemoteException {
        Object value = this._dateEditor.getValue();
        if (value != null && value instanceof Date[]) {
            Date[] dateRange = (Date[])value;
            Date beginDate = dateRange[0];
            Date endDate = dateRange[1];
            DateFilter.DateType type = DateFilter.DateType.MODIFIED_DATE;
            if (this._createdButton.isSelected()) {
                type = DateFilter.DateType.CREATED_DATE;
            }
            DateFilter dateFilter = new DateFilter(type, beginDate, endDate);
            Component[] comp = this._dateEditor.getComponents();
            for (int i = 0; i < comp.length; ++i) {
                String label;
                JComboBox combo;
                Object obj;
                Component c = comp[i];
                if (!(c instanceof JComboBox) || !((obj = (combo = (JComboBox)c).getSelectedItem()) instanceof ValueItem)) continue;
                ValueItem item = (ValueItem)obj;
                if (!this.isSupportedRange(item) || (label = item.getLabel()) == null) break;
                dateFilter.setDateRangeLabel(label);
                break;
            }
            return dateFilter;
        }
        return null;
    }

    private boolean isSupportedRange(ValueItem item) {
        DateParser parser = DateParser.getInstance();
        List<ValueItem> options = parser.getRangeOptions();
        return options != null && options.contains(item);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Component[] comp = this._dateEditor.getComponents();
        for (int i = 0; i < comp.length; ++i) {
            JComboBox combo;
            Object obj;
            Component c = comp[i];
            if (!(c instanceof JComboBox) || !((obj = (combo = (JComboBox)c).getSelectedItem()) instanceof ValueItem)) continue;
            ValueItem item = (ValueItem)obj;
            String label = item.getLabel();
            if (label != null) break;
            this._dateEditor.setValue(null);
            break;
        }
    }

    @Override
    public void setPreviousValues(Search search) throws ServiceException, RemoteException {
        List filters = search.getFilters();
        if (filters == null) {
            return;
        }
        for (SearchFilter filter : filters) {
            if (!(filter instanceof DateFilter)) continue;
            this.setPreviousValues(filter);
            break;
        }
    }

    @Override
    public void setEditable(boolean bEditable) {
        this._enabled = bEditable;
        if (this._createdButton != null) {
            this._createdButton.setEnabled(bEditable);
        }
        if (this._modifiedButton != null) {
            this._modifiedButton.setEnabled(bEditable);
        }
        if (this._dateEditor != null) {
            this._dateEditor.setEnabled(bEditable);
        }
    }

    @Override
    public boolean isEnabled() {
        return this._enabled;
    }
}

