/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.logical.visuals.search;

import com.sas.metadata.logical.visuals.search.AbstractFilterDialog;
import com.sas.metadata.logical.visuals.search.DefaultAdvancedFilterDialog;
import com.sas.metadata.logical.visuals.search.FilterComponentInterface;
import com.sas.metadata.logical.visuals.search.RB;
import com.sas.services.ServiceException;
import com.sas.services.information.ServerInterface;
import com.sas.services.information.search.Search;
import com.sas.services.information.search.SearchFactory;
import com.sas.services.information.search.SearchFilter;
import com.sas.services.information.search.SortOrder;
import com.sas.swing.visuals.util.Util;
import com.sas.workspace.Workspace;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class BaseFilterPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    protected Map<FilterComponentInterface, SearchFilter> _filterPanels = new LinkedHashMap<FilterComponentInterface, SearchFilter>(6);
    protected List<SearchFilter> _filterList;
    protected DefaultAdvancedFilterDialog _advancedFilterDialog;
    protected JButton _advancedButton;
    protected boolean _displayAdvancedFilters = false;
    protected boolean m_bSortSearchResults = true;

    public BaseFilterPanel() {
        this.initializePanel();
    }

    protected void initializePanel() {
        this._advancedButton = new JButton();
        Util.configureMnemonicForButton((AbstractButton)this._advancedButton, (String)RB.getStringResource("BaseFilterPanel.Advanced.Button.txt"));
        this._advancedButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BaseFilterPanel.this.onOpenAdvancedFilterDialog();
            }
        });
    }

    public void layoutWidgets() {
        this.setLayout(new GridBagLayout());
        int yIndex = this.layoutFilterPanels(0);
        if (this.isDisplayingAdvancedButton()) {
            this.add((Component)this._advancedButton, new GridBagConstraints(0, yIndex++, 0, 1, 1.0, 0.0, 18, 0, new Insets(5, 10, 5, 0), 0, 0));
        }
    }

    protected int layoutFilterPanels(int yIndex) {
        JPanel pnlFilters = new JPanel(new GridBagLayout());
        int yPanelIndex = 0;
        for (FilterComponentInterface panel : this._filterPanels.keySet()) {
            if (!(panel instanceof Component)) continue;
            double yWeight = panel.isVerticallyResizable() ? 1.0 : 0.0;
            int fill = panel.isVerticallyResizable() ? 1 : 2;
            pnlFilters.add((Component)((Object)panel), new GridBagConstraints(0, yPanelIndex++, 0, 1, 1.0, yWeight, 18, fill, new Insets(5, 5, 5, 5), 0, 0));
        }
        double yWeight = 1.0;
        if (this.isDisplayingAdvancedButton()) {
            yWeight = 0.0;
        }
        pnlFilters.add((Component)new JPanel(), new GridBagConstraints(0, yPanelIndex++, 0, 1, 0.0, yWeight, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
        JScrollPane scr = new JScrollPane(pnlFilters);
        scr.setBorder(null);
        this.add((Component)scr, new GridBagConstraints(0, yIndex++, 0, 1, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
        return yIndex;
    }

    public Map<FilterComponentInterface, SearchFilter> getFilterPanelMap() {
        return this._filterPanels;
    }

    public List<FilterComponentInterface> getFilterPanels() {
        return new ArrayList<FilterComponentInterface>(this._filterPanels.keySet());
    }

    public List<SearchFilter> getFilters() {
        ArrayList<SearchFilter> filters = new ArrayList<SearchFilter>();
        for (FilterComponentInterface panel : this._filterPanels.keySet()) {
            SearchFilter filter = this._filterPanels.get(panel);
            if (filter == null) continue;
            filters.add(filter);
        }
        if (this.isDisplayingAdvancedButton()) {
            filters.addAll(this._advancedFilterDialog.getFilters());
        }
        return filters;
    }

    public void addFilterPanel(FilterComponentInterface panel) {
        if (!this._filterPanels.containsKey(panel)) {
            this._filterPanels.put(panel, null);
        }
    }

    public void loadInitialData() throws ServiceException, RemoteException {
        for (FilterComponentInterface panel : this._filterPanels.keySet()) {
            panel.loadInitialData();
        }
    }

    public void addFilterPanel(FilterComponentInterface panel, SearchFilter filter) {
        if (!this._filterPanels.containsKey(panel)) {
            this._filterPanels.put(panel, filter);
        }
    }

    public boolean isDisplayingAdvancedButton() {
        return this._displayAdvancedFilters;
    }

    public void setAdvancedFilterDialog(DefaultAdvancedFilterDialog advancedDialog) {
        this._displayAdvancedFilters = advancedDialog != null;
        this._advancedFilterDialog = advancedDialog;
    }

    public AbstractFilterDialog getAdvancedFilterDialog() {
        return this._advancedFilterDialog;
    }

    private void onOpenAdvancedFilterDialog() {
        if (this._advancedFilterDialog != null) {
            this._advancedFilterDialog.show();
            this._advancedFilterDialog.dispose();
        }
    }

    protected Search createSearch() throws RemoteException, ServiceException {
        Search newSearch = SearchFactory.createSearch((ServerInterface)Workspace.getWorkspace().getConnectionManager().getMetadataServer());
        this.updateSearch(newSearch);
        return newSearch;
    }

    protected void updateSearch(Search search) throws RemoteException, ServiceException {
        for (FilterComponentInterface panel : this._filterPanels.keySet()) {
            panel.addToSearch(search);
        }
        if (this.isDisplayingAdvancedButton()) {
            List<SearchFilter> dialogFilters = this._advancedFilterDialog.getFilters();
            for (SearchFilter filter : dialogFilters) {
                search.addFilter(filter);
            }
        }
        if (this._advancedFilterDialog.isDisplayingResultsConfiguration()) {
            search.getResultDetails().setSortOrder(this._advancedFilterDialog.getResultsPanel().getSortOrder());
            search.getResultDetails().setResultLimit(this._advancedFilterDialog.getResultsPanel().getResultLimit());
        }
    }

    protected void reset() {
        Map<FilterComponentInterface, SearchFilter> filterPanels = this.getFilterPanelMap();
        for (FilterComponentInterface panel : filterPanels.keySet()) {
            panel.resetValues();
        }
    }

    public void setPreviousValues(Search search) throws ServiceException, RemoteException {
        List<FilterComponentInterface> filterPanels = this.getFilterPanels();
        for (FilterComponentInterface panel : filterPanels) {
            panel.setPreviousValues(search);
        }
    }

    public void createFilters() throws ServiceException, RemoteException {
        for (FilterComponentInterface panel : this._filterPanels.keySet()) {
            SearchFilter filter = panel.createFilter();
            this._filterPanels.put(panel, filter);
        }
    }

    public boolean isSortingSearchResults() {
        return this.m_bSortSearchResults;
    }

    public void setSortSearchResults(boolean sort) {
        this.m_bSortSearchResults = sort;
        SortOrder.setSortingEnabled((boolean)sort);
    }
}

