/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.logical.visuals.search;

import com.sas.metadata.logical.visuals.search.BaseFilterPanel;
import com.sas.metadata.logical.visuals.search.FilterComponentInterface;
import com.sas.metadata.logical.visuals.search.RB;
import com.sas.services.information.search.SearchFilter;
import com.sas.swing.visuals.LabelView;
import com.sas.swing.visuals.UnderlineIcon;
import com.sas.swing.visuals.util.Util;
import com.sas.visuals.AutoSizingGridLayout;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAStandardDialog;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JPanel;

public abstract class AbstractFilterDialog
extends WAStandardDialog {
    private static final long serialVersionUID = 1L;
    protected JPanel _headerPanel;
    protected LabelView _headerLabel;
    protected JButton _headerResetButton;
    public BaseFilterPanel _basePanel = null;
    protected boolean _previouslyLoaded = false;
    protected String _title;

    public AbstractFilterDialog(String title, Dialog dlgOwner) {
        super(dlgOwner, true);
        this._title = title;
    }

    public AbstractFilterDialog(String title, Frame frameOwner) {
        super(frameOwner, true);
        this._title = title;
    }

    protected void initializeDialog() {
        this.setTitle(this._title);
        this.setResizable(true);
        this.setOKButtonVisible(true);
        this.setCancelButtonVisible(true);
        this.setHelpButtonVisible(true);
        this._basePanel = new BaseFilterPanel();
        super.initialize();
    }

    protected void layoutWidgets() {
        super.layoutWidgets();
        this.configureHeaderPanel();
    }

    public void addFilterPanel(FilterComponentInterface panel) {
        this._basePanel.addFilterPanel(panel);
    }

    public void addFilterPanel(FilterComponentInterface panel, SearchFilter filter) {
        this._basePanel.addFilterPanel(panel, filter);
    }

    protected void configureHeaderPanel() {
        this._headerPanel = new JPanel();
        this.add(this._headerPanel);
        AutoSizingGridLayout headerLayout = new AutoSizingGridLayout(1, -1);
        headerLayout.setFillCell(true);
        headerLayout.setUseColumnRemainder(true);
        headerLayout.setRemainderColumn(1);
        this._headerPanel.setLayout((LayoutManager)headerLayout);
        this._headerLabel = new LabelView();
        this._headerLabel.setText(RB.getStringResource("AbstractFilterDialog.Header.txt"));
        this._headerLabel.setPreferredSpanSize(new Dimension(-101, -1));
        this._headerPanel.add((Component)this._headerLabel);
        this._headerResetButton = new JButton();
        Util.configureMnemonicForButton((AbstractButton)this._headerResetButton, (String)RB.getStringResource("AbstractFilterDialog.ResetDefaults.txt"));
        this._headerResetButton.setRolloverIcon((Icon)new UnderlineIcon(true));
        this._headerResetButton.setIcon((Icon)new UnderlineIcon(false));
        this._headerResetButton.setMargin(new Insets(0, 0, 0, 0));
        this._headerResetButton.setBorderPainted(false);
        this._headerResetButton.setContentAreaFilled(false);
        this._headerResetButton.setVerticalAlignment(3);
        this._headerResetButton.setForeground(SystemColor.blue);
        this._headerResetButton.addActionListener(this.getResetAction());
        this._headerPanel.add(this._headerResetButton);
    }

    protected ActionListener getResetAction() {
        return new ResetAction();
    }

    public boolean doDataExchange(boolean bSaveToModel) {
        if (!bSaveToModel && !this._previouslyLoaded) {
            this.loadFilterData();
            this._previouslyLoaded = true;
            this.setPreviousValues();
        }
        return true;
    }

    public void loadFilterData() {
        try {
            this._basePanel.loadInitialData();
        }
        catch (Exception e) {
            MessageUtil.displayMessage((String)e.getLocalizedMessage(), (int)0);
        }
    }

    public void setPreviousValues() {
        if (!this._previouslyLoaded) {
            return;
        }
        try {
            Map<FilterComponentInterface, SearchFilter> filterPanels = this._basePanel.getFilterPanelMap();
            for (FilterComponentInterface panel : filterPanels.keySet()) {
                SearchFilter filter = filterPanels.get(panel);
                panel.setPreviousValues(filter);
            }
        }
        catch (Exception e) {
            MessageUtil.displayMessage((String)e.getLocalizedMessage(), (int)0);
        }
    }

    public boolean validateData() {
        try {
            this._basePanel.createFilters();
        }
        catch (Exception e) {
            MessageUtil.displayMessage((String)e.getLocalizedMessage(), (int)0);
            return false;
        }
        return true;
    }

    public void show() {
        super.show();
        if (this.getReturnValue() == 2) {
            this.setPreviousValues();
        }
    }

    public List<FilterComponentInterface> getFilterPanels() {
        return this._basePanel.getFilterPanels();
    }

    public List<SearchFilter> getFilters() {
        return this._basePanel.getFilters();
    }

    public void setEditable(boolean bEditable) {
        super.setEditable(bEditable);
        if (this._headerResetButton != null) {
            this._headerResetButton.setEnabled(bEditable);
        }
    }

    private class ResetAction
    implements ActionListener {
        private ResetAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.resetAllValues();
        }

        private void resetAllValues() {
            AbstractFilterDialog.this._basePanel.reset();
        }
    }
}

