/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.logical.visuals.properties;

import com.sas.metadata.logical.visuals.properties.PropertiesModel;
import com.sas.metadata.logical.visuals.properties.PropertyChangeEvent;
import com.sas.metadata.logical.visuals.properties.PropertyChangeListener;
import com.sas.metadata.logical.visuals.properties.RB;
import com.sas.metadata.remote.MdException;
import com.sas.workspace.WsAbstractTableColumn;
import com.sas.workspace.WsAbstractTableModel;
import com.sas.workspace.WsStringTableColumn;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;

public class PropertiesTableModel
extends WsAbstractTableModel {
    private PropertiesModel m_mdlProperties;
    private PropertyChangeListener m_lsnrProperties;
    public static final int NAME = 0;
    public static final int VALUE = 1;

    public PropertiesTableModel() {
        this.initializeColumns();
        this.m_lsnrProperties = new PropertiesModelListener();
    }

    public PropertiesTableModel(PropertiesModel mdlProperties) {
        this();
        this.setPropertiesModel(mdlProperties);
    }

    public void setPropertiesModel(PropertiesModel mdlProperties) {
        if (this.m_mdlProperties != null) {
            this.m_mdlProperties.removePropertyChangeListener(this.m_lsnrProperties);
        }
        this.m_mdlProperties = mdlProperties;
        if (this.m_mdlProperties != null) {
            this.m_mdlProperties.addPropertyChangeListener(this.m_lsnrProperties);
        }
        this.clear();
        this.initializeValues();
    }

    public PropertiesModel getPropertiesModel() {
        return this.m_mdlProperties;
    }

    protected void initializeColumns() {
        this.m_aColumns = new WsAbstractTableColumn[2];
        this.m_aColumns[0] = new WsStringTableColumn(0, RB.getStringResource("PropertiesTableModel.Columns.Name.txt"), 150);
        this.m_aColumns[0].setEditable(false);
        this.m_aColumns[1] = new ValueTableColumn(1, RB.getStringResource("PropertiesTableModel.Columns.Value.txt"), 150);
    }

    protected void initializeValues() {
        int nProperties = 0;
        if (this.m_mdlProperties != null) {
            nProperties = this.m_mdlProperties.getNumberOfProperties();
        }
        this.m_lData = new ArrayList(nProperties);
        for (int iProperty = 0; iProperty < nProperties; ++iProperty) {
            ArrayList<Object> lRowValues = new ArrayList<Object>(2);
            lRowValues.add(this.m_mdlProperties.getPropertyName(iProperty));
            lRowValues.add(this.m_mdlProperties.getPropertyValue(iProperty));
            this.m_lData.add(lRowValues);
        }
        this.fireTableModelPopulated();
    }

    public void populateStore() throws MdException, RemoteException {
        this.m_mdlProperties.populate();
    }

    public void moveDataToModel() throws MdException, RemoteException {
        if (this.m_mdlProperties == null) {
            return;
        }
        int nProperties = this.m_mdlProperties.getNumberOfProperties();
        for (int iProperty = 0; iProperty < nProperties; ++iProperty) {
            this.setValueAtImpl(this.m_mdlProperties.getPropertyValue(iProperty), iProperty, 1);
        }
    }

    public void moveDataToStore() throws MdException, RemoteException {
    }

    public void setValueAt(Object value, int iRow, int iColumn) {
        if (iColumn == 1) {
            this.m_mdlProperties.setPropertyValue(iRow, value);
        } else {
            super.setValueAt(value, iRow, iColumn);
        }
    }

    private void setValueAtImpl(Object value, int iRow, int iColumn) {
        super.setValueAt(value, iRow, iColumn);
    }

    public String getToolTipAt(int iRow, int iCol) {
        Object obj = ((List)this.m_lData.get(iRow)).get(iCol);
        if (obj == null || !(obj instanceof String)) {
            return null;
        }
        String tip = (String)obj;
        if (tip.length() == 0) {
            return null;
        }
        return tip;
    }

    private static class ValueTableColumn
    extends WsAbstractTableColumn {
        public ValueTableColumn(int iModelIndex, String sName, int cxWidth) {
            super(iModelIndex, sName, cxWidth);
            this.setColumnClass(Object.class);
        }

        protected TableCellRenderer createCellRenderer() {
            return null;
        }

        protected TableCellEditor createCellEditor() {
            return null;
        }

        public Object createDefaultValue() {
            return null;
        }
    }

    private class PropertiesModelListener
    implements PropertyChangeListener {
        private PropertiesModelListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent ev) {
            PropertiesTableModel.this.setValueAtImpl(ev.getNewValue(), ev.getPropertyIndex(), 1);
        }
    }
}

