/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.logical.visuals.properties;

import com.sas.metadata.logical.visuals.properties.PropertiesModel;
import com.sas.metadata.logical.visuals.properties.PropertyChangeEvent;
import com.sas.metadata.logical.visuals.properties.PropertyChangeListener;
import com.sas.metadata.logical.visuals.properties.RB;
import com.sas.metadata.remote.Root;
import com.sas.workspace.WAComboBox;
import com.sas.workspace.WAIntTextField;
import com.sas.workspace.WATextField;
import com.sas.workspace.WsDefaultCellEditor;
import com.sas.workspace.WsDefaultTableCellRenderer;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComboBox;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;

public abstract class AbstractPropertiesModel
implements PropertiesModel {
    private static TableCellRenderer g_rdrDefault;
    private static TableCellEditor g_edtDefault;
    private static TableCellRenderer g_rdrDateDefault;
    private static TableCellRenderer g_rdrBooleanDefault;
    private static TableCellEditor g_edtBooleanDefault;
    private static TableCellEditor g_edtIntDefault;
    protected Root m_mdoObject;
    private String[] m_aNames;
    private Object[] m_aValues;
    private TableCellRenderer[] m_aRenderers;
    private boolean[] m_aEditables;
    private TableCellEditor[] m_aEditors;
    protected Thread[] m_aUpdatePropertyThreads;
    private boolean m_bDisplayErrors = true;
    private List m_lListeners;

    public AbstractPropertiesModel() {
        this(null);
    }

    public AbstractPropertiesModel(Root mdoObject) {
        this.m_mdoObject = mdoObject;
        this.initializeArrays();
        this.initializePropertyIndexes();
        this.initializeProperties();
        this.createUpdatePropertyThreads();
    }

    private void initializeArrays() {
        this.m_lListeners = new ArrayList();
        int nProperties = this.getNumberOfProperties();
        this.m_aNames = new String[nProperties];
        this.m_aValues = new Object[nProperties];
        this.m_aEditables = new boolean[nProperties];
        this.m_aEditors = new TableCellEditor[nProperties];
        this.m_aRenderers = new TableCellRenderer[nProperties];
        this.m_aUpdatePropertyThreads = new Thread[nProperties];
    }

    protected abstract void initializePropertyIndexes();

    protected abstract void initializeProperties();

    public void setProperty(int iProperty, String sName, TableCellRenderer rdr) {
        this.setProperty(iProperty, sName, "", rdr, false, null);
    }

    public void setProperty(int iProperty, String sName, Object value, TableCellRenderer rdr) {
        this.setProperty(iProperty, sName, value, rdr, false, null);
    }

    public void setProperty(int iProperty, String sName, Object value, TableCellRenderer rdr, boolean bEditable, TableCellEditor editor) {
        this.m_aNames[iProperty] = sName;
        this.m_aValues[iProperty] = value;
        this.m_aEditables[iProperty] = bEditable;
        this.m_aEditors[iProperty] = editor;
        this.m_aRenderers[iProperty] = rdr;
    }

    public void setPropertyName(int iProperty, String sName) {
        this.m_aNames[iProperty] = sName;
    }

    @Override
    public String getPropertyName(int iProperty) {
        return this.m_aNames[iProperty];
    }

    @Override
    public void setPropertyValue(int iProperty, Object value) {
        if (this.m_aValues[iProperty] != null && this.m_aValues[iProperty].equals(value)) {
            return;
        }
        this.setPropertyValueImpl(iProperty, value);
    }

    protected void setPropertyValueImpl(int iProperty, Object value) {
        this.m_aValues[iProperty] = value;
        this.firePropertyChangeEvent(iProperty, value);
    }

    @Override
    public Object getPropertyValue(int iProperty) {
        return this.m_aValues[iProperty];
    }

    public void setPropertyRenderer(int iProperty, TableCellRenderer rdr) {
        this.m_aRenderers[iProperty] = rdr;
    }

    @Override
    public TableCellRenderer getPropertyRenderer(int iProperty) {
        return this.m_aRenderers[iProperty];
    }

    public void setPropertyValueEditable(int iProperty, boolean bEditable) {
        this.m_aEditables[iProperty] = bEditable;
    }

    @Override
    public boolean isPropertyValueEditable(int iProperty) {
        return this.m_aEditables[iProperty];
    }

    public void setPropertyEditor(int iProperty, TableCellEditor editor) {
        this.m_aEditors[iProperty] = editor;
    }

    @Override
    public TableCellEditor getPropertyEditor(int iProperty) {
        return this.m_aEditors[iProperty];
    }

    public void setMetadataObject(Root mdoObject) {
        this.m_mdoObject = mdoObject;
    }

    @Override
    public Root getMetadataObject() {
        return this.m_mdoObject;
    }

    @Override
    public abstract int getNumberOfProperties();

    @Override
    public void createUpdatePropertyThreads() {
    }

    @Override
    public void startUpdatePropertyThreads() {
        for (int i = 0; i < this.getNumberOfProperties(); ++i) {
            Thread t = this.m_aUpdatePropertyThreads[i];
            if (t == null) continue;
            t.start();
        }
    }

    @Override
    public void setDisplayErrors(boolean displayErrors) {
        this.m_bDisplayErrors = displayErrors;
    }

    @Override
    public boolean isDisplayErrors() {
        return this.m_bDisplayErrors;
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.m_lListeners.add(l);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.m_lListeners.remove(l);
    }

    protected void firePropertyChangeEvent(int iProperty, Object newValue) {
        if (this.m_lListeners.size() == 0) {
            return;
        }
        PropertyChangeEvent ev = new PropertyChangeEvent(this, iProperty, newValue);
        for (int iListener = this.m_lListeners.size() - 1; iListener >= 0; --iListener) {
            PropertyChangeListener listener = (PropertyChangeListener)this.m_lListeners.get(iListener);
            listener.propertyChange(ev);
        }
    }

    public static TableCellRenderer getDefaultRenderer() {
        if (g_rdrDefault == null) {
            g_rdrDefault = new WsDefaultTableCellRenderer();
        }
        return g_rdrDefault;
    }

    public static TableCellEditor getDefaultEditor() {
        if (g_edtDefault == null) {
            g_edtDefault = new WsDefaultCellEditor(new WATextField());
        }
        return g_edtDefault;
    }

    public static TableCellRenderer getDefaultDateRenderer() {
        if (g_rdrDateDefault == null) {
            g_rdrDateDefault = new DefaultDateTableCellRenderer();
        }
        return g_rdrDateDefault;
    }

    public static TableCellRenderer getDefaultBooleanRenderer() {
        if (g_rdrBooleanDefault == null) {
            g_rdrBooleanDefault = new DefaultBooleanTableCellRenderer();
        }
        return g_rdrBooleanDefault;
    }

    public static TableCellEditor getDefaultBooleanEditor() {
        if (g_edtBooleanDefault == null) {
            g_edtBooleanDefault = new DefaultBooleanTableCellEditor();
        }
        return g_edtBooleanDefault;
    }

    public static TableCellEditor getDefaultIntEditor() {
        if (g_edtIntDefault == null) {
            g_edtIntDefault = new DefaultIntTableCellEditor(true, false);
        }
        return g_edtIntDefault;
    }

    public static TableCellEditor getIntEditor(boolean allowNegatives, boolean allowBlank) {
        return new DefaultIntTableCellEditor(allowNegatives, allowBlank);
    }

    public static TableCellEditor getListEditor(List translatedValues, List untranslatedValues) {
        return new DefaultListTableCellEditor(translatedValues, untranslatedValues);
    }

    public static TableCellRenderer getListRenderer(List translatedValues, List untranslatedValues) {
        return new DefaultListTableCellRenderer(translatedValues, untranslatedValues);
    }

    public static class DefaultIntTableCellEditor
    extends WsDefaultCellEditor {
        private WAIntTextField m_intField;

        public DefaultIntTableCellEditor(boolean allowNegatives, boolean allowBlank) {
            this.m_intField = new WAIntTextField(allowNegatives);
            this.initialize((WATextField)this.m_intField, (WsDefaultCellEditor.cEditorDelegate)new WsDefaultCellEditor.cIntTextFieldDelegate((WsDefaultCellEditor)this, this.m_intField));
        }
    }

    public static class DefaultBooleanTableCellEditor
    extends WsDefaultCellEditor {
        private static String[] g_saValues = new String[]{RB.getStringResource("Common.No.txt"), RB.getStringResource("Common.Yes.txt")};

        public DefaultBooleanTableCellEditor() {
            WAComboBox cmb = new WAComboBox((Object[])g_saValues);
            this.initialize((JComboBox)cmb, (WsDefaultCellEditor.cEditorDelegate)new WsDefaultCellEditor.cBooleanComboDelegate((WsDefaultCellEditor)this, cmb));
            cmb.setEditable(false);
        }
    }

    public static class DefaultBooleanTableCellRenderer
    extends WsDefaultTableCellRenderer {
        protected void setValue(Object value) {
            if (value == null) {
                this.setText("");
            } else if (((Boolean)value).booleanValue()) {
                this.setText(RB.getStringResource("Common.Yes.txt"));
            } else {
                this.setText(RB.getStringResource("Common.No.txt"));
            }
        }
    }

    public static class DefaultListTableCellEditor
    extends WsDefaultCellEditor {
        private List m_translatedValues;
        private List m_untranslatedValues;

        public DefaultListTableCellEditor(List transValues, List untransValues) {
            this.m_translatedValues = transValues;
            this.m_untranslatedValues = untransValues;
            WAComboBox cmb = new WAComboBox(transValues.toArray());
            this.initialize((JComboBox)cmb, (WsDefaultCellEditor.cEditorDelegate)new WsDefaultCellEditor.cComboBoxDelegate((WsDefaultCellEditor)this, (JComboBox)cmb));
            cmb.setEditable(false);
        }

        public Object getCellEditorValue() {
            Object obj = this.m_delegate.getValue();
            int index = this.m_translatedValues.indexOf(obj);
            if (index > -1) {
                try {
                    return this.m_untranslatedValues.get(index);
                }
                catch (IndexOutOfBoundsException exc) {
                    return "";
                }
            }
            return "";
        }
    }

    public static class DefaultListTableCellRenderer
    extends WsDefaultTableCellRenderer {
        private List m_translatedValues;
        private List m_untranslatedValues;

        public DefaultListTableCellRenderer(List transValues, List untransValues) {
            this.m_translatedValues = transValues;
            this.m_untranslatedValues = untransValues;
        }

        protected void setValue(Object value) {
            if (value == null) {
                this.setText("");
            } else {
                int index = this.m_untranslatedValues.indexOf(value);
                if (index > -1) {
                    try {
                        this.setText(this.m_translatedValues.get(index).toString());
                    }
                    catch (IndexOutOfBoundsException exc) {
                        this.setText("");
                    }
                } else {
                    this.setText("");
                }
            }
        }
    }

    public static class DefaultDateTableCellRenderer
    extends WsDefaultTableCellRenderer {
        private static DateFormat g_fmt = DateFormat.getDateTimeInstance(2, 2);

        protected void setValue(Object value) {
            if (value == null) {
                this.setText("");
            } else {
                this.setText(g_fmt.format(value));
            }
        }
    }
}

