/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.logical.visuals;

import com.sas.metadata.logical.LogicalObjectInterface;
import com.sas.metadata.logical.UtilMisc;
import com.sas.metadata.logical.UtilPlatformServices;
import com.sas.metadata.logical.visuals.RB;
import com.sas.services.ServiceException;
import com.sas.services.information.ChildServerInterface;
import com.sas.services.information.ServerInterface;
import com.sas.services.information.metadata.MetadataInterface;
import com.sas.services.user.UserContextInterface;
import com.sas.services.util.ProcessStatus;
import com.sas.services.util.UpgradeInterface;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.OpRequestUI;
import com.sas.workspace.Workspace;
import java.awt.Frame;
import java.io.StringWriter;
import java.io.Writer;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.appender.WriterAppender;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.Configurator;
import org.apache.logging.log4j.core.config.LoggerConfig;
import org.apache.logging.log4j.core.layout.PatternLayout;

public class UpgradeLogicalObjectVersionUI {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeLogicalVersionUpgrade(LogicalObjectInterface[] upgradeObjects) {
        if (upgradeObjects == null || upgradeObjects.length == 0) {
            return;
        }
        String loggingContext = this.getClass().getPackage().getName();
        Logger logger = LogManager.getLogger((String)loggingContext);
        Configurator.setLevel((String)logger.getName(), (Level)Level.INFO);
        StringWriter writer = new StringWriter();
        LoggerContext lc = (LoggerContext)LogManager.getContext((boolean)false);
        Configuration config = lc.getConfiguration();
        PatternLayout layout = PatternLayout.newBuilder().withConfiguration(config).withPattern("%-5p - %m%n").build();
        WriterAppender appender = ((WriterAppender.Builder)((WriterAppender.Builder)WriterAppender.newBuilder().setConfiguration(config)).setLayout((Layout)layout)).setTarget((Writer)writer).build();
        appender.start();
        config.addAppender((Appender)appender);
        lc.updateLoggers();
        ProcessStatus globalStatus = new ProcessStatus(logger, RB.getStringResource("UpgradeLogicalObjectVersion.title.txt"));
        ProcessStatus.setGlobalStatus((ProcessStatus)globalStatus);
        try {
            UpgradeObjectsThread thread = new UpgradeObjectsThread(upgradeObjects);
            OpRequestUI ui = new OpRequestUI((Frame)Workspace.getWorkspace());
            ui.setTitle(RB.getStringResource("UpgradeLogicalObjectVersion.title.txt"));
            ui.setMessage(RB.getStringResource("UpgradeLogicalObjectVersion.processing.txt"));
            ui.execute((Runnable)thread);
            globalStatus.logStatus();
            String sMessage = null;
            int eType = 1;
            String sDetails = null;
            if (globalStatus.hasErrors() || globalStatus.hasWarnings()) {
                sMessage = RB.getStringResource("UpgradeLogicalObjectVersion.Errors.txt");
                eType = globalStatus.hasErrors() ? 0 : 2;
                sDetails = writer.toString();
            } else {
                sMessage = RB.getStringResource("UpgradeLogicalObjectVersion.Success.txt");
                sDetails = writer.toString();
            }
            MessageUtil.displayDetailsMessage((String)sMessage, (int)eType, (String)sDetails);
        }
        finally {
            ProcessStatus.clearGlobalStatus();
            lc = (LoggerContext)LogManager.getContext((boolean)false);
            config = lc.getConfiguration();
            LoggerConfig loggerConfig = config.getLoggerConfig(logger.getName());
            if (loggerConfig.getName().equals(logger.getName())) {
                loggerConfig.removeAppender(appender.getName());
            }
            lc.updateLoggers();
        }
    }

    private class UpgradeObjectsThread
    implements Runnable {
        private LogicalObjectInterface[] _upgradeObjects = null;
        private List<LogicalObjectInterface> _upgradedObjects = new ArrayList<LogicalObjectInterface>();

        public UpgradeObjectsThread(LogicalObjectInterface[] upgradeObjects) {
            this._upgradeObjects = upgradeObjects;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            ProcessStatus globalStatus = ProcessStatus.getGlobalStatus();
            if (globalStatus == null) {
                Workspace.getDefaultLogger().error((Object)"Error getting global status for upgrade of objects");
                return;
            }
            ServerInterface server = null;
            try {
                UserContextInterface uContext = UtilPlatformServices.getUserContext();
                if (uContext != null) {
                    server = uContext.getAuthServer();
                }
            }
            catch (RemoteException e) {
                globalStatus.addErrorException("SERVERINTERFACE", (Throwable)e);
            }
            catch (ServiceException e) {
                globalStatus.addErrorException("SERVERINTERFACE", (Throwable)e);
            }
            for (int i = 0; i < this._upgradeObjects.length; ++i) {
                LogicalObjectInterface lo = this._upgradeObjects[i];
                if (lo == null) continue;
                try {
                    String id = lo.getID();
                    String metadataType = lo.getTypeInterface().getMetadataType();
                    if (id == null || id.length() <= 0 || metadataType == null || metadataType.length() <= 0 || server == null) continue;
                    ChildServerInterface cTransaction = server.newChild(true);
                    try {
                        MetadataInterface smartObject = cTransaction.fetch(id + '/' + metadataType, true);
                        if (smartObject instanceof UpgradeInterface) {
                            UpgradeInterface upgradeObject = (UpgradeInterface)smartObject;
                            upgradeObject.upgradeFromPreviousVersion();
                            this._upgradedObjects.add(lo);
                            String message = UtilMisc.getMessage(RB.getStringResource("UpgradeLogicalObjectVersion.SuccessfullObjectUpgrade.fmt"), lo.getTypeInterface().getDisplayType(), lo.getName());
                            globalStatus.addInfo(message);
                            continue;
                        }
                        ServiceException se = new ServiceException(RB.getStringResource("UpgradeLogicalObjectVersion.ErrorCreating.txt"));
                        globalStatus.addErrorException(lo.getName(), (Throwable)se);
                        continue;
                    }
                    finally {
                        cTransaction.destroy();
                    }
                }
                catch (RemoteException e) {
                    globalStatus.addErrorException(lo.getName(), (Throwable)e);
                    continue;
                }
                catch (ServiceException e) {
                    globalStatus.addErrorException(lo.getName(), (Throwable)e);
                    continue;
                }
                catch (IllegalStateException e) {
                    globalStatus.addErrorException(lo.getName(), (Throwable)e);
                }
            }
        }
    }
}

