/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.logical.visuals;

import com.sas.workspace.WAPanel;
import com.sas.workspace.WARootPane;
import com.sas.workspace.WAStandardDialog;
import com.sas.workspace.WATextArea;
import com.sas.workspace.WATextField;
import com.sas.workspace.WsButtonsLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.SystemColor;

public class TextInputDialog
extends WAStandardDialog {
    private static final long serialVersionUID = 1L;
    private WATextArea _msgArea;
    private WATextField _textField;

    public TextInputDialog(Frame parent, String title) {
        super(parent, title, true);
        this._initialize();
    }

    public static String showInputDialog(Frame parent, String title, String message, int maxCharacters, String initialValue) {
        TextInputDialog dlg = new TextInputDialog(parent, title);
        dlg.setOKButtonVisible(true);
        dlg.setCancelButtonVisible(true);
        dlg.setHelpButtonVisible(false);
        dlg.setMessage(message);
        dlg.setMaxCharacters(maxCharacters);
        dlg.setInitialValue(initialValue);
        dlg.show();
        if (dlg.getReturnValue() == 1) {
            return dlg.getInputText();
        }
        return null;
    }

    public String getInputText() {
        return this._textField.getText();
    }

    public void setMessage(String message) {
        this._msgArea.setText(message);
    }

    public String getMessage() {
        return this._msgArea.getText();
    }

    public void setInitialValue(String value) {
        this._textField.setText(value);
    }

    public String getInitialValue() {
        return this._textField.getText();
    }

    public void setMaxCharacters(int maxCharacters) {
        this._textField.setMaxCharacters(maxCharacters);
    }

    public int getMaxCharacters() {
        return this._textField.getMaxCharacters();
    }

    protected void _initialize() {
        WAPanel mainPanel = new WAPanel();
        mainPanel.setLayout((LayoutManager)new GridBagLayout());
        this._textField = new WATextField();
        this._msgArea = new WATextArea();
        this._msgArea.setBackground((Color)SystemColor.control);
        this._msgArea.setBehavior(1);
        mainPanel.add((Component)this._msgArea, (Object)new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
        mainPanel.add((Component)this._textField, (Object)new GridBagConstraints(0, 1, 2, 1, 1.0, 0.0, 18, 2, new Insets(5, 0, 0, 0), 0, 0));
        this.setMainPanel(mainPanel);
    }

    protected void updateButtonsPanel() {
        this.removeKeyListeners(this.m_pnlButtons, this.m_KeyHandler);
        this.m_pnlButtons.removeAll();
        this.m_pnlButtons.setLayout((LayoutManager)new WsButtonsLayout(0, 0));
        if (this.isOKButtonVisible()) {
            this.m_pnlButtons.add(this.m_btnOk);
        }
        if (this.isCancelButtonVisible()) {
            this.m_pnlButtons.add(this.m_btnCancel);
        }
        if (this.isOKButtonVisible()) {
            ((WARootPane)this.getRootPane()).setRealDefaultButton(this.m_btnOk);
        } else {
            ((WARootPane)this.getRootPane()).setRealDefaultButton(this.m_btnCancel);
        }
        this.addKeyListeners(this.m_pnlButtons, this.m_KeyHandler);
    }
}

