/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.logical.visuals;

import com.sas.metadata.logical.Factory;
import com.sas.metadata.logical.LogicalTypeException;
import com.sas.metadata.logical.UtilMetadata;
import com.sas.metadata.logical.UtilMisc;
import com.sas.metadata.logical.visuals.Config;
import com.sas.metadata.logical.visuals.ConfigGeneralPanel;
import com.sas.metadata.logical.visuals.GeneralResponsiblePartyModel;
import com.sas.metadata.logical.visuals.KeywordPanel;
import com.sas.metadata.logical.visuals.LayoutConstants;
import com.sas.metadata.logical.visuals.MetadataDialog;
import com.sas.metadata.logical.visuals.MetadataDialogPanel;
import com.sas.metadata.logical.visuals.RB;
import com.sas.metadata.logical.visuals.SmartWsDescriptionWizardTab;
import com.sas.metadata.logical.visuals.UtilGui;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.Identity;
import com.sas.metadata.remote.Keyword;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdFactory;
import com.sas.metadata.remote.MdOMRConnection;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.MdResponsibilitiesUtil;
import com.sas.metadata.remote.Person;
import com.sas.metadata.remote.PrimaryType;
import com.sas.metadata.remote.Root;
import com.sas.text.Message;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WATextArea;
import com.sas.workspace.WATextField;
import com.sas.workspace.WsAbstractTableModel;
import com.sas.workspace.WsEnumeratedTableColumn;
import com.sas.workspace.WsTable;
import com.sas.workspace.visuals.ResponsiblePartyTableModel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.text.JTextComponent;
import javax.swing.undo.UndoManager;

public class GeneralPropertyTab
extends SmartWsDescriptionWizardTab
implements ListSelectionListener,
LayoutConstants {
    private static final long serialVersionUID = 1L;
    private JLabel _lblType;
    private JLabel _typeValue;
    private JLabel _lblName;
    private WATextField _nameTF;
    private JLabel _lblDisplayName;
    private WATextField _displayNameTF;
    private JLabel _lblDescription;
    private JScrollPane _scrDescription;
    private WATextArea _descriptionTA;
    private JLabel _lblContext;
    private WATextField _contextTF;
    private JLabel _lblCreated;
    private WATextField _createdTF;
    private JLabel _lblModified;
    private WATextField _modifiedTF;
    private JLabel _lblKeywords;
    private JList _listKeywords;
    private DefaultListModel _keywordsListModel;
    private JScrollPane _scrKeywords;
    private JButton _btnAddKeyword;
    private JButton _btnEditKeyword;
    private JButton _btnDeleteKeyword;
    private AssociationList _keywordAL;
    private JLabel _lblResponsibleParties;
    private WsTable _tblResponsibleParties;
    private JScrollPane _scrResponsibleParties;
    private ResponsiblePartyTableModel _mdlResponsibleParties;
    private JButton _btnAddResponsibleParty;
    private JButton _btnDeleteResponsibleParty;
    private JCheckBox _hideFromUserCB;
    private boolean _showContext;
    private boolean _showCreated;
    private boolean _showDescription;
    private boolean _showKeywords;
    private boolean _showModified;
    private boolean _showResponsibleParties;
    private boolean _showType;
    private boolean _showHideFromUser;
    private boolean _showDisplayName;
    private boolean _nameEnabled;
    private boolean _displayNameEnabled;
    private boolean _isNameUserControlled;
    private boolean _isDescUserControlled;
    private Root _root;
    private int _type;
    private Icon _icon;
    private String _metadataObjectDisplayType;
    private String _context;
    private String _originalName;
    private String _displayName;
    private String _createdDateTFValue;
    private String _modifiedDateTFValue;
    private boolean _dataPreviouslyMovedToView;
    private Config _config;
    private boolean _onOKWasSelected;
    private boolean _hideFromUser;
    private boolean _objectShouldBeMarkedModified;
    private boolean _responsiblePartiesModified;
    protected int _layoutRowCount;

    public GeneralPropertyTab(Root root, int type, Config config) throws RemoteException {
        this.setName(RB.getStringResource("COM.GPV.Tab.txt"));
        this._root = root;
        this._type = type;
        this._metadataObjectDisplayType = root.getCMetadataType();
        if (config == null) {
            config = new Config();
        }
        this._config = config;
        this._showContext = config.isVisible(ConfigGeneralPanel.CONTEXT);
        this._showCreated = config.isVisible(ConfigGeneralPanel.CREATED);
        this._showDescription = config.isVisible(ConfigGeneralPanel.DESCRIPTION);
        this._showKeywords = config.isVisible(ConfigGeneralPanel.KEYWORDS);
        this._showModified = config.isVisible(ConfigGeneralPanel.MODIFIED);
        this._showResponsibleParties = config.isVisible(ConfigGeneralPanel.RESPONSIBILITIES);
        this._showType = config.isVisible(ConfigGeneralPanel.TYPE);
        this._isNameUserControlled = config.isUserControlled(ConfigGeneralPanel.NAME);
        this._isDescUserControlled = config.isUserControlled(ConfigGeneralPanel.DESCRIPTION);
        this._showHideFromUser = config.setVisibileInvoked(ConfigGeneralPanel.HIDEFROMUSER) && config.isVisible(ConfigGeneralPanel.HIDEFROMUSER) && root instanceof PrimaryType;
        this._showDisplayName = config.setVisibileInvoked(ConfigGeneralPanel.DISPLAY_NAME) && config.isVisible(ConfigGeneralPanel.DISPLAY_NAME);
        this.initialize();
        this.layoutWidgets();
    }

    protected void initialize() {
        String helpProduct;
        String description = (String)this._config.getInitValue(ConfigGeneralPanel.WIZARD_DESCRIPTION, null);
        if (description != null) {
            this.setDescription(description);
        }
        if ((helpProduct = (String)this._config.getInitValue(ConfigGeneralPanel.HELP_PRODUCT, null)) == null) {
            helpProduct = "folderview";
        }
        this.setHelpProduct(helpProduct);
        String helpTopic = (String)this._config.getInitValue(ConfigGeneralPanel.HELP_TOPIC, null);
        if (helpTopic == null) {
            helpTopic = "generaltab";
        }
        this.setHelpTopic(helpTopic);
        this._nameTF = new WATextField();
        this._nameTF.setMaxCharacters(60);
        this._nameTF.setToolTipText(RB.getStringResource("GPT.Tooltip.Name.txt"));
        this._nameEnabled = this._config.isEnabled(ConfigGeneralPanel.NAME);
        this._nameTF.setEnabled(this._nameEnabled);
        this._lblName = UtilGui.createLabelForComponent((Component)this._nameTF, RB.getStringResource("COM.Lbl.Name0.txt"));
        if (this._showDisplayName) {
            this._displayNameTF = new WATextField();
            this._displayNameTF.setMaxCharacters(256);
            this._displayNameTF.setToolTipText(RB.getStringResource("GPT.Tooltip.DisplayName.txt"));
            this._displayNameEnabled = this._config.isEnabled(ConfigGeneralPanel.DISPLAY_NAME);
            this._displayNameTF.setEnabled(this._displayNameEnabled);
            this._lblDisplayName = UtilGui.createLabelForComponent((Component)this._displayNameTF, RB.getStringResource("GPT.Lbl.DisplayName.txt"));
        }
        if (this._showType) {
            this._lblType = new JLabel(RB.getStringResource("GPT.Lbl.Type.txt"));
            this._typeValue = UtilGui.createLabelForComponent(this._lblType, "");
            this._typeValue.setHorizontalTextPosition(11);
        }
        if (this._showDescription) {
            this._descriptionTA = new WATextArea();
            this._descriptionTA.setMaxCharacters(200);
            this._descriptionTA.setLineWrap(true);
            this._descriptionTA.setWrapStyleWord(true);
            this._descriptionTA.setToolTipText(RB.getStringResource("GPT.Tooltip.Desc.txt"));
            this._lblDescription = UtilGui.createLabelForComponent((Component)this._descriptionTA, RB.getStringResource("GPT.Lbl.Desc.txt"));
            this._scrDescription = new JScrollPane((Component)this._descriptionTA);
        }
        Border emptyBorder = BorderFactory.createEmptyBorder();
        if (this._showContext) {
            this._lblContext = new JLabel(this.getContextLabel());
            this._contextTF = new WATextField();
            this._contextTF.setBehavior(2);
            this._contextTF.setBorder(emptyBorder);
        }
        if (this._showCreated) {
            this._lblCreated = new JLabel(RB.getStringResource("GPT.Lbl.Created.txt"));
            this._createdTF = new WATextField();
            this._createdTF.setBehavior(2);
            this._createdTF.setBorder(emptyBorder);
        }
        if (this._showModified) {
            this._lblModified = new JLabel(RB.getStringResource("GPT.Lbl.Modified.txt"));
            this._modifiedTF = new WATextField();
            this._modifiedTF.setBehavior(2);
            this._modifiedTF.setBorder(emptyBorder);
        }
        if (this._showKeywords) {
            this._keywordsListModel = new DefaultListModel();
            this._listKeywords = new JList(this._keywordsListModel);
            ListCellRenderer lcr = this._listKeywords.getCellRenderer();
            if (lcr instanceof JComponent) {
                ((JComponent)((Object)lcr)).putClientProperty("html.disable", Boolean.TRUE);
            }
            this._listKeywords.setVisibleRowCount(6);
            this._listKeywords.setToolTipText(RB.getStringResource("GPT.KeyList.Tooltip.txt"));
            this._listKeywords.setSelectionMode(0);
            this._listKeywords.addListSelectionListener(this);
            this._scrKeywords = new JScrollPane(this._listKeywords);
            this._lblKeywords = UtilGui.createLabelForComponent(this._listKeywords, RB.getStringResource("GPT.Lbl.KeyWd.txt"));
            this._btnAddKeyword = UtilGui.createButton(RB.getStringResource("GPT.Btn.Add1.txt"));
            this._btnAddKeyword.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    int count = GeneralPropertyTab.this._keywordsListModel.size();
                    try {
                        ListElement le = GeneralPropertyTab.this.doAddkeyword(count);
                        if (le != null) {
                            GeneralPropertyTab.this._keywordsListModel.addElement(le);
                        }
                    }
                    catch (RemoteException e) {
                        UtilGui.displayRemoteException(e);
                    }
                }
            });
            this._btnEditKeyword = UtilGui.createButton(RB.getStringResource("GPT.Btn.Edit.txt"));
            this._btnEditKeyword.setEnabled(false);
            this._btnEditKeyword.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    int selected = GeneralPropertyTab.this._listKeywords.getSelectedIndex();
                    if (selected != -1) {
                        ListElement le = (ListElement)GeneralPropertyTab.this._keywordsListModel.get(selected);
                        try {
                            if (GeneralPropertyTab.this.doEditKeyword(le)) {
                                GeneralPropertyTab.this._keywordsListModel.set(selected, le);
                            }
                        }
                        catch (RemoteException e) {
                            UtilGui.displayRemoteException(e);
                        }
                    }
                }
            });
            this._btnDeleteKeyword = UtilGui.createButton(RB.getStringResource("GPT.Btn.Del1.txt"));
            this._btnDeleteKeyword.setEnabled(false);
            this._btnDeleteKeyword.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    int selected = GeneralPropertyTab.this._listKeywords.getSelectedIndex();
                    if (selected != -1) {
                        ListElement le = (ListElement)GeneralPropertyTab.this._keywordsListModel.get(selected);
                        try {
                            if (GeneralPropertyTab.this.doRemoveKeyword(le)) {
                                GeneralPropertyTab.this._keywordsListModel.remove(selected);
                                GeneralPropertyTab.this.setEnabledStateOfEditDeleteKeywordButtons();
                            }
                        }
                        catch (RemoteException e) {
                            UtilGui.displayRemoteException(e);
                        }
                    }
                }
            });
        }
        if (this._showResponsibleParties) {
            this._mdlResponsibleParties = new GeneralResponsiblePartyModel();
            this._mdlResponsibleParties.addTableModelListener(this.createTableModelListener());
            this._tblResponsibleParties = new WsTable((WsAbstractTableModel)this._mdlResponsibleParties);
            this._lblResponsibleParties = UtilGui.createLabelForComponent((Component)this._tblResponsibleParties, RB.getStringResource("GPT.Lbl.Responsible.txt"));
            this._tblResponsibleParties.getTableHeader().setReorderingAllowed(false);
            this._tblResponsibleParties.setToolTipText(RB.getStringResource("GPT.Tooltip.Responsible.txt"));
            this._tblResponsibleParties.setRowHeaderVisible(false);
            this._tblResponsibleParties.setColumnHidingEnabled(false);
            this._tblResponsibleParties.setColumnHoldingEnabled(false);
            this._tblResponsibleParties.setAutoResizeMode(4);
            this._tblResponsibleParties.setUndoManager((UndoManager)this.getWAUndoManager());
            this._tblResponsibleParties.getSelectionModel().addListSelectionListener(this.createTableSelectionListener());
            this._btnAddResponsibleParty = UtilGui.createButton(RB.getStringResource("GPT.Btn.Add2.txt"));
            this._btnAddResponsibleParty.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    try {
                        GeneralPropertyTab.this.addResponsibleParty();
                    }
                    catch (RemoteException e) {
                        UtilGui.displayRemoteException(e);
                    }
                }
            });
            this._btnDeleteResponsibleParty = UtilGui.createButton(RB.getStringResource("GPT.Btn.Del2.txt"));
            this._btnDeleteResponsibleParty.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    GeneralPropertyTab.this.deleteResponsibleParty();
                }
            });
            this._scrResponsibleParties = new JScrollPane((Component)this._tblResponsibleParties);
            this._scrResponsibleParties.setToolTipText(RB.getStringResource("GPT.Tooltip.Responsible.txt"));
            if (this._showHideFromUser) {
                this._hideFromUserCB = UtilGui.createCheckBox(RB.getStringResource("GPT.Lbl.HFU.txt"));
            }
        }
    }

    private TableModelListener createTableModelListener() {
        return new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                if (e.getType() == 0) {
                    GeneralPropertyTab.this._responsiblePartiesModified = true;
                }
            }
        };
    }

    protected Root getMetadataObject() {
        return this._root;
    }

    protected String getContextLabel() {
        return "";
    }

    private void updateResponsiblePartiesAddDeleteButtons() {
        if (this._showResponsibleParties) {
            boolean editable = this.isEditable();
            this._btnAddResponsibleParty.setEnabled(editable);
            this._btnDeleteResponsibleParty.setEnabled(editable && this._tblResponsibleParties.getSelectedRowsFromSelectedCells().length > 0);
        }
    }

    protected void layoutWidgets() {
        GridLayout gridLayout;
        this.setLayout(new GridBagLayout());
        int row = 0;
        this.add(this._lblName, new GridBagConstraints(0, row, 1, 1, 0.0, 0.0, 18, 0, FIRST_INSETS_IN_TOP_ROW, 0, 0));
        this.add((Component)this._nameTF, new GridBagConstraints(1, row, 0, 1, 1.0, 0.0, 18, 2, NEXT_INSETS_IN_TOP_ROW, 0, 0));
        if (this._showDisplayName) {
            this.add(this._lblDisplayName, new GridBagConstraints(0, ++row, 1, 1, 0.0, 0.0, 18, 0, FIRST_INSETS_IN_ROW, 0, 0));
            this.add((Component)this._displayNameTF, new GridBagConstraints(1, row, 0, 1, 1.0, 0.0, 18, 2, NEXT_INSETS_IN_ROW, 0, 0));
        }
        if (this._showType) {
            this.add(this._lblType, new GridBagConstraints(0, ++row, 1, 1, 0.0, 0.0, 18, 0, FIRST_INSETS_IN_ROW, 0, 0));
            this.add(this._typeValue, new GridBagConstraints(1, row, 2, 1, 1.0, 0.0, 18, 2, NEXT_INSETS_IN_ROW, 0, 0));
        }
        if (this._showDescription) {
            this._scrDescription.setPreferredSize(new Dimension(200, 70));
            this.add(this._lblDescription, new GridBagConstraints(0, ++row, 1, 1, 0.0, 0.0, 18, 0, FIRST_INSETS_IN_ROW, 0, 0));
            this.add(this._scrDescription, new GridBagConstraints(1, row, 2, 1, 1.0, 1.0, 18, 1, NEXT_INSETS_IN_ROW, 0, 0));
        }
        if (this._showContext) {
            this.add(this._lblContext, new GridBagConstraints(0, ++row, 1, 1, 0.0, 0.0, 18, 0, FIRST_INSETS_IN_ROW, 0, 0));
            this.add((Component)this._contextTF, new GridBagConstraints(1, row, 0, 1, 1.0, 0.0, 18, 2, NEXT_INSETS_IN_ROW, 0, 0));
        }
        if (this._showCreated) {
            this.add(this._lblCreated, new GridBagConstraints(0, ++row, 1, 1, 0.0, 0.0, 18, 0, FIRST_INSETS_IN_ROW, 0, 0));
            this.add((Component)this._createdTF, new GridBagConstraints(1, row, 0, 1, 1.0, 0.0, 18, 2, NEXT_INSETS_IN_ROW, 0, 0));
        }
        if (this._showModified) {
            this.add(this._lblModified, new GridBagConstraints(0, ++row, 1, 1, 0.0, 0.0, 18, 0, FIRST_INSETS_IN_ROW, 0, 0));
            this.add((Component)this._modifiedTF, new GridBagConstraints(1, row, 0, 1, 1.0, 0.0, 18, 2, NEXT_INSETS_IN_ROW, 0, 0));
        }
        if (this._showKeywords) {
            ++row;
            JPanel adKeywordsButtonsPanel = new JPanel();
            gridLayout = new GridLayout(3, 1);
            gridLayout.setVgap(5);
            adKeywordsButtonsPanel.setLayout(gridLayout);
            adKeywordsButtonsPanel.add(this._btnAddKeyword);
            adKeywordsButtonsPanel.add(this._btnEditKeyword);
            adKeywordsButtonsPanel.add(this._btnDeleteKeyword);
            this.add(this._lblKeywords, new GridBagConstraints(0, row, 1, 1, 0.0, 0.0, 18, 0, FIRST_INSETS_IN_ROW, 0, 0));
            this.add(this._scrKeywords, new GridBagConstraints(1, row, -1, 1, 1.0, 1.0, 18, 1, NEXT_INSETS_IN_ROW, 0, 0));
            this.add(adKeywordsButtonsPanel, new GridBagConstraints(2, row, 0, 1, 0.0, 0.0, 18, 0, NEXT_INSETS_IN_ROW, 0, 0));
        }
        if (this._showResponsibleParties) {
            ++row;
            JPanel adResponsibilitiesButtonsPanel = new JPanel();
            gridLayout = new GridLayout(2, 1);
            gridLayout.setVgap(5);
            adResponsibilitiesButtonsPanel.setLayout(gridLayout);
            adResponsibilitiesButtonsPanel.add(this._btnAddResponsibleParty);
            adResponsibilitiesButtonsPanel.add(this._btnDeleteResponsibleParty);
            this._scrResponsibleParties.setPreferredSize(new Dimension(200, 80));
            this.add(this._lblResponsibleParties, new GridBagConstraints(0, ++row, 1, 1, 0.0, 0.0, 18, 0, FIRST_INSETS_IN_ROW, 0, 0));
            this.add(this._scrResponsibleParties, new GridBagConstraints(1, row, -1, 1, 1.0, 1.0, 18, 1, NEXT_INSETS_IN_ROW, 0, 0));
            this.add(adResponsibilitiesButtonsPanel, new GridBagConstraints(2, row, 0, 1, 0.0, 0.0, 18, 0, NEXT_INSETS_IN_ROW, 0, 0));
        }
        if (this._showHideFromUser) {
            this.add(this._hideFromUserCB, new GridBagConstraints(0, ++row, 3, 1, 0.0, 0.0, 18, 0, FIRST_INSETS_IN_ROW, 0, 0));
        }
        this._layoutRowCount = row;
    }

    @Override
    protected void smartPopulateStore() throws MdException, RemoteException {
        if (this._showResponsibleParties) {
            this._mdlResponsibleParties.setMetadata(this._root);
        }
        if (this._type == 1) {
            int _flags = 67109132;
            String template = this.getPopulateStoreTemplate(this._root);
            Factory.getInstance().getOMIUtil().getMetadataAllDepths((CMetadata)this._root, null, null, template, _flags);
            this._originalName = this._root.getName();
            if (this._showCreated) {
                String createdBy = this.getCreatedBy();
                String createdDate = this.getDateCreatedValue();
                this._createdDateTFValue = UtilMisc.isStringNullOrEmpty(createdBy) ? createdDate : UtilMisc.getMessage(RB.getStringResource("GPT.Lbl.DateByName.fmt.txt"), createdDate, createdBy);
            }
            if (this._showModified) {
                String modifiedBy = this.getModifiedBy();
                String modifiedDate = this.getDateModifiedValue();
                this._modifiedDateTFValue = UtilMisc.isStringNullOrEmpty(modifiedBy) ? modifiedDate : UtilMisc.getMessage(RB.getStringResource("GPT.Lbl.DateByName.fmt.txt"), modifiedDate, modifiedBy);
            }
            if (this._showResponsibleParties && this._root.getResponsibleParties().size() > 0) {
                this._mdlResponsibleParties.populateStore();
            }
        }
        if (this._showContext) {
            this._context = this.getContext();
        }
        if (this._showKeywords) {
            this._keywordAL = this._root.getKeywords();
        }
        if (this._showHideFromUser) {
            this._hideFromUser = ((PrimaryType)this._root).getIsHidden() != 0;
        }
    }

    protected String getPopulateStoreTemplate(Root root) throws RemoteException {
        String type = root.getCMetadataType();
        String template = "<Templates><" + type + "><Keywords/><ResponsibleParties/></" + type + "></Templates>";
        return template;
    }

    protected String getDateCreatedValue() throws RemoteException {
        String createdDate = UtilMisc.convertDate(this._root.getMetadataCreated());
        return createdDate;
    }

    protected String getDateModifiedValue() throws RemoteException {
        String modifiedDate = UtilMisc.convertDate(this._root.getMetadataUpdated());
        return modifiedDate;
    }

    protected String getDisplayNameValue() {
        return this._displayName;
    }

    protected void setDisplayNameValue(String displayName) {
        this._displayName = displayName;
    }

    @Override
    public void moveDataToView() throws MdException, RemoteException {
        if (this._showType) {
            this._typeValue.setText(this._metadataObjectDisplayType);
            if (this._icon != null) {
                this._typeValue.setIcon(this._icon);
            }
        }
        if (this._showContext) {
            this._contextTF.setText(this._context);
        }
        if (this._type == 1) {
            if (!this._dataPreviouslyMovedToView) {
                this._dataPreviouslyMovedToView = true;
                if (this._isNameUserControlled) {
                    this._config.initializeTextComponent((JTextComponent)this._nameTF, ConfigGeneralPanel.NAME, null);
                } else {
                    this._nameTF.setText(this._root.getName());
                }
                if (this._isDescUserControlled) {
                    this._config.initializeTextComponent((JTextComponent)this._descriptionTA, ConfigGeneralPanel.DESCRIPTION, null);
                } else {
                    this._descriptionTA.setText(this._root.getDesc());
                }
                if (this._showHideFromUser) {
                    this._hideFromUserCB.setSelected(this._hideFromUser);
                }
            } else {
                if (!this._isNameUserControlled) {
                    this._nameTF.setText(this._root.getName());
                }
                if (this._showDescription && !this._isDescUserControlled) {
                    this._descriptionTA.setText(this._root.getDesc());
                }
            }
            if (this._showDisplayName) {
                this._displayNameTF.setText(this._displayName == null ? "" : this._displayName);
            }
            if (this._showCreated) {
                this._createdTF.setText(this._createdDateTFValue);
            }
            if (this._showModified) {
                this._modifiedTF.setText(this._modifiedDateTFValue);
            }
            if (this._showKeywords) {
                AssociationList keywordList = this._keywordAL = this._root.getKeywords();
                this._keywordsListModel.clear();
                for (Keyword k : keywordList) {
                    this._keywordsListModel.addElement(new ListElement(k));
                }
            }
            if (this._showResponsibleParties) {
                this._mdlResponsibleParties.moveDataToModel();
                this.updateResponsiblePartiesAddDeleteButtons();
            }
        } else if (this._type == 0) {
            if (!this._dataPreviouslyMovedToView) {
                Object o;
                this._config.initializeTextComponent((JTextComponent)this._nameTF, ConfigGeneralPanel.NAME, null);
                if (this._showDescription) {
                    this._config.initializeTextComponent((JTextComponent)this._descriptionTA, ConfigGeneralPanel.DESCRIPTION, null);
                }
                if (this._showKeywords && (o = this._config.getInitValue(ConfigGeneralPanel.KEYWORDS, null)) != null) {
                    ArrayList<Object> coll;
                    if (o instanceof Collection) {
                        coll = (ArrayList<Object>)o;
                    } else {
                        coll = new ArrayList<Object>();
                        coll.add(o);
                    }
                    this._keywordsListModel.clear();
                    for (Object e : coll) {
                        String keywordName = e.toString();
                        Keyword keyword = (Keyword)UtilMetadata.createANewComplexObjectToBeAssociatedWithGivenObject((CMetadata)this._root, keywordName, "Keyword");
                        this._keywordAL.add((Object)keyword);
                        this._keywordsListModel.addElement(new ListElement(keyword));
                    }
                }
                this._dataPreviouslyMovedToView = true;
            }
            if (this._showResponsibleParties) {
                this.updateResponsiblePartiesAddDeleteButtons();
            }
        }
    }

    public void setIconForType(Icon icon) {
        this._icon = icon;
    }

    public void setMetadataObjectDisplayType(String metadataObjectDisplayType) {
        this._metadataObjectDisplayType = metadataObjectDisplayType;
    }

    protected String getCreatedBy() {
        if (this._root instanceof PrimaryType) {
            try {
                return MdResponsibilitiesUtil.getCreatedByValue((PrimaryType)((PrimaryType)this._root));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return "";
    }

    protected String getModifiedBy() {
        if (this._root instanceof PrimaryType) {
            try {
                return MdResponsibilitiesUtil.getModifiedByValue((PrimaryType)((PrimaryType)this._root));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return "";
    }

    protected String getContext() throws MdException, RemoteException {
        return "";
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (e.getValueIsAdjusting()) {
            return;
        }
        this.setEnabledStateOfEditDeleteKeywordButtons();
    }

    public String createFinishString() {
        String finishStr = Message.format((String)RB.getStringResource("GPT.FinStr.fmt.txt"), (Object)this._nameTF.getText(), (Object)this._descriptionTA.getText());
        return finishStr;
    }

    private void setEnabledStateOfEditDeleteKeywordButtons() {
        if (this._showKeywords) {
            boolean enable = this._listKeywords.getSelectedIndex() >= 0 && this.isEditable();
            this._btnEditKeyword.setEnabled(enable);
            this._btnDeleteKeyword.setEnabled(enable);
        }
    }

    private ListElement doAddkeyword(int count) throws RemoteException {
        Keyword keyword = (Keyword)UtilMetadata.createANewComplexObjectToBeAssociatedWithGivenObject((CMetadata)this._root, "", "Keyword");
        KeywordPanel keywordPanel = new KeywordPanel(keyword, this.getKeywordNames(), 1);
        MetadataDialog dialog = MetadataDialog.createInstance((JComponent)((Object)this), null, RB.getStringResource("GPT.AddKeywd.DlgTitle.txt"), (MetadataDialogPanel)keywordPanel);
        int retVal = dialog.doModal();
        if (retVal == 1) {
            this._keywordAL.add((Object)keyword);
            this._objectShouldBeMarkedModified = true;
            return new ListElement(keyword);
        }
        MdObjectStore store = (MdObjectStore)keyword.getObjectStore();
        store.deleteObjectFromStore(keyword.getFQID());
        return null;
    }

    private boolean doEditKeyword(ListElement le) throws RemoteException {
        Keyword k = le._keyword;
        Keyword keyword = (Keyword)UtilMetadata.createAChildStoreAndCopyObjectIntoIt((CMetadata)k);
        KeywordPanel keywordPanel = new KeywordPanel(keyword, this.getKeywordNames(), 2);
        MetadataDialog dialog = MetadataDialog.createInstance((JComponent)((Object)this), (CMetadata)keyword, RB.getStringResource("GPT.EditKeywd.DlgTitle.txt"), (MetadataDialogPanel)keywordPanel);
        if (dialog.doModal() == 1) {
            this._objectShouldBeMarkedModified = true;
            return true;
        }
        return false;
    }

    private boolean doRemoveKeyword(ListElement le) throws RemoteException {
        Keyword k = le._keyword;
        String msg = this.getMessageForDeleteKeywordDialog(k);
        if (MessageUtil.displayMessage((String)msg, (String)RB.getStringResource("GPT.ConfDel.DlgTitle.txt"), (int)3, (int)0) == 0) {
            k.delete();
            this._objectShouldBeMarkedModified = true;
            return true;
        }
        return false;
    }

    protected String getMessageForDeleteKeywordDialog(Keyword keyword) throws RemoteException {
        return Message.format((ResourceBundle)RB.getResources(), (String)"GPT.ConfDel.msg.fmt.txt", (Object)keyword.getName());
    }

    private String[] getKeywordNames() throws RemoteException {
        int size = this._keywordsListModel.size();
        String[] names = new String[size];
        for (int i = 0; i < size; ++i) {
            ListElement le = (ListElement)this._keywordsListModel.getElementAt(i);
            names[i] = le.getName();
        }
        return names;
    }

    @Override
    protected boolean dataValidate() throws RemoteException {
        String nameToBeValidated;
        if (this._nameEnabled && !this.validateName(nameToBeValidated = this._nameTF.getText())) {
            this._nameTF.requestFocus();
            return false;
        }
        return this.validateResponsibleParties();
    }

    protected boolean validateName(String nameToBeValidated) throws RemoteException {
        if ((nameToBeValidated = nameToBeValidated.trim()).length() == 0) {
            MessageUtil.displayMessage((String)Message.format((String)RB.getStringResource("GPT.NoName.fmt.txt"), (Object)this._metadataObjectDisplayType), (String)RB.getStringResource("COM.NameErr.title.txt"), (int)0);
            return false;
        }
        try {
            UtilMetadata.validateCharactersInNameOfItemInFolder(nameToBeValidated);
        }
        catch (LogicalTypeException lte) {
            MessageUtil.displayMessage((String)lte.getMessage(), (String)RB.getStringResource("COM.ErrDlgTitle.txt"), (int)0, (int)-1);
            return false;
        }
        boolean checkNameForDuplicates = true;
        if (this._type == 1 && this._originalName.equalsIgnoreCase(nameToBeValidated)) {
            checkNameForDuplicates = false;
        }
        if (checkNameForDuplicates) {
            try {
                if (this.checkForDuplicate(nameToBeValidated)) {
                    return false;
                }
            }
            catch (MdException e) {
                UtilGui.displayMdException(e);
                return false;
            }
            catch (LogicalTypeException e) {
                UtilGui.displayExceptionError(e);
                return false;
            }
        }
        return true;
    }

    protected boolean checkForDuplicate(String nameToBeValidated) throws RemoteException, LogicalTypeException, MdException {
        List<? extends Root> objectsInContext = this.getOtherObjectsInContext();
        int count = objectsInContext.size();
        for (int i = 0; i < count; ++i) {
            Root rootInList = objectsInContext.get(i);
            if (!nameToBeValidated.equalsIgnoreCase(rootInList.getName()) || this._root.getFQID().equalsIgnoreCase(rootInList.getFQID())) continue;
            String text = Message.format((ResourceBundle)RB.getResources(), (String)"COM.Exsts.fmt.txt", (Object)nameToBeValidated);
            MessageUtil.displayMessage((String)text, (String)RB.getStringResource("COM.NameErr.title.txt"), (int)0);
            return true;
        }
        return false;
    }

    protected List<? extends Root> getOtherObjectsInContext() throws MdException, RemoteException {
        return new ArrayList();
    }

    protected boolean validateResponsibleParties() {
        if (this._showResponsibleParties) {
            int nResponsibleParties = this._mdlResponsibleParties.getRowCount();
            HashMap tableValues = new HashMap();
            for (int iResponsibleParty = 0; iResponsibleParty < nResponsibleParties; ++iResponsibleParty) {
                String sName = (String)this._mdlResponsibleParties.getValueAt(iResponsibleParty, 0);
                String sRole = (String)this._mdlResponsibleParties.getValueAt(iResponsibleParty, 1);
                String nRole = sRole.toUpperCase();
                if (tableValues.containsKey(sName)) {
                    List list = (List)tableValues.get(sName);
                    if (list.contains(nRole)) {
                        UtilGui.displayError(UtilMisc.getMessage(RB.getStringResource("GPT.DuplicateResponsibleParty.fmt.txt"), sName, sRole));
                        return false;
                    }
                    list.add(nRole);
                    continue;
                }
                ArrayList<String> newList = new ArrayList<String>();
                newList.add(nRole);
                tableValues.put(sName, newList);
            }
        }
        return true;
    }

    @Override
    public void moveDataToStore() throws MdException, RemoteException {
        String newString;
        String oldString;
        if (!this._isNameUserControlled) {
            oldString = this._root.getName();
            newString = this._nameTF.getText().trim();
            if (!newString.equals(oldString)) {
                this._objectShouldBeMarkedModified = false;
                this._root.setName(newString);
            }
        }
        if (this._showDisplayName) {
            oldString = this.getDisplayNameValue();
            newString = this._displayNameTF.getText().trim();
            if (!newString.equals(oldString)) {
                this._objectShouldBeMarkedModified = false;
                this.setDisplayNameValue(newString);
            }
        }
        if (this._showDescription && !this._isDescUserControlled) {
            oldString = this._root.getDesc();
            newString = this._descriptionTA.getText().trim();
            if (!newString.equals(oldString)) {
                this._objectShouldBeMarkedModified = false;
                this._root.setDesc(newString);
            }
        }
        if (this._showResponsibleParties && this._responsiblePartiesModified) {
            this._objectShouldBeMarkedModified = true;
            this._mdlResponsibleParties.moveDataToStore();
            this._responsiblePartiesModified = false;
        }
        if (this._showHideFromUser && this._hideFromUser != this._hideFromUserCB.isSelected()) {
            ((PrimaryType)this._root).setIsHidden(this._hideFromUserCB.isSelected() ? 1 : 0);
            this._hideFromUser = this._hideFromUserCB.isSelected();
            this._objectShouldBeMarkedModified = true;
        }
        if (this._objectShouldBeMarkedModified) {
            this._root.setName(this._root.getName());
            this._objectShouldBeMarkedModified = false;
        }
    }

    public void setEditable(boolean editable) {
        super.setEditable(editable);
        this._nameTF.setEditable(editable);
        if (this._showDisplayName) {
            this._displayNameTF.setEditable(editable);
        }
        if (this._showDescription) {
            this._descriptionTA.setEditable(editable);
        }
        if (this._showKeywords) {
            this._btnAddKeyword.setEnabled(editable);
        }
        if (this._showHideFromUser) {
            this._hideFromUserCB.setEnabled(editable);
        }
        this.setEnabledStateOfEditDeleteKeywordButtons();
    }

    protected ListSelectionListener createTableSelectionListener() {
        return new cTableSelectionListener();
    }

    private void addResponsibleParty() throws RemoteException {
        String[] saPersons = this._mdlResponsibleParties.getPersons();
        if (saPersons.length == 0) {
            MessageUtil.displayMessage((String)RB.getStringResource("GPT.NoPersonsError.txt"));
        } else {
            WsEnumeratedTableColumn colName = (WsEnumeratedTableColumn)this._mdlResponsibleParties.getColumn(0);
            if (colName.getDefaultValue() == null) {
                colName.createDefaultValue();
                String[] persons = colName.getPossibleValues();
                if (persons != null) {
                    List<String> list;
                    Identity identity = null;
                    try {
                        MdFactory mdObjectFactory = Factory.getInstance().getMdFactory();
                        MdOMRConnection mdOMRConnection = mdObjectFactory.getConnection();
                        if (mdOMRConnection != null) {
                            identity = mdOMRConnection.getIdentityOfUserConnected(this._root.getObjectStore(), UtilMetadata.makeRepositoryFQIDFromRoot(this._root));
                        }
                    }
                    catch (MdException mde) {
                        identity = null;
                    }
                    if (identity instanceof Person && (list = Arrays.asList(persons)).contains(identity.getName())) {
                        colName.setDefaultValue(identity.getName());
                    }
                }
            }
            this._tblResponsibleParties.undoableInsertNewRowAfterLastSelectedRow();
            this._responsiblePartiesModified = true;
        }
    }

    private void deleteResponsibleParty() {
        this._tblResponsibleParties.undoableDeleteSelectedRows();
        this._responsiblePartiesModified = true;
    }

    protected int getType() {
        return this._type;
    }

    public void saveSettingsAndCleanUp() {
        Config.Callback cb = this._config.getCallback(ConfigGeneralPanel.SAVE_SETTINGS_AND_CLOSE);
        if (cb != null) {
            try {
                cb.callback(this._onOKWasSelected ? Boolean.TRUE : Boolean.FALSE);
            }
            catch (RemoteException re) {
                UtilGui.displayRemoteException(re);
            }
            catch (LogicalTypeException e) {
                UtilGui.displayExceptionError(e);
            }
        }
    }

    public void onParentOK() {
        Config.Callback cb;
        this._onOKWasSelected = true;
        if (!this._config.isUserControlled(ConfigGeneralPanel.LASTUPDATED_UNAFFECTED_BY_CHANGELIST)) {
            try {
                MdObjectStore store = (MdObjectStore)this._root.getObjectStore();
                Vector changeList = store.getChangeList();
                if (changeList.size() > 0) {
                    this._root.setName(this._root.getName());
                }
            }
            catch (RemoteException e) {
                UtilGui.displayRemoteException(e);
            }
        }
        if ((cb = this._config.getCallback(ConfigGeneralPanel.ON_PARENT_OK)) != null) {
            try {
                cb.callback(null);
            }
            catch (RemoteException re) {
                UtilGui.displayRemoteException(re);
            }
            catch (LogicalTypeException e) {
                UtilGui.displayExceptionError(e);
            }
        }
    }

    public JComponent getUserControlledComponent(Config.Element element) {
        if (element == ConfigGeneralPanel.NAME && this._isNameUserControlled) {
            return this._nameTF;
        }
        if (element == ConfigGeneralPanel.DESCRIPTION && this._isDescUserControlled) {
            return this._descriptionTA;
        }
        return null;
    }

    class cTableSelectionListener
    implements ListSelectionListener {
        cTableSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            GeneralPropertyTab.this.updateResponsiblePartiesAddDeleteButtons();
        }
    }

    static class ListElement {
        private Keyword _keyword;

        ListElement(Keyword keyword) {
            this._keyword = keyword;
        }

        String getName() throws RemoteException {
            return this._keyword.getName();
        }

        public String toString() {
            String listName;
            try {
                listName = this._keyword.getName();
                if (listName.length() == 0 && (listName = this._keyword.getDesc()).length() == 0) {
                    listName = RB.getStringResource("COM.MissnAttrName.txt");
                }
            }
            catch (RemoteException e) {
                UtilGui.displayRemoteException(e);
                listName = RB.getStringResource("COM.REOccurd.txt");
            }
            return listName;
        }
    }
}

