/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.logical.visuals;

import com.sas.metadata.logical.Factory;
import com.sas.metadata.logical.FolderInterface;
import com.sas.metadata.logical.LogicalTypeException;
import com.sas.metadata.logical.ObjectContainer;
import com.sas.metadata.logical.UtilMetadata;
import com.sas.metadata.logical.UtilMisc;
import com.sas.metadata.logical.UtilPlatformServices;
import com.sas.metadata.logical.visuals.FolderGeneralTabVC;
import com.sas.metadata.logical.visuals.RB;
import com.sas.metadata.logical.visuals.UtilGui;
import com.sas.text.Message;
import com.sas.workspace.MessageUtil;
import java.rmi.RemoteException;
import java.util.ResourceBundle;

public final class FolderUnderContentMappedRootGeneralTab
extends FolderGeneralTabVC {
    private static final long serialVersionUID = 1L;
    private FolderInterface _parent;
    private ObjectContainer _tc;
    private Factory _factory;

    FolderUnderContentMappedRootGeneralTab(FolderInterface parent, Factory factory, ObjectContainer loc) {
        super(true);
        this._parent = parent;
        this._factory = factory;
        this._tc = loc;
    }

    @Override
    protected boolean dataValidate() throws RemoteException {
        String newFolderName = this._txtName.getText().trim();
        this._txtName.requestFocus();
        if (newFolderName.length() == 0) {
            MessageUtil.displayMessage((String)RB.getStringResource("COM.NoName.txt"), (String)RB.getStringResource("FGTP.ErrDlgTitle.txt"), (int)0);
            return false;
        }
        try {
            UtilMetadata.validateCharactersInNameOfItemInFolder(newFolderName);
            int ret = this._parent.childFolderExists(newFolderName);
            if (ret == 1 || ret == 2) {
                String text = Message.format((ResourceBundle)RB.getResources(), (String)(ret == 1 ? "COM.Exsts.fmt.txt" : "COM.ExstsInv.fmt.txt"), (Object)newFolderName);
                MessageUtil.displayMessage((String)text, (String)RB.getStringResource("FGTP.ErrDlgTitle.txt"), (int)0);
                return false;
            }
        }
        catch (LogicalTypeException lte) {
            MessageUtil.displayMessage((String)lte.getMessage(), (String)RB.getStringResource("FGTP.ErrDlgTitle.txt"), (int)0);
            return false;
        }
        try {
            com.sas.services.information.metadata.FolderInterface fi = (com.sas.services.information.metadata.FolderInterface)UtilPlatformServices.getSmartObject(this._parent);
            com.sas.services.information.metadata.FolderInterface fiNewFolder = fi.makeSubfolder(newFolderName);
            String descText = this._txtDescription.getText();
            if (descText != null && descText.length() > 0) {
                fiNewFolder.setDescription(descText);
            }
            this._tc.setObject(fiNewFolder);
            fi.update();
        }
        catch (Exception e) {
            this._factory.error(e, null);
            UtilGui.displayError(UtilMisc.getMessage(RB.getStringResource("FCMRGT.Excp.ex.fmt.txt"), newFolderName, e.getMessage()));
            return false;
        }
        return true;
    }
}

