/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.logical.visuals;

import com.sas.metadata.logical.FolderInterface;
import com.sas.metadata.logical.LogicalTypeException;
import com.sas.metadata.logical.UtilMetadata;
import com.sas.metadata.logical.visuals.FolderGeneralTabVC;
import com.sas.metadata.logical.visuals.RB;
import com.sas.metadata.logical.visuals.UtilGui;
import com.sas.metadata.remote.Tree;
import com.sas.text.Message;
import com.sas.workspace.MessageUtil;
import java.rmi.RemoteException;
import java.util.ResourceBundle;

public class FolderGeneralTabPanel
extends FolderGeneralTabVC {
    private static final long serialVersionUID = 1L;
    private Tree _tree;
    private int _type;
    private FolderInterface _parent;

    public FolderGeneralTabPanel(FolderInterface parent, Tree tree, int type) {
        super(type == 0);
        this._tree = tree;
        this._type = type;
        this._parent = parent;
    }

    @Override
    public void moveDataToView() throws RemoteException {
        if (this._type == 1) {
            this._txtName.setText(this._tree.getName());
            this._txtDescription.setText(this._tree.getDesc());
        }
    }

    @Override
    public void moveDataToStore() throws RemoteException {
        if (this._type == 0) {
            this._tree.setName(this._txtName.getText().trim());
        }
        this._tree.setDesc(this._txtDescription.getText());
    }

    @Override
    protected boolean dataValidate() throws RemoteException {
        if (this._type == 0) {
            String newFolderName = this._txtName.getText().trim();
            if (newFolderName.length() == 0) {
                MessageUtil.displayMessage((String)RB.getStringResource("COM.NoName.txt"), (String)RB.getStringResource("FGTP.ErrDlgTitle.txt"), (int)0);
                this._txtName.requestFocus();
                return false;
            }
            try {
                int ret = this._parent.childFolderExists(newFolderName);
                if (ret == 1 || ret == 2) {
                    String text = Message.format((ResourceBundle)RB.getResources(), (String)(ret == 1 ? "COM.Exsts.fmt.txt" : "COM.ExstsInv.fmt.txt"), (Object)newFolderName);
                    MessageUtil.displayMessage((String)text, (String)RB.getStringResource("FGTP.ErrDlgTitle.txt"), (int)0);
                    return false;
                }
                return UtilMetadata.validateCharactersInNameOfItemInFolder(newFolderName);
            }
            catch (LogicalTypeException e) {
                this._txtName.requestFocus();
                UtilGui.displayExceptionError(e);
                return false;
            }
        }
        return true;
    }
}

