/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.logical.visuals;

import com.sas.metadata.logical.LogicalTypeException;
import com.sas.metadata.logical.visuals.ConfigPanelInterface;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import javax.swing.text.JTextComponent;

public class Config {
    public static final int _DISABLEABLE = 1;
    public static final int _INITIALIZABLE = 2;
    public static final int _FILTERABLE = 4;
    public static final int _VISIBILITY = 8;
    public static final int _CALLBACKABLE = 16;
    public static final int _USERCONTROLLABLE = 32;
    private HashMap<Element, Callback> _callbackMap = new HashMap();
    private HashSet<Element> _disabledElements = new HashSet();
    private HashMap<Element, Set<Filter>> _filterMap = new HashMap();
    private HashSet<Element> _hiddenElements = new HashSet();
    private HashSet<Element> _setVisibleInvoked = new HashSet();
    private HashMap<Element, Object> _initMap = new HashMap();
    private HashSet<Element> _userControlledElements = new HashSet();
    private double _usageVersion = -1.0;

    public Config() {
    }

    public Config(double usageVerion) {
        this();
        this._usageVersion = usageVerion;
    }

    public double getUsageVersion() {
        return this._usageVersion;
    }

    public void setCallback(Element element, Callback callback) {
        if ((element._properties & 0x10) == 0) {
            throw new IllegalStateException("Callback is not supported for " + element);
        }
        this._callbackMap.put(element, callback);
    }

    public void setFilter(Element element, Set<Filter> filters) {
        if ((element._properties & 4) == 0) {
            throw new IllegalStateException("Filtering is not supported for " + element);
        }
        this._filterMap.put(element, filters);
    }

    public void setInitValue(Element element, Object value) {
        if ((element._properties & 2) == 0) {
            throw new IllegalStateException("Initialization is not supported for " + element);
        }
        element._configPanelInterface.validateInitValue(element, value);
        this._initMap.put(element, value);
    }

    public void setEnabled(Element element, boolean enabled) {
        if ((element._properties & 1) == 0) {
            throw new IllegalStateException("Controlling the enabled nature is not supported for " + element);
        }
        if (enabled) {
            this._disabledElements.remove(element);
        } else {
            this._disabledElements.add(element);
        }
    }

    public void setVisible(Element element, boolean visible) {
        if ((element._properties & 8) == 0) {
            throw new IllegalStateException("Controlling the visibility is not supported for " + element);
        }
        if (visible) {
            this._hiddenElements.remove(element);
        } else {
            this._hiddenElements.add(element);
        }
        this._setVisibleInvoked.add(element);
    }

    public boolean setVisibileInvoked(Element element) {
        return this._setVisibleInvoked.contains(element);
    }

    public void setUserControlled(Element element) {
        if ((element._properties & 0x20) == 0) {
            throw new IllegalStateException("User control is not supported for " + element);
        }
        this._userControlledElements.add(element);
    }

    public Callback getCallback(Element element) {
        return this._callbackMap.get(element);
    }

    public Set<Filter> getFilter(Element element) {
        return this._filterMap.get(element);
    }

    public Object getInitValue(Element element, Object defaultValue) {
        Object retVal = this._initMap.get(element);
        return retVal == null ? defaultValue : retVal;
    }

    public boolean isEnabled(Element element) {
        return !this._disabledElements.contains(element);
    }

    public boolean isVisible(Element element) {
        return !this._hiddenElements.contains(element);
    }

    public boolean isUserControlled(Element element) {
        return this._userControlledElements.contains(element);
    }

    public void initializeTextComponent(JTextComponent tc, Element element, Object defaultValue) {
        Object initVal = this.getInitValue(element, defaultValue);
        if (initVal == null) {
            return;
        }
        tc.setText(initVal.toString());
    }

    public static class Selection
    extends Base {
        public Selection(ConfigPanelInterface configPanelInterface, String name) {
            super(configPanelInterface, name);
        }
    }

    public static class Filter
    extends Base {
        public Filter(ConfigPanelInterface configPanelInterface, String name) {
            super(configPanelInterface, name);
        }
    }

    public static class Element
    extends Base {
        int _properties;

        public Element(ConfigPanelInterface configPanelInterface, String name, int properties) {
            super(configPanelInterface, name);
            this._properties = properties;
        }

        public String toString() {
            return this._name;
        }
    }

    public static abstract class Callback {
        public abstract void callback(Object var1) throws LogicalTypeException, RemoteException;
    }

    private static class Base {
        protected String _name;
        protected ConfigPanelInterface _configPanelInterface;

        private Base(ConfigPanelInterface configPanelInterface, String name) {
            this._name = name;
            this._configPanelInterface = configPanelInterface;
        }
    }
}

