/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.logical.visuals;

import com.sas.metadata.logical.Factory;
import com.sas.metadata.logical.FolderInterface;
import com.sas.metadata.logical.UtilMetadata;
import com.sas.metadata.logical.UtilMetadataRemote;
import com.sas.metadata.logical.visuals.ActionNewFolderAbstract;
import com.sas.metadata.logical.visuals.Config;
import com.sas.metadata.logical.visuals.FolderContentMappingTabPanel;
import com.sas.metadata.logical.visuals.FolderGeneralTabPanel;
import com.sas.metadata.logical.visuals.Images;
import com.sas.metadata.logical.visuals.RB;
import com.sas.metadata.logical.visuals.UtilGui;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.Tree;
import com.sas.services.ServiceException;
import com.sas.services.information.ChildServerInterface;
import com.sas.services.information.MetadataServerInterface;
import com.sas.util.UsageVersion;
import com.sas.workspace.WAPropertyTab;
import com.sas.workspace.WAWizardDialog;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.rmi.RemoteException;
import javax.swing.Icon;

public class ActionNewFolder
extends ActionNewFolderAbstract {
    private static final long serialVersionUID = 1L;
    static final String TEMP_FOLDER_NAME = "Temp Folder";
    static final UsageVersion CURRENT_FOLDER_VERSION = new UsageVersion(1, 0);

    public ActionNewFolder(FolderInterface parent, Frame frame, Factory factory, Config config) {
        super(parent, frame, factory, config);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionPerformed(ActionEvent e) {
        String reposID = UtilMetadata.get8CharReposidFromFQID(this._parent.getID());
        if (reposID == null) {
            return;
        }
        ChildServerInterface childServer = null;
        try {
            MetadataServerInterface server = Factory.getInstance().getMetadataServerInterface();
            if (server == null) {
                return;
            }
            childServer = server.newChild(true);
            String key = this._parent.getID() + "/" + this._parent.getTypeInterface().getMetadataType();
            com.sas.services.information.metadata.FolderInterface parentFolder = (com.sas.services.information.metadata.FolderInterface)childServer.fetch(key, true);
            String folderName = "Temp Folder: " + System.currentTimeMillis();
            com.sas.services.information.metadata.FolderInterface childFolder = parentFolder.makeSubfolder(folderName);
            Tree newTree = (Tree)childFolder.getRepositoryEntity();
            MdObjectStore store = (MdObjectStore)newTree.getObjectStore();
            NewFolderWizard wizard = new NewFolderWizard(this._parent, newTree);
            wizard.show();
            boolean added = false;
            if (wizard.getReturnValue() == 1) {
                this._frame.setCursor(Cursor.getPredefinedCursor(3));
                try {
                    childServer.flush();
                    newTree = (Tree)UtilMetadata.locateExistingObject(store, "Tree", newTree.getFQID());
                    added = true;
                }
                catch (ServiceException se) {
                    UtilGui.displayExceptionError((Exception)((Object)se));
                }
                catch (MdException mde) {
                    UtilGui.displayMdException(mde);
                }
                finally {
                    this._frame.setCursor(Cursor.getPredefinedCursor(0));
                }
            }
            if (added) {
                this.linkNewTreeToParentVisual(newTree);
                if (this._parent.isRoot()) {
                    try {
                        UtilMetadataRemote.flushBIPTree();
                    }
                    catch (Exception ex) {
                        this._factory.error(ex, null);
                        UtilGui.displayExceptionError(ex);
                    }
                }
            }
        }
        catch (ServiceException se) {
            UtilGui.displayExceptionError((Exception)((Object)se));
        }
        catch (RemoteException re) {
            UtilGui.displayRemoteException(re);
        }
        finally {
            try {
                if (childServer != null) {
                    childServer.rollback();
                }
            }
            catch (Exception se) {}
        }
    }

    private class NewFolderWizard
    extends WAWizardDialog {
        private static final long serialVersionUID = 1L;

        public NewFolderWizard(FolderInterface parentNode, Tree newTree) throws RemoteException {
            super(ActionNewFolder.this._frame, true);
            String strTitle = RB.getStringResource("NFW.title.txt");
            Icon icon = Images.getNameDescriptionWizardImage();
            this.setTitle(strTitle);
            this.addTab(RB.getStringResource("COM.GPV.Tab.txt"), RB.getStringResource("COM.GPV.Tab.txt"), (WAPropertyTab)new FolderGeneralTabPanel(parentNode, newTree, 0), "gen", icon, true);
            if (parentNode.isRoot()) {
                this.addTab(RB.getStringResource("FCMTP.Tab.txt"), RB.getStringResource("FCMTP.Tab.txt"), (WAPropertyTab)new FolderContentMappingTabPanel(newTree, 0, ActionNewFolder.this._config), "cm", icon, true);
            }
        }
    }
}

