/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.logical.batch;

import com.sas.codepolicy.SASScope;
import com.sas.metadata.logical.batch.BatchDriver2;
import com.sas.metadata.logical.batch.BatchDriverOptions;
import com.sas.metadata.logical.batch.RB;
import com.sas.metadata.remote.Identity;
import com.sas.metadata.remote.IdentityGroup;
import com.sas.metadata.remote.Login;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.MdStore;
import com.sas.metadata.remote.Person;
import com.sas.services.util.UncaughtRuntimeExceptionHandler;
import com.sas.text.Message;
import java.rmi.RemoteException;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.ResourceBundle;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.MissingOptionException;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.ParseException;

@SASScope
public class ChangeLoginDomain2
extends BatchDriver2 {
    public static final String OPTION_NOEXECUTE = "noexecute";
    public static final String OPTION_LIST = "list";
    public static final String OPTION_VERBOSE = "verbose";
    protected boolean _noExecute = false;
    protected boolean _verbose = false;
    protected boolean _listDomains = false;
    protected String _fromDomain = null;
    protected String _toDomain = null;
    private static final String BACKSLASHSTYLE_PATTERN = "^([^\\\\]+)\\\\(.*)$";
    private static final String ATSIGNSTYLE_PATTERN = "^(.*)@([^@]+)$";

    public ChangeLoginDomain2() {
        this._logFilePrefix = "ChangeLoginDomain";
        this._logContextName = "com.sas.metadata.logical.batch";
        this._logTimestamps = false;
    }

    public void setListDomains(boolean listDomains) {
        this._listDomains = listDomains;
    }

    public void setNoExecute(boolean noexecute) {
        this._noExecute = noexecute;
    }

    public void setVerbose(boolean verbose) {
        this._verbose = verbose;
    }

    public int execute() throws Exception {
        try {
            this.setInitializeLogicalTypes(false);
            this.initialize();
            this._logger.info(Message.format((ResourceBundle)RB.getResources(), (String)"ChangeLoginDomain.Start.fmt.log", (Object)new Date()));
            this.logConnectionInfo();
            if (this._listDomains) {
                this.listDomains();
            } else {
                this.changeDomain();
            }
        }
        catch (Exception e) {
            this._rc |= 8;
            throw e;
        }
        finally {
            this.terminate();
        }
        return this._rc;
    }

    private void listDomains() throws MdException, RemoteException {
        int loginCount = 0;
        MdObjectStore store = this._factory.createObjectStore();
        HashSet<String> domains = new HashSet<String>();
        int flags = 8452;
        String options = "<Templates><Login UserID=''><AssociatedIdentity/></Login><IdentityGroup Name=''/><Person Name=''/></Templates>";
        List logins = this._factory.getOMIUtil().getMetadataObjectsSubset((MdStore)store, "", "Login", flags, options);
        Pattern domainStyle1 = Pattern.compile(BACKSLASHSTYLE_PATTERN);
        Pattern domainStyle2 = Pattern.compile(ATSIGNSTYLE_PATTERN);
        for (Login login : logins) {
            String domain;
            String userID = login.getUserID();
            Matcher matcher = domainStyle1.matcher(userID);
            if (matcher.matches()) {
                domain = matcher.group(1);
            } else {
                matcher = domainStyle2.matcher(userID);
                if (!matcher.matches()) continue;
                domain = matcher.group(2);
            }
            ++loginCount;
            if (this._verbose) {
                this.logLogin(login);
            }
            domains.add(domain.toLowerCase());
        }
        if (loginCount == 0) {
            this._logger.info(RB.getStringResource("ChangeLoginDomain.NoMatchingDomains.txt"));
        } else {
            this._logger.info(Message.format((ResourceBundle)RB.getResources(), (String)"ChangeLoginDomain.FoundLoginsAndDomains.fmt.txt", (Object)new Integer(loginCount), (Object)new Integer(domains.size())));
            for (String domain : domains) {
                this._logger.info("  " + domain);
            }
        }
    }

    private void changeDomain() throws MdException, RemoteException {
        boolean noToDomain;
        int loginCount = 0;
        boolean bl = noToDomain = this._toDomain == null || this._toDomain.length() == 0;
        if (noToDomain) {
            this._logger.info(Message.format((ResourceBundle)RB.getResources(), (String)"ChangeLoginDomain.RemovingDomain.fmt.log", (Object)this._fromDomain));
        } else {
            this._logger.info(Message.format((ResourceBundle)RB.getResources(), (String)"ChangeLoginDomain.UpdatingDomain.fmt.log", (Object)this._fromDomain, (Object)this._toDomain));
        }
        MdObjectStore store = this._factory.createObjectStore();
        int flags = 8580;
        String options = "<XMLSelect search=\"*[@UserID?'" + this.encodeXMLAttribute(this._fromDomain) + "']\"/><Templates><Login UserID=''><AssociatedIdentity/></Login><IdentityGroup Name=''/><Person Name=''/></Templates>";
        List logins = this._factory.getOMIUtil().getMetadataObjectsSubset((MdStore)store, "", "Login", flags, options);
        Pattern domainStyle1 = Pattern.compile(BACKSLASHSTYLE_PATTERN);
        Pattern domainStyle2 = Pattern.compile(ATSIGNSTYLE_PATTERN);
        for (Login login : logins) {
            boolean backslashDomainStyle;
            String remainder;
            String domain;
            String userID = login.getUserID();
            Matcher matcher = domainStyle1.matcher(userID);
            if (matcher.matches()) {
                domain = matcher.group(1);
                remainder = matcher.group(2);
                backslashDomainStyle = true;
            } else {
                matcher = domainStyle2.matcher(userID);
                if (!matcher.matches()) continue;
                domain = matcher.group(2);
                remainder = matcher.group(1);
                backslashDomainStyle = false;
            }
            if (!domain.equalsIgnoreCase(this._fromDomain)) continue;
            ++loginCount;
            if (this._verbose) {
                this.logLogin(login);
            }
            String newUserID = noToDomain ? remainder : (backslashDomainStyle ? this._toDomain + "\\" + remainder : remainder + "@" + this._toDomain);
            if (this._noExecute) continue;
            login.setUserID(newUserID);
        }
        if (loginCount == 0) {
            this._logger.info(RB.getStringResource("ChangeLoginDomain.NoMatchingDomains.txt"));
        } else if (this._noExecute) {
            this._logger.info(Message.format((ResourceBundle)RB.getResources(), (String)"ChangeLoginDomain.FoundLogins.fmt.txt", (Object)new Integer(loginCount)));
        } else {
            store.updatedMetadataAll();
            this._logger.info(Message.format((ResourceBundle)RB.getResources(), (String)"ChangeLoginDomain.UpdatedLogins.fmt.txt", (Object)new Integer(loginCount)));
        }
    }

    private void logLogin(Login login) throws MdException, RemoteException {
        Identity identity = login.getAssociatedIdentity();
        if (identity instanceof Person) {
            this._logger.info(Message.format((ResourceBundle)RB.getResources(), (String)"ChangeLoginDomain.FoundUserLogin.fmt.txt", (Object)login.getUserID(), (Object)login.getId(), (Object)identity.getName()));
        } else if (identity instanceof IdentityGroup) {
            this._logger.info(Message.format((ResourceBundle)RB.getResources(), (String)"ChangeLoginDomain.FoundGroupLogin.fmt.txt", (Object)login.getUserID(), (Object)login.getId(), (Object)identity.getName()));
        } else {
            this._logger.info(Message.format((ResourceBundle)RB.getResources(), (String)"ChangeLoginDomain.FoundLogin.fmt.txt", (Object)login.getUserID(), (Object)login.getId()));
        }
    }

    @Override
    protected void parse(String[] args) throws ParseException, MissingOptionException {
        this._options = new Options();
        super.parse(args);
        if (this._help) {
            return;
        }
        this._listDomains = this._commandLine.hasOption(OPTION_LIST);
        this._noExecute = this._commandLine.hasOption(OPTION_NOEXECUTE);
        this._verbose = this._commandLine.hasOption(OPTION_VERBOSE);
        String[] remainingArgs = this._commandLine.getArgs();
        if (this._listDomains) {
            if (remainingArgs.length > 0) {
                throw new ParseException(RB.getStringResource("ChangeLoginDomain.NoArgumentsWithList.txt"));
            }
        } else if (remainingArgs.length == 2) {
            this._fromDomain = remainingArgs[0];
            this._toDomain = remainingArgs[1];
        } else {
            if (remainingArgs.length > 2) {
                throw new ParseException(RB.getStringResource("ChangeLoginDomain.TooManyArguments.txt"));
            }
            throw new ParseException(RB.getStringResource("ChangeLoginDomain.MissingArguments.txt"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        Thread.setDefaultUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)new UncaughtRuntimeExceptionHandler(true, 8));
        ChangeLoginDomain2 changer = new ChangeLoginDomain2();
        int rc = 0;
        try {
            changer.parse(args);
            if (changer._help) {
                HelpFormatter help = new HelpFormatter();
                help.printHelp(80, ChangeLoginDomain2.getUsage(help), RB.getStringResource("ChangeLoginDomain.Options.txt"), (org.apache.commons.cli.Options)changer._options, null);
                return;
            }
            rc = changer.execute();
            System.out.println(RB.getStringResource("ChangeLoginDomain.Complete.txt"));
        }
        catch (ParseException e) {
            System.err.println(RB.getStringResource("ChangeLoginDomain.InvalidSyntax.log"));
            System.err.println(e.getLocalizedMessage());
            rc = 8;
        }
        catch (Exception e) {
            String msg = Message.format((ResourceBundle)RB.getResources(), (String)"ChangeLoginDomain.Failed.fmt.txt", (Object)e.getLocalizedMessage());
            System.err.println(msg);
            rc = 8;
        }
        finally {
            if (changer != null) {
                rc |= changer.getReturnCode();
                String logFileName = changer.getLogFileName();
                if (logFileName != null) {
                    System.out.println(Message.format((ResourceBundle)RB.getResources(), (String)"ChangeLoginDomain.ViewLog.fmt.txt", (Object)logFileName));
                }
            }
        }
        System.exit(rc);
    }

    private static String getUsage(HelpFormatter help) {
        String NEW_LINE = help.getNewLine();
        StringBuffer usage = new StringBuffer();
        usage.append(RB.getStringResource("ChangeLoginDomain.HelpUsage.txt"));
        usage.append(NEW_LINE).append(NEW_LINE);
        usage.append(RB.getStringResource("ChangeLoginDomain.HelpUsage2.txt"));
        return usage.toString();
    }

    private String encodeXMLAttribute(String value) {
        StringBuffer encodedValue = new StringBuffer();
        for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            if (c == '\'') {
                encodedValue.append("&apos;");
                continue;
            }
            if (c == '\"') {
                encodedValue.append("@quot;");
                continue;
            }
            if (c == '<') {
                encodedValue.append("@lt;");
                continue;
            }
            encodedValue.append(c);
        }
        return encodedValue.toString();
    }

    protected class Options
    extends BatchDriverOptions {
        private static final long serialVersionUID = 1L;

        public Options() {
            Option option = new Option(ChangeLoginDomain2.OPTION_NOEXECUTE, RB.getStringResource("ChangeLoginDomain.Noexecute.Desc.txt"));
            this.addOption(option);
            option = new Option(ChangeLoginDomain2.OPTION_LIST, RB.getStringResource("ChangeLoginDomain.List.Desc.txt"));
            this.addOption(option);
            option = new Option(ChangeLoginDomain2.OPTION_VERBOSE, RB.getStringResource("ChangeLoginDomain.Verbose.Desc.txt"));
            this.addOption(option);
        }
    }
}

