/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.logical.batch;

import com.sas.codepolicy.SASScopeExtension;
import com.sas.metadata.logical.Factory;
import com.sas.metadata.logical.FactoryConfiguration;
import com.sas.metadata.logical.LogicalTypeException;
import com.sas.metadata.logical.SecurityContext;
import com.sas.metadata.logical.batch.BatchDriverOptions;
import com.sas.metadata.logical.batch.RB;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdFactory;
import com.sas.metadata.remote.MdFactoryImpl;
import com.sas.services.ServiceException;
import com.sas.services.deployment.CorePlatformServices;
import com.sas.services.deployment.Environment;
import com.sas.services.deployment.MetadataSourceFactory;
import com.sas.services.deployment.MetadataSourceInterface;
import com.sas.services.deployment.PlatformServicesConfiguration;
import com.sas.services.information.InformationServiceInterface;
import com.sas.services.information.MetadataServerInterface;
import com.sas.services.information.OMIServer;
import com.sas.services.information.ServerInterface;
import com.sas.services.security.ConnectionProfile;
import com.sas.services.session.SessionContextInterface;
import com.sas.services.user.UserContextInterface;
import com.sas.services.user.UserInitializationException;
import com.sas.services.user.UserServiceInterface;
import com.sas.text.Message;
import com.sas.workspace.Workspace;
import com.sas.workspace.WorkspaceFile;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.rmi.RemoteException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.MissingOptionException;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.appender.ConsoleAppender;
import org.apache.logging.log4j.core.appender.FileAppender;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.Configurator;
import org.apache.logging.log4j.core.config.LoggerConfig;
import org.apache.logging.log4j.core.layout.PatternLayout;

@SASScopeExtension(value="sas")
public abstract class BatchDriver2 {
    private static final char SUBTYPE_SEPARATOR = '.';
    public static final int SUCCESS = 0;
    public static final int WARNING = 4;
    public static final int ERROR = 8;
    protected static final String UTILITY_VERSION = "9.4";
    protected BatchDriverOptions _options;
    protected CommandLine _commandLine;
    protected boolean _help = false;
    protected BatchDriver2 _parent = null;
    protected SessionContextInterface _session;
    protected ServerInterface _server;
    protected UserContextInterface _user;
    protected MdFactory _factory;
    protected boolean _privateServicesDeployment;
    protected boolean _remoteServicesDeployment = false;
    protected List<String> _supportedTypes;
    protected String _utilityName = this.getClass().getSimpleName();
    protected String _utilityNameWithVersion = null;
    protected String _logContextName = this.getClass().getPackage().getName();
    protected Logger _logger;
    protected String _logFilePrefix;
    protected String _logFileName;
    protected String _logFileOption;
    protected boolean _logFileDisabled = false;
    protected boolean _debug = false;
    protected boolean _logTimestamps = false;
    protected Appender _logFileAppender = null;
    protected List<Logger> _loggersWithLogFileAppender = null;
    protected int _rc = 0;
    @Deprecated
    protected SecurityContext _securityContext = new SecurityContext();
    private boolean _initializeLogicalTypes = true;
    private boolean _logFileTimestamp = true;
    private boolean _appendToLogFile = true;
    private ConsoleAppender _consoleAppender;
    private List<Logger> _loggersWithConsoleAppender;
    private String _profile = null;
    private String _host = null;
    private String _port = null;
    private String _userid = null;
    private String _password = null;
    private String _domain = null;
    private ConnectionProfile _connectionProfile = null;

    protected void setLogContextName(String contextName) {
        this._logContextName = contextName;
    }

    protected void setLogFilePrefix(String filePrefix) {
        if (this._logFileName != null) {
            throw new IllegalStateException("Log options may not be set after the log has been created.");
        }
        this._logFilePrefix = filePrefix;
    }

    protected void setLogFileTimestamp(boolean logFileTimestamp) {
        if (this._logFileName != null) {
            throw new IllegalStateException("Log options may not be set after the log has been created.");
        }
        this._logFileTimestamp = logFileTimestamp;
    }

    public void setLogFile(String logFileOrDirectory) {
        if (this._logFileName != null) {
            throw new IllegalStateException("Log options may not be set after the log has been created.");
        }
        this._logFileOption = logFileOrDirectory;
        this._logFileDisabled = this._logFileOption == null;
    }

    protected void setAppendToLogFile(boolean append) {
        this._appendToLogFile = append;
    }

    public void setConnection(String host, String port) {
        this._connectionProfile = ConnectionProfile.newProfile((String)host, (String)port);
    }

    public void setConnection(SessionContextInterface session) throws ServiceException, RemoteException {
        this._session = session;
        this._user = session.getUserContext();
        this._server = this._user.getAuthServer();
        if (this._server instanceof OMIServer) {
            this._factory = ((OMIServer)this._server).getMdFactory();
        }
    }

    public void setConnectionProfile(String profile) throws IOException {
        this._connectionProfile = ConnectionProfile.loadProfile((String)profile);
    }

    public void setCredential(String user, String password) {
        if (this._connectionProfile == null) {
            throw new IllegalStateException("Connection profile has not been initialized.");
        }
        this._connectionProfile.setProperty("userid", user);
        this._connectionProfile.setProperty("password", password);
    }

    public void setDebug(boolean debug) {
        this._debug = debug;
        this._logTimestamps = debug;
        if (this._logger != null && this._parent == null) {
            if (debug) {
                Configurator.setLevel((String)this._logger.getName(), (Level)Level.DEBUG);
            } else {
                Configurator.setLevel((String)this._logger.getName(), (Level)Level.INFO);
            }
        }
    }

    public void setDomain(String domain) {
        if (this._connectionProfile == null) {
            throw new IllegalStateException("Connection profile has not been initialized.");
        }
        this._connectionProfile.setProperty("authenticationdomain", domain);
    }

    protected boolean getInitializeLogicalTypes() {
        return this._initializeLogicalTypes;
    }

    protected void setInitializeLogicalTypes(boolean initializeLogicalTypes) {
        this._initializeLogicalTypes = initializeLogicalTypes;
    }

    public void setParent(BatchDriver2 parent) {
        this._parent = parent;
    }

    public void setSupportedTypes(List<String> supportedTypes) {
        this._supportedTypes = supportedTypes;
    }

    protected void parse(String[] args) throws ParseException, MissingOptionException {
        if (this._options == null) {
            throw new IllegalStateException("Implementation error: BatchDriver2 options are uninitialized");
        }
        if (args == null || args.length == 0 || args[0].equalsIgnoreCase("-?") || args[0].equalsIgnoreCase("--help")) {
            this._help = true;
            return;
        }
        this._commandLine = new GnuParser().parse((Options)this._options, args);
        if (this._commandLine.hasOption("?")) {
            this._help = true;
            return;
        }
        if (this._commandLine.hasOption("profile")) {
            this._profile = this._commandLine.getOptionValue("profile");
            this._userid = this._commandLine.getOptionValue("user");
            this._password = this._commandLine.getOptionValue("password");
        } else {
            if (!this._commandLine.hasOption("host")) {
                throw new MissingOptionException(RB.getStringResource("BatchDriver.MissingHostOption.txt"));
            }
            if (!this._commandLine.hasOption("port")) {
                throw new MissingOptionException(RB.getStringResource("BatchDriver.MissingPortOption.txt"));
            }
            if (!this._commandLine.hasOption("user") || !this._commandLine.hasOption("password")) {
                throw new MissingOptionException(RB.getStringResource("BatchDriver.MissingUserOption.txt"));
            }
            this._host = this._commandLine.getOptionValue("host");
            this._port = this._commandLine.getOptionValue("port");
            this._userid = this._commandLine.getOptionValue("user");
            this._password = this._commandLine.getOptionValue("password");
        }
        this._domain = this._commandLine.getOptionValue("domain");
        if (this._commandLine.hasOption("log")) {
            this.setLogFile(this._commandLine.getOptionValue("log"));
        } else if (this._commandLine.hasOption("nolog")) {
            this.setLogFile(null);
        }
        this._debug = this._commandLine.hasOption("debug");
        if (this._debug) {
            this._logTimestamps = true;
        }
    }

    public Logger getLogger() {
        return this._logger;
    }

    public String getLogFileName() {
        return this._logFileName;
    }

    public int getReturnCode() {
        return this._rc;
    }

    public List<String> getSupportedTypes() {
        return this._supportedTypes;
    }

    public void initialize() throws ServiceException, LogicalTypeException, RemoteException {
        if (this._parent != null) {
            this._session = this._parent._session;
            this._server = this._parent._server;
            this._factory = this._parent._factory;
            this._user = this._parent._user;
            this._logger = this._parent._logger;
        } else if (this._session == null) {
            this.initializeNoConnection();
            this.connect();
        } else {
            this.initializeLoggers(false);
            this.initializeLogicalTypes();
        }
    }

    protected void initializeNoConnection() throws ServiceException {
        this.initializeLoggers(this._factory == null);
        if (this._factory != null) {
            return;
        }
        this._privateServicesDeployment = true;
        if (this._connectionProfile == null) {
            if (this._profile != null) {
                try {
                    this.setConnectionProfile(this._profile);
                }
                catch (FileNotFoundException e) {
                    throw new ServiceException((Throwable)e, Message.format((ResourceBundle)RB.getResources(), (String)"BatchDriver.ProfileNotFound.fmt.txt", (Object)this._profile));
                }
                catch (IOException e) {
                    throw new ServiceException((Throwable)e, Message.format((ResourceBundle)RB.getResources(), (String)"BatchDriver.ProfileLoadError.fmt.txt", (Object)this._profile));
                }
                if (this._userid != null) {
                    this.setCredential(this._userid, this._password);
                }
                if (this._domain != null) {
                    this.setDomain(this._domain);
                }
            } else {
                this.setConnection(this._host, this._port);
                this.setCredential(this._userid, this._password);
                if (this._domain != null) {
                    this.setDomain(this._domain);
                }
            }
        }
        CorePlatformServices.setEnvironment((Environment)this._connectionProfile.getEnvironment());
        if (this._remoteServicesDeployment) {
            Properties prop = new Properties();
            prop.setProperty("omr_host", this._connectionProfile.getProperty("host"));
            prop.setProperty("omr_port", this._connectionProfile.getProperty("port"));
            prop.setProperty("omr_user", this._connectionProfile.getProperty("userid"));
            prop.setProperty("omr_password", this._connectionProfile.getProperty("password"));
            prop.setProperty("software_component", "Remote Services");
            prop.setProperty("deployment_group_1", "Core");
            CorePlatformServices.setServicesConfiguration((PlatformServicesConfiguration)new PlatformServicesConfiguration(null, new MetadataSourceInterface[]{MetadataSourceFactory.newMetadataSource((Properties)prop)}));
            CorePlatformServices.startServices();
        } else {
            CorePlatformServices.startLocalServices();
            try {
                UserServiceInterface userService;
                InformationServiceInterface infoService = CorePlatformServices.getInformationService();
                if (infoService != null) {
                    infoService.setIsolated();
                }
                if ((userService = CorePlatformServices.getUserService()) != null) {
                    userService.setGroupLoginEnabled(true);
                }
            }
            catch (RemoteException e) {
                throw new ServiceException((Throwable)e, "Error in BatchDriver2.initializeNoConnection().");
            }
        }
    }

    protected void initializeWorkspace() throws ServiceException {
        if (Workspace.getWorkspace() == null) {
            try {
                if (this._debug) {
                    Workspace.processCommandLineArguments((String[])new String[]{"-debug"});
                }
                Workspace wksp = new Workspace(this._session);
                CMetadata foundationRepos = this._factory.getOMIUtil().getFoundationRepository();
                if (foundationRepos != null) {
                    wksp.setDefaultRepository(foundationRepos);
                }
                if (wksp.getAppDefaultsFile() == null) {
                    wksp.setAppDefaultsFile(new WorkspaceFile());
                }
            }
            catch (MdException e) {
                throw new ServiceException((Throwable)e);
            }
            catch (RemoteException e) {
                throw new ServiceException((Throwable)e, "Error in BatchDriver2.initializeWorkspace().");
            }
        }
    }

    protected void connectWithoutServices() throws ServiceException {
        if (this._factory != null) {
            return;
        }
        try {
            this._factory = new MdFactoryImpl(false);
            this._factory.setDebug(false);
            this._factory.getUtil().setOutputStream((OutputStream)System.out);
            this._factory.setLoggingEnabled(false);
            this._factory.getUtil().setLogStream((OutputStream)System.out);
            if (this._debug) {
                this._factory.setDebug(true);
                this._factory.setLoggingEnabled(true);
            }
            String host = this._connectionProfile.getProperty("host");
            String port = this._connectionProfile.getProperty("port");
            try {
                this._factory.makeOMRConnection(host, port, this._connectionProfile.getProperty("userid"), this._connectionProfile.getProperty("password"));
            }
            catch (MdException e) {
                throw new ServiceException((Throwable)e, Message.format((ResourceBundle)RB.getResources(), (String)"BatchDriver.MetaConnectionFailed.fmt.txt", (Object)host, (Object)port));
            }
        }
        catch (MdException e) {
            throw new ServiceException((Throwable)e, RB.getStringResource("BatchDriver.UpgradeInitializationError.txt"));
        }
        catch (RemoteException e) {
            throw new ServiceException((Throwable)e, "Error in BatchDriver2.connectWithoutServices().");
        }
    }

    protected void connect() throws ServiceException, LogicalTypeException {
        try {
            if (this._session != null) {
                this.initializeLogicalTypes();
                return;
            }
            UserServiceInterface userService = CorePlatformServices.getUserService();
            if (userService != null) {
                block15: {
                    this._user = null;
                    try {
                        String userName;
                        String appName = this._utilityNameWithVersion;
                        if (appName == null) {
                            appName = this._utilityName + " " + UTILITY_VERSION;
                        }
                        if ((userName = this._connectionProfile.getProperty("userid")) == null || userName.length() == 0) {
                            this._user = userService.newUser(null, appName);
                        } else {
                            String domain = this._remoteServicesDeployment ? "DefaultAuth" : this._connectionProfile.getDomain();
                            this._user = userService.newUser(this._connectionProfile.getProperty("userid"), this._connectionProfile.getProperty("password"), domain, null, appName);
                        }
                    }
                    catch (UserInitializationException e) {
                        this._user = e.getUser();
                        if (!this._debug) break block15;
                        Exception[] exceptions = e.getExceptions();
                        for (int i = 0; i < exceptions.length; ++i) {
                            Exception exception = exceptions[i];
                            exception.printStackTrace(System.out);
                        }
                    }
                }
                if (this._user == null) {
                    throw new ServiceException(RB.getStringResource("BatchDriver.InitError.NoUser.txt"));
                }
                this._session = CorePlatformServices.getSessionService().newSessionContext(this._user);
                this._server = this._user.getAuthServer();
                if (this._server == null) {
                    throw new ServiceException(RB.getStringResource("BatchDriver.InitError.NoServer.txt"));
                }
                if (this._server instanceof OMIServer) {
                    this._factory = ((OMIServer)this._server).getMdFactory();
                    if (this._factory == null) {
                        throw new ServiceException(RB.getStringResource("BatchDriver.InitError.NoFactory.txt"));
                    }
                }
            } else {
                throw new ServiceException(RB.getStringResource("BatchDriver.InitError.NoUser.txt"));
            }
            this.initializeLogicalTypes();
        }
        catch (RemoteException e) {
            throw new ServiceException((Throwable)e);
        }
    }

    protected void disconnect() throws ServiceException {
        block11: {
            if (this._privateServicesDeployment) {
                try {
                    if (this._session != null) {
                        try {
                            UserServiceInterface userService = CorePlatformServices.getUserService();
                            if (userService != null) {
                                userService.removeUser(this._session.getUserContext());
                            }
                            this._session.destroy();
                            break block11;
                        }
                        finally {
                            this._session = null;
                        }
                    }
                    if (this._factory == null) break block11;
                    try {
                        this._factory.closeOMRConnection();
                        this._factory.dispose();
                    }
                    finally {
                        this._factory = null;
                    }
                }
                catch (RemoteException e) {
                    throw new ServiceException((Throwable)e, "Error in BatchDriver2.disconnect().");
                }
            }
        }
    }

    private void initializeLoggers(boolean standAloneMode) {
        if (this._logger != null) {
            return;
        }
        LoggerContext lc = (LoggerContext)LogManager.getContext((boolean)false);
        Configuration config = lc.getConfiguration();
        String patternStr = (this._logTimestamps ? RB.getStringResource("BatchDriver.LogPatternTimePrefix.txt") + " " : "") + (this._debug ? RB.getStringResource("BatchDriver.LogPatternDebug.txt") : RB.getStringResource("BatchDriver.LogPattern.txt"));
        PatternLayout layout = PatternLayout.newBuilder().withConfiguration(config).withPattern(patternStr).build();
        if (standAloneMode) {
            Logger root = LogManager.getRootLogger();
            Configurator.setLevel((String)root.getName(), (Level)Level.OFF);
            ConsoleAppender rootConsole = ((ConsoleAppender.Builder)((ConsoleAppender.Builder)ConsoleAppender.newBuilder().setName("A1")).setConfiguration(config)).build();
            rootConsole.start();
            config.addAppender((Appender)rootConsole);
            lc.getLogger(root.getName()).addAppender((Appender)rootConsole);
        }
        ConsoleAppender _consoleAppender = ((ConsoleAppender.Builder)((ConsoleAppender.Builder)ConsoleAppender.newBuilder().setName("SASConsoleAppender")).setConfiguration(config)).build();
        _consoleAppender.start();
        config.addAppender((Appender)_consoleAppender);
        this.makeLogFileAppender(layout);
        lc.updateLoggers();
        List<DefaultLoggingContext> contexts = this.getDefaultLoggingContexts();
        if (contexts != null) {
            for (DefaultLoggingContext context : contexts) {
                Level level;
                String name = context.getContextName();
                Level level2 = level = this._debug ? context.getDebugLevel() : context.getDefaultLevel();
                if (name.equalsIgnoreCase(this._logContextName)) {
                    this._logger = this.setLoggerAttributes(name, level, _consoleAppender, this._logFileAppender);
                    continue;
                }
                this.setLoggerAttributes(name, level, _consoleAppender, this._logFileAppender);
            }
        }
        if (this._logContextName != null && this._logger == null) {
            this._logger = this.setLoggerAttributes(this._logContextName, this._debug ? Level.DEBUG : Level.INFO, _consoleAppender, this._logFileAppender);
        }
    }

    private void terminateLoggers() {
        LoggerConfig loggerConfig;
        LoggerContext lc = (LoggerContext)LogManager.getContext((boolean)false);
        Configuration config = lc.getConfiguration();
        if (this._logFileAppender != null && this._loggersWithLogFileAppender != null) {
            for (Logger logger : this._loggersWithLogFileAppender) {
                loggerConfig = config.getLoggerConfig(logger.getName());
                if (!loggerConfig.getName().equals(logger.getName())) continue;
                loggerConfig.removeAppender(this._logFileAppender.getName());
            }
            this._logFileAppender.stop();
        }
        if (this._consoleAppender != null && this._loggersWithConsoleAppender != null) {
            for (Logger logger : this._loggersWithConsoleAppender) {
                loggerConfig = config.getLoggerConfig(logger.getName());
                if (!loggerConfig.getName().equals(logger.getName())) continue;
                loggerConfig.removeAppender(this._consoleAppender.getName());
            }
            this._consoleAppender.stop();
        }
        lc.updateLoggers();
        this._logger = null;
    }

    protected void makeLogFileAppender(PatternLayout layout) {
        this._logFileAppender = null;
        if (this._logFileDisabled) {
            return;
        }
        String logDirectory = null;
        this._logFileName = null;
        if (this._logFileOption == null) {
            logDirectory = BatchDriver2.getDefaultLogDirectory(null, null);
            if (logDirectory == null) {
                this._logFileDisabled = true;
                return;
            }
        } else {
            File testLogFile = new File(this._logFileOption);
            if (testLogFile.isDirectory()) {
                logDirectory = this._logFileOption;
            } else {
                this._logFileName = this._logFileOption;
            }
        }
        if (this._logFileName == null) {
            String suffix;
            String fileSep;
            if (this._logFilePrefix == null) {
                this._logFilePrefix = this._utilityName;
            }
            if (logDirectory.endsWith(fileSep = File.separator)) {
                fileSep = "";
            }
            if (this._logFileTimestamp) {
                SimpleDateFormat sdf = new SimpleDateFormat("_yyMMddHHmmss'.log'");
                suffix = sdf.format(new Date());
            } else {
                suffix = ".log";
            }
            this._logFileName = logDirectory + fileSep + this._logFilePrefix + suffix;
        }
        LoggerContext lc = (LoggerContext)LogManager.getContext((boolean)false);
        Configuration config = lc.getConfiguration();
        this._logFileAppender = ((FileAppender.Builder)((FileAppender.Builder)((FileAppender.Builder)FileAppender.newBuilder().setName("com.sas.services")).withFileName(this._logFileName).withAppend(this._appendToLogFile).setLayout((Layout)layout)).setConfiguration(config)).build();
        this._logFileAppender.start();
        config.addAppender(this._logFileAppender);
    }

    public static String getDefaultLogDirectory(String application, String version) {
        File dirFile;
        String appData = Workspace.getAppDataPath();
        String separator = File.separator;
        String dirPath = appData + separator + "SAS";
        if (application != null) {
            dirPath = dirPath + separator + application;
        }
        if (version != null) {
            dirPath = dirPath + separator + version;
        }
        if (!(dirFile = new File(dirPath = dirPath + separator + "Logs")).exists() && !dirFile.mkdirs()) {
            System.err.println(Message.format((ResourceBundle)RB.getResources(), (String)"BatchDriver.UnableToCreateLogDir.fmt.txt", (Object)dirPath));
            dirPath = null;
        }
        return dirPath;
    }

    protected List<DefaultLoggingContext> getDefaultLoggingContexts() {
        ArrayList<DefaultLoggingContext> loggingContexts = new ArrayList<DefaultLoggingContext>();
        loggingContexts.add(new DefaultLoggingContext("com.sas", Level.WARN, Level.DEBUG));
        loggingContexts.add(new DefaultLoggingContext("com.sas.services", Level.WARN, Level.DEBUG));
        loggingContexts.add(new DefaultLoggingContext("com.sas.services.deployment", Level.WARN, Level.WARN));
        loggingContexts.add(new DefaultLoggingContext("com.sas.iom", Level.WARN, Level.WARN));
        return loggingContexts;
    }

    private Logger setLoggerAttributes(String name, Level level, ConsoleAppender appender1, Appender appender2) {
        Logger logger = LogManager.getLogger((String)name);
        if (logger != null) {
            LoggerContext lc = (LoggerContext)LogManager.getContext((boolean)false);
            Configuration config = lc.getConfiguration();
            lc.getLogger(logger.getName()).setAdditive(false);
            Configurator.setLevel((String)logger.getName(), (Level)level);
            if (appender1 != null) {
                lc.getLogger(logger.getName()).addAppender((Appender)appender1);
            }
            if (appender2 != null) {
                lc.getLogger(logger.getName()).addAppender(appender2);
            }
            if (this._loggersWithLogFileAppender == null) {
                this._loggersWithLogFileAppender = new ArrayList<Logger>();
            }
            this._loggersWithLogFileAppender.add(logger);
            if (this._loggersWithConsoleAppender == null) {
                this._loggersWithConsoleAppender = new ArrayList<Logger>();
            }
            this._loggersWithConsoleAppender.add(logger);
            lc.updateLoggers();
        }
        return logger;
    }

    private void initializeLogicalTypes() throws LogicalTypeException, RemoteException, ServiceException {
        if (!this._initializeLogicalTypes) {
            return;
        }
        Factory factory = Factory.getInstance();
        if (!factory.isInitialized()) {
            FactoryConfiguration config = new FactoryConfiguration();
            if (this._supportedTypes != null) {
                if (!this._supportedTypes.contains("Folder")) {
                    this._supportedTypes.add("Folder");
                }
                if (!this._supportedTypes.contains("RootFolder")) {
                    this._supportedTypes.add("RootFolder");
                }
                this.addSubTypes();
                config.setSupportedPublicTypes(this._supportedTypes);
            }
            factory.initialize(config);
            factory.setConnection(this._session, this._factory);
        }
    }

    private void addSubTypes() throws ServiceException, RemoteException {
        if (this._server instanceof MetadataServerInterface) {
            Map typesMap = ((MetadataServerInterface)this._server).getTypeDictionaryMap();
            for (String typeName : typesMap.keySet()) {
                List<String> subTypeList;
                if (typeName.indexOf(46) >= 0 || (subTypeList = this.getSubTypes(typesMap, typeName)) == null) continue;
                for (String name : subTypeList) {
                    if (this._supportedTypes.contains(name)) continue;
                    this._supportedTypes.add(name);
                }
            }
        }
    }

    private List<String> getSubTypes(Map<String, ?> typesMap, String typeName) {
        ArrayList<String> subTypeList = null;
        for (String subTypeName : typesMap.keySet()) {
            if (subTypeName.indexOf(46) <= -1 || !subTypeName.startsWith(typeName)) continue;
            if (subTypeList == null) {
                subTypeList = new ArrayList<String>();
            }
            subTypeList.add(subTypeName);
        }
        return subTypeList;
    }

    public void validateSetup() throws ServiceException {
        CorePlatformServices.validateServices();
        if (this._server == null) {
            throw new ServiceException(RB.getStringResource("BatchDriver.InitError.NoServer.txt"));
        }
        Factory factory = Factory.getInstance();
        if (factory.getMdFactory() == null) {
            throw new ServiceException(RB.getStringResource("BatchDriver.InitError.Types.txt"));
        }
    }

    public void terminate() throws ServiceException, RemoteException {
        if (this._parent != null) {
            return;
        }
        if (this._privateServicesDeployment) {
            this.disconnect();
            CorePlatformServices.terminateServices();
            this._privateServicesDeployment = false;
        }
        this.terminateLoggers();
    }

    protected void logStart() {
        this._logger.info(Message.format((ResourceBundle)RB.getResources(), (String)"BatchDriver.Start.fmt.log", (Object)this._utilityName, (Object)new Date()));
    }

    protected void logConnectionInfo() {
        if (this._connectionProfile != null && this._connectionProfile.getProperty("host") != null) {
            String user = this._connectionProfile.getProperty("userid");
            if (user == null || user.length() == 0) {
                user = System.getProperty("user.name");
            }
            this._logger.info(Message.format((ResourceBundle)RB.getResources(), (String)"BatchDriver.LogConnectionInfo.fmt.txt", (Object)this._connectionProfile.getProperty("host"), (Object)this._connectionProfile.getProperty("port"), (Object)user));
        }
    }

    protected void logCompletion() {
        if (this._rc == 0) {
            System.out.println(Message.format((ResourceBundle)RB.getResources(), (String)"BatchDriver.Complete.fmt.txt", (Object)this._utilityName));
        } else if (this._rc == 4) {
            System.out.println(Message.format((ResourceBundle)RB.getResources(), (String)"BatchDriver.CompleteWarning.fmt.txt", (Object)this._utilityName));
        } else {
            System.out.println(Message.format((ResourceBundle)RB.getResources(), (String)"BatchDriver.CompleteError.fmt.txt", (Object)this._utilityName));
        }
        if (this._logFileName != null) {
            System.out.println(Message.format((ResourceBundle)RB.getResources(), (String)"BatchDriver.LogSaved.fmt.txt", (Object)this._logFileName));
        }
    }

    protected void logException(Throwable t) {
        if (this._rc < 8) {
            this._rc = 8;
        }
        if (t instanceof ParseException) {
            System.err.println(RB.getStringResource("BatchDriver.InvalidSyntax.log"));
            System.err.println(t.getLocalizedMessage());
            return;
        }
        String msg = Message.format((ResourceBundle)RB.getResources(), (String)"BatchDriver.Failed.fmt.txt", (Object)this._utilityName, (Object)t.getLocalizedMessage());
        if (this._logger != null) {
            this._logger.error(msg);
            if (t.getCause() != null) {
                this._logger.error(t.getCause().getLocalizedMessage());
            }
            if (this._debug) {
                for (StackTraceElement trace : t.getStackTrace()) {
                    this._logger.error("  at " + trace.toString());
                }
            }
        } else {
            System.err.println(msg);
            if (t.getCause() != null) {
                System.err.println("  " + t.getCause().getLocalizedMessage());
            }
            if (this._debug) {
                t.printStackTrace();
            }
        }
    }

    protected static Options getHelpOptions(Options allOptions, String[] optionsToExclude) {
        if (allOptions == null || optionsToExclude == null || optionsToExclude.length == 0) {
            return allOptions;
        }
        Options helpOptions = new Options();
        for (Option opt : allOptions.getOptions()) {
            String name = opt.getOpt();
            boolean include = true;
            for (String optionToExclude : optionsToExclude) {
                if (!name.equalsIgnoreCase(optionToExclude)) continue;
                include = false;
                break;
            }
            if (!include) continue;
            helpOptions.addOption(opt);
        }
        return helpOptions;
    }

    protected static class DefaultLoggingContext {
        String _contextName;
        Level _defaultLevel = Level.WARN;
        Level _debugLevel = Level.INFO;

        public DefaultLoggingContext(String contextName) {
            this._contextName = contextName;
        }

        public DefaultLoggingContext(String contextName, Level defaultLevel) {
            this(contextName);
            this._defaultLevel = defaultLevel;
        }

        public DefaultLoggingContext(String contextName, Level defaultLevel, Level debugLevel) {
            this(contextName, defaultLevel);
            this._debugLevel = debugLevel;
        }

        public String getContextName() {
            return this._contextName;
        }

        public Level getDefaultLevel() {
            return this._defaultLevel;
        }

        public Level getDebugLevel() {
            return this._debugLevel;
        }

        public String toString() {
            return this._contextName + " (" + this._defaultLevel.toString() + ")";
        }
    }
}

