/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.logical;

import com.sas.services.util.DateUtil;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.util.Date;
import java.util.TimeZone;

public final class UtilMisc {
    public static final DateFormat SAS_DATE_FORMAT = DateFormat.getDateTimeInstance(3, 3);

    public static boolean isStringNullOrEmpty(String s) {
        return s == null || s.length() == 0;
    }

    public static boolean isBlankOrEmptyString(String s) {
        if (s == null) {
            return true;
        }
        int length = s.length();
        if (length == 0) {
            return true;
        }
        for (int i = 0; i < length; ++i) {
            if (s.charAt(i) == ' ') continue;
            return false;
        }
        return true;
    }

    public static String getValidFileName(String inputName) {
        StringBuffer work = new StringBuffer(inputName);
        work.append(".sas");
        return work.toString();
    }

    public static String getMessage(String pattern, Object[] args) {
        return MessageFormat.format(pattern, args);
    }

    public static String getMessage(String pattern, Object arg) {
        Object[] paramArray = new Object[]{arg};
        return UtilMisc.getMessage(pattern, paramArray);
    }

    public static String getMessage(String pattern, Object arg1, Object arg2) {
        Object[] paramArray = new Object[]{arg1, arg2};
        return UtilMisc.getMessage(pattern, paramArray);
    }

    public static String getMessage(String pattern, Object arg1, Object arg2, Object arg3) {
        Object[] paramArray = new Object[]{arg1, arg2, arg3};
        return UtilMisc.getMessage(pattern, paramArray);
    }

    public static String getMessage(String pattern, Object arg1, Object arg2, Object arg3, Object arg4) {
        Object[] paramArray = new Object[]{arg1, arg2, arg3, arg4};
        return UtilMisc.getMessage(pattern, paramArray);
    }

    public static String getMessage(String pattern, Object arg1, Object arg2, Object arg3, Object arg4, Object arg5) {
        Object[] paramArray = new Object[]{arg1, arg2, arg3, arg4, arg5};
        return UtilMisc.getMessage(pattern, paramArray);
    }

    public static Date convertSASDateInDoubleFormat(String dateValue) {
        try {
            double d = Double.parseDouble(dateValue);
            TimeZone timezone = TimeZone.getTimeZone("GMT");
            long l = DateUtil.SASDateTimeToJavaDate((double)d, (TimeZone)timezone);
            return new Date(l);
        }
        catch (Exception e) {
            return new Date(0L);
        }
    }

    public static String convertDate(String dateValue) {
        try {
            double d = Double.parseDouble(dateValue);
            TimeZone timezone = TimeZone.getTimeZone("GMT");
            long l = DateUtil.SASDateTimeToJavaDate((double)d, (TimeZone)timezone);
            Date date = new Date(l);
            return SAS_DATE_FORMAT.format(date);
        }
        catch (Exception e) {
            return dateValue;
        }
    }

    public static String getExceptionMessageText(Exception e) {
        String text = e.getLocalizedMessage();
        if (text == null && (text = e.getMessage()) == null && (text = e.toString()) == null) {
            text = "";
        }
        return text;
    }
}

