/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.logical;

import com.sas.metadata.logical.Factory;
import com.sas.metadata.logical.FolderContentMappingModel;
import com.sas.metadata.logical.FolderInterface;
import com.sas.metadata.logical.LogicalObject;
import com.sas.metadata.logical.LogicalTypeException;
import com.sas.metadata.logical.TypeInterface;
import com.sas.metadata.logical.UtilMetadata;
import com.sas.metadata.logical.UtilPlatformServices;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.SoftwareComponent;
import com.sas.metadata.remote.Tree;
import com.sas.services.ServiceException;
import com.sas.services.information.metadata.RootFolderInterface;
import java.rmi.RemoteException;
import java.util.List;

class RootFolderLogicalObject
extends LogicalObject
implements FolderInterface {
    private boolean _isContentMapped;
    private boolean _isCreateChildTested;
    private boolean _isCreateChildAllowed;

    RootFolderLogicalObject(SoftwareComponent softwareComponent, TypeInterface type, Factory factory) throws LogicalTypeException, RemoteException {
        super((Root)softwareComponent, type, factory);
        this.setDetails(softwareComponent);
    }

    private void setDetails(SoftwareComponent softwareComponent) throws LogicalTypeException, RemoteException {
        FolderContentMappingModel fcmm = new FolderContentMappingModel(softwareComponent);
        try {
            fcmm.loadMetadata();
        }
        catch (MdException e) {
            throw new LogicalTypeException((Exception)((Object)e));
        }
        this._isContentMapped = fcmm.getBackingType() != 0;
    }

    public boolean isMoveAllowed() {
        return false;
    }

    public boolean isMoveAllowed(FolderInterface targetFolder) {
        return false;
    }

    @Override
    public boolean isDeleteAllowed() throws LogicalTypeException {
        return false;
    }

    @Override
    public boolean ischeckOutAllowed() throws LogicalTypeException {
        return false;
    }

    public boolean isFetchAllowed() throws LogicalTypeException {
        return false;
    }

    @Override
    public boolean isRenameAllowed() throws LogicalTypeException {
        return false;
    }

    @Override
    public boolean isExportAllowed() throws LogicalTypeException {
        return true;
    }

    @Override
    public boolean isValidName(String name) throws LogicalTypeException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void refresh(Root root) throws LogicalTypeException, RemoteException {
        if (!(root instanceof SoftwareComponent)) {
            throw new LogicalTypeException("Logic error: can only call refresh on the RootFolderLogicalObject with a SoftwareComponent.");
        }
        this.setDetails((SoftwareComponent)root);
    }

    @Override
    public int childFolderExists(String name) throws LogicalTypeException, RemoteException {
        MdObjectStore store = Factory.getInstance().getMdFactory().createObjectStore();
        UtilPlatformServices.DetachedTransaction detachedTransaction = null;
        try {
            SoftwareComponent softwareComponent = (SoftwareComponent)UtilMetadata.getJOMAObjectFromLogicalObject(this, store);
            List<Tree> children = UtilMetadata.getChildTreesFromSoftwareComponent(softwareComponent);
            for (Tree child : children) {
                if (!child.getName().equalsIgnoreCase(name)) continue;
                int n = 1;
                return n;
            }
            detachedTransaction = UtilPlatformServices.getDetachedTransaction();
            com.sas.services.information.metadata.FolderInterface fi = (com.sas.services.information.metadata.FolderInterface)detachedTransaction.getSmartObject((Root)softwareComponent);
            if (fi == null) {
                throw new ServiceException("Could not obtain folder smart object for " + softwareComponent.getFQID());
            }
            int n = fi.hasDuplicateSubfolder(name) ? 2 : 0;
            return n;
        }
        catch (MdException e) {
            throw new LogicalTypeException((Exception)((Object)e));
        }
        catch (ServiceException e) {
            throw new LogicalTypeException((Exception)((Object)e));
        }
        finally {
            if (detachedTransaction != null) {
                detachedTransaction.rollback();
            }
            store.dispose();
        }
    }

    @Override
    public boolean isEmpty() throws LogicalTypeException, RemoteException {
        UtilPlatformServices.DetachedTransaction detachedTransaction = null;
        try {
            detachedTransaction = UtilPlatformServices.getDetachedTransaction();
            RootFolderInterface rfi = (RootFolderInterface)detachedTransaction.getSmartObject(this);
            boolean bl = rfi.isEmpty();
            return bl;
        }
        catch (ServiceException e) {
            throw new LogicalTypeException((Exception)((Object)e));
        }
        finally {
            if (detachedTransaction != null) {
                detachedTransaction.rollback();
            }
        }
    }

    @Override
    public boolean isContentMapped() {
        return this._isContentMapped;
    }

    @Override
    public boolean isContentBacked() {
        return this._isContentMapped;
    }

    @Override
    public boolean isCustomRepositoryRoot() {
        return false;
    }

    @Override
    public boolean isRoot() {
        return true;
    }

    public boolean isRootFolder() {
        return false;
    }

    @Override
    public boolean isTopLevel() {
        return false;
    }

    @Override
    public boolean isSystem() {
        return false;
    }

    @Override
    public boolean isCreateChildAllowed() throws LogicalTypeException, RemoteException {
        if (!this._isCreateChildTested) {
            this._isCreateChildTested = true;
            boolean hasWriteMemberPermissionOnRepository = this._factory.getWriteAllowedOnRepository(this);
            if (hasWriteMemberPermissionOnRepository) {
                UtilPlatformServices.DetachedTransaction detachedTransaction = null;
                try {
                    detachedTransaction = UtilPlatformServices.getDetachedTransaction();
                    RootFolderInterface rfi = (RootFolderInterface)detachedTransaction.getSmartObject(this);
                    this._isCreateChildAllowed = rfi.isAuthorized("WriteMetadata");
                }
                catch (ServiceException e) {
                    throw new LogicalTypeException((Exception)((Object)e));
                }
                finally {
                    if (detachedTransaction != null) {
                        detachedTransaction.rollback();
                    }
                }
            } else {
                this._isCreateChildAllowed = false;
            }
        }
        return this._isCreateChildAllowed;
    }
}

