/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.logical;

import com.sas.codepolicy.SASScopeExtension;
import com.sas.metadata.logical.Factory;
import com.sas.metadata.logical.FolderInterface;
import com.sas.metadata.logical.LogicalObjectInterface;
import com.sas.metadata.logical.LogicalTypeException;
import com.sas.metadata.logical.MoveDisallowedCause;
import com.sas.metadata.logical.OperationUserInteractionInterface;
import com.sas.metadata.logical.RB;
import com.sas.metadata.logical.TransportableTypeInterface;
import com.sas.metadata.logical.TypeInterface;
import com.sas.metadata.logical.UtilMetadata;
import com.sas.metadata.logical.UtilMisc;
import com.sas.metadata.logical.UtilPlatformServices;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.Tree;
import com.sas.services.ServiceException;
import com.sas.services.information.metadata.MetadataInterface;
import com.sas.services.information.metadata.RootFolderInterface;
import com.sas.services.information.publicobject.TypeDescriptorInterface;
import com.sas.text.Message;
import com.sas.util.UsageVersion;
import com.sas.workspace.ProjectUtil;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.Icon;

@SASScopeExtension(value="sas")
public class LogicalObject
implements LogicalObjectInterface {
    private UsageVersion OLDEST_VERSION = new UsageVersion(0, 0);
    private UsageVersion CURRENT_VERSION = new UsageVersion(1, 0);
    protected static final String WRITE_METADATA = "WriteMetadata";
    protected static final String WRITE_MEMBER_METADATA = "WriteMemberMetadata";
    protected static final String CHECKIN_METADATA = "CheckInMetadata";
    protected final Factory _factory;
    protected final String _fqid;
    private String _name;
    private String _cMetadataType;
    private UsageVersion _usageVersion;
    private UsageVersion _oldest;
    private UsageVersion _current;
    private boolean _isCompatible;
    private boolean _isReadCompatible;
    private HashMap<String, Object> _attributeMap;
    protected final TypeInterface _ti;
    private boolean _isCheckInTested;
    private boolean _isCheckinAllowed;
    private boolean _isWriteOnObjectTested;
    private boolean _isWriteOnObjectAllowed;
    private boolean _isWriteOnParentTested;
    private boolean _isWriteOnParentAllowed;
    private boolean _isDeleteAndMoveAllowedSet;
    private boolean _isRenameAllowed;
    private boolean _isRenameAllowedSet;
    private MoveDisallowedCause _causeForDeleteAndMoveNotAllowed;

    public LogicalObject(Root root, TypeInterface ti, Factory factory) throws RemoteException {
        this._name = root.getName();
        this._fqid = root.getFQID();
        this._cMetadataType = root.getCMetadataType();
        this._usageVersion = UsageVersion.decode((double)root.getUsageVersion());
        this._ti = ti;
        this._factory = factory;
        this._attributeMap = new HashMap();
        this.setCompatibility(this.OLDEST_VERSION, this.CURRENT_VERSION);
        this.refreshNeededAttributesFromRoot(root);
    }

    private void refreshNeededAttributesFromRoot(Root root) throws RemoteException {
        this._attributeMap.clear();
        Map rootAttrMap = root.getAttrs();
        String[] neededAttrs = this._factory.getNeededAttributes();
        for (int i = 0; i < neededAttrs.length; ++i) {
            String attr = neededAttrs[i];
            this._attributeMap.put(attr, rootAttrMap.get(attr));
        }
    }

    @Override
    public String getName() {
        return this._name;
    }

    @Override
    public String getID() {
        return this._fqid;
    }

    @Override
    public TypeInterface getTypeInterface() {
        return this._ti;
    }

    @Override
    public void refresh(Root root) throws LogicalTypeException, RemoteException {
        if (!root.getFQID().equalsIgnoreCase(this._fqid)) {
            throw new UnsupportedOperationException("Logic error - updating with a different FQID.");
        }
        String oldType = this._ti.getMetadataType();
        if (oldType.length() > 0 && !root.getCMetadataType().equalsIgnoreCase(oldType)) {
            throw new UnsupportedOperationException("Logic error - updating with a different metadata type object.");
        }
        this._name = root.getName();
        this._usageVersion = UsageVersion.decode((double)root.getUsageVersion());
        this.setCompatibility(this._oldest, this._current);
        this.refreshNeededAttributesFromRoot(root);
        this.resetPermissionState();
    }

    protected void resetPermissionState() {
        this._isWriteOnObjectTested = false;
        this._isWriteOnObjectAllowed = false;
        this._isWriteOnParentTested = false;
        this._isWriteOnParentAllowed = false;
        this._isDeleteAndMoveAllowedSet = false;
        this._isRenameAllowed = false;
        this._isRenameAllowedSet = false;
        this._causeForDeleteAndMoveNotAllowed = null;
    }

    protected String getProgressMessageForDelete() {
        return UtilMisc.getMessage(RB.getStringResource("COM.UpdProgDelete.fmt.txt"), this._name);
    }

    @Override
    public Icon getIcon() {
        return this._ti.getIcon(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean delete(OperationUserInteractionInterface oui) throws LogicalTypeException, RemoteException {
        if (!this.isDeleteAllowed()) {
            throw new UnsupportedOperationException("Logic error - this object does not support deleting.");
        }
        String progressText = this.getProgressMessageForDelete();
        oui.updateProgress(progressText);
        UtilPlatformServices.DetachedTransaction detachedTransaction = null;
        String folderName = "";
        try {
            detachedTransaction = UtilPlatformServices.getDetachedTransaction();
            MetadataInterface mi = detachedTransaction.getSmartObject(this);
            try {
                Root root = (Root)mi.getRepositoryEntity();
                AssociationList al = root.getTrees();
                if (al.size() == 1) {
                    Tree tree = (Tree)root.getTrees().get(0);
                    folderName = tree.getName();
                }
            }
            catch (Exception root) {
                // empty catch block
            }
            mi.delete();
            boolean root = true;
            return root;
        }
        catch (ServiceException e) {
            String logmsg = UtilMisc.getMessage(RB.getStringResource("COM.DelExcpOccrdLogMsgWithFldr.fmt.txt"), this._ti.getDisplayType(), this.getName(), folderName, UtilMisc.getExceptionMessageText((Exception)((Object)e)));
            this._factory.error(logmsg);
            if (oui.continueOperationWithPrompting()) {
                String messageText = folderName.length() == 0 ? UtilMisc.getMessage(RB.getStringResource("COM.DelExcpOccrdNoFolder.fmt.txt"), this._ti.getDisplayType(), this.getName(), UtilMisc.getExceptionMessageText((Exception)((Object)e))) : UtilMisc.getMessage(RB.getStringResource("COM.DelExcpOccrd.fmt.txt"), this._ti.getDisplayType(), this.getName(), folderName, UtilMisc.getExceptionMessageText((Exception)((Object)e)));
                int choice = oui.displayMessage(RB.getStringResource("COM.DelDlgTitle.txt"), messageText, 2, OperationUserInteractionInterface.OK_OKTOALL_CANCEL_CHOICE_SET);
                OperationUserInteractionInterface.Updater.updateUsingOkOkToAllCancelValue_OkToAllTerminatesPrompting(oui, choice);
            }
            boolean bl = false;
            return bl;
        }
        finally {
            if (detachedTransaction != null) {
                detachedTransaction.rollback();
            }
        }
    }

    protected String getNotCompatibleMessage() {
        return Message.format((String)RB.getStringResource("LO.NotCompat.fmt.txt"), (Object)this._usageVersion.toString(), (Object)this._ti.getDisplayType(), (Object)this.getName());
    }

    @Override
    public boolean isDeleteAllowed() throws LogicalTypeException, RemoteException {
        return this.isDeleteAndMoveAllowed() == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rename(String name, OperationUserInteractionInterface oui) throws LogicalTypeException, RemoteException {
        if (!this.isRenameAllowed()) {
            throw new UnsupportedOperationException("Logic error - this object does not support renaming");
        }
        UtilPlatformServices.DetachedTransaction detachedTransaction = null;
        try {
            detachedTransaction = UtilPlatformServices.getDetachedTransaction();
            MetadataInterface mi = detachedTransaction.getSmartObject(this);
            try {
                mi.setName(name);
                mi.update();
            }
            catch (Exception e) {
                throw new LogicalTypeException(e);
            }
        }
        finally {
            if (detachedTransaction != null) {
                detachedTransaction.rollback();
            }
        }
    }

    @Override
    public boolean isRenameAllowed() throws LogicalTypeException {
        if (!this._isRenameAllowedSet) {
            this._isRenameAllowedSet = true;
            this._isRenameAllowed = this._isCompatible ? this.isWriteOnObjectAllowed() : false;
        }
        return this._isRenameAllowed;
    }

    private boolean isWriteOnObjectAllowed() throws LogicalTypeException {
        if (!this._isWriteOnObjectTested) {
            this._isWriteOnObjectTested = true;
            this._isWriteOnObjectAllowed = UtilMetadata.checkRootPermission(this._factory, this._cMetadataType, this._fqid, WRITE_METADATA);
        }
        return this._isWriteOnObjectAllowed;
    }

    private boolean isWriteOnParentAllowed() throws LogicalTypeException, RemoteException {
        if (!this._isWriteOnParentTested) {
            this._isWriteOnParentTested = true;
            UtilPlatformServices.DetachedTransaction detachedTransaction = null;
            try {
                detachedTransaction = UtilPlatformServices.getDetachedTransaction();
                MetadataInterface mi = detachedTransaction.getSmartObject(this);
                com.sas.services.information.metadata.FolderInterface fi = mi.getParent();
                this._isWriteOnParentAllowed = fi == null ? true : fi.isAuthorized(fi instanceof RootFolderInterface ? WRITE_METADATA : WRITE_MEMBER_METADATA);
            }
            catch (ServiceException e) {
                throw new LogicalTypeException((Exception)((Object)e));
            }
            finally {
                if (detachedTransaction != null) {
                    detachedTransaction.rollback();
                }
            }
        }
        return this._isWriteOnParentAllowed;
    }

    /*
     * Unable to fully structure code
     */
    private MoveDisallowedCause isDeleteAndMoveAllowed() throws LogicalTypeException, RemoteException {
        if (!this._isDeleteAndMoveAllowedSet) {
            this._isDeleteAndMoveAllowedSet = true;
            reposID = UtilMetadata.makeRepositoryFQIDFromRoot(this._fqid);
            try {
                isInProjectRepos = this._factory.isProjectRepository(reposID);
            }
            catch (MdException e) {
                throw new LogicalTypeException((Exception)e);
            }
            if (this._isCompatible) {
                if (this.isWriteOnObjectAllowed()) {
                    this._causeForDeleteAndMoveNotAllowed = null;
                    if (isInProjectRepos) {
                        detachedTransaction = null;
                        try {
                            detachedTransaction = UtilPlatformServices.getDetachedTransaction();
                            mi = detachedTransaction.getSmartObject(this);
                            fi = mi.getParent();
                            if (fi == null || (parentReposID = UtilMetadata.makeRepositoryFQIDFromRoot((meta = (CMetadata)fi.getRepositoryEntity()).getFQID())).equalsIgnoreCase(reposID)) ** GOTO lbl42
                            if (this._factory.isProjectRepository(parentReposID)) {
                                throw new LogicalTypeException("Repository corruption.  Parent of project repository object " + this._fqid + " is in a different project reposotiry (" + parentReposID + ").");
                            }
                            store = this._factory.getScratchStore();
                            root = UtilMetadata.getJOMAObjectFromLogicalObject(this, store);
                            lockedBy = root.getLockedBy();
                            store.removeElementFromStore((CMetadata)root);
                            if (lockedBy.length() == 0 || fi.isAuthorized("CheckInMetadata")) ** GOTO lbl42
                            this._causeForDeleteAndMoveNotAllowed = MoveDisallowedCause.NO_PARENT_CHECKIN_PERMISSION;
                        }
                        catch (MdException e) {
                            throw new LogicalTypeException((Exception)e);
                        }
                        catch (ServiceException e) {
                            throw new LogicalTypeException((Exception)e);
                        }
                        finally {
                            if (detachedTransaction != null) {
                                detachedTransaction.rollback();
                            }
                        }
                    } else if (!this.isWriteOnParentAllowed()) {
                        this._causeForDeleteAndMoveNotAllowed = MoveDisallowedCause.NO_PARENT_WRITE_PERMISSION;
                    }
                } else {
                    this._causeForDeleteAndMoveNotAllowed = MoveDisallowedCause.NO_OBJECT_WRITE_PERMISSION;
                }
            } else {
                this._causeForDeleteAndMoveNotAllowed = MoveDisallowedCause.OBJECT_NOT_COMPATIBLE;
            }
lbl42:
            // 6 sources

            if (this._causeForDeleteAndMoveNotAllowed == null) {
                try {
                    if (!isInProjectRepos) {
                        store = this._factory.getScratchStore();
                        root = UtilMetadata.getJOMAObjectFromLogicalObject(this, store);
                        lockedBy = root.getLockedBy();
                        store.removeElementFromStore((CMetadata)root);
                        if (lockedBy.length() != 0) {
                            this._causeForDeleteAndMoveNotAllowed = MoveDisallowedCause.LOCKED_NOT_IN_PROJECT;
                        }
                    }
                }
                catch (MdException e) {
                    throw new LogicalTypeException((Exception)e);
                }
            }
        }
        return this._causeForDeleteAndMoveNotAllowed;
    }

    @Override
    public boolean isExportAllowed() throws LogicalTypeException {
        if (!this._isCompatible) {
            return false;
        }
        return this._ti instanceof TransportableTypeInterface;
    }

    @Override
    public boolean isValidName(String name) throws LogicalTypeException, RemoteException {
        return UtilMetadata.validateCharactersInNameOfItemInFolder(name);
    }

    @Override
    public boolean checkOut(Root repository, OperationUserInteractionInterface oui) throws LogicalTypeException, RemoteException {
        if (!this.ischeckOutAllowed()) {
            throw new UnsupportedOperationException("Logic error - this object does not support check-out");
        }
        ArrayList<CMetadata> objects = new ArrayList<CMetadata>(1);
        objects.add(this._factory.getMdFactory().createSimpleMetadataObject(this._name, this._ti.getMetadataType(), this._fqid));
        try {
            if (oui != null) {
                oui.updateProgress(UtilMisc.getMessage(RB.getStringResource("COM.UpdProgCheckOut.fmt.txt"), this._name));
            }
            ProjectUtil.checkOut(objects, (CMetadata)repository);
            return true;
        }
        catch (MdException ex) {
            throw new LogicalTypeException((Exception)((Object)ex));
        }
    }

    @Override
    public boolean ischeckOutAllowed() throws LogicalTypeException, RemoteException {
        if (!this._isCompatible) {
            return false;
        }
        if (!this._isCheckInTested) {
            this._isCheckinAllowed = false;
            TypeDescriptorInterface tdi = this._factory.getTypeDescriptorFromTypeDictionary(this._ti.getPublicType());
            if (tdi != null) {
                Iterator it;
                try {
                    it = tdi.getApplicablePermissions().iterator();
                }
                catch (ServiceException e) {
                    throw new LogicalTypeException((Exception)((Object)e));
                }
                while (it.hasNext()) {
                    String perm = (String)it.next();
                    if (!perm.equalsIgnoreCase(CHECKIN_METADATA)) continue;
                    this._isCheckinAllowed = true;
                    break;
                }
            }
            this._isCheckInTested = true;
        }
        return this._isCheckinAllowed;
    }

    @Override
    public String getAttributeValue(String attributeName) {
        return (String)this._attributeMap.get(attributeName);
    }

    @Override
    public boolean isCompatible() {
        return this._isCompatible;
    }

    @Override
    public boolean isReadCompatible() {
        return this._isReadCompatible;
    }

    @Override
    public UsageVersion getUsageVersion() {
        return this._usageVersion;
    }

    @Override
    public boolean isParentMoveAllowed() throws LogicalTypeException, RemoteException {
        return true;
    }

    @Override
    public MoveDisallowedCause checkMoveAllowed() throws LogicalTypeException, RemoteException {
        return this.isDeleteAndMoveAllowed();
    }

    @Override
    public MoveDisallowedCause checkMoveAllowed(FolderInterface targetFolder) throws LogicalTypeException, RemoteException {
        MoveDisallowedCause mnac = this.checkMoveAllowed();
        if (mnac != null) {
            return mnac;
        }
        if (targetFolder.isRoot()) {
            return MoveDisallowedCause.TARGET_IS_ROOT;
        }
        String reposID = UtilMetadata.makeRepositoryFQIDFromRoot(this._fqid);
        try {
            boolean isInProjectRepos = this._factory.isProjectRepository(reposID);
            if (isInProjectRepos) {
                MdObjectStore store = this._factory.getScratchStore();
                Root root = UtilMetadata.getJOMAObjectFromLogicalObject(this, store);
                String lockedBy = root.getLockedBy();
                String changeState = root.getChangeState();
                store.removeElementFromStore((CMetadata)root);
                if (lockedBy.length() != 0) {
                    int colonPos = changeState.indexOf(58);
                    boolean valid = false;
                    String originalID = null;
                    if (colonPos != -1 && colonPos + 2 <= changeState.length() && (originalID = changeState.substring(colonPos + 2)).length() == 17) {
                        valid = true;
                    }
                    if (!valid) {
                        String msg = UtilMisc.getMessage(RB.getStringResource("COM.InvChngSt.ex.fmt.txt"), changeState, this._fqid);
                        throw new LogicalTypeException(msg);
                    }
                    if (!UtilMetadata.get8CharReposidFromFQID(originalID).equalsIgnoreCase(UtilMetadata.get8CharReposidFromFQID(targetFolder.getID()))) {
                        return MoveDisallowedCause.CROSS_REPOSITORY;
                    }
                } else {
                    String targetFolderReposID = UtilMetadata.makeRepositoryFQIDFromRoot(targetFolder.getID());
                    if (this._factory.isProjectRepository(targetFolderReposID)) {
                        return MoveDisallowedCause.NEW_OBJECT_NOT_TO_PROJECT_REPOSITORY_FOLDER;
                    }
                }
            } else {
                if (!UtilMetadata.get8CharReposidFromFQID(this._fqid).equalsIgnoreCase(UtilMetadata.get8CharReposidFromFQID(targetFolder.getID()))) {
                    return MoveDisallowedCause.CROSS_REPOSITORY;
                }
                if (!UtilMetadata.checkRootPermission(this._factory, "Tree", targetFolder.getID(), WRITE_MEMBER_METADATA)) {
                    return MoveDisallowedCause.NO_TARGET_WRITE_PERMISSION;
                }
            }
        }
        catch (MdException e) {
            throw new LogicalTypeException((Exception)((Object)e));
        }
        if (this.isNamePresent(targetFolder)) {
            return MoveDisallowedCause.NAME_EXISTS;
        }
        return null;
    }

    protected boolean isNamePresent(FolderInterface targetFolder) throws LogicalTypeException, RemoteException {
        UtilPlatformServices.DetachedTransaction detachedTransaction = null;
        try {
            detachedTransaction = UtilPlatformServices.getDetachedTransaction();
            com.sas.services.information.metadata.FolderInterface fi = (com.sas.services.information.metadata.FolderInterface)detachedTransaction.getSmartObject(targetFolder);
            if (fi == null) {
                throw new LogicalTypeException("Logic error - couldn't get smart object for Tree \"" + targetFolder.getName() + "\" id \"" + targetFolder.getID() + "\".");
            }
            if (this._ti == null) {
                throw new LogicalTypeException("Logic error - TypeInterface not set for " + this.getName() + "\" id \"" + this.getID() + "\".");
            }
            String publicType = this._ti.getPublicType();
            if (publicType == null || publicType.length() == 0) {
                throw new LogicalTypeException("Logic error - PublicType not set for " + this.getName() + "\" id \"" + this.getID() + "\".");
            }
            boolean bl = fi.hasDuplicate(this.getName(), this._ti.getPublicType());
            return bl;
        }
        catch (ServiceException e) {
            throw new LogicalTypeException((Exception)((Object)e));
        }
        finally {
            if (detachedTransaction != null) {
                detachedTransaction.rollback();
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void move(FolderInterface targetFolder) throws LogicalTypeException, RemoteException {
        if (this.checkMoveAllowed(targetFolder) != null) {
            throw new UnsupportedOperationException("Logic error - cannot move to the folder specified");
        }
        this.resetPermissionState();
        UtilPlatformServices.DetachedTransaction detachedTransaction = null;
        try {
            com.sas.services.information.metadata.FolderInterface fi;
            detachedTransaction = UtilPlatformServices.getDetachedTransaction();
            MetadataInterface mi = detachedTransaction.getSmartObject(this);
            if (mi != null && (fi = (com.sas.services.information.metadata.FolderInterface)detachedTransaction.getSmartObject(targetFolder)) != null) {
                mi.moveTo(fi);
                mi.update();
                return;
            }
        }
        catch (ServiceException e) {
            throw new LogicalTypeException((Exception)((Object)e));
        }
        finally {
            if (detachedTransaction != null) {
                detachedTransaction.rollback();
            }
        }
        MdObjectStore store = this._factory.getMdFactory().createObjectStore();
        try {
            Root root = UtilMetadata.getJOMAObjectFromLogicalObject(this, store);
            Tree target = (Tree)UtilMetadata.getJOMAObjectFromLogicalObject(targetFolder, store);
            AssociationList al = root.getTrees();
            int i = 0;
            while (i < al.size()) {
                Tree tree = (Tree)al.get(i);
                String treesPublicType = tree.getPublicType();
                if (treesPublicType.equals("Folder") || treesPublicType.startsWith("Folder.")) {
                    al.set(i, (Object)target);
                    store.updatedMetadataAll();
                    return;
                }
                ++i;
            }
            throw new LogicalTypeException("Unable to find a containing Tree with the PublicType attribute of \"Folder\" or with the PublicType attribute starting with \"Folder.\").");
        }
        catch (MdException e) {
            throw new LogicalTypeException((Exception)((Object)e));
        }
        finally {
            store.dispose();
        }
    }

    protected final void setCompatibility(UsageVersion oldest, UsageVersion current) {
        this._oldest = oldest;
        this._current = current;
        this._isCompatible = this._usageVersion.isCompatible(this._oldest, this._current);
        this._isReadCompatible = this._usageVersion.isReadCompatible(this._oldest, this._current);
    }

    protected Factory getFactory() {
        return this._factory;
    }

    public String toString() {
        if (this._name != null && this._name.length() > 0) {
            return this._name;
        }
        return super.toString();
    }
}

