/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.logical;

import com.sas.metadata.logical.Factory;
import com.sas.metadata.logical.FolderContentMappingModel;
import com.sas.metadata.logical.FolderInterface;
import com.sas.metadata.logical.LogicalObject;
import com.sas.metadata.logical.LogicalObjectInterface;
import com.sas.metadata.logical.LogicalTypeException;
import com.sas.metadata.logical.MoveDisallowedCause;
import com.sas.metadata.logical.ObjectContainer;
import com.sas.metadata.logical.OperationUserInteractionInterface;
import com.sas.metadata.logical.RB;
import com.sas.metadata.logical.TypeInterface;
import com.sas.metadata.logical.UtilMetadata;
import com.sas.metadata.logical.UtilMetadataRemote;
import com.sas.metadata.logical.UtilMisc;
import com.sas.metadata.logical.UtilPlatformServices;
import com.sas.metadata.logical.visuals.Config;
import com.sas.metadata.logical.visuals.ConfigContentMappingPanel;
import com.sas.metadata.logical.visuals.ConfigGeneralPanel;
import com.sas.metadata.logical.visuals.FolderContentMappingTabPanel;
import com.sas.metadata.logical.visuals.FolderGeneralPropertyTab;
import com.sas.metadata.logical.visuals.UtilGui;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdFactory;
import com.sas.metadata.remote.MdFactoryEvent;
import com.sas.metadata.remote.MdFactoryListener;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.MdSecurityUtil;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.SoftwareComponent;
import com.sas.metadata.remote.Tree;
import com.sas.services.ServiceException;
import com.sas.services.information.metadata.MetadataInterface;
import com.sas.workspace.WAPropertyTab;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public class FolderLogicalObject
extends LogicalObject
implements FolderInterface {
    static final String ROOT_FOLDER_TEMPLATE = "<Templates><Tree><Documents/></Tree><Document><Notes/></Document></Templates>";
    static final String TEMPLATE_TO_GET_PARENT_TREE = "<Templates><Tree><ParentTree/><SoftwareComponents/></Tree></Templates>";
    protected boolean _isTopLevelContentMapped;
    protected boolean _isTopLevel;
    protected boolean _isCustomRepositoryRoot;
    protected boolean _isProjectRepositoryRoot;
    protected boolean _isCreateChildTested;
    protected boolean _isCreateChildAllowed;
    protected boolean _isSystem;
    private HashSet<String> _objectsDeleted;
    private MdFactoryListener _objectsDeletedListener;

    protected FolderLogicalObject(Tree tree, TypeInterface type, Factory factory) throws LogicalTypeException, MdException, RemoteException {
        super((Root)tree, type, factory);
        this.setDetails(tree);
    }

    private void setDetails(Tree tree) throws MdException, LogicalTypeException, RemoteException {
        this._isSystem = tree.getTreeType().equalsIgnoreCase("System");
        Tree parent = tree.getParentTree();
        if (parent == null) {
            this._isTopLevel = true;
            String reposID = UtilMetadata.makeRepositoryFQIDFromRoot((Root)tree);
            if (this.getFactory().isProjectRepository(reposID)) {
                this._isTopLevelContentMapped = false;
                this._isCustomRepositoryRoot = false;
                this._isProjectRepositoryRoot = true;
            } else {
                String foundationReposid = UtilMetadata.getFoundationRepositoryID();
                FolderContentMappingModel fcmm = new FolderContentMappingModel(tree);
                fcmm.loadMetadata();
                this._isTopLevelContentMapped = fcmm.getBackingType() != 0;
                this._isCustomRepositoryRoot = !reposID.equalsIgnoreCase(foundationReposid);
                this._isProjectRepositoryRoot = false;
            }
        } else {
            this._isTopLevel = false;
            this._isCustomRepositoryRoot = false;
            this._isProjectRepositoryRoot = false;
        }
    }

    @Override
    public boolean isDeleteAllowed() throws LogicalTypeException, RemoteException {
        if (!super.isDeleteAllowed()) {
            return false;
        }
        return !this.isCustomRepositoryRoot();
    }

    @Override
    public boolean isRenameAllowed() throws LogicalTypeException {
        if (!super.isRenameAllowed()) {
            return false;
        }
        return !this.isCustomRepositoryRoot();
    }

    @Override
    public boolean isCreateChildAllowed() throws LogicalTypeException, RemoteException {
        if (!this._isCreateChildTested) {
            this._isCreateChildTested = true;
            boolean hasWriteMemberPermissionOnRepository = this._factory.getWriteAllowedOnRepository(this);
            if (hasWriteMemberPermissionOnRepository) {
                UtilPlatformServices.DetachedTransaction detachedTransaction = null;
                try {
                    detachedTransaction = UtilPlatformServices.getDetachedTransaction();
                    com.sas.services.information.metadata.FolderInterface fi = (com.sas.services.information.metadata.FolderInterface)detachedTransaction.getSmartObject(this);
                    this._isCreateChildAllowed = fi.isAuthorized("WriteMemberMetadata");
                }
                catch (ServiceException e) {
                    throw new LogicalTypeException((Exception)((Object)e));
                }
                finally {
                    if (detachedTransaction != null) {
                        detachedTransaction.rollback();
                    }
                }
            } else {
                this._isCreateChildAllowed = false;
            }
        }
        return this._isCreateChildAllowed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean delete(OperationUserInteractionInterface oi) throws LogicalTypeException, RemoteException {
        if (!this.isDeleteAllowed()) {
            throw new UnsupportedOperationException("Logic error - this object does not support deletion");
        }
        MdFactory mdFactory = this.getFactory().getMdFactory();
        if (this._objectsDeleted == null) {
            this._objectsDeleted = new HashSet();
            this._objectsDeletedListener = new MdFactoryListener(){

                public void MdObjectsCreated(MdFactoryEvent e) throws RemoteException {
                }

                public void MdObjectsDeleted(MdFactoryEvent e) throws RemoteException {
                    String[] id = e.getObjectIDs();
                    if (id != null) {
                        for (int i = 0; i < id.length; ++i) {
                            FolderLogicalObject.this._objectsDeleted.add(id[i]);
                        }
                    }
                }

                public void MdObjectsModified(MdFactoryEvent e) throws RemoteException {
                }
            };
        } else {
            this._objectsDeleted.clear();
        }
        mdFactory.addMdFactoryListener(this._objectsDeletedListener);
        MdObjectStore objectStore = mdFactory.createObjectStore();
        boolean isContentMapped = this.isContentBacked();
        UtilPlatformServices.DetachedTransaction detachedTransaction = null;
        try {
            detachedTransaction = UtilPlatformServices.getDetachedTransaction();
            boolean bl = this.deleteContentsAndSelf(oi, objectStore, detachedTransaction, isContentMapped);
            return bl;
        }
        finally {
            if (detachedTransaction != null) {
                detachedTransaction.rollback();
            }
            mdFactory.removeMdFactoryListener(this._objectsDeletedListener);
            objectStore.dispose();
        }
    }

    private boolean deleteContentsAndSelf(OperationUserInteractionInterface oi, MdObjectStore store, UtilPlatformServices.DetachedTransaction detachedTransaction, boolean isContentMapped) throws RemoteException {
        Tree tree;
        try {
            tree = (Tree)UtilMetadata.getJOMAObjectFromLogicalObject(this, store);
        }
        catch (MdException e) {
            String logmsg = UtilMisc.getMessage(RB.getStringResource("COM.DelExcpOccrdLogMsg.fmt.txt"), this._ti.getDisplayType(), this.getName(), UtilMisc.getExceptionMessageText((Exception)((Object)e)));
            this._factory.error(logmsg);
            if (oi.isUserInteractionSupported() && oi.continueOperationWithPrompting()) {
                String msg = UtilMisc.getMessage(RB.getStringResource("COM.DelExcpOccrdNoFolder.fmt.txt"), this._ti.getDisplayType(), this.getName(), UtilMisc.getExceptionMessageText((Exception)((Object)e)));
                int choice = oi.displayMessage(RB.getStringResource("COM.DelDlgTitle.txt"), msg, 2, OperationUserInteractionInterface.OK_CHOICE_SET);
                OperationUserInteractionInterface.Updater.updateUsingOkOkToAllCancelValue_OkToAllTerminatesPrompting(oi, choice);
            }
            return false;
        }
        return this.deleteTreeContentsAndTree(oi, tree, true, detachedTransaction, isContentMapped);
    }

    private boolean deleteTreeContentsAndTree(OperationUserInteractionInterface oui, Tree tree, boolean deletingTop, UtilPlatformServices.DetachedTransaction detachedTransaction, boolean isContentMapped) throws RemoteException {
        try {
            Tree[] childTrees = (Tree[])tree.getSubTrees().toArray((Object[])new Tree[0]);
            for (int i = 0; i < childTrees.length; ++i) {
                Tree childTree = childTrees[i];
                if (childTree == null || this._objectsDeleted.contains(childTree.getFQID())) continue;
                this.deleteTreeContentsAndTree(oui, childTree, false, detachedTransaction, isContentMapped);
                if (!oui.isOperationCancelled()) continue;
                return false;
            }
            Factory factory = this.getFactory();
            Root[] members = (Root[])tree.getMembers().toArray((Object[])new Root[0]);
            for (int i = 0; i < members.length; ++i) {
                block11: {
                    Root member = members[i];
                    if (member == null || this._objectsDeleted.contains(member.getFQID())) continue;
                    LogicalObjectInterface item = factory.getObject(member);
                    if (item == null) {
                        String progressText = UtilMisc.getMessage(RB.getStringResource("COM.UpdProgDelete.fmt.txt"), member.getName());
                        oui.updateProgress(progressText);
                        String messageText = UtilMisc.getMessage(RB.getStringResource("FLD.UnkTypErr.fmt.txt"), member.getName(), this.getName());
                        this._factory.error(messageText);
                        if (oui.isUserInteractionSupported() && oui.continueOperationWithPrompting()) {
                            int choice = oui.displayMessage(RB.getStringResource("COM.DelDlgTitle.txt"), messageText, 2, OperationUserInteractionInterface.OK_OKTOALL_CANCEL_CHOICE_SET);
                            OperationUserInteractionInterface.Updater.updateUsingOkOkToAllCancelValue_OkToAllTerminatesPrompting(oui, choice);
                        }
                    } else {
                        try {
                            item.delete(oui);
                        }
                        catch (Exception e) {
                            String logmsg = UtilMisc.getMessage(RB.getStringResource("COM.DelExcpOccrdLogMsgWithFldr.fmt.txt"), item.getTypeInterface().getDisplayType(), item.getName(), this.getName(), UtilMisc.getExceptionMessageText(e));
                            this._factory.error(logmsg);
                            if (!oui.isUserInteractionSupported() || !oui.continueOperationWithPrompting()) break block11;
                            String messageText = UtilMisc.getMessage(RB.getStringResource("COM.DelExcpOccrd.fmt.txt"), item.getTypeInterface().getDisplayType(), item.getName(), this.getName(), UtilMisc.getExceptionMessageText(e));
                            int choice = oui.displayMessage(RB.getStringResource("COM.DelDlgTitle.txt"), messageText, 2, OperationUserInteractionInterface.OK_OKTOALL_CANCEL_CHOICE_SET);
                            OperationUserInteractionInterface.Updater.updateUsingOkOkToAllCancelValue_OkToAllTerminatesPrompting(oui, choice);
                        }
                    }
                }
                if (!oui.isOperationCancelled()) continue;
                return false;
            }
            if (!this.canTreeBeDeleted(oui, tree, detachedTransaction)) {
                return false;
            }
            String progressText = UtilMisc.getMessage(RB.getStringResource("COM.UpdProgDelete.fmt.txt"), tree.getName());
            oui.updateProgress(progressText);
            return this.doDelete(tree, deletingTop, isContentMapped);
        }
        catch (Exception e) {
            String messageText = UtilMisc.getMessage(RB.getStringResource("COM.DelExcpOccrdNoFolder.fmt.txt"), this._ti.getDisplayType(), tree.getName(), UtilMisc.getExceptionMessageText(e));
            this._factory.error(e, messageText);
            if (oui.isUserInteractionSupported() && oui.continueOperationWithPrompting()) {
                int choice = oui.displayMessage(RB.getStringResource("COM.DelDlgTitle.txt"), messageText, 2, OperationUserInteractionInterface.OK_OKTOALL_CANCEL_CHOICE_SET);
                OperationUserInteractionInterface.Updater.updateUsingOkOkToAllCancelValue_OkToAllTerminatesPrompting(oui, choice);
            }
            return false;
        }
    }

    private boolean canTreeBeDeleted(OperationUserInteractionInterface oui, Tree tree, UtilPlatformServices.DetachedTransaction detachedTransaction) throws MdException, RemoteException, LogicalTypeException, ServiceException {
        MetadataInterface mi = detachedTransaction.getSmartObject((Root)tree);
        if (mi == null) {
            throw new LogicalTypeException("Could not obtain folder smart object for " + tree.getFQID());
        }
        if (mi.countAssociatedObjects("SubTrees") > 0 || mi.countAssociatedObjects("Members") > 0) {
            if (oui.isUserInteractionSupported() && oui.continueOperationWithPrompting() && tree.getSubTrees(true).size() == 0 && tree.getMembers(true).size() == 0) {
                String messageText = UtilMisc.getMessage(RB.getStringResource("FLD.NotDeltd.fmt.txt"), tree.getName());
                int choice = oui.displayMessage(RB.getStringResource("COM.DelDlgTitle.txt"), messageText, 2, OperationUserInteractionInterface.OK_OKTOALL_CANCEL_CHOICE_SET);
                OperationUserInteractionInterface.Updater.updateUsingOkOkToAllCancelValue_OkToAllTerminatesPrompting(oui, choice);
            }
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doDelete(Tree tree, boolean deletingTop, boolean isContentMapped) throws Exception {
        boolean retVal = true;
        if (deletingTop && this._isTopLevel && isContentMapped && !this._isProjectRepositoryRoot) {
            Tree treeClone = (Tree)UtilMetadata.createAnExistingObjectInANewStore((CMetadata)tree);
            try {
                FolderContentMappingModel fcmm = new FolderContentMappingModel(treeClone);
                fcmm.loadMetadata();
                fcmm.deleteContentMappingIfPresent();
            }
            finally {
                treeClone.getObjectStore().dispose();
            }
        }
        if (isContentMapped) {
            UtilPlatformServices.DetachedTransaction detachedTransaction = null;
            try {
                detachedTransaction = UtilPlatformServices.getDetachedTransaction();
                MetadataInterface smartObj = detachedTransaction.getSmartObject((Root)tree);
                if (smartObj == null) {
                    throw new ServiceException("Could not obtain folder smart object for " + tree.getFQID());
                }
                smartObj.delete();
            }
            finally {
                if (detachedTransaction != null) {
                    detachedTransaction.rollback();
                }
            }
        } else {
            tree.getObjectStore().getFactory().deletePublicObject((CMetadata)tree);
        }
        return retVal;
    }

    @Override
    public boolean isContentMapped() {
        try {
            return this.isContentBacked();
        }
        catch (RemoteException e) {
            throw new RuntimeException(e);
        }
        catch (LogicalTypeException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean isContentBacked() throws LogicalTypeException, RemoteException {
        Factory factory = this.getFactory();
        if (!this._isTopLevel) {
            String reposID = UtilMetadata.makeRepositoryFQIDFromRoot(this._fqid);
            try {
                if (factory.isProjectRepository(reposID)) {
                    return false;
                }
            }
            catch (MdException e) {
                throw new LogicalTypeException((Exception)((Object)e));
            }
            ObjectContainer oc = new ObjectContainer();
            if (factory.isContentMappingStatusDeterminableFromRootAndTopLevelFolders(oc)) {
                return (Boolean)oc.getObject();
            }
            MdObjectStore store = this._factory.getMdFactory().createObjectStore();
            try {
                Tree topLevelTree = UtilMetadata.getTopLevelTree(store, this);
                FolderLogicalObject topLevelFolder = (FolderLogicalObject)factory.getObject((Root)topLevelTree, false, true);
                boolean bl = topLevelFolder.isContentBacked();
                return bl;
            }
            catch (MdException e) {
                throw new LogicalTypeException((Exception)((Object)e));
            }
            finally {
                store.dispose();
            }
        }
        if (this._isProjectRepositoryRoot) {
            return false;
        }
        if (this._isTopLevelContentMapped) {
            return true;
        }
        return factory.getRootFolder().isContentBacked();
    }

    @Override
    public boolean isValidName(String name) throws LogicalTypeException, RemoteException {
        super.isValidName(name);
        MdObjectStore store = this.getFactory().getMdFactory().createObjectStore();
        try {
            List<Tree> peers;
            Tree thisTree = (Tree)UtilMetadata.getJOMAObjectFromLogicalObject(this, store);
            Tree parentTree = thisTree.getParentTree();
            if (parentTree != null) {
                peers = UtilMetadata.getChildTreesFromTree(parentTree);
            } else {
                SoftwareComponent softwareComponent = UtilMetadata.locateFoundationSoftwareComponentFromTopLevelTree(thisTree);
                peers = UtilMetadata.getChildTreesFromSoftwareComponent(softwareComponent);
            }
            String thisFQID = this.getID();
            for (Tree t : peers) {
                if (t.getFQID().equals(thisFQID) || !name.equalsIgnoreCase(t.getName())) continue;
                throw new LogicalTypeException(UtilMisc.getMessage(RB.getStringResource("FLD.NameExists.fmt.txt"), name));
            }
        }
        catch (MdException e) {
            throw new LogicalTypeException((Exception)((Object)e));
        }
        finally {
            store.dispose();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rename(String name, OperationUserInteractionInterface oui) throws LogicalTypeException, RemoteException {
        block16: {
            if (!this.isRenameAllowed()) {
                throw new UnsupportedOperationException("Logic error - this object does not support rename");
            }
            if (this.getName().equals(name)) {
                return;
            }
            MdObjectStore store = this.getFactory().getMdFactory().createObjectStore();
            try {
                Tree tree = (Tree)UtilMetadata.getJOMAObjectFromLogicalObject(this, store);
                String ret = this.checkIfTreeCanBeMovedOrRenamed(tree, true, ".");
                if (ret != null) {
                    throw new LogicalTypeException(ret);
                }
                if (this._isTopLevel && this._isTopLevelContentMapped) {
                    FolderContentMappingModel model = new FolderContentMappingModel(tree);
                    model.loadMetadata();
                    tree.setName(name);
                    model.updateJomaObjects();
                    tree.updateMetadataAll();
                    this.refresh((Root)tree);
                    try {
                        UtilMetadataRemote.flushBIPTree();
                    }
                    catch (Exception e) {
                        this._factory.error(e, null);
                        oui.displayMessage(RB.getStringResource("FLD.RenameDlgTitle.txt"), e.getMessage(), 1, OperationUserInteractionInterface.OK_CHOICE_SET);
                    }
                    break block16;
                }
                UtilPlatformServices.DetachedTransaction detachedTransaction = null;
                try {
                    detachedTransaction = UtilPlatformServices.getDetachedTransaction();
                    com.sas.services.information.metadata.FolderInterface fi = (com.sas.services.information.metadata.FolderInterface)detachedTransaction.getSmartObject(this);
                    fi.setName(name);
                    fi.update();
                    tree = (Tree)UtilMetadata.getJOMAObjectFromLogicalObject(this, store);
                    this.refresh((Root)tree);
                }
                finally {
                    if (detachedTransaction != null) {
                        detachedTransaction.rollback();
                    }
                }
            }
            catch (MdException e) {
                throw new LogicalTypeException((Exception)((Object)e));
            }
            catch (ServiceException e) {
                throw new LogicalTypeException((Exception)((Object)e));
            }
            finally {
                store.dispose();
            }
        }
    }

    List<WAPropertyTab> getPropertyTabs(LogicalObjectInterface loi, Root root, Config config) throws MdException, RemoteException {
        if (!(root instanceof Tree)) {
            throw new IllegalStateException(root.toString() + " is invalid.  A Tree object was expected.");
        }
        Tree tree = (Tree)root;
        if (config == null) {
            config = new Config();
        }
        config.setEnabled(ConfigGeneralPanel.NAME, false);
        ArrayList<WAPropertyTab> list = new ArrayList<WAPropertyTab>();
        Tree parent = this._isTopLevel ? null : tree.getParentTree();
        FolderGeneralPropertyTab generalTab = new FolderGeneralPropertyTab(tree, parent, 1, loi, config);
        list.add((WAPropertyTab)generalTab);
        if (this.isTopLevel() && this.isReadCompatible() && !this._isProjectRepositoryRoot) {
            OurCallback cb = new OurCallback();
            config.setCallback(ConfigContentMappingPanel.SAVE_SETTINGS_AND_CLOSE, cb);
            list.add((WAPropertyTab)new FolderContentMappingTabPanel((Tree)root, 1, config));
        }
        return list;
    }

    @Override
    public void refresh(Root root) throws LogicalTypeException, RemoteException {
        boolean oldIsTopLevel = this.isTopLevel();
        super.refresh(root);
        MdObjectStore store = this.getFactory().getMdFactory().createObjectStore();
        try {
            Tree treeCopy = (Tree)UtilMetadata.locateExistingObject(store, root.getCMetadataType(), root.getFQID());
            this.setDetails(treeCopy);
        }
        catch (MdException e) {
            throw new LogicalTypeException((Exception)((Object)e));
        }
        finally {
            store.dispose();
        }
        if (oldIsTopLevel != this.isTopLevel()) {
            throw new LogicalTypeException("Changing top level status via refresh is not supported.");
        }
    }

    @Override
    protected void resetPermissionState() {
        super.resetPermissionState();
        this._isCreateChildTested = false;
        this._isCreateChildAllowed = false;
    }

    @Override
    public int childFolderExists(String name) throws LogicalTypeException, RemoteException {
        MdObjectStore store = this.getFactory().getMdFactory().createObjectStore();
        UtilPlatformServices.DetachedTransaction detachedTransaction = null;
        try {
            Tree tree = (Tree)UtilMetadata.getJOMAObjectFromLogicalObject(this, store);
            List<Tree> children = UtilMetadata.getChildTreesFromTree(tree);
            for (Tree child : children) {
                if (!child.getName().equalsIgnoreCase(name)) continue;
                int n = 1;
                return n;
            }
            detachedTransaction = UtilPlatformServices.getDetachedTransaction();
            com.sas.services.information.metadata.FolderInterface fi = (com.sas.services.information.metadata.FolderInterface)detachedTransaction.getSmartObject((Root)tree);
            if (fi == null) {
                throw new ServiceException("Could not obtain folder smart object for " + tree.getFQID());
            }
            int n = fi.hasDuplicateSubfolder(name) ? 2 : 0;
            return n;
        }
        catch (MdException e) {
            throw new LogicalTypeException((Exception)((Object)e));
        }
        catch (ServiceException e) {
            throw new LogicalTypeException((Exception)((Object)e));
        }
        finally {
            if (detachedTransaction != null) {
                detachedTransaction.rollback();
            }
            store.dispose();
        }
    }

    @Override
    public boolean isEmpty() throws LogicalTypeException, RemoteException {
        UtilPlatformServices.DetachedTransaction detachedTransaction = null;
        try {
            detachedTransaction = UtilPlatformServices.getDetachedTransaction();
            com.sas.services.information.metadata.FolderInterface fi = (com.sas.services.information.metadata.FolderInterface)detachedTransaction.getSmartObject(this);
            boolean bl = fi.isEmpty();
            return bl;
        }
        catch (ServiceException e) {
            throw new LogicalTypeException((Exception)((Object)e));
        }
        finally {
            if (detachedTransaction != null) {
                detachedTransaction.rollback();
            }
        }
    }

    @Override
    public boolean isCustomRepositoryRoot() {
        return this._isCustomRepositoryRoot;
    }

    @Override
    public boolean isRoot() {
        return false;
    }

    @Override
    public boolean isTopLevel() {
        return this._isTopLevel;
    }

    @Override
    public boolean isSystem() {
        return this._isSystem;
    }

    @Override
    public MoveDisallowedCause checkMoveAllowed() throws LogicalTypeException, RemoteException {
        if (this.isTopLevel() && this._isTopLevelContentMapped) {
            return MoveDisallowedCause.TOPLEVEL_HAS_CM;
        }
        return super.checkMoveAllowed();
    }

    @Override
    public MoveDisallowedCause checkMoveAllowed(FolderInterface targetFolder) throws LogicalTypeException, RemoteException {
        Object lockedBy;
        MoveDisallowedCause mnac = this.checkMoveAllowed();
        if (mnac != null) {
            return mnac;
        }
        if (targetFolder.isRoot() && this.isTopLevel()) {
            return MoveDisallowedCause.NAME_EXISTS;
        }
        if (this._fqid.equalsIgnoreCase(targetFolder.getID())) {
            return MoveDisallowedCause.UNDER_SELF;
        }
        String fqIDtoBeUsedForMoveUnderOneselfCheck = null;
        String reposID = UtilMetadata.makeRepositoryFQIDFromRoot(this._fqid);
        try {
            boolean isInProjectRepos = this._factory.isProjectRepository(reposID);
            if (isInProjectRepos) {
                MdObjectStore store = this._factory.getScratchStore();
                Root root = UtilMetadata.getJOMAObjectFromLogicalObject(this, store);
                lockedBy = root.getLockedBy();
                String changeState = root.getChangeState();
                store.removeElementFromStore((CMetadata)root);
                if (((String)lockedBy).length() != 0) {
                    int colonPos = changeState.indexOf(58);
                    boolean valid = false;
                    String originalID = null;
                    if (colonPos != -1 && colonPos + 2 <= changeState.length() && (originalID = changeState.substring(colonPos + 2)).length() == 17) {
                        valid = true;
                    }
                    if (!valid) {
                        String msg = UtilMisc.getMessage(RB.getStringResource("COM.InvChngSt.ex.fmt.txt"), changeState, this._fqid);
                        throw new LogicalTypeException(msg);
                    }
                    if (targetFolder.getID().equalsIgnoreCase(originalID)) {
                        return MoveDisallowedCause.UNDER_SELF;
                    }
                    if (!UtilMetadata.get8CharReposidFromFQID(originalID).equalsIgnoreCase(UtilMetadata.get8CharReposidFromFQID(targetFolder.getID()))) {
                        return MoveDisallowedCause.CROSS_REPOSITORY;
                    }
                    fqIDtoBeUsedForMoveUnderOneselfCheck = originalID;
                } else {
                    String targetFolderReposID = UtilMetadata.makeRepositoryFQIDFromRoot(targetFolder.getID());
                    if (this._factory.isProjectRepository(targetFolderReposID)) {
                        return MoveDisallowedCause.NEW_OBJECT_NOT_TO_PROJECT_REPOSITORY_FOLDER;
                    }
                }
            } else {
                if (!UtilMetadata.get8CharReposidFromFQID(this._fqid).equalsIgnoreCase(UtilMetadata.get8CharReposidFromFQID(targetFolder.getID()))) {
                    return MoveDisallowedCause.CROSS_REPOSITORY;
                }
                if (!targetFolder.isCreateChildAllowed()) {
                    return MoveDisallowedCause.NO_TARGET_WRITE_PERMISSION;
                }
                fqIDtoBeUsedForMoveUnderOneselfCheck = this._fqid;
            }
        }
        catch (MdException e) {
            throw new LogicalTypeException((Exception)((Object)e));
        }
        if (fqIDtoBeUsedForMoveUnderOneselfCheck != null) {
            if (this._factory.isContentMappingDefinedOnTopLevelFolders()) {
                MdObjectStore store = this._factory.getMdFactory().createObjectStore();
                try {
                    Tree sourceTopLevel = UtilMetadata.getTopLevelTree(store, this);
                    if (targetFolder.isRoot()) {
                        FolderLogicalObject sourceTopLevelFLO = (FolderLogicalObject)this._factory.getObject((Root)sourceTopLevel, false, true);
                        if (sourceTopLevelFLO._isTopLevelContentMapped) {
                            lockedBy = MoveDisallowedCause.UNDER_TOPLEVEL_WITH_CM;
                            return lockedBy;
                        }
                    } else {
                        Tree targetTopLevel = UtilMetadata.getTopLevelTree(store, targetFolder);
                        if (!sourceTopLevel.getFQID().equals(targetTopLevel.getFQID())) {
                            FolderInterface sourceTopLevelFI = (FolderInterface)this._factory.getObject((Root)sourceTopLevel, false, true);
                            FolderInterface targetTopLevelFI = (FolderInterface)this._factory.getObject((Root)targetTopLevel, false, true);
                            if (sourceTopLevelFI.isContentBacked() || targetTopLevelFI.isContentBacked()) {
                                MoveDisallowedCause moveDisallowedCause = MoveDisallowedCause.CROSS_TOPLEVEL_CM;
                                return moveDisallowedCause;
                            }
                        }
                    }
                }
                catch (MdException e) {
                    throw new LogicalTypeException((Exception)((Object)e));
                }
                finally {
                    store.dispose();
                }
            }
            if (!targetFolder.isRoot()) {
                MdObjectStore store = this._factory.getMdFactory().createObjectStore();
                Tree targetTree = null;
                try {
                    targetTree = (Tree)UtilMetadata.getJOMAObjectFromLogicalObject(targetFolder, store);
                    for (Tree parentTree = targetTree.getParentTree(); parentTree != null; parentTree = parentTree.getParentTree()) {
                        if (!parentTree.getFQID().equalsIgnoreCase(fqIDtoBeUsedForMoveUnderOneselfCheck)) continue;
                        MoveDisallowedCause moveDisallowedCause = MoveDisallowedCause.UNDER_SELF;
                        return moveDisallowedCause;
                    }
                }
                catch (MdException e) {
                    throw new LogicalTypeException((Exception)((Object)e));
                }
                finally {
                    store.dispose();
                }
            }
        }
        if (this.isNamePresent(targetFolder)) {
            return MoveDisallowedCause.NAME_EXISTS;
        }
        return null;
    }

    @Override
    public void move(FolderInterface targetFolder) throws LogicalTypeException, RemoteException {
        if (this.checkMoveAllowed(targetFolder) != null) {
            throw new UnsupportedOperationException("Logic error - this folder does not support moving");
        }
        MdObjectStore store = this.getFactory().getMdFactory().createObjectStore();
        try {
            Tree tree = (Tree)UtilMetadata.getJOMAObjectFromLogicalObject(this, store);
            String ret = this.checkIfTreeCanBeMovedOrRenamed(tree, true, ".");
            if (ret != null) {
                throw new LogicalTypeException(ret);
            }
        }
        catch (MdException e) {
            throw new LogicalTypeException((Exception)((Object)e));
        }
        finally {
            store.dispose();
        }
        this.resetPermissionState();
        UtilPlatformServices.DetachedTransaction detachedTransaction = null;
        try {
            com.sas.services.information.metadata.FolderInterface fi;
            detachedTransaction = UtilPlatformServices.getDetachedTransaction();
            MetadataInterface mi = detachedTransaction.getSmartObject(this);
            if (mi != null && (fi = (com.sas.services.information.metadata.FolderInterface)detachedTransaction.getSmartObject(targetFolder)) != null) {
                mi.moveTo(fi);
                mi.update();
                return;
            }
        }
        catch (ServiceException e) {
            throw new LogicalTypeException((Exception)((Object)e));
        }
        finally {
            if (detachedTransaction != null) {
                detachedTransaction.rollback();
            }
        }
    }

    private String checkIfTreeCanBeMovedOrRenamed(Tree tree, boolean topLevel, String path) throws RemoteException, MdException, LogicalTypeException {
        FolderInterface fi;
        Factory factory = this.getFactory();
        if (!topLevel && !(fi = (FolderInterface)factory.getObject((Root)tree)).isParentMoveAllowed()) {
            return UtilMisc.getMessage(RB.getStringResource("FLD.CantMoveFldr.fmt.txt"), fi.getName(), path);
        }
        path = path + '/';
        path = path + tree.getName();
        for (Tree childTree : tree.getSubTrees()) {
            String ret;
            if (childTree == null || (ret = this.checkIfTreeCanBeMovedOrRenamed(childTree, false, path)) == null) continue;
            return ret;
        }
        for (Root member : tree.getMembers()) {
            if (member == null) continue;
            LogicalObjectInterface item = factory.getObject(member);
            if (item == null) {
                return UtilMisc.getMessage(RB.getStringResource("FLD.CantMoveNoLogObj.fmt.txt"), member.getName(), path);
            }
            if (item.isParentMoveAllowed()) continue;
            return UtilMisc.getMessage(RB.getStringResource("FLD.CantMove.fmt.txt"), item.getTypeInterface().getDisplayType(), item.getName(), path);
        }
        MdFactory mdf = this._factory.getMdFactory();
        if (mdf == null) {
            throw new LogicalTypeException("Could not obtain MdFactory.");
        }
        MdSecurityUtil su = mdf.getSecurityUtil();
        if (su == null) {
            throw new LogicalTypeException("Could not obtain SecurityUtil.");
        }
        if (su.getAssociationCountForObject((CMetadata)tree, "SubTrees") > tree.getSubTrees(true).size()) {
            return UtilMisc.getMessage(RB.getStringResource("FLD.CantMoveHiddenFld.fmt.txt"), tree.getName());
        }
        if (su.getAssociationCountForObject((CMetadata)tree, "Members") > tree.getMembers(true).size()) {
            return UtilMisc.getMessage(RB.getStringResource("FLD.CantMoveHiddenMem.fmt.txt"), tree.getName());
        }
        return null;
    }

    private class OurCallback
    extends Config.Callback {
        OurCallback() {
        }

        @Override
        public void callback(Object object) throws LogicalTypeException, RemoteException {
            MdObjectStore store = FolderLogicalObject.this.getFactory().getMdFactory().createObjectStore();
            try {
                Tree tree = (Tree)UtilMetadata.getJOMAObjectFromLogicalObject(FolderLogicalObject.this, store);
                FolderContentMappingModel fcmm = new FolderContentMappingModel(tree);
                fcmm.loadMetadata();
                FolderLogicalObject.this._isTopLevelContentMapped = fcmm.getBackingType() != 0;
            }
            catch (MdException e) {
                throw new LogicalTypeException((Exception)((Object)e));
            }
            finally {
                store.dispose();
            }
            try {
                UtilMetadataRemote.flushBIPTree();
            }
            catch (Exception e) {
                FolderLogicalObject.this._factory.error(e, null);
                UtilGui.displayExceptionError(e);
            }
        }
    }
}

